#ifndef CONTACTSWINDOW_H
#define CONTACTSWINDOW_H

#include <QDialog>
#include <QTimer>
/*#ifdef Q_OS_SYMBIAN
    #include <applications/qtcontacts.h>
    using namespace QtMobility;
#endif*/
#ifdef Q_WS_MAEMO_5
    #include <QContact>
    using namespace QtMobility;
#endif
#include "contact.h"

namespace Ui {
    class ContactsWindow;
}

class ContactsWindow : public QDialog
{
    Q_OBJECT

public:
    explicit ContactsWindow(QWidget *parent = 0);
    ~ContactsWindow();

    void Init();
    QString GetSelectedNumber();
    void FillContactsList();

private:
    Ui::ContactsWindow *ui;

    QTimer* m_Timer;
    QList<Contact*> m_Contacts;
    QString m_Selected;    
    void AddContactToList(Contact* c, int index, QPixmap* defaultImage);

private slots:
    void TimerSlot();
    void SelectContactSlot();
    void CercaSlot();
    void ClearSlot();
};

#endif // CONTACTSWINDOW_H
