#include "simwidget.h"

#include <QLabel>
#include <QMouseEvent>
#include "commonstatic.h"

SimWidget::SimWidget(QWidget *parent, QString* number) :
    QScrollArea(parent)
{
    Number = *number;

    m_Pressed = false;
    setFrameStyle(QFrame::NoFrame | QFrame::Plain);
    setWidgetResizable(true);
    setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Minimum);
    SetStyle(false);

    m_Container = new QWidget(this);
    m_Container->setStyleSheet("color: black; border-width: 0px;");
    m_Container->setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Maximum);
    setWidget(m_Container);

    m_Layout = new QGridLayout( m_Container );
    m_Layout->setSpacing(3);
    m_Layout->setMargin(0);
    m_Container->setLayout(m_Layout);

    QPixmap* cImage = new QPixmap(":/images/sim.png");

    QLabel* lbl = new QLabel(m_Container);
    lbl->setScaledContents(true);
    lbl->setMaximumSize(48, 48);
    lbl->setPixmap(*cImage);
    m_Layout->addWidget(lbl, 0, 0, 2, 1);

    lbl = new QLabel(m_Container);
    lbl->setText(*number);
    m_Layout->addWidget(lbl, 0, 1, 1, 1);
}

void SimWidget::mousePressEvent(QMouseEvent* event)
{
    if (event->button() == Qt::LeftButton){
        m_Pressed = true;
        SetStyle(true);
    }
}

void SimWidget::mouseReleaseEvent(QMouseEvent* event)
{
    SetStyle(false);
    if (m_Pressed && CommonStatic::IsMouseOver(this))
        emit clicked();
}

void SimWidget::leaveEvent(QEvent* event)
{
    if (m_Pressed)
        SetStyle(false);
}

void SimWidget::enterEvent(QEvent* event)
{
    if (m_Pressed)
        SetStyle(true);
}

void SimWidget::SetStyle(bool selected)
{
    if (selected)
        setStyleSheet("color: black; \
                       border-width: 1px; \
                       border-style: solid; \
                       border-color: red;");
    else
        setStyleSheet("color: black; \
                       border-width: 1px; \
                       border-style: solid; \
                       border-color: black;");
}
