#include "contactwidget.h"
#include <QLabel>
#include "commonstatic.h"

ContactWidget::ContactWidget(QWidget *parent, Contact* contact, QPixmap* defaultImage) :
    QScrollArea(parent)
{
    m_Contact = contact;

    m_Pressed = false;
    setFrameStyle(QFrame::NoFrame | QFrame::Plain);
    setWidgetResizable(true);
    setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Minimum);
    SetStyle(false);

    m_Container = new QWidget(this);
    m_Container->setStyleSheet("color: black; border-width: 0px;");
    m_Container->setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Maximum);
    setWidget(m_Container);

    m_Layout = new QGridLayout( m_Container );
    m_Layout->setSpacing(3);
    m_Layout->setMargin(0);
    m_Container->setLayout(m_Layout);

    QPixmap* cImage = defaultImage;
    if (cImage == NULL)
        cImage = new QPixmap(":/images/contacts.png");

    QLabel* lbl = new QLabel(m_Container);
    lbl->setScaledContents(true);
    lbl->setMaximumSize(48, 48);
    if (m_Contact->Thumbnail != NULL)
        lbl->setPixmap(QPixmap::fromImage(*m_Contact->Thumbnail));
    else
        lbl->setPixmap(*cImage);
    m_Layout->addWidget(lbl, 0, 0, 2, 1);

    lbl = new QLabel(m_Container);
    lbl->setText(m_Contact->Name);
    QFont f = lbl->font();
    f.setBold(true);
    lbl->setFont(f);
    m_Layout->addWidget(lbl, 0, 1, 1, 1);

    lbl = new QLabel(m_Container);
    lbl->setText(m_Contact->MobileNumber);
    m_Layout->addWidget(lbl, 1, 1, 1, 1);
}


void ContactWidget::mousePressEvent(QMouseEvent* event)
{
    if (event->button() == Qt::LeftButton){
        m_Pressed = true;
        SetStyle(true);
    }
}

void ContactWidget::mouseReleaseEvent(QMouseEvent* event)
{
    SetStyle(false);
    if (m_Pressed && CommonStatic::IsMouseOver(this))
        emit clicked();
}

void ContactWidget::leaveEvent(QEvent* event)
{
    if (m_Pressed)
        SetStyle(false);
}

void ContactWidget::enterEvent(QEvent* event)
{
    if (m_Pressed)
        SetStyle(true);
}

void ContactWidget::SetStyle(bool selected)
{
    if (selected)
        setStyleSheet("color: black; \
                       border-width: 1px; \
                       border-style: solid; \
                       border-color: red;");
    else
        setStyleSheet("color: black; \
                       border-width: 1px; \
                       border-style: solid; \
                       border-color: black;");
}
