#include "settingswindow.h"
#include "ui_settingswindow.h"

SettingsWindow::SettingsWindow(QWidget *parent, Settings* settings) :
    QDialog(parent),
    ui(new Ui::SettingsWindow)
{
    ui->setupUi(this);

    m_Settings = settings;
    connect(ui->btnCancel, SIGNAL(clicked()), this, SLOT(CancelSlot()));
    connect(ui->btnSave, SIGNAL(clicked()), this, SLOT(SaveSlot()));

#ifdef Q_OS_SYMBIAN
    ui->lblShowLastData->setText(tr("Visualizza dati all'avvio:"));

    ui->btnCancel->setVisible(false);
    ui->btnSave->setVisible(false);

    QAction* softKey = new QAction( tr("Ok"), this );
    softKey->setSoftKeyRole( QAction::PositiveSoftKey );
    connect(softKey, SIGNAL(triggered()), this, SLOT(SaveSlot()));
    addAction(softKey);

    softKey = new QAction( tr("Annulla"), this );
    softKey->setSoftKeyRole( QAction::NegativeSoftKey );
    connect(softKey, SIGNAL(triggered()), this, SLOT(CancelSlot()));
    addAction(softKey);
#endif

    ui->txUsername->setText(m_Settings->Username);
    ui->txPassword->setText(m_Settings->Password);
    ui->chkLogXML->setChecked(m_Settings->LogXml);
    ui->chkShowLastData->setChecked(m_Settings->ShowLastData);
    ui->chkPerc->setChecked(m_Settings->ShowPercentage);
#ifdef Q_WS_MAEMO_5
    ui->scrollArea->setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    ui->scrollArea->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    setAttribute(Qt::WA_Maemo5AutoOrientation, true);
#endif

    ui->txUsername->setFocus();
}

SettingsWindow::~SettingsWindow()
{
    delete ui;
}

void SettingsWindow::CancelSlot()
{
    reject();
}

void SettingsWindow::SaveSlot()
{
    m_Settings->Username = ui->txUsername->text();
    m_Settings->Password = ui->txPassword->text();
    m_Settings->LogXml = ui->chkLogXML->isChecked();
    m_Settings->ShowLastData = ui->chkShowLastData->isChecked();
    m_Settings->ShowPercentage = ui->chkPerc->isChecked();

    m_Settings->Save();

    accept();
}
