#include "commonstatic.h"
#include <QMessageBox>
#include <QApplication>
#include <QDesktopWidget>
#ifdef Q_WS_MAEMO_5
    #include <QDesktopServices>
    #include <QMaemo5InformationBox>
    #include <QLabel>
    #include <QVBoxLayout>
#endif
#include <QDir>

void CommonStatic::ErrorMessage(QWidget* parent, QString message)
{
#ifdef Q_WS_MAEMO_5
    QMaemo5InformationBox* box = new QMaemo5InformationBox(parent);
    QObject::connect(box, SIGNAL(clicked()), box, SLOT(accept()));
    box->setStyleSheet("background: white; color: red; opacity: 223;");
    box->setTimeout(-1);

    QLabel* text = new QLabel(box);
    text->setText(message);
    text->setAlignment(Qt::AlignCenter);

    box->setWidget(text);
    box->exec();
#else
    QMessageBox msgBox(parent);
    msgBox.setIcon(QMessageBox::Critical);
    msgBox.setText(message);
    msgBox.exec();
#endif
}

void CommonStatic::InfoMessage(QWidget* parent, QString message)
{
#ifdef Q_WS_MAEMO_5
    QMaemo5InformationBox* box = new QMaemo5InformationBox(parent);
    QObject::connect(box, SIGNAL(clicked()), box, SLOT(accept()));
    box->setStyleSheet("background: white; color: red; opacity: 223;");

    QLabel* text = new QLabel(box);
    text->setText(message);
    text->setAlignment(Qt::AlignCenter);

    box->setWidget(text);
    box->exec();
#else
    QMessageBox msgBox(parent);
    msgBox.setIcon(QMessageBox::Information);
    msgBox.setText(message);
    msgBox.exec();
#endif
}


bool CommonStatic::IsPortrait()
{
    QRect screenGeometry = QApplication::desktop()->screenGeometry();
    return screenGeometry.height() > screenGeometry.width();
}

QString CommonStatic::GetHomeFolder()
{
#ifdef Q_WS_MAEMO_5
    return QDesktopServices::storageLocation(QDesktopServices::HomeLocation);
#else
    return QDir::homePath();
#endif
}

QString CommonStatic::FormatKBytes(int kbytes)
{
    float tKb = (float)kbytes;
    if (tKb/1024/1024.0 >= 1)
        return QString("%1Gb").arg(tKb / 1024.0 / 1024.0, 4, 'f', 2);
    else if (tKb/1024.0 >= 1)
        return QString("%1Mb").arg(tKb / 1024.0, 4, 'f', 2);

    return QString("%1Kb").arg(kbytes);
}

bool CommonStatic::IsMouseOver(QWidget* w)
{
    QPoint mousePos = QCursor::pos();
    QPoint widgetPos = w->mapToGlobal(QPoint(0,0));

    if (mousePos.x() >= widgetPos.x() && mousePos.x() <= widgetPos.x() + w->size().width() &&
        mousePos.y() >= widgetPos.y() && mousePos.y() <= widgetPos.y() + w->size().height())
        return true;
    return false;
}
