#include "settingswindow.h"
#include "ui_settingswindow.h"

SettingsWindow::SettingsWindow(QWidget *parent, Settings* settings) :
    QDialog(parent),
    ui(new Ui::SettingsWindow)
{
    ui->setupUi(this);

    m_Settings = settings;
    connect(ui->btnCancel, SIGNAL(clicked()), this, SLOT(CancelSlot()));
    connect(ui->btnSave, SIGNAL(clicked()), this, SLOT(SaveSlot()));

    ui->txUsername->setText(m_Settings->Username);
    ui->txPassword->setText(m_Settings->Password);
    ui->chkLogXML->setChecked(m_Settings->LogXml);
    ui->chkShowLastData->setChecked(m_Settings->ShowLastData);
#ifdef Q_WS_MAEMO_5
    ui->scrollArea->setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    ui->scrollArea->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    setAttribute(Qt::WA_Maemo5AutoOrientation, true);
#endif

    ui->txUsername->setFocus();
}

SettingsWindow::~SettingsWindow()
{
    delete ui;
}

void SettingsWindow::CancelSlot()
{
    reject();
}

void SettingsWindow::SaveSlot()
{
    m_Settings->Username = ui->txUsername->text();
    m_Settings->Password = ui->txPassword->text();
    m_Settings->LogXml = ui->chkLogXML->isChecked();
    m_Settings->ShowLastData = ui->chkShowLastData->isChecked();

    m_Settings->Save();

    accept();
}
