#include "settings.h"
#include <QCoreApplication>
#include <QFile>
#include <QDir>
#include "commonstatic.h"

Settings::Settings(QObject *parent) :
    QObject(parent)
{
    LogXml = false;
    ShowLastData = true;
    LastCredito = 0;
    LastSaldoPunti = NULL;
    LastCounters = NULL;
}

QString Settings::GetConfigName()
{
#ifdef Q_WS_MAEMO_5
    QString folder = QString("%1/.vodafone190").arg(CommonStatic::GetHomeFolder());
    if (!QDir().exists(folder))
        QDir().mkdir(folder);
    return QString("%1/settings.conf").arg(folder);
#else
    return QString("%1/settings.conf").arg(QCoreApplication::applicationDirPath());
#endif
}

bool Settings::Save()
{
    QSettings* settings = new QSettings(GetConfigName(), QSettings::IniFormat);

    settings->beginGroup("Main");

    settings->setValue("username", Username);
    settings->setValue("password", Password);
    settings->setValue("logxml", LogXml);

    settings->setValue("showlastdata", ShowLastData);
    settings->setValue("lastupdated", LastUpdated);
    settings->setValue("lastcredito", LastCredito);
    settings->setValue("lastvaluta", LastValuta);
    if (LastSaldoPunti)
        settings->setValue("lastsaldopunti", LastSaldoPunti->ToString());

    if (LastCounters){
        settings->beginWriteArray("counters");
        for (int i = 0; i < LastCounters->count(); ++i) {
            settings->setArrayIndex(i);
            settings->setValue("counter", LastCounters->at(i)->ToString());
        }
        settings->endArray();
    }

    settings->endGroup();
    settings->sync();

    return true;
}

bool Settings::Load()
{
    if (!QFile::exists(GetConfigName()))
        return false;

    QSettings* settings = new QSettings(GetConfigName(), QSettings::IniFormat);

    settings->beginGroup("Main");

    Username = settings->value("username").toString();
    Password = settings->value("password").toString();
    LogXml = settings->value("logxml").toBool();

    ShowLastData = settings->value("showlastdata").toBool();
    LastUpdated = settings->value("lastupdated").toDateTime();
    LastCredito = settings->value("lastcredito").toFloat();
    LastValuta = settings->value("lastvaluta").toString();
    QString saldo = settings->value("lastsaldopunti").toString();
    LastSaldoPunti = new SaldoPunti();
    LastSaldoPunti->FromString(saldo);

    LastCounters = new QList<Counter*>();
    int max = settings->beginReadArray("counters");
    for (int i = 0; i < max; ++i) {
        settings->setArrayIndex(i);

        Counter* c = new Counter();
        c->FromString(settings->value("counter").toString());
        LastCounters->append(c);
    }
    settings->endArray();

    settings->endGroup();

    return true;
}
