#include "saldopunti.h"
#include <QStringList>

SaldoPunti::SaldoPunti(QObject *parent) :
    QObject(parent)
{
    Punti = 0;
    PuntiInScadenza = 0;
    AnnoPuntiInScadenza = 0;
}

QString SaldoPunti::ToString()
{
    return QString("%1;%2;%3;%4;%5").arg(Punti).arg(PuntiInScadenza).arg(AnnoPuntiInScadenza)
                                    .arg(Scadenza.toString("dd/MM/yyyy"))
                                    .arg(Aggiornamento.toString("dd/MM/yyyy"));
}

void SaldoPunti::FromString(QString string)
{
    QStringList list = string.split(';');
    if (list.count() < 5)
        return;

    Punti = list.at(0).toInt();
    PuntiInScadenza = list.at(1).toInt();
    AnnoPuntiInScadenza = list.at(2).toInt();
    Scadenza = QDate::fromString(list.at(3), "dd/MM/yyyy");
    Aggiornamento = QDate::fromString(list.at(4), "dd/MM/yyyy");
}
