#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QMenuBar>
#include <QMovie>
#include <QTimer>
#include "vodafonewidget.h"
#include "settings.h"

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();    
    void Init();

private:
    QTimer* m_Timer;
    bool m_NoSettings;
    bool m_Closing;
    Ui::MainWindow *ui;

    QMovie* m_WaitIcon;
    Settings* m_Settings;
    QAction* m_SettingsAction;
    QAction* m_AboutAction;
    QAction* m_QuitAction;
    QAction* m_UpdateAction;

    VodafoneWidget* m_Vodafone;
    QList<Counter*>* m_Counters;
    void Update();
    void closeEvent(QCloseEvent *event);
    void SetUpdatedLabel(QDateTime date);

private slots:
    void TimerSlot();
    void OrientationChanged();
    void SettingsSlot();
    void AboutSlot();
    void QuitSlot();
    void SmsSlot();
    void UpdateSlot();
};

#endif // MAINWINDOW_H

