#include "mainwindow.h"
#include "ui_mainwindow.h"

#include <QVBoxLayout>
#include <QDesktopWidget>
#include "settingswindow.h"
#include "smswindow.h"
#include "aboutwindow.h"
#include "commonstatic.h"
#include "widgets/counterwidget.h"

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);    

    SetUpdatedLabel(QDateTime());
    m_NoSettings = false;
    m_Counters = NULL;
    m_Timer = NULL;
    m_Vodafone = new VodafoneWidget("", "");
    m_Closing = false;
    m_WaitIcon = new QMovie(":/images/wait.gif");
    m_WaitIcon->setScaledSize(QSize(40, 40));

#ifdef Q_OS_SYMBIAN
    QMenu *menu = menuBar();
#else
    QMenu *menu = menuBar()->addMenu(tr("Vodafone 190"));
#endif
    m_SettingsAction = new QAction(tr("Impostazioni"), this);
    connect(m_SettingsAction, SIGNAL(triggered()), this, SLOT(SettingsSlot()));
    m_AboutAction = new QAction(tr("About"), this);
    connect(m_AboutAction, SIGNAL(triggered()), this, SLOT(AboutSlot()));
    m_QuitAction = new QAction(tr("Esci"), this);
    connect(m_QuitAction, SIGNAL(triggered()), this, SLOT(QuitSlot()));
    m_UpdateAction = new QAction(tr("Aggiorna"), this);
    connect(m_UpdateAction, SIGNAL(triggered()), this, SLOT(UpdateSlot()));

    menu->addAction(m_UpdateAction);
    menu->addAction(m_SettingsAction);
    menu->addAction(m_AboutAction);
    menu->addAction(m_QuitAction);

    connect(ui->btnSMS, SIGNAL(clicked()), this, SLOT(SmsSlot()));

    m_Settings = new Settings(this);

    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(OrientationChanged()));
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5AutoOrientation, true);
    ui->scrollArea->setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    ui->scrollArea->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
#endif

    if (!m_Settings->Load())
        m_NoSettings = true;
    else if (m_Settings->ShowLastData){
        if (m_Settings->LastUpdated.isValid())
            SetUpdatedLabel(m_Settings->LastUpdated);
        ui->lblCreditoResiduo->setText(QString("%1 %2").arg(m_Settings->LastCredito, 4, 'f', 2).arg(m_Settings->LastValuta).trimmed());
        ui->lblPunti->setText(QString("%1").arg(m_Settings->LastSaldoPunti->Punti));
        ui->lblScadenza->setText(QString("%1 %2").arg(m_Settings->LastSaldoPunti->PuntiInScadenza).arg(m_Settings->LastSaldoPunti->Scadenza.toString("dd/MM/yyyy")).trimmed());

        if (ui->grpContatori->layout() == NULL){
            QVBoxLayout* layout = new QVBoxLayout(ui->grpContatori);
            ui->grpContatori->setLayout(layout);
        }
        foreach (Counter* c, *m_Settings->LastCounters){
            CounterWidget* w = new CounterWidget(this, c);
            ui->grpContatori->layout()->addWidget(w);
        }
    }

}

MainWindow::~MainWindow()
{
    delete m_Vodafone;
    delete ui;
}

void MainWindow::Init()
{
    ui->btnSMS->setEnabled(false);
    m_SettingsAction->setEnabled(false);
    m_UpdateAction->setEnabled(false);

    m_Timer = new QTimer();
    m_Timer->setInterval(1000);
    m_Timer->setSingleShot(true);
    connect(m_Timer, SIGNAL(timeout()), this, SLOT(TimerSlot()));
    m_Timer->start();
}

void MainWindow::closeEvent(QCloseEvent *event)
{
    m_Closing = true;
    m_Vodafone->AbortRequest();
    m_Settings->Save();
    qApp->quit();
}

void MainWindow::TimerSlot()
{
    delete m_Timer;
    m_Timer = NULL;

    if (m_NoSettings)
        SettingsSlot();

    m_Vodafone->SetCredentials(m_Settings->Username, m_Settings->Password, false);
    m_Vodafone->DebugXml = m_Settings->LogXml;

    if (!m_Settings->Username.isEmpty() && !m_Settings->Password.isEmpty())
        Update();
    else
        m_SettingsAction->setEnabled(true);
}

void MainWindow::SettingsSlot()
{
    QString user = m_Settings->Username;
    QString pwd = m_Settings->Password;
    SettingsWindow* frm = new SettingsWindow(this, m_Settings);
    if (frm->exec() == QDialog::Accepted){
        m_Vodafone->DebugXml = m_Settings->LogXml;
        if (!m_NoSettings && (m_Settings->Username != user || m_Settings->Password != pwd)){
            m_Vodafone->SetCredentials(m_Settings->Username, m_Settings->Password);
            Update();
        }
    }
    m_NoSettings = false;
}

void MainWindow::AboutSlot()
{
    AboutWindow* frm = new AboutWindow(this);
    frm->show();
    frm->Init();
    frm->exec();
}

void MainWindow::QuitSlot()
{
    this->close();
}

void MainWindow::UpdateSlot()
{
    Update();
}

void MainWindow::SmsSlot()
{
    SmsWindow* frm = new SmsWindow(this, m_Vodafone);
    frm->exec();
}

void MainWindow::Update()
{
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#else
    ui->lblLogo->setMovie(m_WaitIcon);
    m_WaitIcon->start();
#endif

    ui->btnSMS->setEnabled(false);
    m_SettingsAction->setEnabled(false);
    m_UpdateAction->setEnabled(false);

    QString valuta;
    if (m_Vodafone->IsLoggedIn() || m_Vodafone->Login()){
        if (m_Closing)
            return;
        ui->btnSMS->setEnabled(true);

        float credito = m_Vodafone->GetCredito(&valuta);
        if (valuta == "E")
            valuta = QChar(8364);
        if (m_Closing)
            return;

        SaldoPunti* punti = new SaldoPunti();
        m_Vodafone->GetSaldoPunti(punti);
        if (m_Closing)
            return;

        ui->lblCreditoResiduo->setText(QString("%1 %2").arg(credito, 4, 'f', 2).arg(valuta).trimmed());
        ui->lblPunti->setText(QString("%1").arg(punti->Punti));
        ui->lblScadenza->setText(QString("%1 %2").arg(punti->PuntiInScadenza).arg(punti->Scadenza.toString("dd/MM/yyyy")).trimmed());

        m_Settings->LastCredito = credito;
        m_Settings->LastValuta = valuta;
        m_Settings->LastSaldoPunti = punti;

        m_Counters = m_Vodafone->GetListaContatori();
        if (m_Closing)
            return;

        if (ui->grpContatori->layout() == NULL){
            QVBoxLayout* layout = new QVBoxLayout(ui->grpContatori);
            ui->grpContatori->setLayout(layout);
        }else{
            QLayoutItem *child;
            while ((child = ui->grpContatori->layout()->takeAt(0)) != 0) {
                delete child->widget();
                delete child;
            }
        }

        foreach(Counter* c, *m_Counters){
            bool res = m_Vodafone->GetDettaglioContatore(c);
            if (m_Closing)
                return;
            if (res){
                CounterWidget* w = new CounterWidget(this, c);
                ui->grpContatori->layout()->addWidget(w);
            }
        }
        m_Settings->LastCounters = m_Counters;
        m_Settings->LastUpdated = QDateTime::currentDateTime();
        SetUpdatedLabel(m_Settings->LastUpdated);
    }else{
        if (!m_Closing)
            CommonStatic::ErrorMessage(this, tr("Login fallito"));
    }

    m_SettingsAction->setEnabled(true);
    m_UpdateAction->setEnabled(true);

#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#else
    ui->lblLogo->setMovie(NULL);
    ui->lblLogo->setPixmap(QPixmap(":/images/vodafone_logo.png"));
#endif
}

void MainWindow::OrientationChanged()
{
    if (ui->grpContatori->layout() != NULL){
        QLayoutItem *child;
        while ((child = ui->grpContatori->layout()->takeAt(0)) != 0) {
            delete child->widget();
            delete child;
        }

        if (m_Counters){
            foreach(Counter* c, *m_Counters){
                CounterWidget* w = new CounterWidget(this, c);
                ui->grpContatori->layout()->addWidget(w);
            }
        }
        SetUpdatedLabel(m_Settings->LastUpdated);
    }
}

void MainWindow::SetUpdatedLabel(QDateTime date)
{
    if (CommonStatic::IsPortrait()){
        ui->lblUpdated->setVisible(false);
        ui->lblUpdatedP->setVisible(true);
    }else{
        ui->lblUpdatedP->setVisible(false);
        ui->lblUpdated->setVisible(true);
    }

    if (!date.isNull()){
        ui->lblUpdatedP->setText(QString(tr("Aggiornato: %1").arg(date.toString("dd/MM/yyyy hh:mm"))));
        ui->lblUpdated->setText(QString(tr("Aggiornato: %1").arg(date.toString("dd/MM/yyyy hh:mm"))));
    }
}
