/*
 * This file is part of vncviewer.
 *
 * Copyright (C) 2005, 2006 Aaron Levinson.
 *
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <locale.h>
#include <libintl.h>
//#include <dlfcn.h>
#include <hildon-1/hildon/hildon-program.h>
#include <gtk/gtk.h> 
//fremantle
#include <gdk/gdkx.h>
#include <X11/Xatom.h>

#include "rfb.h"
#include "vnc-viewer.h"
#include "appdata.h"
#include "interface.h"

//static void take_screenshot(void);

static AppData *create_data()
{
  AppData *result = g_new0(AppData, 1);

  result->osso = osso_initialize("vncviewer", VERSION, FALSE, 0);
  g_assert(result->osso);
  return result;
}

/* Here we clean up all the data that we allocated */
static void destroy_data(AppData *data)
{
  osso_deinitialize(data->osso);
  
  g_free(data);
}

/*
static void save_screenshot(GtkFileSelection *win) {
  GdkImlibImage *img = gtk_object_get_data(GTK_OBJECT(win), "imlib-image");

  gdk_imlib_save_image(img,
		       gtk_entry_get_text(GTK_ENTRY(win->selection_entry)),
		       NULL);
  gtk_object_destroy(GTK_OBJECT(win));
}

static void take_screenshot(void) {
  GdkImlibImage *img;
  GtkWidget *win;

  g_return_if_fail(vnc != NULL);
  img = gdk_imlib_create_image_from_drawable(vnc->offscreen, NULL, 0, 0,
					     vnc->width, vnc->height);
  // it would be pointless to save something like this in the image cache
  gdk_imlib_changed_image(img);

  win = gtk_file_selection_new(_("Save Screenshot"));

  gtk_object_set_data_full(GTK_OBJECT(win), "imlib-image", img,
			  (GtkDestroyNotify)gdk_imlib_destroy_image);
  gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION(win)->ok_button),
			    "clicked", GTK_SIGNAL_FUNC(save_screenshot),
			    GTK_OBJECT(win));
  gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION(win)->cancel_button),
			    "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy),
			    GTK_OBJECT(win));

  gtk_widget_show(win);
}
*/

/* arg parsing stuff ... */
/*
static void parseAnArg(poptContext con, enum poptCallbackReason reason,
		       const struct poptOption *opt,
		       const char *arg, void *data) {
  char *str;

  switch(reason) {
  case POPT_CALLBACK_REASON_OPTION:
    switch(opt->val) {
    case -1:
      curShared = TRUE; break;
    case -2:
      
    }
  case POPT_CALLBACK_REASON_PRE:
    if(!strcmp(arg, "8"))
      curDepth = VNC_VIEWER_DEPTH_8BIT;
    else if(!strcmp(arg, "16"))
      curDepth = VNC_VIEWER_DEPTH_16BIT;
    else if(!strcmp(arg, "24"))
      curDepth = VNC_VIEWER_DEPTH_24BIT;
    else if(!strcmp(arg, "default"))
      curDepth = VNC_VIEWER_DEPTH_DEFAULT;
    else {
      poptPrintUsage(con, stdout, 0);
      exit(1);
    }
    break;
  case POPT_CALLBACK_REASON_POST:
    str = poptGetArg(con);
    if(str) {
      curDisplay = g_strdup(str);
      if(poptGetArg(con) != NULL) {
	poptPrintUsage(con, stdout, 0);
	exit(1);
      }
    }
    break;
  }
}
static const struct poptOption vnc_options[] = {
  { NULL, '\0', POPT_ARG_CALLBACK|POPT_CBFLAG_POST,
    &parseAnArg, 0, NULL },
  { "shared", 's', POPT_ARG_NONE, NULL, -1,
    N_("share this display"), NULL },
  { "depth", 'd', POPT_ARG_STRING, NULL, -2,
    N_("the maximum bit depth for the display"), NULL },
  POPT_AUTOHELP
  { NULL, '\0', 0, NULL, 0 }
};
*/

gchar *arg_hostname = 0;
gchar *arg_password = 0;
gboolean arg_have_password = FALSE;
gboolean arg_lockdown = FALSE;
gchar *arg_lockdown_password = 0;

gboolean ParsePasswordOption(const gchar *option_name, const gchar *value,
			     gpointer data, GError **error)
{
  arg_have_password = TRUE;
  if (value)
    arg_password = g_strdup(value);

  return TRUE;
}

static GOptionEntry options[] =
{
  {
    "hostname", 0, 0, G_OPTION_ARG_STRING, &arg_hostname,
    "Specify hostname", "hst[:dispNum]"
  },
  {
    "password", 0, 0, G_OPTION_ARG_CALLBACK, ParsePasswordOption,
    "Specify password", "[pass]"
  },
  {
    "lockdown", 0, 0, G_OPTION_ARG_NONE, &arg_lockdown,
    "Lock down the user interface", 0
  },
  {
    "lockdown-password", 0, 0, G_OPTION_ARG_STRING, &arg_lockdown_password,
    "Specify password to turn off lock down mode", "pass"
  },
  { 0 }
};
static void
ungrab_volume_keys(GtkWidget *main_window)
{
    /* Tell maemo-status-volume daemon to ungrab keys */
    unsigned long val = 1; /* ungrab, use 0 to grab */
    Atom atom;
    GdkDisplay *display = NULL;
    display = gdk_drawable_get_display (main_window);
    atom = gdk_x11_get_xatom_by_name_for_display (display, "_HILDON_ZOOM_KEY_ATOM");
    XChangeProperty (GDK_DISPLAY_XDISPLAY (display),
    GDK_WINDOW_XID (main_window->window), atom, XA_INTEGER, 32,
    PropModeReplace, (unsigned char *) &val, 1);
}

int main(int argc, char *argv[]) {
  AppData *data;
  HildonProgram *app; 
  MainView *main_view;
  gboolean bRet;

  /* Initialize the locale stuff */
  setlocale(LC_ALL, "");
  bindtextdomain(PACKAGE, LOCALEDIR);
  bind_textdomain_codeset(PACKAGE, "UTF-8");
  textdomain(PACKAGE);
  //bindtextdomain(GETTEXT_PACKAGE, LOCALEDIR);
  //bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
  //textdomain(GETTEXT_PACKAGE);

  /* Init the gtk - must be called before any hildon stuff */
  //gtk_init(&argc, &argv);
  bRet = gtk_init_with_args(&argc, &argv, _("- VNC viewer client"),
			    options, 0, 0);
  if (bRet == FALSE)
    return 0;

  /* Create the hildon application and setup the title */
  app = HILDON_PROGRAM(hildon_program_get_instance());
  g_set_application_name(_("VNC Viewer"));

  /* Create the data and views for our application */
  data = create_data();
  data->app = app;
  main_view = interface_main_view_new(data);
  hildon_program_add_window(data->app, data->main_view);

  // Connect signal to X in the upper corner
  g_signal_connect(G_OBJECT(data->main_view), "delete_event",
		   G_CALLBACK(gtk_main_quit), 0);

  /* Begin the main app */
  gtk_widget_show(GTK_WIDGET(data->main_view));
  //fremantle
  ungrab_volume_keys(GTK_WIDGET(data->main_view));

  gtk_main();

  /* Clean up */
  interface_main_view_destroy(main_view);
  destroy_data(data);

  if (arg_password)
    g_free(arg_password);

  return 0;  
}
