/*   VLC-REMOTE for MAEMO 5
*   Copyright (C) 2010 Schutz Sacha <istdasklar@gmail.com>, Dru Moore <usr@dru-id.co.uk>, Yann Nave <yannux@onbebop.net>
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License version 2,
*   or (at your option) any later version, as published by the Free
*   Software Foundation
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details
*
*   You should have received a copy of the GNU General Public
*   License along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/
#include "newaccountdialog.h"
#include <QFormLayout>
#include <QDebug>
#include <QSettings>
#include "appsettings.h"
//#include <QMaemo5InformationBox>

NewAccountDialog::NewAccountDialog(QWidget *parent)
{
    Q_UNUSED(parent);
    this->setWindowTitle(tr("Add account"));

    mKeyLineEdit = new QLineEdit;
    mIpLineEdit = new QLineEdit;
    mPortLineEdit = new QLineEdit;
    mPortLineEdit->setText("8080");
    mPortLineEdit->setReadOnly(false);

    mButtonBox = new QDialogButtonBox;
    mButtonBox->addButton(QDialogButtonBox::Save);
    mButtonBox->addButton(QDialogButtonBox::Cancel);

    connect(mButtonBox, SIGNAL(accepted()), this, SLOT(save()));
    connect(mButtonBox, SIGNAL(rejected()), this, SLOT(reject()));

    QFormLayout *layout = new QFormLayout;
    layout->expandingDirections();
    layout->addRow(tr("Name:"), mKeyLineEdit);
    layout->addRow(tr("Ip:"), mIpLineEdit);
    layout->addRow(tr("Port:"), mPortLineEdit);
    layout->addWidget(mButtonBox);

    setLayout(layout);
}

void NewAccountDialog::save()
{
    QString myKey = mKeyLineEdit->text();
    QString myIp = mIpLineEdit->text();
    QString myPort = mPortLineEdit->text();

    /// TODO create account through appsettings
    QSettings settings;
    settings.beginGroup("account");
    if (!mEditKey.isEmpty()) {
        settings.remove(mEditKey);
    }

    if (!myIp.isEmpty() && !myKey.isEmpty()) {
        if (myPort.isEmpty()) {
            myPort = "8080";
        }
        settings.setValue(myKey, myIp+":"+myPort);
        // Rajouter des tests pour vérifier qu'on est sur Maemo
        //QMaemo5InformationBox::information(this, tr("Account saved"), QMaemo5InformationBox::DefaultTimeout);
    }
    settings.endGroup();

    emit accept();
}

void NewAccountDialog::edit(QString &key, QString &ip)
{
    Q_UNUSED(ip);
    this->setWindowTitle(tr("Edit account"));

    QSettings settings;
    settings.beginGroup("account");
    QString value = settings.value(key).toString();
    settings.endGroup();

    QStringList values = value.split(":");

    mEditKey = key;
    mEditIp = values.first();
    mEditPort = values.last();

    mKeyLineEdit->setText(mEditKey);
    mKeyLineEdit->setDisabled(true);
    mIpLineEdit->setText(mEditIp);
    mPortLineEdit->setText(mEditPort);
}

