/*   VLC-REMOTE for MAEMO 5
*   Copyright (C) 2010 Schutz Sacha <istdasklar@gmail.com>, Dru Moore <usr@dru-id.co.uk>, Yann Nave <yannux@onbebop.net>
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License version 2,
*   or (at your option) any later version, as published by the Free
*   Software Foundation
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details
*
*   You should have received a copy of the GNU General Public
*   License along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/
#include <QtGui/QApplication>
#include <QSettings>
#include <QLocale>
#include <QTextCodec>
#include <QTranslator>
#include <QDebug>
#include "playermainwindow.h"
#include "appsettings.h"
int main(int argc, char *argv[])
{
    QApplication a(argc, argv);

    QCoreApplication::setOrganizationName("Omed");
    QCoreApplication::setOrganizationDomain("medsoft.blogspot.com/");
    QCoreApplication::setApplicationName("Maemo VLC remote");

    QString locale = QLocale::system().name();
    QTranslator translator;
    translator.load(QString(":/languages/vlcremote_") + locale);
    a.installTranslator(&translator);

    QTextCodec::setCodecForTr(QTextCodec::codecForName("utf8"));


    qDebug() << AppSettings::getCurrentIp();


  PlayerMainWindow * mainwindow = new PlayerMainWindow;

  //mainwindow->setAttribute(Qt::WA_Maemo5LandscapeOrientation, true);
  //mainwindow->setAttribute(Qt::WA_Maemo5PortraitOrientation, true);
  //mainwindow->setAttribute(Qt::WA_Maemo5AutoOrientation, true);

  mainwindow->showMaximized();
 #if defined(Q_WS_S60) || defined(Q_WS_MAEMO_5)
  Orientation o = AppSettings::getOrientation();
  switch (o) {
      case AUTO_ROTATE:
      mainwindow->setAttribute(Qt::WA_Maemo5AutoOrientation, true);
          break;
      case LANDSCAPE:
          mainwindow->setAttribute(Qt::WA_Maemo5LandscapeOrientation, true);
          break;
      case PORTRAIT:
          mainwindow->setAttribute(Qt::WA_Maemo5PortraitOrientation, true);
          break;
      default:
          mainwindow->setAttribute(Qt::WA_Maemo5AutoOrientation, true);
          break;
  }
#endif
    return a.exec();
}
