/*   VLC-REMOTE for MAEMO 5
*   Copyright (C) 2010 Schutz Sacha <istdasklar@gmail.com>, Dru Moore <usr@dru-id.co.uk>, Yann Nave <yannux@onbebop.net>
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License version 2,
*   or (at your option) any later version, as published by the Free
*   Software Foundation
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details
*
*   You should have received a copy of the GNU General Public
*   License along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/
#ifndef APPSETTINGS_H
#define APPSETTINGS_H
#include <QSettings>

#ifndef STATUS_POLL_TIMEOUT
#define STATUS_POLL_TIMEOUT 5000
#endif
#ifndef PING_TIMEOUT
#define PING_TIMEOUT 1000
#endif
#ifndef CONNECTION_TIMEOUT
#define CONNECTION_TIMEOUT 1000
#endif
#ifndef RETRIEVE_ART_TIMEOUT
#define RETRIEVE_ART_TIMEOUT 500
#endif
#ifndef RETRY_NETWORK_TIMEOUT
#define RETRY_NETWORK_TIMEOUT 25000
#endif

#ifndef SHOW_UNKNOWN_FILETYPES
#define SHOW_UNKNOWN_FILETYPES false
#endif

#ifndef SHOW_ALBUM_ART
#define SHOW_ALBUM_ART true
#endif

#ifndef ALERT_ON_CLOSE
#define ALERT_ON_CLOSE false
#endif


struct VlcDirectory {
    QString name;
    QString path;
};
enum Orientation {
    AUTO_ROTATE = 0,
    LANDSCAPE,
    PORTRAIT
};

class AppSettings {
public:
    explicit AppSettings();
    ~AppSettings();
    static QString getCurrentKey();
    static QString setCurrentKey(QString);
    static QString getCurrentIp();
    static QString setCurrentIp(QString);
    static QStringList getAllAccounts();
    static VlcDirectory getHomeDirectory();
    static QList<VlcDirectory>* getFavourites();
    static bool addFavourite(VlcDirectory);
    static bool deleteFavourite(VlcDirectory);
    static bool setHomeDirectory(VlcDirectory);
    static bool isConnected();
    static int getStatusPollTimeout();
    static int setStatusPollTimeout(int);
    static int getPingTimeout();
    static int setPingTimeout(int);
    static int getConnectionTimeout();
    static int setConnectionTimeout(int);
    static int getRetrieveArtTimeout();
    static int setRetrieveArtTimeout(int);
    static int getRetryNetworkTimeout();
    static int setRetryNetworkTimeout(int);
    static bool getShowUnknownFileTypes();
    static bool setShowUnknownFileTypes(bool);
    static bool getShowAlbumArt();
    static bool setShowAlbumArt(bool);
    static bool getAlertOnClose();
    static bool setAlertOnClose(bool);
    static Orientation setOrientation(Orientation);
    static Orientation getOrientation();

private:
    static bool _haveCurrentKey;
    static QString _currentKey;
    static bool _haveCurrentIp;
    static QString _currentIp;
    static bool _haveConnectionTimeout;
    static int _connectionTimeout;
    static bool _havePingTimeout;
    static int _pingTimeout;
    static bool _haveStatusPollTimeout;
    static int _statusPollTimeout;
    static bool _haveRetrieveArtTimeout;
    static int _retrieveArtTimeout;
    static bool _haveRetryNetworkTimeout;
    static int _retryNetworkTimeout;
    static bool _haveShowUnknownFileTypes;
    static bool _showUnknownFileTypes;
    static bool _haveShowAlbumArt;
    static bool _showAlbumArt;
    static bool _haveAlertOnClose;
    static bool _alertOnClose;
    static bool _haveOrientation;
    static Orientation _orientation;


};

#endif // APPSETTINGS_H
