/*   VLC-REMOTE for MAEMO 5
*   Copyright (C) 2010 Schutz Sacha <istdasklar@gmail.com>, Dru Moore <usr@dru-id.co.uk>, Yann Nave <yannux@onbebop.net>
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License version 2,
*   or (at your option) any later version, as published by the Free
*   Software Foundation
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details
*
*   You should have received a copy of the GNU General Public
*   License along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/
#ifndef BROWSEMAINWINDOW_H
#define BROWSEMAINWINDOW_H

#include <QMainWindow>
#include <QtNetwork>
#include <QtXml>
#include <QListWidgetItem>
#include "vlcbrowseelement.h"
#include "favouritesmainwindow.h"

namespace Ui {
    class BrowseMainWindow;
}

class BrowseMainWindow : public QMainWindow {
    Q_OBJECT
public:
    explicit BrowseMainWindow(QWidget *parent = 0);
    ~BrowseMainWindow();

public slots:
    void init();
    void browseDirectory(QString);
    void onBrowse();
    void onPlay();
    void onAddToPlaylist();
    void onListSelectionChanged();
    void finished(QNetworkReply * reply);
    void readReady();
    void error(QNetworkReply::NetworkError code);
    void showCurrentDirectory();
    void setHomeFolder();
    void showHomeFolder();
    void showUserHomeFolder();
    void setFavourite();
    void showFavourites();
    void setHomeDirectory();

protected slots:
    void parseXmlDirectory();
    void updateList();

protected:
    void changeEvent(QEvent *e);
    VlcBrowseElement getElementFromText(QString text);
    QString getExtension(QString path, QString extension);

private:
    Ui::BrowseMainWindow *ui;
    FavouritesMainWindow *mFavouritesMainWindow;
    QNetworkAccessManager * mNetManager;
    QString mCurrentDir;
    QString mIp;
    QList<VlcBrowseElement>* mContents;
    VlcBrowseElement mCurrentElement;
    QByteArray mResponse;
};

#endif // BROWSEMAINWINDOW_H
