/*   VLC-REMOTE for MAEMO 5
*   Copyright (C) 2010 Schutz Sacha <istdasklar@gmail.com>, Dru Moore <usr@dru-id.co.uk>, Yann Nave <yannux@onbebop.net>
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License version 2,
*   or (at your option) any later version, as published by the Free
*   Software Foundation
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details
*
*   You should have received a copy of the GNU General Public
*   License along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/
#ifndef APPSETTINGS_H
#define APPSETTINGS_H
#include <QSettings>

struct VlcDirectory {
    QString name;
    QString path;
};
enum Orientation {
    AUTO_ROTATE = 0,
    LANDSCAPE,
    PORTRAIT
};

class AppSettings {
public:
    explicit AppSettings();
    ~AppSettings();
    static QString getCurrentKey();
    static QString getCurrentIp();
    static VlcDirectory getHomeDirectory();
    static QList<VlcDirectory>* getFavourites();
    static bool addFavourite(VlcDirectory dir);
    static bool deleteFavourite(VlcDirectory dir);
    static bool setHomeDirectory(VlcDirectory dir);
    static Orientation setOrientation(Orientation orientation);
    static Orientation getOrientation();
//private:
    //static QSettings settings;
};

#endif // APPSETTINGS_H
