/*   VLC-REMOTE for MAEMO 5
 *   Copyright (C) 2010 Schutz Sacha <istdasklar@gmail.com>
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License version 2,
 *   or (at your option) any later version, as published by the Free
 *   Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include <QDebug>
#include <QTime>
#include "playermainwindow.h"
#include "ui_playermainwindow.h"
#include "configdialog.h"
#include "aboutdialog.h"

PlayerMainWindow::PlayerMainWindow(QWidget *parent) :
        QMainWindow(parent),
        ui(new Ui::PlayerMainWindow)
{
    ui->setupUi(this);
    setWindowTitle("Vlc remote");

    QSettings settings;
    mIp = settings.value("ip").toString();

    if ( mIp.isEmpty())
        showConfig();


    mTimer = new QTimer(this);
    mNetManager = new QNetworkAccessManager(this);
    mPlayListMainWindow = new PlayListMainWindow;


    ui->playlistButton->setIcon(QIcon::fromTheme("notes_bullets"));
    ui->previousButton->setIcon(QIcon::fromTheme("pdf_viewer_first_page"));
    ui->nextButton->setIcon(QIcon::fromTheme("pdf_viewer_last_page"));
    ui->playButton->setIcon(QIcon::fromTheme("camera_playback"));
    ui->stopButton->setIcon(QIcon::fromTheme("camera_video_stop"));
    ui->pauseButton->setIcon(QIcon::fromTheme("camera_video_pause"));
    ui->fullscreenButton->setIcon(QIcon::fromTheme("general_fullsize"));
    ui->volDown->setIcon(QIcon::fromTheme("statusarea_volumelevel1"));
    ui->volUp->setIcon(QIcon::fromTheme("statusarea_volumelevel4"));

#if defined(Q_WS_S60) || defined(Q_WS_MAEMO_5)
    mPlayListMainWindow->setParent(this);
    mPlayListMainWindow->setAttribute(Qt::WA_Maemo5StackedWindow);
    mPlayListMainWindow->setAttribute(Qt::WA_Maemo5LandscapeOrientation,true);
    mPlayListMainWindow->setAttribute(Qt::WA_Maemo5LandscapeOrientation,true);
    setAttribute(Qt::WA_Maemo5StackedWindow);
    mPlayListMainWindow->setWindowFlags(mPlayListMainWindow->windowFlags() | Qt::Window);
#endif

    connect(mTimer,SIGNAL(timeout()),this,SLOT(askStatus()));
    connect(ui->actionConfiguration,SIGNAL(triggered()),this,SLOT(showConfig()));
    connect(ui->actionAbout,SIGNAL(triggered()),this,SLOT(showAbout()));
    connect(ui->playlistButton,SIGNAL(clicked()),mPlayListMainWindow,SLOT(show()));
    connect(ui->playButton,SIGNAL(clicked()),this,SLOT(play()));
    connect(ui->stopButton,SIGNAL(clicked()),this,SLOT(stop()));
    connect(ui->pauseButton,SIGNAL(clicked()),this,SLOT(pause()));
    connect(ui->previousButton,SIGNAL(clicked()),this,SLOT(previous()));
    connect(ui->nextButton,SIGNAL(clicked()),this,SLOT(next()));
    connect(ui->fullscreenButton,SIGNAL(clicked()),this,SLOT(fullscreen()));
    connect(ui->volUp,SIGNAL(clicked()),this,SLOT(volUp()));
    connect(ui->volDown,SIGNAL(clicked()),this,SLOT(volDown()));
    connect(ui->slider,SIGNAL(sliderMoved(int)),this,SLOT(slide(int)));

    mTimer->start(5000);

}

PlayerMainWindow::~PlayerMainWindow()
{
    delete ui;
}

void PlayerMainWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void PlayerMainWindow::play()
{

    mNetManager->get(QNetworkRequest(QUrl("http://"+mIp+"/requests/status.xml?command=pl_play")));

}
void PlayerMainWindow::stop()
{
    mNetManager->get(QNetworkRequest(QUrl("http://"+mIp+"/requests/status.xml?command=pl_stop")));

}
void PlayerMainWindow::pause()
{
    mNetManager->get(QNetworkRequest(QUrl("http://"+mIp+"/requests/status.xml?command=pl_pause")));

}
void PlayerMainWindow::previous()
{
    mNetManager->get(QNetworkRequest(QUrl("http://"+mIp+"/requests/status.xml?command=pl_previous")));

}
void PlayerMainWindow::next()
{
    mNetManager->get(QNetworkRequest(QUrl("http://"+mIp+"/requests/status.xml?command=pl_next")));

}
void PlayerMainWindow::fullscreen()
{
    mNetManager->get(QNetworkRequest(QUrl("http://"+mIp+"/requests/status.xml?command=fullscreen")));

}
void PlayerMainWindow::volUp()
{
    mNetManager->get(QNetworkRequest(QUrl("http://"+mIp+"/requests/status.xml?command=volume&val=500")));

}
void PlayerMainWindow::volDown()
{

    mNetManager->get(QNetworkRequest(QUrl("http://"+mIp+"/requests/status.xml?command=volume&val=-20")));

}
void PlayerMainWindow::slide(int value)
{
    mNetManager->get(QNetworkRequest(QUrl("http://"+mIp+"/requests/status.xml?command=seek&val="+QString::number(value)+"%25")));

}

void PlayerMainWindow::showConfig()
{
    ConfigDialog * dialog = new ConfigDialog;
    dialog->exec();
}
void PlayerMainWindow::showAbout()
{

    AboutDialog * dialog = new AboutDialog;
    dialog->exec();

}


void PlayerMainWindow::askStatus()
{

    QNetworkReply * reply =  mNetManager->get(QNetworkRequest(QUrl("http://"+mIp+"/requests/status.xml")));
    connect(reply,SIGNAL(readyRead()),this,SLOT(parseXmlStatus()));
}
void PlayerMainWindow::parseXmlStatus()
{
    QNetworkReply * reply = qobject_cast<QNetworkReply*>(sender());
    QDomDocument doc;
    doc.setContent(reply->readAll());
    QDomElement docElem = doc.documentElement();

    int volume = docElem.namedItem("volume").toElement().text().toInt();
    int length = docElem.namedItem("length").toElement().text().toInt();
    int time = docElem.namedItem("time").toElement().text().toInt();
    int position = docElem.namedItem("position").toElement().text().toInt();
    QString state  =docElem.namedItem("state").toElement().text();

    QTime timeLength(0,0,0) ;
   timeLength =  timeLength.addSecs(time);

ui->timeLabel->setText(timeLength.toString("mm:ss"));


    QDomNode infoNode =  docElem.namedItem("information");
    QDomNode metaInfoNode =  infoNode.namedItem("meta-information");
    QString title = metaInfoNode.namedItem("title").toElement().text();

    if ( position >= 0 && position <=100)
        ui->slider->setValue(position);

    ui->label->setText(title);
    delete reply;

}

