/*   VLC-REMOTE for MAEMO 5
 *   Copyright (C) 2010 Schutz Sacha <istdasklar@gmail.com>
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License version 2,
 *   or (at your option) any later version, as published by the Free
 *   Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "configdialog.h"
#include "ui_configdialog.h"
#include <QSettings>
ConfigDialog::ConfigDialog(QWidget *parent) :
        QDialog(parent),
        ui(new Ui::ConfigDialog)
{
    ui->setupUi(this);
    load();
    connect(ui->buttonBox,SIGNAL(accepted()),this,SLOT(save()));
}

ConfigDialog::~ConfigDialog()
{
    delete ui;
}

void ConfigDialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}
void ConfigDialog::load()
{


    QSettings settings;
    ui->lineEdit->setText(settings.value("ip").toString());

}

void ConfigDialog::save()
{

    QSettings settings;
    settings.setValue("ip",ui->lineEdit->text());

    emit accept();



}
