/**
 *  Viito -- an image dictionary for sign language
 *
 *  Copyright (C) 2010  Aki Niemi <aki.niemi@iki.fi>
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef VDATAMODEL_H
#define VDATAMODEL_H

#include <QStandardItem>

class QStandardItemModel;
class QString;

class VTopicItem : public QStandardItem
{

public:
    VTopicItem();
    VTopicItem(const QString &name, QStandardItemModel *model);

    enum Roles {
	ModelRole = Qt::UserRole + 1,
    };
};

class VImageItem : public QStandardItem
{

public:
    VImageItem();
    VImageItem(const QString &name, const QString &author,
	       const QString &path);

    enum Roles {
	AuthorRole = Qt::UserRole + 1,
	PathRole,
    };
};    

#endif // VDATAMODEL_H
