/**
 *  Viito -- an image dictionary for sign language
 *
 *  Copyright (C) 2010  Aki Niemi <aki.niemi@iki.fi>
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <QtGui>

#include "vimagewidget.h"

VImageWidget::VImageWidget(QWidget *parent)
    : QWidget(parent)
{
    QVBoxLayout *vbox = new QVBoxLayout(this);

    mAuthor = new QLabel(this);
    mImage = new QLabel(this);

    mAuthor->setStyleSheet("color: black; background-color: white");
    mAuthor->setAlignment(Qt::AlignBottom | Qt::AlignRight);
    mImage->setAlignment(Qt::AlignCenter);

    vbox->addWidget(mImage);
    vbox->addWidget(mAuthor);

    grabGesture(Qt::SwipeGesture);

    setStyleSheet("background-color: white");

    setWindowFlags(windowFlags() | Qt::Window);
    setAttribute(Qt::WA_Maemo5StackedWindow);
}

void VImageWidget::setAuthor(const QString &author)
{
    mAuthor->setText(author);
}

void VImageWidget::setPixmap(const QPixmap &pixmap)
{
    mImage->setPixmap(pixmap);
}

bool VImageWidget::event(QEvent *event)
{
    if (event->type() == QEvent::Gesture)
	return gestureEvent(static_cast<QGestureEvent*>(event));
    else
	return QWidget::event(event);
}

bool VImageWidget::gestureEvent(QGestureEvent *event)
{
    QGesture *swipe = event->gesture(Qt::SwipeGesture);

    if (!swipe)
	return true;

    return handleSwipe(static_cast<QSwipeGesture *>(swipe));
}

bool VImageWidget::handleSwipe(QSwipeGesture *swipe)
{
    if (swipe->state() != Qt::GestureFinished)
	return true;

    if (swipe->horizontalDirection() == QSwipeGesture::Left)
	emit next();

    if (swipe->horizontalDirection() == QSwipeGesture::Right)
	emit previous();

    return true;
}
