/*
@version: 0.7
@author: Sudheer K. <scifi1947 at gmail.com>
@license: GNU General Public License
*/

import QtQuick 1.1
import com.nokia.meego 1.0
import "file:///usr/lib/qt4/imports/com/meego/UIConstants.js" as UIConstants
//import "file:///usr/lib/qt4/imports/com/nokia/extras/constants.js" as ExtrasConstants
import "Library/js/DBUtility.js" as DBUtility
import "Library/js/CoreLogic.js" as Core

Page {
    tools: commonTools
    id: mainPage

    Component.onCompleted: {
        DBUtility.initialize();
        Core.loadRules();
    }

    function reload(){
        Core.loadRules();
    }

    Rectangle{
        id: headerRect
        anchors.top:parent.top
        width: parent.width ; height: appWindow.inPortrait ? UIConstants.HEADER_DEFAULT_HEIGHT_PORTRAIT: UIConstants.HEADER_DEFAULT_HEIGHT_LANDSCAPE
        color: "darkgray"

        Text {
            id: titleText
            font.family: UIConstants.FONT_FAMILY
            font.pixelSize: UIConstants.FONT_SLARGE
            color: UIConstants.COLOR_FOREGROUND
            anchors.centerIn: parent
            horizontalAlignment: Text.AlignHCenter;
            text: qsTr("VICaR - Rules")
        }
    }

    Loader
    {
        id: uiLoader
        anchors {top: headerRect.bottom; bottom: parent.bottom}
        width: parent.width
    }

    ListModel{
        id: rulesModel
    }


    Component {
        id: rulesComponent
        Item {
            ListView {
                id: rulesView
                anchors.fill: parent
                clip: true
                model: rulesModel                      
                delegate:ruleDelegate
            }
        }
    }

    Component {
        id: ruleDelegate
        Item{
            width: uiLoader.width            
            height: UIConstants.LIST_ITEM_HEIGHT_DEFAULT

            BorderImage {
                anchors.fill: parent
                visible: mouseArea.pressed
                source: theme.inverted ?
                            'image://theme/meegotouch-list-fullwidth-inverted-background-pressed-vertical-center':
                            'image://theme/meegotouch-list-fullwidth-background-pressed-vertical-center'
            }

            Text {
                height: parent.height;
                anchors {left: parent.left;leftMargin: UIConstants.DEFAULT_MARGIN; right: parent.right; rightMargin: UIConstants.DEFAULT_MARGIN}
                font.family: UIConstants.FONT_FAMILY
                font.pixelSize: UIConstants.FONT_SLARGE
                color: UIConstants.COLOR_FOREGROUND
                horizontalAlignment: Text.AlignLeft; verticalAlignment: Text.AlignVCenter
                wrapMode: Text.WordWrap
                //lineHeightMode: Text.ProportionalHeight; lineHeight: 1.5
                text: "For numbers starting with "+numberpattern+ ", use "+gatewaynumber;
            }
            MouseArea{
                id: mouseArea
                anchors.fill: parent
                onPressAndHold: {
                    ruleContextMenu.ruleID = id;
                    console.log("Setting Rule ID as "+id);
                    ruleContextMenu.open();
                }
            }
        }
    }

    ContextMenu{
        id: ruleContextMenu
        property int ruleID:0

        MenuLayout{
            MenuItem {
                text: qsTr("Edit");
                onClicked: {
                    Core.editRule(ruleContextMenu.ruleID);
                }
            }
            MenuItem {
                text: qsTr("Delete");
                onClicked: {
                    DBUtility.removeRule(ruleContextMenu.ruleID);
                    Core.loadRules();
                }
            }
        }
    }

    Component{
        id: blankComponent
        Item {
            Label {
                id: label
                anchors.centerIn: parent
                text: qsTr("Add rules for call routing.")
                visible: true
            }
        }
    }
}
