/*
@version: 0.5
@author: Sudheer K. <scifi1947 at gmail.com>
@license: GNU General Public License
*/

#include "profilesettingsdialog.h"
#include "ui_profilesettingsdialog.h"
#include "vicarprofiletypes.h"
#include <QMessageBox>

ProfileSettingsDialog::ProfileSettingsDialog(QWidget *parent, org::maemo::vicar::Profile *profile) :
    QDialog(parent),
    ui(new Ui::ProfileSettingsDialog)
{
    ui->setupUi(this);
    this->profile = profile;

    if (profile != 0){
        //Load Profile values
        ui->lineEditNumberStartsWith->setText(profile->phoneNumberPattern);
        ui->lineEditCallingCardNumber->setText(profile->gatewayNumber);
        int intIndex = ui->comboBoxDTMFFormat->findText(profile->dtmfFormat);
        ui->comboBoxDTMFFormat->setCurrentIndex(intIndex);
        ui->lineEditDTMFPrefix->setText(profile->dtmfPrefix);
        ui->lineEditDTMFSuffix->setText(profile->dtmfSuffix);
    }

    ui->lineEditCallingCardNumber->setValidator(new QRegExpValidator(QRegExp( "^-?\\d\\d*$"), this));
    ui->lineEditDTMFPrefix->setValidator(new QRegExpValidator(QRegExp( "^[0-9p#\\*]*$"), this));
    ui->lineEditDTMFSuffix->setValidator(new QRegExpValidator(QRegExp( "^[0-9p#\\*]*$"), this));
}

ProfileSettingsDialog::~ProfileSettingsDialog()
{
    delete ui;
}


void ProfileSettingsDialog::on_saveButton_clicked()
{
    QString strMessage = QString("");
    if (profile != 0){
        QString strNumberStartsWith = ui->lineEditNumberStartsWith->text();
        if (strNumberStartsWith.isEmpty()){
            strMessage.append("Enter Phone number starts with\n");
            ui->lineEditNumberStartsWith->setFocus();
        }

        QString strCallingCardNumber = ui->lineEditCallingCardNumber->text();

        if (strCallingCardNumber.isEmpty()){
            strMessage.append("Enter a calling card number\n");
            ui->lineEditCallingCardNumber->setFocus();
        }

        if (strMessage.isEmpty()){
            profile->phoneNumberPattern = ui->lineEditNumberStartsWith->text();
            profile->gatewayNumber = ui->lineEditCallingCardNumber->text();
            profile->dtmfFormat = ui->comboBoxDTMFFormat->currentText();
            profile->dtmfPrefix = ui->lineEditDTMFPrefix->text();
            profile->dtmfSuffix = ui->lineEditDTMFSuffix->text();
            this->accept();
        }
        else{
            QMessageBox::warning(this,"Invalid Data",strMessage);
        }
    }
    else{
        this->accept();
    }
}

void ProfileSettingsDialog::on_closeButton_clicked()
{
    this->reject();
}
