import ctypes

class _PyGObject_Functions(ctypes.Structure):
    _fields_ = [
        ('register_class',ctypes.PYFUNCTYPE(ctypes.c_void_p, ctypes.c_char_p,ctypes.c_int, 
                                            ctypes.py_object, ctypes.py_object)),
        ('register_wrapper',ctypes.PYFUNCTYPE(ctypes.c_void_p, ctypes.py_object)),
        ('register_sinkfunc',ctypes.PYFUNCTYPE(ctypes.py_object, ctypes.c_void_p)),
        ('lookupclass',ctypes.PYFUNCTYPE(ctypes.py_object, ctypes.c_int)),
        ('newgobj',ctypes.PYFUNCTYPE(ctypes.py_object, ctypes.c_void_p)),
    ]

class PyGObjectCPAI(object):
    def __init__(self):
        import gobject
        py_obj = ctypes.py_object(gobject._PyGObject_API)
        addr = ctypes.pythonapi.PyCObject_AsVoidPtr(py_obj)
        self._api = _PyGObject_Functions.from_address(addr)

    def pygobject_new(self, addr):
        return self._api.newgobj(addr)
