#!/usr/bin/env python
# -*- coding: utf-8 -*-
#vertsms Ossipena/TimoP
#plus others (will add at some stage)
''' 1. Imports '''

import sys
import time
import ctypes
import threading
import dbus
import pango
import gtk
import hildon
import osso
import sqlite3

''' 2. Sending SMS '''

def octify(str):
#    print "octifying " + str
    bytes = map(ord, str)
    bitsconsumed = 0
    referencebit = 7
    octets = []
    bitstocopy = 0

    while len(bytes):
        byte = bytes.pop(0)
        byte = byte >> bitsconsumed

        try:
            nextbyte = bytes[0]

            bitstocopy = (nextbyte & (0xff >> referencebit)) << referencebit
            octet = (byte | bitstocopy)

        except:
            octet = (byte | 0x00)

        if bitsconsumed != 7:
            octets.append(byte | bitstocopy)
            bitsconsumed += 1
            referencebit -= 1
        else:
            bitsconsumed = 0
            referencebit = 7
#    print "finished octifying  " + str
    return octets

def semi_octify(str):
#    print "semi-octifying " +str
    '''
    Expects a string containing two digits.
    Returns an octet -
    first nibble in the octect is the first
    digit and the second nibble represents
    the second digit.
    '''
    try:
#      global digit_1
        digit_1 = int(str[0])
#      global digit_2
        digit_2 = int(str[1])
        octet = (digit_2 << 4) | digit_1
    except:
        octet = (1 << 4) | digit_1

#    print "finished semioctifying " + str
    return octet

def resetnumber(number):
#    print "resetting number " +number
    '''
    Adds trailing F to number if length is
    odd.
    '''
    length = len(number)
    if (length % 2) != 0:
        number = number + 'F'
    print "number is " +number
    return number

def createPDUstring(number, msg):
    '''
    Returns a list of bytes to represent a valid PDU message
    '''
#    print "creating pdu string with number: " +number
#    print "and message: " +msg
    octifiedmsg = octify(msg)
    number = resetnumber(number)
    octifiednumber = [ semi_octify(number[i:i+2]) for i in range(0, len(number), 2) ]

    HEADER = 1
    FIRSTOCTETOFSMSDELIVERMSG = 10
    ADDR_TYPE = 129 #unknown format
    number_length = len(number)
    msg_length = len(msg)
    pdu_message = [HEADER, FIRSTOCTETOFSMSDELIVERMSG, number_length, ADDR_TYPE]
    pdu_message.extend(octifiednumber)
    pdu_message.append(0)
    pdu_message.append(0)
    pdu_message.append(msg_length)
    pdu_message.extend(octifiedmsg)
#    print "pdu message is " +pdu_message
    return pdu_message


class SMS(object):
    '''
    Sends sms messages
    '''

    def __init__(self, msg, number):
        self.pdustring = createPDUstring(number, msg)

    def send(self):
        self.__dbus_send(self.pdustring)
        print "sms sent"
    def __dbus_send(self, pdu_string):
#        import dbus
        bus = dbus.SystemBus()
        smsobject = bus.get_object('com.nokia.phone.SMS', '/com/nokia/phone/SMS/ba212ae1')
        smsiface = dbus.Interface(smsobject, 'com.nokia.csd.SMS.Outgoing')
        arr = dbus.Array(pdu_string)
        msgdeliver = dbus.Array([arr])
        smsiface.Send(msgdeliver,'')
        print "sending sms"
    def print_pdustring(self):
        print self.pdustring
''' x. writing to conversations '''
def write_to_rtcomm(message, number_2):
    connection = sqlite3.connect('/home/user/.rtcom-eventlogger/el.db')
    cursor = connection.cursor()
    cursor.execute('SELECT id FROM Events')
    id_array = cursor.fetchall()  
    seq_id = max(id_array)
    seq_id = seq_id[0] +1
    unixtime = int(time.time())
    cutoff = len(number_2) -7
    strippednumber = number_2[cutoff:]
    dbstring = "("+str(seq_id) + ", 3, 8, " +str(unixtime)+", " + str(unixtime) +", " +str(unixtime)+", 1, 0, 0, 0, 'ring/tel/ring', '<SelfHandle>', '" + number_2 + "', 'None', '" + message +"', '"+ strippednumber +"')"
    dbquery = "INSERT INTO Events VALUES " + dbstring
    print dbquery
    cursor.execute(dbquery)
    connection.commit()




''' 3. Address book '''
class _PyGObject_Functions(ctypes.Structure):
    _fields_ = [
        ('register_class',ctypes.PYFUNCTYPE(ctypes.c_void_p, ctypes.c_char_p,ctypes.c_int, ctypes.py_object, ctypes.py_object)),
        ('register_wrapper',ctypes.PYFUNCTYPE(ctypes.c_void_p, ctypes.py_object)),
        ('register_sinkfunc',ctypes.PYFUNCTYPE(ctypes.py_object, ctypes.c_void_p)),
        ('lookupclass',ctypes.PYFUNCTYPE(ctypes.py_object, ctypes.c_int)),
        ('newgobj',ctypes.PYFUNCTYPE(ctypes.py_object, ctypes.c_void_p)),
    ]

class PyGObjectCPAI(object):
    def __init__(self):
        import gobject
        py_obj = ctypes.py_object(gobject._PyGObject_API)
        addr = ctypes.pythonapi.PyCObject_AsVoidPtr(py_obj)
        self._api = _PyGObject_Functions.from_address(addr)

    def pygobject_new(self, addr):
        return self._api.newgobj(addr)
        

def disable_osk(widget):
    input_mode = widget.get_property("hildon-input-mode")
    input_mode = input_mode | gtk.HILDON_GTK_INPUT_MODE_NO_SCREEN_PLUGINS
    widget.set_property("hildon-input-mode", input_mode)


window = hildon.Window()
window.set_title("VertSMS")
hildon.hildon_gtk_window_set_portrait_flags(window,hildon.PORTRAIT_MODE_SUPPORT | hildon.PORTRAIT_MODE_REQUEST)
receiver = hildon.TextView()
#receiver = hildon.Entry(gtk.HILDON_SIZE_AUTO_WIDTH | 
#                          gtk.HILDON_SIZE_THUMB_HEIGHT)
receiver.set_placeholder("To")
disable_osk(receiver)
message = hildon.TextView()
message.set_wrap_mode(gtk.WRAP_WORD)
message.set_placeholder("Write your message here")
message.set_cursor_visible(True)
disable_osk(message)
buffer = message.get_buffer()
buffer_receiver = receiver.get_buffer()

osso_ctx = osso.Context("test_abook", "0.1")

sequential_presses  = 0
last_key_pressed = None
elapsed_time = 0
last_update = time.time()


capi = PyGObjectCPAI()
#c_obj = c_function_returning_gobject(capi)
#obj = capi.pygobject_new(c_obj)

    
def update_text(cursor_correction):
    start, end = buffer.get_bounds()

    if cursor_correction == 0:
        updatedtext = buffer.get_text(start,end)

    else:
        new_end = buffer.get_iter_at_offset(cursor_correction)
        updatedtext = buffer.get_text(start,new_end)
        updatedtext = updatedtext[:cursor_correction]
        buffer.set_text(updatedtext)

    return updatedtext


def addrbook(nuthin):
    osso_abook = ctypes.CDLL('libosso-abook-1.0.so.0')
    argv_type = ctypes.c_char_p * len(sys.argv)
    argv = argv_type(*sys.argv)
    argc = ctypes.c_int(len(sys.argv))
    osso_abook.osso_abook_init(ctypes.byref(argc), ctypes.byref(argv), hash(osso_ctx))
    capi = PyGObjectCPAI()
    c_chooser = osso_abook.osso_abook_contact_chooser_new(None, "Choose a contact")
    chooser = capi.pygobject_new(c_chooser)
    hildon.hildon_gtk_window_set_portrait_flags(chooser, hildon.PORTRAIT_MODE_SUPPORT)
#
    chooser.run()
    chooser.hide()
#
    contacts = osso_abook.osso_abook_contact_chooser_get_selection(c_chooser)
    glib = ctypes.CDLL('libglib-2.0.so.0')
    def glist(addr):
        class _GList(ctypes.Structure):
            _fields_ = [('data', ctypes.c_void_p),
                        ('next', ctypes.c_void_p)]
        l = addr
        while l:
            l = _GList.from_address(l)
            yield l.data
            l = l.next

    for i in glist(contacts):
      c_selector = osso_abook.osso_abook_contact_detail_selector_new_for_contact(c_chooser, i, 2) 	
      selector = capi.pygobject_new(c_selector)
      hildon.hildon_gtk_window_set_portrait_flags(selector, hildon.PORTRAIT_MODE_SUPPORT)
      selector.run()
      selector.hide()
      c_field = osso_abook.osso_abook_contact_detail_selector_get_selected_field(c_selector)
      get_display_value = osso_abook.osso_abook_contact_field_get_display_value
      get_display_value.restype = ctypes.c_char_p
      finalval = osso_abook.osso_abook_contact_field_get_display_value(c_field)
      glib.g_list_free(contacts)
#      return finalval
#        receiver = buffer_receiver
#        get_display_name = osso_abook.osso_abook_contact_get_value(receiver, "OSSO_ABOOK_CONTACT_ACTION_SMS")
##    get_display_name.restype = ctypes.c_char_p
#        receiver = buffer_receiver
#      print "selection was " + finalval
      buffer_receiver.set_text(finalval)
#        chooser.hide()
#
def input(feed):
    text = update_text(0)
    buffer.set_text(text + feed)

def timeout():
#    print "timer started"
    global sequential_presses
    global elapsed_time
    global last_update

    TIMEOUT = 1
    
    elapsed_time = time.time() - last_update
    last_update = time.time()
#    print "elapsed time: " + str(elapsed_time)
    if elapsed_time > TIMEOUT:
#     and sequential_presses > 1:
#        print "doublepress after timer"
        return True
    else:
#        print "doublepress within timer"
        return False

def number_pressed(button):
#    print "key pressed"
    key = button.get_title().strip()[0]
    global last_key_pressed
    global sequential_presses

    letters = {}
    letters['1'] = ['', '.', ',', ':', ';', '!', '?', '1']
    letters['2'] = ['', 'a', 'b', 'c', '2']
    letters['3'] = ['', 'd', 'e', 'f', '3']
    letters['4'] = ['', 'g', 'h', 'i', '4']
    letters['5'] = ['', 'j', 'k', 'l', '5']
    letters['6'] = ['', 'm', 'n', 'o', '6']
    letters['7'] = ['', 'p', 'q', 'r', 's', '7']
    letters['8'] = ['', 't', 'u', 'v', '8']
    letters['9'] = ['','w', 'x', 'y', 'z', '9']
    letters['0'] = ['',' ', '0', '\n']
    letters['*'] = ['', '*', '+']
    letters['#'] = ['', '#']

    if sequential_presses == len(letters[key]) - 1:
        sequential_presses = 0
        
    if key == last_key_pressed and not timeout():
        update_text(-1)
        sequential_presses += 1
#        print "same key pressed twice " + letters[key][sequential_presses]
        
    else:
        timeout()
        sequential_presses = 1
        last_key_pressed = key
        
#        print "you pressed a new key " + letters[key][sequential_presses]
        #elapsed_time = 0

#    print "key is " + str(key)
    output = letters[key][sequential_presses]
    input(output)

def backspace(empty):
  update_text(-1)
  global last_key_pressed
  last_key_pressed = None

def backspace_hold(widget):

  print widget.get_title()
#  buffer.delete(buffer.get_start_iter(), buffer.get_end_iter())
#  this needs to be done better
#  i=0
#  while widget.pressed():  
#    update_text(-1)
#    time.sleep(1)
#    i =+1
#    print "holded " + str(i)
  
#''' backspace copypaste'''"
#__init__ (self, ...):
#    ...
#    self.buttonReleased = True
#    self.minimumRepeatTime = 500
#    self.buttonDownTime = tomorrow
#    self.repeatButtonEvent = False
#    self.buttonPressID = 0
#    ...
#
#timer_cb (self, buttonPressID):
#    if self.buttonReleased or buttonPressID != self.buttonPressID:
#        # stop timer forever
#        return False
#    if not self.repeatButtonEvent:
#        now = getTheTime()
#        self.repeatButtonEvent = now - self.buttonDownTime >=\
#            self.minimumRepeatTime
#    if not self.repeatButtonEvent:
#        return True
#    ...
#    print a character
#    ...
#    return True
#
#on_button_press_event_cb (self, button, event, ...):
#    ...
#    self.buttonReleased = False
#    self.buttonDownTime = event.time
#    self.repeatButtonEvent = False
#    self.buttonPressID = (self.buttonPressID + 1) % 0x7fffffff
#    # I'm pretty sure this is call-by-value
#    gobject.timeout_add(150, self.timer_cb, self.buttonPressID)
#    ...
#
#on_button_release_event_cb (self, ...):
#    ...
#    self.buttonReleased = True
#    ...
#"
#'''copypaste ends'''
#
def send(widget):
  start, end = buffer.get_bounds()
  text = buffer.get_text(start,end)
  start2, end2 = buffer_receiver.get_bounds()
  number = buffer_receiver.get_text(start2,end2)
  number_2 = number
  number = number.replace('+','00')
    
  if number == "":
          note2 = "No receiver number specified!"
          banner = hildon.hildon_banner_show_information(window,"" , note2)
          print "error, no number specified!"
  
  elif text == "":
          note3 = "Message is empty!"
          banner = hildon.hildon_banner_show_information(window,"" , note3)
          print "error, message is empty!"
  
  else:
          confirm = hildon.hildon_note_new_confirmation(window, "Send message?")
#       def show_confirmation_note(parent):
#       note = hildon.hildon_note_new_confirmation(parent, "Do you want foo ?")
#   
#       response = gtk.Dialog.run(note)
#   
#       if response == gtk.RESPONSE_DELETE_EVENT:
#           print "show_information_note: gtk.RESPONSE_DELETE_EVENT"
#
          response = gtk.Dialog.run(confirm)
          gtk.Dialog.hide(confirm)
          print "response was: " +str(response)
          if response == gtk.RESPONSE_DELETE_EVENT:
            print "sending cancelled"
          elif response == gtk.RESPONSE_OK:
#            start, end = buffer.get_bounds()
#            text = buffer.get_text(start,end)
#            start2, end2 = buffer_receiver.get_bounds()
#            number = buffer_receiver.get_text(start2,end2)
#        #    print "number is " +number
#            number_2 = number
#            number = number.replace('+','00')
        #    print "final number is " +number    
        
            note = "Sending message to: " + number
            banner = hildon.hildon_banner_show_information(window,"" , note)
            sms = SMS(text, number)
            sms.send()
            write_to_rtcomm(text, number_2)
  #        sms.print_pdustring()
          else:
            print "not sent"
  
        
def main():
    program = hildon.Program.get_instance()
    program.add_window(window)

    window.connect("delete_event", gtk.main_quit, None)

    table = gtk.Table(8, 3, True)

    button_1 = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH |
                             gtk.HILDON_SIZE_THUMB_HEIGHT, 
                             hildon.BUTTON_ARRANGEMENT_VERTICAL, 
                             "  1", ".,:;!?")
    button_2 = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH |
                             gtk.HILDON_SIZE_THUMB_HEIGHT, 
                             hildon.BUTTON_ARRANGEMENT_VERTICAL, 
                             " 2", "abc")
    button_3 = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH |
                             gtk.HILDON_SIZE_THUMB_HEIGHT, 
                             hildon.BUTTON_ARRANGEMENT_VERTICAL, 
                             " 3", "def")
    button_4 = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH |
                             gtk.HILDON_SIZE_THUMB_HEIGHT, 
                             hildon.BUTTON_ARRANGEMENT_VERTICAL, 
                             " 4", "ghi")
    button_5 = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH |
                             gtk.HILDON_SIZE_THUMB_HEIGHT, 
                             hildon.BUTTON_ARRANGEMENT_VERTICAL, 
                             " 5", "jkl")
    button_6 = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH |
                             gtk.HILDON_SIZE_THUMB_HEIGHT, 
                             hildon.BUTTON_ARRANGEMENT_VERTICAL, 
                             " 6", "mno")
    button_7 = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH |
                             gtk.HILDON_SIZE_THUMB_HEIGHT, 
                             hildon.BUTTON_ARRANGEMENT_VERTICAL, 
                             "  7", "pqrs")
    button_8 = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH |
                             gtk.HILDON_SIZE_THUMB_HEIGHT, 
                             hildon.BUTTON_ARRANGEMENT_VERTICAL, 
                             " 8", "tuv")
    button_9 = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH |
                             gtk.HILDON_SIZE_THUMB_HEIGHT, 
                             hildon.BUTTON_ARRANGEMENT_VERTICAL, 
                             "  9", "wxyz")
    button_0 = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH |
                             gtk.HILDON_SIZE_THUMB_HEIGHT, 
                             hildon.BUTTON_ARRANGEMENT_VERTICAL, 
                             "0", u"_>")
#    button_star = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH |
#                                gtk.HILDON_SIZE_THUMB_HEIGHT, 
#                                hildon.BUTTON_ARRANGEMENT_VERTICAL, 
#                                "*\t", "\t+")
#    button_pound = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH |
#                                 gtk.HILDON_SIZE_THUMB_HEIGHT, 
#                                 hildon.BUTTON_ARRANGEMENT_VERTICAL, 
#"#\t", u"\t\u2191")

    button_star = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH |
                                gtk.HILDON_SIZE_THUMB_HEIGHT, 
                                hildon.BUTTON_ARRANGEMENT_VERTICAL, 
                                "*\t", "\t+")
    button_pound = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH |
                                 gtk.HILDON_SIZE_THUMB_HEIGHT, 
                                 hildon.BUTTON_ARRANGEMENT_VERTICAL, 
                                 "#\t")



    for i in range(0,10):
        for parent in eval("button_%s.get_children()" % i):    #We start with the Button itself
            for child in parent.get_children():                #Alignment containing HBox that contains the HBox with HildonButton's Labels
                for grandchild in child.get_children():           #HBox containg HBox that contains the HBox with HildonButton's Labels...
                    for great_grandchild in grandchild.get_children():        #HBox containing HildonButton's Labels
                        if isinstance(great_grandchild, gtk.Label) and great_grandchild.name == "hildon-button-title":
                            great_grandchild.modify_font(pango.FontDescription("Nokia Sans Bold 35px"))
                        elif isinstance(great_grandchild, gtk.Label) and great_grandchild.name == "hildon-button-value":
                            hildon.hildon_helper_set_logical_font(great_grandchild, "SystemFont")

    button_send = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH |
                                gtk.HILDON_SIZE_THUMB_HEIGHT, 
                                hildon.BUTTON_ARRANGEMENT_VERTICAL, "Send")
    button_send.set_name("hildon-accept-button-thumb")

    button_back = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH |
                                gtk.HILDON_SIZE_THUMB_HEIGHT, 
                                hildon.BUTTON_ARRANGEMENT_VERTICAL)
    button_back.set_image(gtk.image_new_from_icon_name("call_dialpad_backspace", gtk.ICON_SIZE_DIALOG))

    button_to = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH |
                              gtk.HILDON_SIZE_THUMB_HEIGHT, 
                              hildon.BUTTON_ARRANGEMENT_VERTICAL, "To:")

    table.attach(button_to, 0, 1, 0, 1)
    table.attach(receiver, 1, 3, 0, 1)
    table.attach(message, 0, 3, 1, 3)
    table.attach(button_send, 0, 2, 3, 4)
    table.attach(button_back, 2, 3, 3, 4)
    table.attach(button_1, 0, 1,  4, 5)
    table.attach(button_2, 1, 2,  4, 5)
    table.attach(button_3, 2, 3,  4, 5)
    table.attach(button_4, 0, 1,  5, 6)
    table.attach(button_5, 1, 2,  5, 6)
    table.attach(button_6, 2, 3,  5, 6)
    table.attach(button_7, 0, 1,  6, 7)
    table.attach(button_8, 1, 2,  6, 7)
    table.attach(button_9, 2, 3,  6, 7)
    table.attach(button_star, 0, 1, 7, 8)
    table.attach(button_0, 1, 2, 7, 8)
    table.attach(button_pound, 2, 3, 7, 8)

    button_back.tap_and_hold_setup(None, None, 0)
    button_send.connect("clicked", send)
    button_back.connect("clicked", backspace)
    button_back.connect("tap-and-hold", backspace_hold)
    button_to.connect("clicked", addrbook)
    button_1.connect("clicked", number_pressed)
    button_2.connect("clicked", number_pressed)
    button_3.connect("clicked", number_pressed)
    button_4.connect("clicked", number_pressed)
    button_5.connect("clicked", number_pressed)
    button_6.connect("clicked", number_pressed)
    button_7.connect("clicked", number_pressed)
    button_8.connect("clicked", number_pressed)
    button_9.connect("clicked", number_pressed)
    button_0.connect("clicked", number_pressed)
    button_star.connect('clicked', number_pressed)
    button_pound.connect('clicked', number_pressed)
    window.add(table)
    window.show_all()

    gtk.main()

if __name__ == "__main__":
    main()

