# Uncomment this to turn on verbose mode.
#export DH_VERBOSE=1

# Values lifted from setup.py and control file
PYVERS=$(shell pyversions -vr debian/control)

ifeq ($(origin py_package), undefined)
  py_package=$(shell van-pydeb src_to_py `dpkg-parsechangelog -c1 -ldebian/changelog | grep 'Source: ' | sed 's/Source: //'`)
endif

ifeq ($(origin package), undefined)
  package=$(shell van-pydeb py_to_bin $(py_package))
endif

-include /usr/share/python/python.mk
ifeq (,$(py_sitename))
  py_sitename = site-packages
  py_libdir = /usr/lib/python$(subst python,,$(1))/site-packages
  py_sitename_sh = $(py_sitename)
  py_libdir_sh = $(py_libdir)
endif

build: $(PYVERS:%=build-python%)
	touch $@
build-python%:
	dh_testdir
	python$* setup.py build
	touch $@

.PHONY: clean
clean:
	dh_testdir
	dh_testroot
	$(MAKE) -f debian/rules $(PYVERS:%=clean-python%)
	rm -f build-python?.?
	rm -rf build
	rm -rf dist
	find -iname '*.pyc' -exec rm -f {} \;
	dh_clean

clean-python%:
	python$* setup.py clean

.PHONY: install
install: build
	dh_testdir
	dh_testroot
	dh_clean -k
	dh_installdirs
	$(MAKE) -f debian/rules $(PYVERS:%=install-python%)

install-python%:
	python$* setup.py install --no-compile --single-version-externally-managed $(py_setup_install_args) --root=debian/$(package) --install-data=usr/lib/$(package)
	mv debian/$(package)$(call py_libdir,$*)/$(py_package)-*-py$*.egg-info \
	   debian/$(package)$(call py_libdir,$*)/$(py_package).egg-info 
	find debian/$(package)$(call py_libdir,$*) -name "$(py_package)-*-nspkg.pth" -exec \
	   mv {} debian/$(package)$(call py_libdir,$*)/$(py_package)-nspkg.pth \;
	$(MAKE) -f debian/rules dependencies-python$*
	$(MAKE) -f debian/rules post-install-python$*

post-install-python%:
	echo

dependencies-python%:
	(echo -n 'setuptools:Depends=' && van-pydeb depends --egg-info debian/$(package)$(call py_libdir,$*)/$(py_package).egg-info) >> debian/$(package).substvars
	(echo -n 'setuptools:Provides=' && van-pydeb provides --egg-info debian/$(package)$(call py_libdir,$*)/$(py_package).egg-info) >> debian/$(package).substvars

.PHONY: binary-common
binary-common:
	dh_testdir
	dh_testroot
	dh_install
	dh_installchangelogs
	dh_installdocs
	dh_installexamples
	dh_installman
	dh_link
	dh_strip
	dh_compress
	dh_fixperms
	dh_pycentral
	dh_makeshlibs
	dh_installdeb
	dh_shlibdeps
	dh_gencontrol
	dh_md5sums
	dh_builddeb

.PHONY: binary-indep
binary-indep: install
	$(MAKE) -f debian/rules DH_OPTIONS=-i binary-common

.PHONY: binary-arch
binary-arch: install
	$(MAKE) -f debian/rules DH_OPTIONS=-a binary-common

.PHONY: binary
binary: binary-indep binary-arch
