objects = {}

objects["Barrel1"] = {
    animation_filename = "img/sprites/map/objects/barrel1.lua",
    coll_half_width = 0.78,
    coll_height = 1.6,
    img_half_width = 0.78,
    img_height = 2.125
}

objects["Bed1"] = {
    animation_filename = "img/sprites/map/objects/bed1.lua",
    coll_half_width = 1.75,
    coll_height = 5.50,
    img_half_width = 1.75,
    img_height = 5.68
}

objects["Bed2"] = {
    animation_filename = "img/sprites/map/objects/bed2.lua",
    coll_half_width = 3.31,
    coll_height = 5.50,
    img_half_width = 3.31,
    img_height = 5.68
}

objects["Bench1"] = {
    animation_filename = "img/sprites/map/objects/bench1.lua",
    coll_half_width = 3.0,
    coll_height = 1.6,
    img_half_width = 3.0,
    img_height = 2.0
}

objects["Bench2"] = {
    animation_filename = "img/sprites/map/objects/bench2.lua",
    coll_half_width = 1.0,
    coll_height = 1.6,
    img_half_width = 1.0,
    img_height = 2.0
}

objects["Box1"] = {
    animation_filename = "img/sprites/map/objects/box1.lua",
    coll_half_width = 1.0,
    coll_height = 2.27,
    img_half_width = 1.0,
    img_height = 2.37
}

objects["Book1"] = {
    animation_filename = "img/sprites/map/objects/book1.lua",
    coll_half_width = 1.0,
    coll_height = 1.8,
    img_half_width = 1.0,
    img_height = 2.0
}

objects["Bread1"] = {
    animation_filename = "img/sprites/map/objects/bread1.lua",
    coll_half_width = 1.0,
    coll_height = 1.8,
    img_half_width = 1.0,
    img_height = 2.0
}

objects["Bush1"] = {
    animation_filename = "img/sprites/map/objects/bush1.lua",
    coll_half_width = 1.9,
    coll_height = 3.8,
    img_half_width = 2.0,
    img_height = 4.0
}

objects["Bush2"] = {
    animation_filename = "img/sprites/map/objects/bush2.lua",
    coll_half_width = 1.9,
    coll_height = 3.8,
    img_half_width = 2.0,
    img_height = 4.0
}

objects["Bush3"] = {
    animation_filename = "img/sprites/map/objects/bush3.lua",
    coll_half_width = 1.9,
    coll_height = 3.8,
    img_half_width = 2.0,
    img_height = 4.0
}

objects["Bush4"] = {
    animation_filename = "img/sprites/map/objects/bush4.lua",
    coll_half_width = 1.9,
    coll_height = 3.8,
    img_half_width = 2.0,
    img_height = 4.0
}

objects["Campfire1"] = {
    animation_filename = "img/sprites/map/objects/campfire.lua",
    coll_half_width = 1.0,
    coll_height = 1.6,
    img_half_width = 2.0,
    img_height = 4.0
}

objects["Candle1"] = {
    animation_filename = "img/sprites/map/objects/candle1.lua",
    coll_half_width = 1.0,
    coll_height = 1.8,
    img_half_width = 1.0,
    img_height = 2.0
}

objects["Cat1"] = {
    animation_filename = "img/sprites/map/objects/cat1.lua",
    coll_half_width = 0.95,
    coll_height = 0.9,
    img_half_width = 0.68,
    img_height = 1.56
}

objects["Chair1"] = {
    animation_filename = "img/sprites/map/objects/chair1.lua",
    coll_half_width = 0.95,
    coll_height = 0.9,
    img_half_width = 0.95,
    img_height = 2.9
}

objects["Chair1_inverted"] = {
    animation_filename = "img/sprites/map/objects/chair1_inverted.lua",
    coll_half_width = 0.95,
    coll_height = 0.9,
    img_half_width = 0.95,
    img_height = 2.9
}

objects["Chair1_north"] = {
    animation_filename = "img/sprites/map/objects/chair1_north.lua",
    coll_half_width = 0.75,
    coll_height = 0.9,
    img_half_width = 0.75,
    img_height = 2.81
}

objects["Chair2"] = {
    animation_filename = "img/sprites/map/objects/chair2.lua",
    coll_half_width = 0.95,
    coll_height = 0.9,
    img_half_width = 0.95,
    img_height = 2.9
}

objects["Clock1"] = {
    animation_filename = "img/sprites/map/objects/clock1.lua",
    coll_half_width = 1.0,
    coll_height = 1.9,
    img_half_width = 1.0,
    img_height = 2.0
}

objects["Dog1"] = {
    animation_filename = "img/sprites/map/objects/dog1.lua",
    coll_half_width = 1.18,
    coll_height = 1.6,
    img_half_width = 1.18,
    img_height = 2.6
}

objects["Fence1 horizontal"] = {
    animation_filename = "img/sprites/map/objects/fence1-horizontal.lua",
    coll_half_width = 1.0,
    coll_height = 1.2,
    img_half_width = 1.0,
    img_height = 2.0
}

objects["Fence1 vertical"] = {
    animation_filename = "img/sprites/map/objects/fence1-vertical.lua",
    coll_half_width = 0.6,
    coll_height = 2.0,
    img_half_width = 1.0,
    img_height = 2.0
}

objects["Fence1 l top left"] = {
    animation_filename = "img/sprites/map/objects/fence1-l-top-left.lua",
    coll_half_width = 0.6,
    coll_height = 1.2,
    img_half_width = 1.0,
    img_height = 2.0
}

objects["Fence1 l top right"] = {
    animation_filename = "img/sprites/map/objects/fence1-l-top-right.lua",
    coll_half_width = 0.6,
    coll_height = 1.2,
    img_half_width = 1.0,
    img_height = 2.0
}

objects["Fence1 l bottom left"] = {
    animation_filename = "img/sprites/map/objects/fence1-l-bottom-left.lua",
    coll_half_width = 0.6,
    coll_height = 1.2,
    img_half_width = 1.0,
    img_height = 2.0
}

objects["Fence1 l bottom right"] = {
    animation_filename = "img/sprites/map/objects/fence1-l-bottom-right.lua",
    coll_half_width = 0.6,
    coll_height = 1.2,
    img_half_width = 1.0,
    img_height = 2.0
}

objects["Flower Pot1"] = {
    animation_filename = "img/sprites/map/objects/flower_pot1.lua",
    coll_half_width = 0.59,
    coll_height = 1.2,
    img_half_width = 0.59,
    img_height = 1.68
}

objects["Flower Pot2"] = {
    animation_filename = "img/sprites/map/objects/flower_pot2.lua",
    coll_half_width = 0.53,
    coll_height = 1.2,
    img_half_width = 0.53,
    img_height = 1.75
}

objects["Gate1 closed"] = {
    animation_filename = "img/sprites/map/objects/gate1_closed.lua",
    coll_half_width = 2.0,
    coll_height = 1.0,
    img_half_width = 2.0,
    img_height = 6.0
}

objects["Gate1 open"] = {
    animation_filename = "img/sprites/map/objects/gate1_open.lua",
    coll_half_width = 2.0,
    coll_height = 1.0,
    img_half_width = 2.0,
    img_height = 2.0
}

objects["Grass Clump1"] = {
    animation_filename = "img/sprites/map/objects/grass_clump1.lua",
    coll_half_width = 2.2,
    coll_height = 1.2,
    img_half_width = 2.5,
    img_height = 3.5
}

objects["Green Pepper1"] = {
    animation_filename = "img/sprites/map/objects/green_pepper1.lua",
    coll_half_width = 1.0,
    coll_height = 1.8,
    img_half_width = 1.0,
    img_height = 2.0
}

objects["Harlequin"] = {
    animation_filename = "img/sprites/map/objects/harlequin.lua",
    coll_half_width = 2.3,
    coll_height = 2.0,
    img_half_width = 2.46,
    img_height = 5.8
}

objects["Knife1"] = {
    animation_filename = "img/sprites/map/objects/knife1.lua",
    coll_half_width = 1.0,
    coll_height = 1.8,
    img_half_width = 1.0,
    img_height = 2.0
}

objects["Layna Statue"] = {
    animation_filename = "img/sprites/map/objects/layna_statue.lua",
    coll_half_width = 0.93,
    coll_height = 2.0,
    img_half_width = 0.93,
    img_height = 5.31
}

objects["Locker"] = {
    animation_filename = "img/sprites/map/objects/locker.lua",
    coll_half_width = 0.75,
    coll_height = 1.1,
    img_half_width = 0.75,
    img_height = 1.43
}

objects["Paper and Feather"] = {
    animation_filename = "img/sprites/map/objects/paper_feather.lua",
    coll_half_width = 0.93,
    coll_height = 1.75,
    img_half_width = 0.93,
    img_height = 1.75
}

objects["Parchment"] = {
    animation_filename = "img/sprites/map/objects/parchment.lua",
    coll_half_width = 0.59,
    coll_height = 1.31,
    img_half_width = 0.59,
    img_height = 1.31
}

objects["Plate Pile1"] = {
    animation_filename = "img/sprites/map/objects/plate_pile1.lua",
    coll_half_width = 1.0,
    coll_height = 1.8,
    img_half_width = 1.0,
    img_height = 2.0
}

objects["Rock1"] = {
    animation_filename = "img/sprites/map/objects/rock1.lua",
    coll_half_width = 1.0,
    coll_height = 1.63,
    img_half_width = 1.0,
    img_height = 1.93
}

objects["Rock2"] = {
    animation_filename = "img/sprites/map/objects/rock2.lua",
    coll_half_width = 0.9,
    coll_height = 1.78,
    img_half_width = 0.9,
    img_height = 3.56
}

objects["Rock3"] = {
    animation_filename = "img/sprites/map/objects/rock3.lua",
    coll_half_width = 4.0,
    coll_height = 6.0,
    img_half_width = 4.0,
    img_height = 6.0
}

objects["Rolling Stone"] = {
    animation_filename = "img/sprites/map/objects/rolling_stone.lua",
    coll_half_width = 0.9,
    coll_height = 1.8,
    img_half_width = 1.0,
    img_height = 2.0
}

objects["Sauce Pot1"] = {
    animation_filename = "img/sprites/map/objects/sauce_pot1.lua",
    coll_half_width = 1.0,
    coll_height = 1.8,
    img_half_width = 1.0,
    img_height = 2.0
}

objects["Shroom"] = {
    animation_filename = "img/sprites/map/enemies/spiky_mushroom_idle_object.lua",
    coll_half_width = 0.9,
    coll_height = 1.9,
    img_half_width = 1.25,
    img_height = 2.6
}

objects["Stone Sign1"] = {
   animation_filename = "img/sprites/map/objects/stone_sign1.lua",
   coll_half_width = 1.03,
   coll_height = 2.18,
   img_half_width = 1.03,
   img_height = 2.18
}

objects["Stele1"] = {
   animation_filename = "img/sprites/map/objects/stele1.lua",
   coll_half_width = 1.0,
   coll_height = 2.18,
   img_half_width = 1.06,
   img_height = 4.0
}

objects["Table1"] = {
    animation_filename = "img/sprites/map/objects/table1.lua",
    coll_half_width = 2.95,
    coll_height = 3.9,
    img_half_width = 2.95,
    img_height = 5.0
}

objects["Table2"] = {
    animation_filename = "img/sprites/map/objects/table2.lua",
    coll_half_width = 2.95,
    coll_height = 3.9,
    img_half_width = 2.95,
    img_height = 5.0
}

objects["Big Wooden Table"] = {
    animation_filename = "img/sprites/map/objects/wooden_table_big.lua",
    coll_half_width = 3.0,
    coll_height = 4.77,
    img_half_width = 3.0,
    img_height = 4.87
}

objects["Small Wooden Table"] = {
    animation_filename = "img/sprites/map/objects/wooden_table_small.lua",
    coll_half_width = 2.0,
    coll_height = 2.7,
    img_half_width = 2.0,
    img_height = 4.0
}

objects["Salad1"] = {
    animation_filename = "img/sprites/map/objects/salad1.lua",
    coll_half_width = 1.0,
    coll_height = 1.8,
    img_half_width = 1.0,
    img_height = 2.0
}

objects["Tree Big1"] = {
    animation_filename = "img/sprites/map/objects/tree_big1.lua",
    coll_half_width = 3.0,
    coll_height = 4.0,
    img_half_width = 3.0,
    img_height = 8.0
}

objects["Tree Big2"] = {
    animation_filename = "img/sprites/map/objects/tree_big2.lua",
    coll_half_width = 2.0,
    coll_height = 3.4,
    img_half_width = 2.0,
    img_height = 6.8
}

objects["Tree Little1"] = {
    animation_filename = "img/sprites/map/objects/tree_little1.lua",
    coll_half_width = 1.5,
    coll_height = 2.8,
    img_half_width = 2.0,
    img_height = 6.0
}

objects["Tree Little2"] = {
    animation_filename = "img/sprites/map/objects/tree_little2.lua",
    coll_half_width = 1.5,
    coll_height = 2.8,
    img_half_width = 2.0,
    img_height = 6.0
}

objects["Tree Little3"] = {
    animation_filename = "img/sprites/map/objects/tree_little3.lua",
    coll_half_width = 1.5,
    coll_height = 2.8,
    img_half_width = 2.0,
    img_height = 6.0
}

objects["Tree Little4"] = {
    animation_filename = "img/sprites/map/objects/tree_little4.lua",
    coll_half_width = 1.5,
    coll_height = 2.8,
    img_half_width = 2.0,
    img_height = 6.0
}

objects["Tree Small1"] = {
    animation_filename = "img/sprites/map/objects/tree_small1.lua",
    coll_half_width = 1.75,
    coll_height = 2.43,
    img_half_width = 1.75,
    img_height = 4.87
}

objects["Tree Small2"] = {
    animation_filename = "img/sprites/map/objects/tree_small2.lua",
    coll_half_width = 3.0,
    coll_height = 3.0,
    img_half_width = 3.0,
    img_height = 6.0
}

objects["Tree Small3"] = {
    animation_filename = "img/sprites/map/objects/tree_small3.lua",
    coll_half_width = 2.0,
    coll_height = 2.5,
    img_half_width = 3.5,
    img_height = 8.0
}

objects["Tree Small3 Tilting"] = {
    animation_filename = "img/sprites/map/objects/tree_small3_tilting.lua",
    coll_half_width = 2.0,
    coll_height = 2.5,
    img_half_width = 3.46,
    img_height = 8.25
}

objects["Tree Small4"] = {
    animation_filename = "img/sprites/map/objects/tree_small4.lua",
    coll_half_width = 2.0,
    coll_height = 2.5,
    img_half_width = 3.5,
    img_height = 8.0
}

objects["Tree Small5"] = {
    animation_filename = "img/sprites/map/objects/tree_small5.lua",
    coll_half_width = 2.0,
    coll_height = 2.5,
    img_half_width = 3.5,
    img_height = 8.0
}

objects["Tree Small5 Fallen"] = {
    animation_filename = "img/sprites/map/objects/tree_small5_fallen.lua",
    coll_half_width = 4.0,
    coll_height = 3.5,
    img_half_width = 4.03,
    img_height = 7.0
}

objects["Tree Small6"] = {
    animation_filename = "img/sprites/map/objects/tree_small6.lua",
    coll_half_width = 2.0,
    coll_height = 2.5,
    img_half_width = 3.5,
    img_height = 8.0
}

objects["Tree Tiny1"] = {
    animation_filename = "img/sprites/map/objects/tree_tiny1.lua",
    coll_half_width = 1.6,
    coll_height = 1.7,
    img_half_width = 2.0,
    img_height = 4.0
}

objects["Tree Tiny2"] = {
    animation_filename = "img/sprites/map/objects/tree_tiny2.lua",
    coll_half_width = 1.6,
    coll_height = 1.7,
    img_half_width = 2.0,
    img_height = 4.0
}

objects["Tree Tiny3"] = {
    animation_filename = "img/sprites/map/objects/tree_tiny3.lua",
    coll_half_width = 1.6,
    coll_height = 1.7,
    img_half_width = 2.0,
    img_height = 4.0
}

objects["Tree Tiny4"] = {
    animation_filename = "img/sprites/map/objects/tree_tiny4.lua",
    coll_half_width = 1.6,
    coll_height = 1.7,
    img_half_width = 2.0,
    img_height = 4.0
}

objects["Vase1"] = {
    animation_filename = "img/sprites/map/objects/vase1.lua",
    coll_half_width = 0.75,
    coll_height = 1.2,
    img_half_width = 0.75,
    img_height = 1.5
}

objects["Well"] = {
    animation_filename = "img/sprites/map/objects/well.lua",
    coll_half_width = 2.10,
    coll_height = 3.20,
    img_half_width = 2.43,
    img_height = 4.56
}

objects["Wooden Sword1"] = {
    animation_filename = "img/sprites/map/objects/wooden_sword1.lua",
    coll_half_width = 0.65,
    coll_height = 2.5,
    img_half_width = 0.65,
    img_height = 2.5
}

-- "Ground" lights
-- Those are special light effect that have to be applied before the sky layer
objects["Left Window Light"] = {
    animation_filename = "img/misc/lights/left_window_light.lua",
    coll_half_width = 0.0,
    coll_height = 0.0,
    img_half_width = 1.56,
    img_height = 4.5
}

objects["Right Window Light"] = {
    animation_filename = "img/misc/lights/right_window_light.lua",
    coll_half_width = 0.0,
    coll_height = 0.0,
    img_half_width = 1.56,
    img_height = 4.5
}

objects["Left Window Light 2"] = {
    animation_filename = "img/misc/lights/left_window_light.lua",
    coll_half_width = 0.0,
    coll_height = 0.0,
    img_half_width = 2.56,
    img_height = 6.5
}

objects["Right Window Light 2"] = {
    animation_filename = "img/misc/lights/right_window_light.lua",
    coll_half_width = 0.0,
    coll_height = 0.0,
    img_half_width = 2.56,
    img_height = 6.5
}

-- The helper function permitting to easily create a prepared map object
function CreateObject(Map, name, x, y)
    if (objects[name] == nil) then
        print("Error: No object named: "..name.." found!!");
        return nil;
    end

    if (Map == nil) then
        print("Error: Function called with invalid Map object");
        return nil;
    end

    local object = {}
    object = vt_map.PhysicalObject();
    object:SetObjectID(Map.object_supervisor:GenerateObjectID());
    object:SetPosition(x, y);
    object:SetCollHalfWidth(objects[name].coll_half_width);
    object:SetCollHeight(objects[name].coll_height);
    object:SetImgHalfWidth(objects[name].img_half_width);
    object:SetImgHeight(objects[name].img_height);
    object:AddAnimation(objects[name].animation_filename);

    return object;
end
