/* valacodecontext.c generated by valac, the Vala compiler
 * generated from valacodecontext.vala, do not modify */

/* valacodecontext.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <config.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>


#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContext ValaCodeContext;
typedef struct _ValaCodeContextClass ValaCodeContextClass;
typedef struct _ValaCodeContextPrivate ValaCodeContextPrivate;

#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_MEMBER (vala_member_get_type ())
#define VALA_MEMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_MEMBER, ValaMember))
#define VALA_MEMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_MEMBER, ValaMemberClass))
#define VALA_IS_MEMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_MEMBER))
#define VALA_IS_MEMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_MEMBER))
#define VALA_MEMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_MEMBER, ValaMemberClass))

typedef struct _ValaMember ValaMember;
typedef struct _ValaMemberClass ValaMemberClass;

#define VALA_TYPE_METHOD (vala_method_get_type ())
#define VALA_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD, ValaMethod))
#define VALA_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD, ValaMethodClass))
#define VALA_IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD))
#define VALA_IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD))
#define VALA_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD, ValaMethodClass))

typedef struct _ValaMethod ValaMethod;
typedef struct _ValaMethodClass ValaMethodClass;

#define VALA_TYPE_PROFILE (vala_profile_get_type ())

#define VALA_TYPE_REPORT (vala_report_get_type ())
#define VALA_REPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_REPORT, ValaReport))
#define VALA_REPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_REPORT, ValaReportClass))
#define VALA_IS_REPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_REPORT))
#define VALA_IS_REPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_REPORT))
#define VALA_REPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_REPORT, ValaReportClass))

typedef struct _ValaReport ValaReport;
typedef struct _ValaReportClass ValaReportClass;

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;

#define VALA_TYPE_NAMESPACE (vala_namespace_get_type ())
#define VALA_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NAMESPACE, ValaNamespace))
#define VALA_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NAMESPACE, ValaNamespaceClass))
#define VALA_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NAMESPACE))
#define VALA_IS_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NAMESPACE))
#define VALA_NAMESPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NAMESPACE, ValaNamespaceClass))

typedef struct _ValaNamespace ValaNamespace;
typedef struct _ValaNamespaceClass ValaNamespaceClass;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_CODE_GENERATOR (vala_code_generator_get_type ())
#define VALA_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGenerator))
#define VALA_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))
#define VALA_IS_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_GENERATOR))
#define VALA_IS_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_GENERATOR))
#define VALA_CODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))

typedef struct _ValaCodeGenerator ValaCodeGenerator;
typedef struct _ValaCodeGeneratorClass ValaCodeGeneratorClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
typedef struct _ValaParamSpecCodeContext ValaParamSpecCodeContext;

struct _ValaCodeContext {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeContextPrivate * priv;
};

struct _ValaCodeContextClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeContext *self);
};

typedef enum  {
	VALA_PROFILE_POSIX,
	VALA_PROFILE_GOBJECT
} ValaProfile;

struct _ValaCodeContextPrivate {
	gboolean _assert;
	gboolean _checking;
	gboolean _deprecated;
	gboolean _experimental;
	gboolean _experimental_non_null;
	gboolean _dbus_transformation;
	gboolean _ccode_only;
	char* _header_filename;
	char* _internal_header_filename;
	gboolean _use_header;
	char* _includedir;
	char* _symbols_filename;
	gboolean _compile_only;
	char* _output;
	char* _basedir;
	char* _directory;
	gboolean _debug;
	gint _optlevel;
	gboolean _thread;
	ValaMethod* _module_init_method;
	gboolean _save_temps;
	ValaProfile _profile;
	gint _target_glib_major;
	gint _target_glib_minor;
	gboolean _verbose_mode;
	ValaReport* _report;
	ValaMethod* _entry_point;
	char* _entry_point_name;
	ValaList* source_files;
	ValaList* c_source_files;
	ValaNamespace* _root;
	ValaList* packages;
	ValaSet* defines;
	ValaCodeGenerator* _codegen;
};

struct _ValaParamSpecCodeContext {
	GParamSpec parent_instance;
};


static GStaticPrivate vala_code_context_context_stack_key;
static GStaticPrivate vala_code_context_context_stack_key = {0};
static gpointer vala_code_context_parent_class = NULL;

gpointer vala_code_context_ref (gpointer instance);
void vala_code_context_unref (gpointer instance);
GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_context (GValue* value, gpointer v_object);
gpointer vala_value_get_code_context (const GValue* value);
GType vala_code_context_get_type (void);
gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void);
GType vala_symbol_get_type (void);
GType vala_member_get_type (void);
GType vala_method_get_type (void);
GType vala_profile_get_type (void);
GType vala_report_get_type (void);
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void);
GType vala_namespace_get_type (void);
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void);
GType vala_code_generator_get_type (void);
#define VALA_CODE_CONTEXT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CODE_CONTEXT, ValaCodeContextPrivate))
enum  {
	VALA_CODE_CONTEXT_DUMMY_PROPERTY
};
ValaReport* vala_report_new (void);
ValaReport* vala_report_construct (GType object_type);
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void);
ValaNamespace* vala_namespace_new (const char* name, ValaSourceReference* source_reference);
ValaNamespace* vala_namespace_construct (GType object_type, const char* name, ValaSourceReference* source_reference);
ValaCodeGenerator* vala_code_generator_new (void);
ValaCodeGenerator* vala_code_generator_construct (GType object_type);
gint vala_code_context_get_target_glib_major (ValaCodeContext* self);
gint vala_code_context_get_target_glib_minor (ValaCodeContext* self);
gboolean vala_code_context_require_glib_version (ValaCodeContext* self, gint major, gint minor);
ValaCodeContext* vala_code_context_new (void);
ValaCodeContext* vala_code_context_construct (GType object_type);
ValaCodeContext* vala_code_context_get (void);
void vala_code_context_push (ValaCodeContext* context);
void vala_code_context_pop (void);
ValaList* vala_code_context_get_source_files (ValaCodeContext* self);
ValaList* vala_code_context_get_c_source_files (ValaCodeContext* self);
void vala_code_context_add_source_file (ValaCodeContext* self, ValaSourceFile* file);
void vala_code_context_add_c_source_file (ValaCodeContext* self, const char* file);
ValaList* vala_code_context_get_packages (ValaCodeContext* self);
gboolean vala_code_context_has_package (ValaCodeContext* self, const char* pkg);
void vala_code_context_add_package (ValaCodeContext* self, const char* pkg);
ValaNamespace* vala_code_context_get_root (ValaCodeContext* self);
void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
void vala_source_file_accept (ValaSourceFile* self, ValaCodeVisitor* visitor);
void vala_code_context_accept (ValaCodeContext* self, ValaCodeVisitor* visitor);
void vala_code_context_add_define (ValaCodeContext* self, const char* define);
gboolean vala_code_context_is_defined (ValaCodeContext* self, const char* define);
static char* vala_code_context_get_file_path (ValaCodeContext* self, const char* basename, const char* data_dir, char** directories, int directories_length1);
char* vala_code_context_get_package_path (ValaCodeContext* self, const char* pkg, char** directories, int directories_length1);
char* vala_code_context_get_gir_path (ValaCodeContext* self, const char* gir, char** directories, int directories_length1);
gboolean vala_code_context_get_assert (ValaCodeContext* self);
void vala_code_context_set_assert (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_checking (ValaCodeContext* self);
void vala_code_context_set_checking (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_deprecated (ValaCodeContext* self);
void vala_code_context_set_deprecated (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_experimental (ValaCodeContext* self);
void vala_code_context_set_experimental (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_experimental_non_null (ValaCodeContext* self);
void vala_code_context_set_experimental_non_null (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_dbus_transformation (ValaCodeContext* self);
void vala_code_context_set_dbus_transformation (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_ccode_only (ValaCodeContext* self);
void vala_code_context_set_ccode_only (ValaCodeContext* self, gboolean value);
const char* vala_code_context_get_header_filename (ValaCodeContext* self);
void vala_code_context_set_header_filename (ValaCodeContext* self, const char* value);
const char* vala_code_context_get_internal_header_filename (ValaCodeContext* self);
void vala_code_context_set_internal_header_filename (ValaCodeContext* self, const char* value);
gboolean vala_code_context_get_use_header (ValaCodeContext* self);
void vala_code_context_set_use_header (ValaCodeContext* self, gboolean value);
const char* vala_code_context_get_includedir (ValaCodeContext* self);
void vala_code_context_set_includedir (ValaCodeContext* self, const char* value);
const char* vala_code_context_get_symbols_filename (ValaCodeContext* self);
void vala_code_context_set_symbols_filename (ValaCodeContext* self, const char* value);
gboolean vala_code_context_get_compile_only (ValaCodeContext* self);
void vala_code_context_set_compile_only (ValaCodeContext* self, gboolean value);
const char* vala_code_context_get_output (ValaCodeContext* self);
void vala_code_context_set_output (ValaCodeContext* self, const char* value);
const char* vala_code_context_get_basedir (ValaCodeContext* self);
void vala_code_context_set_basedir (ValaCodeContext* self, const char* value);
const char* vala_code_context_get_directory (ValaCodeContext* self);
void vala_code_context_set_directory (ValaCodeContext* self, const char* value);
gboolean vala_code_context_get_debug (ValaCodeContext* self);
void vala_code_context_set_debug (ValaCodeContext* self, gboolean value);
gint vala_code_context_get_optlevel (ValaCodeContext* self);
void vala_code_context_set_optlevel (ValaCodeContext* self, gint value);
gboolean vala_code_context_get_thread (ValaCodeContext* self);
void vala_code_context_set_thread (ValaCodeContext* self, gboolean value);
ValaMethod* vala_code_context_get_module_init_method (ValaCodeContext* self);
void vala_code_context_set_module_init_method (ValaCodeContext* self, ValaMethod* value);
gboolean vala_code_context_get_save_temps (ValaCodeContext* self);
void vala_code_context_set_save_temps (ValaCodeContext* self, gboolean value);
ValaProfile vala_code_context_get_profile (ValaCodeContext* self);
void vala_code_context_set_profile (ValaCodeContext* self, ValaProfile value);
void vala_code_context_set_target_glib_major (ValaCodeContext* self, gint value);
void vala_code_context_set_target_glib_minor (ValaCodeContext* self, gint value);
gboolean vala_code_context_get_verbose_mode (ValaCodeContext* self);
void vala_code_context_set_verbose_mode (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_save_csources (ValaCodeContext* self);
ValaReport* vala_code_context_get_report (ValaCodeContext* self);
void vala_code_context_set_report (ValaCodeContext* self, ValaReport* value);
ValaMethod* vala_code_context_get_entry_point (ValaCodeContext* self);
void vala_code_context_set_entry_point (ValaCodeContext* self, ValaMethod* value);
const char* vala_code_context_get_entry_point_name (ValaCodeContext* self);
void vala_code_context_set_entry_point_name (ValaCodeContext* self, const char* value);
ValaCodeGenerator* vala_code_context_get_codegen (ValaCodeContext* self);
void vala_code_context_set_codegen (ValaCodeContext* self, ValaCodeGenerator* value);
static void vala_code_context_finalize (ValaCodeContext* obj);
static gint _vala_array_length (gpointer array);



gboolean vala_code_context_require_glib_version (ValaCodeContext* self, gint major, gint minor) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->_target_glib_major > major) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp1_ = FALSE;
		if (self->priv->_target_glib_major == major) {
			_tmp1_ = self->priv->_target_glib_minor >= minor;
		} else {
			_tmp1_ = FALSE;
		}
		_tmp0_ = _tmp1_;
	}
	result = _tmp0_;
	return result;
}


ValaCodeContext* vala_code_context_construct (GType object_type) {
	ValaCodeContext* self;
	self = (ValaCodeContext*) g_type_create_instance (object_type);
	return self;
}


ValaCodeContext* vala_code_context_new (void) {
	return vala_code_context_construct (VALA_TYPE_CODE_CONTEXT);
}


ValaCodeContext* vala_code_context_get (void) {
	ValaCodeContext* result;
	ValaList* context_stack;
	context_stack = g_static_private_get (&vala_code_context_context_stack_key);
	result = (ValaCodeContext*) vala_list_get (context_stack, vala_collection_get_size ((ValaCollection*) context_stack) - 1);
	return result;
}


void vala_code_context_push (ValaCodeContext* context) {
	ValaList* context_stack;
	g_return_if_fail (context != NULL);
	context_stack = g_static_private_get (&vala_code_context_context_stack_key);
	if (context_stack == NULL) {
		context_stack = vala_array_list_new (VALA_TYPE_CODE_CONTEXT, (GBoxedCopyFunc) vala_code_context_ref, vala_code_context_unref, g_direct_equal);
		g_static_private_set (&vala_code_context_context_stack_key, context_stack, NULL);
	}
	vala_collection_add ((ValaCollection*) context_stack, context);
}


void vala_code_context_pop (void) {
	ValaList* context_stack;
	context_stack = g_static_private_get (&vala_code_context_context_stack_key);
	vala_list_remove_at (context_stack, vala_collection_get_size ((ValaCollection*) context_stack) - 1);
}


ValaList* vala_code_context_get_source_files (ValaCodeContext* self) {
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = (ValaList*) vala_read_only_list_new (VALA_TYPE_SOURCE_FILE, (GBoxedCopyFunc) vala_source_file_ref, vala_source_file_unref, self->priv->source_files);
	return result;
}


ValaList* vala_code_context_get_c_source_files (ValaCodeContext* self) {
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = (ValaList*) vala_read_only_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, self->priv->c_source_files);
	return result;
}


void vala_code_context_add_source_file (ValaCodeContext* self, ValaSourceFile* file) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	vala_collection_add ((ValaCollection*) self->priv->source_files, file);
}


void vala_code_context_add_c_source_file (ValaCodeContext* self, const char* file) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	vala_collection_add ((ValaCollection*) self->priv->c_source_files, file);
}


ValaList* vala_code_context_get_packages (ValaCodeContext* self) {
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = (ValaList*) vala_read_only_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, self->priv->packages);
	return result;
}


gboolean vala_code_context_has_package (ValaCodeContext* self, const char* pkg) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (pkg != NULL, FALSE);
	result = vala_collection_contains ((ValaCollection*) self->priv->packages, pkg);
	return result;
}


void vala_code_context_add_package (ValaCodeContext* self, const char* pkg) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (pkg != NULL);
	vala_collection_add ((ValaCollection*) self->priv->packages, pkg);
}


void vala_code_context_accept (ValaCodeContext* self, ValaCodeVisitor* visitor) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (visitor != NULL);
	vala_code_node_accept ((ValaCodeNode*) vala_code_context_get_root (self), visitor);
	{
		ValaIterator* _file_it;
		_file_it = vala_iterable_iterator ((ValaIterable*) self->priv->source_files);
		while (TRUE) {
			ValaSourceFile* file;
			if (!vala_iterator_next (_file_it)) {
				break;
			}
			file = (ValaSourceFile*) vala_iterator_get (_file_it);
			vala_source_file_accept (file, visitor);
			_vala_source_file_unref0 (file);
		}
		_vala_collection_object_unref0 (_file_it);
	}
}


void vala_code_context_add_define (ValaCodeContext* self, const char* define) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (define != NULL);
	vala_collection_add ((ValaCollection*) self->priv->defines, define);
}


gboolean vala_code_context_is_defined (ValaCodeContext* self, const char* define) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (define != NULL, FALSE);
	result = vala_collection_contains ((ValaCollection*) self->priv->defines, define);
	return result;
}


char* vala_code_context_get_package_path (ValaCodeContext* self, const char* pkg, char** directories, int directories_length1) {
	char* result;
	char* _tmp0_;
	char* _tmp1_;
	char* path;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (pkg != NULL, NULL);
	path = (_tmp1_ = vala_code_context_get_file_path (self, _tmp0_ = g_strconcat (pkg, ".vapi", NULL), "vala/vapi", directories, directories_length1), _g_free0 (_tmp0_), _tmp1_);
	if (path == NULL) {
		char* _tmp2_;
		char* _tmp3_;
		char* filename;
		filename = (_tmp3_ = g_build_filename (PACKAGE_DATADIR, "vapi", _tmp2_ = g_strconcat (pkg, ".vapi", NULL), NULL), _g_free0 (_tmp2_), _tmp3_);
		if (g_file_test (filename, G_FILE_TEST_EXISTS)) {
			char* _tmp4_;
			path = (_tmp4_ = g_strdup (filename), _g_free0 (path), _tmp4_);
		}
		_g_free0 (filename);
	}
	result = path;
	return result;
}


char* vala_code_context_get_gir_path (ValaCodeContext* self, const char* gir, char** directories, int directories_length1) {
	char* result;
	char* _tmp0_;
	char* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (gir != NULL, NULL);
	result = (_tmp1_ = vala_code_context_get_file_path (self, _tmp0_ = g_strconcat (gir, ".gir", NULL), "gir-1.0", directories, directories_length1), _g_free0 (_tmp0_), _tmp1_);
	return result;
}


static char* vala_code_context_get_file_path (ValaCodeContext* self, const char* basename, const char* data_dir, char** directories, int directories_length1) {
	char* result;
	char* filename;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (basename != NULL, NULL);
	g_return_val_if_fail (data_dir != NULL, NULL);
	filename = NULL;
	if (directories != NULL) {
		{
			char** dir_collection;
			int dir_collection_length1;
			int dir_it;
			dir_collection = directories;
			dir_collection_length1 = directories_length1;
			for (dir_it = 0; dir_it < directories_length1; dir_it = dir_it + 1) {
				char* dir;
				dir = g_strdup (dir_collection[dir_it]);
				{
					char* _tmp0_;
					filename = (_tmp0_ = g_build_filename (dir, basename, NULL), _g_free0 (filename), _tmp0_);
					if (g_file_test (filename, G_FILE_TEST_EXISTS)) {
						result = filename;
						_g_free0 (dir);
						return result;
					}
					_g_free0 (dir);
				}
			}
		}
	}
	{
		char** _tmp1_;
		char** dir_collection;
		int dir_collection_length1;
		int dir_it;
		dir_collection = _tmp1_ = g_get_system_data_dirs ();
		dir_collection_length1 = _vala_array_length (_tmp1_);
		for (dir_it = 0; dir_it < _vala_array_length (_tmp1_); dir_it = dir_it + 1) {
			char* dir;
			dir = g_strdup (dir_collection[dir_it]);
			{
				char* _tmp2_;
				filename = (_tmp2_ = g_build_filename (dir, data_dir, basename, NULL), _g_free0 (filename), _tmp2_);
				if (g_file_test (filename, G_FILE_TEST_EXISTS)) {
					result = filename;
					_g_free0 (dir);
					return result;
				}
				_g_free0 (dir);
			}
		}
	}
	result = NULL;
	_g_free0 (filename);
	return result;
}


gboolean vala_code_context_get_assert (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_assert;
	return result;
}


void vala_code_context_set_assert (ValaCodeContext* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_assert = value;
}


gboolean vala_code_context_get_checking (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_checking;
	return result;
}


void vala_code_context_set_checking (ValaCodeContext* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_checking = value;
}


gboolean vala_code_context_get_deprecated (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_deprecated;
	return result;
}


void vala_code_context_set_deprecated (ValaCodeContext* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_deprecated = value;
}


gboolean vala_code_context_get_experimental (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_experimental;
	return result;
}


void vala_code_context_set_experimental (ValaCodeContext* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_experimental = value;
}


gboolean vala_code_context_get_experimental_non_null (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_experimental_non_null;
	return result;
}


void vala_code_context_set_experimental_non_null (ValaCodeContext* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_experimental_non_null = value;
}


gboolean vala_code_context_get_dbus_transformation (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_dbus_transformation;
	return result;
}


void vala_code_context_set_dbus_transformation (ValaCodeContext* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_dbus_transformation = value;
}


gboolean vala_code_context_get_ccode_only (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_ccode_only;
	return result;
}


void vala_code_context_set_ccode_only (ValaCodeContext* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_ccode_only = value;
}


const char* vala_code_context_get_header_filename (ValaCodeContext* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_header_filename;
	return result;
}


void vala_code_context_set_header_filename (ValaCodeContext* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_header_filename = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_header_filename), _tmp0_);
}


const char* vala_code_context_get_internal_header_filename (ValaCodeContext* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_internal_header_filename;
	return result;
}


void vala_code_context_set_internal_header_filename (ValaCodeContext* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_internal_header_filename = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_internal_header_filename), _tmp0_);
}


gboolean vala_code_context_get_use_header (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_use_header;
	return result;
}


void vala_code_context_set_use_header (ValaCodeContext* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_use_header = value;
}


const char* vala_code_context_get_includedir (ValaCodeContext* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_includedir;
	return result;
}


void vala_code_context_set_includedir (ValaCodeContext* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_includedir = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_includedir), _tmp0_);
}


const char* vala_code_context_get_symbols_filename (ValaCodeContext* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_symbols_filename;
	return result;
}


void vala_code_context_set_symbols_filename (ValaCodeContext* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_symbols_filename = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_symbols_filename), _tmp0_);
}


gboolean vala_code_context_get_compile_only (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_compile_only;
	return result;
}


void vala_code_context_set_compile_only (ValaCodeContext* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_compile_only = value;
}


const char* vala_code_context_get_output (ValaCodeContext* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_output;
	return result;
}


void vala_code_context_set_output (ValaCodeContext* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_output = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_output), _tmp0_);
}


const char* vala_code_context_get_basedir (ValaCodeContext* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_basedir;
	return result;
}


void vala_code_context_set_basedir (ValaCodeContext* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_basedir = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_basedir), _tmp0_);
}


const char* vala_code_context_get_directory (ValaCodeContext* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_directory;
	return result;
}


void vala_code_context_set_directory (ValaCodeContext* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_directory = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_directory), _tmp0_);
}


gboolean vala_code_context_get_debug (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_debug;
	return result;
}


void vala_code_context_set_debug (ValaCodeContext* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_debug = value;
}


gint vala_code_context_get_optlevel (ValaCodeContext* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_optlevel;
	return result;
}


void vala_code_context_set_optlevel (ValaCodeContext* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_optlevel = value;
}


gboolean vala_code_context_get_thread (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_thread;
	return result;
}


void vala_code_context_set_thread (ValaCodeContext* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_thread = value;
}


ValaMethod* vala_code_context_get_module_init_method (ValaCodeContext* self) {
	ValaMethod* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_module_init_method;
	return result;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


void vala_code_context_set_module_init_method (ValaCodeContext* self, ValaMethod* value) {
	ValaMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_module_init_method = (_tmp0_ = _vala_code_node_ref0 (value), _vala_code_node_unref0 (self->priv->_module_init_method), _tmp0_);
}


gboolean vala_code_context_get_save_temps (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_save_temps;
	return result;
}


void vala_code_context_set_save_temps (ValaCodeContext* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_save_temps = value;
}


ValaProfile vala_code_context_get_profile (ValaCodeContext* self) {
	ValaProfile result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_profile;
	return result;
}


void vala_code_context_set_profile (ValaCodeContext* self, ValaProfile value) {
	g_return_if_fail (self != NULL);
	self->priv->_profile = value;
}


gint vala_code_context_get_target_glib_major (ValaCodeContext* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_target_glib_major;
	return result;
}


void vala_code_context_set_target_glib_major (ValaCodeContext* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_target_glib_major = value;
}


gint vala_code_context_get_target_glib_minor (ValaCodeContext* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_target_glib_minor;
	return result;
}


void vala_code_context_set_target_glib_minor (ValaCodeContext* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_target_glib_minor = value;
}


gboolean vala_code_context_get_verbose_mode (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_verbose_mode;
	return result;
}


void vala_code_context_set_verbose_mode (ValaCodeContext* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_verbose_mode = value;
}


gboolean vala_code_context_get_save_csources (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_save_temps;
	return result;
}


ValaReport* vala_code_context_get_report (ValaCodeContext* self) {
	ValaReport* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_report;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void vala_code_context_set_report (ValaCodeContext* self, ValaReport* value) {
	ValaReport* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_report = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_report), _tmp0_);
}


ValaMethod* vala_code_context_get_entry_point (ValaCodeContext* self) {
	ValaMethod* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_entry_point;
	return result;
}


void vala_code_context_set_entry_point (ValaCodeContext* self, ValaMethod* value) {
	ValaMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_entry_point = (_tmp0_ = _vala_code_node_ref0 (value), _vala_code_node_unref0 (self->priv->_entry_point), _tmp0_);
}


const char* vala_code_context_get_entry_point_name (ValaCodeContext* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_entry_point_name;
	return result;
}


void vala_code_context_set_entry_point_name (ValaCodeContext* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_entry_point_name = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_entry_point_name), _tmp0_);
}


ValaNamespace* vala_code_context_get_root (ValaCodeContext* self) {
	ValaNamespace* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_root;
	return result;
}


ValaCodeGenerator* vala_code_context_get_codegen (ValaCodeContext* self) {
	ValaCodeGenerator* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_codegen;
	return result;
}


static gpointer _vala_code_visitor_ref0 (gpointer self) {
	return self ? vala_code_visitor_ref (self) : NULL;
}


void vala_code_context_set_codegen (ValaCodeContext* self, ValaCodeGenerator* value) {
	ValaCodeGenerator* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_codegen = (_tmp0_ = _vala_code_visitor_ref0 (value), _vala_code_visitor_unref0 (self->priv->_codegen), _tmp0_);
}


static void vala_value_code_context_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_code_context_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_code_context_unref (value->data[0].v_pointer);
	}
}


static void vala_value_code_context_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_code_context_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_code_context_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_code_context_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaCodeContext* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_code_context_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_code_context_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaCodeContext** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_code_context_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecCodeContext* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_CODE_CONTEXT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer vala_value_get_code_context (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CODE_CONTEXT), NULL);
	return value->data[0].v_pointer;
}


void vala_value_set_code_context (GValue* value, gpointer v_object) {
	ValaCodeContext* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CODE_CONTEXT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_CODE_CONTEXT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_code_context_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_code_context_unref (old);
	}
}


static void vala_code_context_class_init (ValaCodeContextClass * klass) {
	GStaticPrivate _tmp0_ = {0};
	vala_code_context_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_CONTEXT_CLASS (klass)->finalize = vala_code_context_finalize;
	g_type_class_add_private (klass, sizeof (ValaCodeContextPrivate));
	vala_code_context_context_stack_key = (g_static_private_init (&_tmp0_), _tmp0_);
}


static void vala_code_context_instance_init (ValaCodeContext * self) {
	self->priv = VALA_CODE_CONTEXT_GET_PRIVATE (self);
	self->priv->_report = vala_report_new ();
	self->priv->source_files = (ValaList*) vala_array_list_new (VALA_TYPE_SOURCE_FILE, (GBoxedCopyFunc) vala_source_file_ref, vala_source_file_unref, g_direct_equal);
	self->priv->c_source_files = (ValaList*) vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_direct_equal);
	self->priv->_root = vala_namespace_new (NULL, NULL);
	self->priv->packages = (ValaList*) vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_equal);
	self->priv->defines = (ValaSet*) vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal);
	self->priv->_codegen = vala_code_generator_new ();
	self->ref_count = 1;
}


static void vala_code_context_finalize (ValaCodeContext* obj) {
	ValaCodeContext * self;
	self = VALA_CODE_CONTEXT (obj);
	_g_free0 (self->priv->_header_filename);
	_g_free0 (self->priv->_internal_header_filename);
	_g_free0 (self->priv->_includedir);
	_g_free0 (self->priv->_symbols_filename);
	_g_free0 (self->priv->_output);
	_g_free0 (self->priv->_basedir);
	_g_free0 (self->priv->_directory);
	_vala_code_node_unref0 (self->priv->_module_init_method);
	_g_object_unref0 (self->priv->_report);
	_vala_code_node_unref0 (self->priv->_entry_point);
	_g_free0 (self->priv->_entry_point_name);
	_vala_collection_object_unref0 (self->priv->source_files);
	_vala_collection_object_unref0 (self->priv->c_source_files);
	_vala_code_node_unref0 (self->priv->_root);
	_vala_collection_object_unref0 (self->priv->packages);
	_vala_collection_object_unref0 (self->priv->defines);
	_vala_code_visitor_unref0 (self->priv->_codegen);
}


GType vala_code_context_get_type (void) {
	static GType vala_code_context_type_id = 0;
	if (vala_code_context_type_id == 0) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_code_context_init, vala_value_code_context_free_value, vala_value_code_context_copy_value, vala_value_code_context_peek_pointer, "p", vala_value_code_context_collect_value, "p", vala_value_code_context_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaCodeContextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_code_context_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCodeContext), 0, (GInstanceInitFunc) vala_code_context_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		vala_code_context_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaCodeContext", &g_define_type_info, &g_define_type_fundamental_info, 0);
	}
	return vala_code_context_type_id;
}


gpointer vala_code_context_ref (gpointer instance) {
	ValaCodeContext* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void vala_code_context_unref (gpointer instance) {
	ValaCodeContext* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_CODE_CONTEXT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}




