#include <QtGui>
#include <iostream>
#include <string.h>

#define PROCESSING "Processing..."

class QUssd : public QMainWindow {
	Q_OBJECT

	public:
		QUssd(QString message, bool lock = false) {
			number = "";

			QActionGroup *filterGroup = new QActionGroup(this);
			filterGroup->setExclusive(true);

			actPortrait = new QAction(tr("Portrait"), filterGroup);
			actPortrait->setCheckable(true);

			actLandscape = new QAction(tr("Landscape"), filterGroup);
			actLandscape->setCheckable(true);

			actAuto = new QAction(tr("Auto"), filterGroup);
			actAuto->setCheckable(true);
			actAuto->setChecked(true);
		
			menuBar()->addActions(filterGroup->actions());

			connect(actPortrait, SIGNAL(changed()), this, SLOT(setOrientation()));
			connect(actLandscape, SIGNAL(changed()), this, SLOT(setOrientation()));
			connect(actAuto, SIGNAL(changed()), this, SLOT(setOrientation()));

			replyLabel = new QLabel(message);
			replyLabel->setMinimumWidth(400);
			replyLabel->setMaximumHeight(100);
			replyLabel->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Maximum);

			numberLabel = new QLabel("");
			replyLabel->setMinimumWidth(400);
			replyLabel->setMinimumHeight(150);
			replyLabel->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);

			indicationLayout = new QVBoxLayout;
			indicationLayout->addWidget(numberLabel);
			indicationLayout->addWidget(replyLabel);

			padDel = new QPushButton("C");
			connect(padDel, SIGNAL(clicked()), this, SLOT(del()));
			padDel->setMaximumWidth(150);
			padDel->setMaximumHeight(72);
			padDel->setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Expanding);
			padSend = new QPushButton("SEND");
			connect(padSend, SIGNAL(clicked()), this, SLOT(send()));
			padSend->setMaximumWidth(300);
			padSend->setMaximumHeight(72);
			padSend->setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Expanding);

			btnLayout = new QHBoxLayout;
			btnLayout->addWidget(padSend);
			btnLayout->addWidget(padDel);

			numberPad = new QGridLayout();
			numberPad->setSpacing(2);

			padBtn1 = new QPushButton("1");
			connect(padBtn1, SIGNAL(clicked()), this, SLOT(add1()));
			padBtn1->setMaximumWidth(150);
			padBtn1->setMaximumHeight(72);
			padBtn1->setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Expanding);
			numberPad->addWidget(padBtn1, 0, 0);
			padBtn2 = new QPushButton("2");
			connect(padBtn2, SIGNAL(clicked()), this, SLOT(add2()));
			padBtn2->setMaximumWidth(150);
			padBtn2->setMaximumHeight(72);
			padBtn2->setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Expanding);
			numberPad->addWidget(padBtn2, 0, 1);
			padBtn3 = new QPushButton("3");
			connect(padBtn3, SIGNAL(clicked()), this, SLOT(add3()));
			padBtn3->setMaximumWidth(150);
			padBtn3->setMaximumHeight(72);
			padBtn3->setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Expanding);
			numberPad->addWidget(padBtn3, 0, 2);
			padBtn4 = new QPushButton("4");
			connect(padBtn4, SIGNAL(clicked()), this, SLOT(add4()));
			padBtn4->setMaximumWidth(150);
			padBtn4->setMaximumHeight(72);
			padBtn4->setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Expanding);
			numberPad->addWidget(padBtn4, 1, 0);
			padBtn5 = new QPushButton("5");
			connect(padBtn5, SIGNAL(clicked()), this, SLOT(add5()));
			padBtn5->setMaximumWidth(150);
			padBtn5->setMaximumHeight(72);
			padBtn5->setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Expanding);
			numberPad->addWidget(padBtn5, 1, 1);
			padBtn6 = new QPushButton("6");
			connect(padBtn6, SIGNAL(clicked()), this, SLOT(add6()));
			padBtn6->setMaximumWidth(150);
			padBtn6->setMaximumHeight(72);
			padBtn6->setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Expanding);
			numberPad->addWidget(padBtn6, 1, 2);
			padBtn7 = new QPushButton("7");
			connect(padBtn7, SIGNAL(clicked()), this, SLOT(add7()));
			padBtn7->setMaximumWidth(150);
			padBtn7->setMaximumHeight(72);
			padBtn7->setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Expanding);
			numberPad->addWidget(padBtn7, 2, 0);
			padBtn8 = new QPushButton("8");
			connect(padBtn8, SIGNAL(clicked()), this, SLOT(add8()));
			padBtn8->setMaximumWidth(150);
			padBtn8->setMaximumHeight(72);
			padBtn8->setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Expanding);
			numberPad->addWidget(padBtn8, 2, 1);
			padBtn9 = new QPushButton("9");
			connect(padBtn9, SIGNAL(clicked()), this, SLOT(add9()));
			padBtn9->setMaximumWidth(150);
			padBtn9->setMaximumHeight(72);
			padBtn9->setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Expanding);
			numberPad->addWidget(padBtn9, 2, 2);
			padBtnStar = new QPushButton("*+");
			connect(padBtnStar, SIGNAL(clicked()), this, SLOT(addStar()));
			padBtnStar->setMaximumWidth(150);
			padBtnStar->setMaximumHeight(72);
			padBtnStar->setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Expanding);
			numberPad->addWidget(padBtnStar, 3, 0);
			padBtn0 = new QPushButton("0");
			connect(padBtn0, SIGNAL(clicked()), this, SLOT(add0()));
			padBtn0->setMaximumWidth(150);
			padBtn0->setMaximumHeight(72);
			padBtn0->setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Expanding);
			numberPad->addWidget(padBtn0, 3, 1);
			padBtnGrid = new QPushButton("#");
			connect(padBtnGrid, SIGNAL(clicked()), this, SLOT(addGrid()));
			padBtnGrid->setMaximumWidth(150);
			padBtnGrid->setMaximumHeight(72);
			padBtnGrid->setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Expanding);
			numberPad->addWidget(padBtnGrid, 3, 2);

			centralWidget = new QWidget;
			setCentralWidget(centralWidget);
			mainLayout = new QGridLayout(centralWidget);

			connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged()));
			setOrientation();
			orientationChanged();

			startUSSD (lock);
		}

		~QUssd () {
			USSDquery->write("exit\n");
			USSDquery->closeWriteChannel();
			USSDquery->waitForFinished();

			delete USSDquery;
		}

	public slots:
		void restartUSSD( int, QProcess::ExitStatus) {
			replyLabel->setText(QString("Error: ")+QString::fromUtf8(reply));
			reply = "";
			number = "";
			setNumber();

			delete USSDquery;
			startUSSD ();
		}


		void send() {	
			USSDquery->write(number.toUtf8().data());
			USSDquery->write("\n");
			number = tr(PROCESSING);
			setNumber();
		}

		void readData() {
			QByteArray line;
			for (line = USSDquery->readLine(); !line.isEmpty(); line = USSDquery->readLine()) {
				reply += line;
				if (reply.endsWith("\n==MESSAGE END ==\n")) {
					reply.chop(strlen("\n==MESSAGE END ==\n"));
					if (!reply.isEmpty())
						replyLabel->setText(QString::fromUtf8(reply));
					reply = "";
					number = "";
					setNumber();
					break;
				}
			}
		}

		void setOrientation() {
			if (actLandscape->isChecked())
				setAttribute(Qt::WA_Maemo5LandscapeOrientation, true);
			else if (actPortrait->isChecked())
				setAttribute(Qt::WA_Maemo5PortraitOrientation, true);
			else
				setAttribute(Qt::WA_Maemo5AutoOrientation, true);
		}

		void orientationChanged() {
			QRect screenGeometry = QApplication::desktop()->screenGeometry();
			mainLayout->removeItem(indicationLayout);
			mainLayout->removeItem(numberPad);
			mainLayout->removeItem(btnLayout);
			
			if (screenGeometry.width() > screenGeometry.height()) {
				mainLayout->addLayout(indicationLayout, 0, 0);
				mainLayout->addLayout(btnLayout, 1, 0);
				mainLayout->addLayout(numberPad, 0, 1, -1, 1);
			} else {
				mainLayout->addLayout(indicationLayout, 0, 0);
				mainLayout->addLayout(numberPad, 1, 0);
				mainLayout->addLayout(btnLayout, 2, 0);
			}
		}
	
		void add1 () {
			if (number != tr(PROCESSING)) {
				number += "1";
				setNumber();
			}
		}

		void add2 () {
			if (number != tr(PROCESSING)) {
				number += "2";
				setNumber();
			}
		}

		void add3 () {
			if (number != tr(PROCESSING)) {
				number += "3";
				setNumber();
			}
		}

		void add4 () {
			if (number != tr(PROCESSING)) {
				number += "4";
				setNumber();
			}
		}

		void add5 () {
			if (number != tr(PROCESSING)) {
				number += "5";
				setNumber();
			}
		}

		void add6 () {
			if (number != tr(PROCESSING)) {
				number += "6";
				setNumber();
			}
		}
	
		void add7 () {
			if (number != tr(PROCESSING)) {
				number += "7";
				setNumber();
			}
		}

		void add8 () {
			if (number != tr(PROCESSING)) {
				number += "8";
				setNumber();
			}
		}

		void add9 () {
			if (number != tr(PROCESSING)) {
				number += "9";
				setNumber();
			}
		}

		void add0 () {
			if (number != tr(PROCESSING)) {
				number += "0";
				setNumber();
			}
		}

		void addGrid () {
			if (number != tr(PROCESSING)) {
				number += "#";
				setNumber();
			}
		}

		void addStar () {
			if (number != tr(PROCESSING)) {
				// Do not change star if it was created more than 3 seconds before.
				if (number[number.length()-1] == '*' && lastStar.elapsed() < 3*1000) {
					number[number.length()-1] = '+';
				} else {
					number += "*";
					lastStar = QTime();
					lastStar.start();
				}
				setNumber();
			}
		}

		void del () {
			if (number != tr(PROCESSING)) {
				number.chop(1);
				setNumber();
			}
		}

	private:
		void startUSSD (bool lock = false) {
			QString program = "ussdquery.py";
			QStringList arguments;
			arguments << "interactive" << "-d" << "\n==MESSAGE END ==\n";
			if (lock)
				arguments << "-m";

			USSDquery = new QProcess();
			USSDquery->setProcessChannelMode(QProcess::MergedChannels);
			connect(USSDquery, SIGNAL(readyReadStandardOutput()), this, SLOT(readData()));
			connect(USSDquery, SIGNAL(readyReadStandardError()), this, SLOT(readData()));
			connect(USSDquery, SIGNAL(finished( int, QProcess::ExitStatus )), this, SLOT(restartUSSD( int, QProcess::ExitStatus )));

			USSDquery->start(program, arguments);
		}

		void setNumber () {
			numberLabel->setText(QString("<p style=\"font-size: 30pt;\" align=\"center\">")+number+"</p>");
		}

		QLabel *replyLabel;
		QLabel *numberLabel;
		QAction *actPortrait;
		QAction *actLandscape;
		QAction *actAuto;

		QVBoxLayout *indicationLayout;
		QHBoxLayout *btnLayout;
		QGridLayout *numberPad;
		QGridLayout *mainLayout;
		QWidget* centralWidget;

		QPushButton *padBtn1;
		QPushButton *padBtn2;
		QPushButton *padBtn3;
		QPushButton *padBtn4;
		QPushButton *padBtn5;
		QPushButton *padBtn6;
		QPushButton *padBtn7;
		QPushButton *padBtn8;
		QPushButton *padBtn9;
		QPushButton *padBtn0;
		QPushButton *padBtnStar;
		QPushButton *padBtnGrid;

		QPushButton *padDel;
		QPushButton *padSend;

		QProcess *USSDquery;

		QString number;
		QByteArray reply;

		QTime lastStar;
};

int main(int argc, char *argv[]) {
	QApplication app(argc, argv);

	bool lock = false;
	QString message;
	if (argc >= 2)
		message = message.fromUtf8(argv[1]);
	if (argc >=3 && !strcmp(argv[2], "lock"))
		lock = true;

	QUssd w(message, lock);
	w.show();
	
	return app.exec();
}

#include "qussd.moc"
