/**************************************************************************

    URPO

    Unix Remote Printing Operation
    Copyright (c) Arto Hyvättinen 2010

    This file is part of URPO.

    URPO is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    URPO is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.


**************************************************************************/

#include "urpoconnection.h"


UrpoConnection::UrpoConnection()
{
    debugMonitor_ = 0;
}

UrpoConnection::~UrpoConnection()
{

}


QObject* UrpoConnection::getDebugMonitor() const
{
    return debugMonitor_;
}

void UrpoConnection::setDebugMonitor(QObject *monitor)
{
    debugMonitor_ = monitor;
}

QString UrpoConnection::getHostString()
{
    // Get string user@host OR host (if userid empty)
    QString hostString;
    if( !getUserid().isEmpty())
        hostString=getUserid() + "@";
    hostString.append( getHost());
    return hostString;
}

QString UrpoConnection::getKeyOption()
{
    if( getIdentity().isEmpty())
        return QString();   // No identity
    else
        return QString("-i ").append(getIdentity() + " ");
}
