/**************************************************************************

    URPO

    Unix Remote Printing Operation
    Copyright (c) Arto Hyvättinen 2010

    This file is part of URPO.

    URPO is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    URPO is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.


**************************************************************************/

#ifndef PRINTWIDGET_H
#define PRINTWIDGET_H

#include <QWidget>

class QLineEdit;
class QPushButton;
class QComboBox;
class QProgressBar;
class QLabel;
class QSpinBox;

/*! GUI Widget of Urpo printing

  @author Arto Hyvättinen
  @date 2010-06-17
  @version 0.1


  */
class PrintWidget : public QWidget
{
    Q_OBJECT
public:
    explicit PrintWidget(QWidget *parent = 0);
    /*! Set printers

      Set printers and enable printing if printer exists

      @arg printers List of printer names
      */
    void setPrinters(QStringList printers);

signals:
    /*! User press Cancel button */
    void cancel();
    /*! User press Reconnect button */
    void reconnect();
    /*! User press Print button */
    void print(QString file, QString options);

public slots:
    /*! Set status information

      @arg message Message to show. Use html tags for red error color
      @arg busy Show busy progress bar
      */
    void setStatus(QString message=QString(), bool busy=false);
    /*! Set ready to print

      Enable print button and set status message to ready

      @arg ready Is ready to print
      */
    void setReady(bool ready);
    void browseFile();  /*! Press browse button */
    void doPrint();     /*! Press print button */
    void doCancel() { emit cancel(); } /*! Press cancel button */


private:
    QLineEdit*      filenameEdit;
    QPushButton*    browseButton;
    QComboBox*      printerCombo;
    QComboBox*      persheetCombo;
    QLineEdit*      rangeEdit;
    QSpinBox*       copiesSpin;
    QPushButton*    printButton;
    QLabel*         statusLabel;
    QProgressBar*   progressBar;
    QPushButton*    cancelButton;
    QPushButton*    reconnectButton;
};

#endif // PRINTWIDGET_H
