#include <QtGui/QApplication>
#include <QTranslator>
#include "urpomainwindow.h"
#include <QString>
#include <cstdlib>

/*! @mainpage Urpo - Unix Remote Printing Operation


  @author Arto Hyvättinen
  @version 0.9
  @date 2010-06

  Urpo prints to remote computer via cups and ssh. Urpo is designed for Maemo.

  Urpo uses Qt library. It it translated into Finnish.

  */



int main(int argc, char *argv[])
{
    QApplication a(argc, argv);

    QTranslator appTranslator;
    // using LANG enviroment variable instead of QLocale because of Qt on Maemo problem
    // bug #6136
    QString language = std::getenv("LANG");
    appTranslator.load("urpo_" + language.toLower() ,":/");
    a.installTranslator(&appTranslator);

    UrpoMainWindow w;
#if defined(Q_WS_S60)
    w.showMaximized();
#else
    w.show();
#endif

    return a.exec();
}
