#!/usr/bin/python
# -*- coding: utf-8 -*-
#
#
#   Copyright (c) 2007 Urho Konttori <urho.konttori@gmail.com>
#
#   This program is free software; you can redistribute it and/or
#   modify it under the terms of the GNU General Public License as
#   published by the Free Software Foundation; either version 2 of the
#   License, or (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful, but
#   WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
#   General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
#   02111-1307, USA.
#


#TODO: Add dynamic categories: New, most played, lastPLayed
 
import pygame, os, sys
from pygame.locals import *
import md5 # FIXME: md5 is deprecated in python 2.5, use hashlib instead



def toggleFullscreen():
    global winstyle, changed, cdClicked
    cdClicked=1
    changed=1

    if (winstyle == 1):
        winstyle = FULLSCREEN
    else:
        winstyle = 1
    screen = pygame.display.set_mode(SCREENRECT.size, winstyle, bestdepth)
    clearScreen()
    if viewMode == ALBUMLISTVIEW:
        updateCovers()
    elif viewMode == ALBUMCONTENTVIEW:
        print "should update the view - alas, cannot"
    elif viewMode == VIDEOLISTVIEW:
        updateClips()
    pygame.display.flip()
    return screen



def handleRowUp( selectedCD ):
    if viewMode == ALBUMLISTVIEW:
        selectedCD = selectedCD + 3
    
    if viewMode == VIDEOLISTVIEW:
        selectedCD = selectedCD + 3
    
    return selectedCD

def handleRowDown(selectedCD):
    if viewMode == ALBUMLISTVIEW:
        selectedCD = selectedCD - 3
    
    if viewMode == VIDEOLISTVIEW:
        selectedCD = selectedCD - 3
    
    return selectedCD

os.environ["SDL_VIDEO_X11_WMCLASS"]="ukmp"

ISMAEMO=0
SONGITEMMAXCOUNT=35
NOT_MAC=False
if os.name=="posix" and os.path.exists('/media/mmc1'): 
    ISMAEMO=1
    NOT_MAC=True

DISPLAY_ROTATE=False
if ISMAEMO:  DISPLAY_ROTATE=True
defaultPath="/Volumes/OSX/iTunes"
if len(sys.argv)>1:
     DISPLAY_ROTATE=int(sys.argv[1])
if len(sys.argv)>2:
     defaultPath=sys.argv[2]
     


if ISMAEMO == 1:    
    import osso
    import gst,pygst
    import dbus
    #import dbus.glib
    import dbus.service
    import gobject
    
    
    bus = dbus.SessionBus()
    searchproxy = bus.get_object('org.freedesktop.Tracker','/org/freedesktop/Tracker/Search')
    metadataproxy=bus.get_object('org.freedesktop.Tracker','/org/freedesktop/Tracker/Metadata')
    print "dbus set"
    try:
        osso_c = osso.Context("ukmp", "1.0", False)        
        # Turn the backlight on (for convinience if you are running this remotely from SSH shell)
        #device = osso.DeviceState(osso_c)
        #device.display_state_on()
        #osso_rpc = osso.Rpc(osso_c)        
    except:
        print "OSSO CONTEXT FAILED"    


SCREENRECT = Rect(0, 0, 800, 480)
#SCREENRECT = Rect(0, 0, 480, 800)
#if DISPLAY_ROTATE:
#    SCREENRECT = Rect(0, 0, 800, 480)
THUMBNAIL_SIZE = [128, 128]
ALBUMSPACEWIDTH=150#143
ALBUMSPACEHEIGHT=180#143
ALBUMWIDTH=128
ALBUMHEIGHT=128
ALBUMYSCROLL=180
ALBUMSTARTX=25
ALBUMSTARTY=90+ALBUMYSCROLL

VIDEOCOVERWIDTH=240
REFLECTIONSTART=700
ALBUMBOTTOM=750

BGCOLOR=0,0,0
MAINFONTCOLOR=240,240,240
ALTFONTCOLOR=0,0,0
MAINFONTBGCOLOR=0,0,0
MAINTRANSPARENTCOLOR=255,0,0
SMOOTHSCROLLENABLED=True
VIDEOSMOOTHSCROLLENABLED=True
SCROLLENABLED=True
SONGLISTSTARTX=140
SONGLISTSTARTY=140

SONGLISTHEIGHT=75
if DISPLAY_ROTATE:
    SONGLISTSTARTY=70
SHINEX=0
SHINEY=0
SHINEVX=0
SHINEVY=0
buttonDown=0
currentPlayFile="/"

OSSO_MEDIA_SERVER_PATH="/com/nokia/osso_media_server"
OSSO_MEDIA_SERVER_IFC="com.nokia.osso_media_server"
OSSO_MEDIA_SERVER_MUSIC_IFC="com.nokia.osso_media_server.music"

albumTextBG=pygame.Surface((ALBUMWIDTH, 30))
albumTextBG.fill((0,0,0))
albumTextBG.set_alpha(90)

videoTextBG=pygame.Surface((VIDEOCOVERWIDTH, 30))
videoTextBG.fill((0,0,0))
videoTextBG.set_alpha(90)

pilImported=False
progressChanged=False

songPosition=0
print "pre-pygame-init"

pygame.init()
pygame.display.set_caption('ukmp')
print "pygame init complete"

#if NOT_MAC: pygame.mixer.quit() 


winstyle = 1
if ISMAEMO: winstyle = FULLSCREEN
bestdepth = pygame.display.mode_ok(SCREENRECT.size, winstyle, 16)
screen = pygame.display.set_mode(SCREENRECT.size, winstyle, bestdepth)
if ISMAEMO: pygame.mouse.set_visible(True)

import md5
import unicodedata

import  random,os,urllib,time,string, shutil,math,  time, gc

import id3reader
from ID3 import *
from PyAtom import *


# View constants
PLAYPOSSIBLE=0

volume=0.5
shuffleClicked=0
socketOk=True


lastSongPosition=0
currentAlbumSongCount=0
# TODO: Add UI for turning this on/off
keepBacklightOn=False

ALBUMBIGFONT = pygame.font.Font(None,20)
ALBUMFONT = pygame.font.Font(None,16)

ALBUMNAMESTARTX=170
ALBUMNAMESTARTY=400

ALBUMCOVERSTARTY=425
ALBUMCOVERSTARTX=35

IMAGECACHINUSE=False
mouseReleased=0
lastMouseReleased=0

MEDIA_TYPE_UNKNOWN = 0
MEDIA_TYPE_AUDIO   = 1
MEDIA_TYPE_VIDEO   = 2

FORMAT_UNKNOWN   = 0
FORMAT_AUDIO_MP3 = 1
FORMAT_AUDIO_M4A = 2
FORMAT_AUDIO_OGG = 3
FORMAT_AUDIO_WMA = 4
FORMAT_AUDIO_AAC = 5
FORMAT_VIDEO_AVI = 1000
FORMAT_VIDEO_FLV = 1001
FORMAT_VIDEO_MOV = 1002
FORMAT_VIDEO_3GP = 1003
# TODO: Test before adding
FORMAT_VIDEO_M4V = 1004
FORMAT_VIDEO_MKV = 1005

CLICKMODE=0
CLICK_PLAYNOW=0
CLICK_QUEUE=1
CLICK_PLAYLIST=2
CLICK_DELETE=3

BME_REQ_PATH="/com/nokia/bme/request"
BME_REQ_IFC ="com.nokia.bme.request"
mainfont = pygame.font.Font(None,22)



def getMediaTypeFromFileName(fileName):
    if fileName.find('.')== 0:
        return MEDIA_TYPE_UNKNOWN
#fileName.endswith(".ogg") or fileName.endswith(".OGG") or 
    if fileName.endswith(".mp3") or fileName.endswith(".MP3") or fileName.endswith(".m4a") or fileName.endswith(".M4A") or fileName.endswith(".wma") or fileName.endswith(".WMA") or fileName.endswith(".aac") or fileName.endswith(".AAC"):
        return MEDIA_TYPE_AUDIO

    elif fileName.endswith(".mp4") or fileName.endswith(".avi") or fileName.endswith(".asf") or fileName.endswith(".AVI") or fileName.endswith(".flv") or fileName.endswith(".FLV")or fileName.endswith(".mov") or fileName.endswith(".MOV") or fileName.endswith(".3gp") or fileName.endswith(".3GP") or fileName.endswith(".m4v")  or fileName.endswith(".mkv")  or fileName.endswith(".MKV"):
        return MEDIA_TYPE_VIDEO
    return MEDIA_TYPE_UNKNOWN



#ogg support by Neil Jerram
def ogg_comment_value(block, tag):
   comment_pos = block.find(tag)
   if (comment_pos >= 4):
       comment_len = ord(block[comment_pos - 4])
       comment_val = block[comment_pos + len(tag) : comment_pos + comment_len]
   else:
       comment_val = ''
   return comment_val

def get_ogg_comments(file_name):
   f = open(file_name, 'r')
   block = f.read(1024)
   f.close()

   title = ogg_comment_value(block, 'TITLE=')
   artist = ogg_comment_value(block, 'ARTIST=')
   tracknumber = ogg_comment_value(block, 'TRACKNUMBER=')
   album = ogg_comment_value(block, 'ALBUM=')

   return [title, artist, tracknumber, album]


#THESE SHOULD BE CHANGED TO USE LOWER CASE VERSION OF FILENAME
def getFormatFromFileName(fileName):
    if fileName.find('.')== 0:
        return FORMAT_UNKNOWN

    if fileName.endswith(".mp3") or fileName.endswith(".MP3"):
        return FORMAT_AUDIO_MP3
    elif fileName.endswith(".m4a") or fileName.endswith(".M4A"):
        return FORMAT_AUDIO_M4A
    elif fileName.endswith(".ogg") or fileName.endswith(".OGG"):
        return FORMAT_AUDIO_OGG
    elif fileName.endswith(".wma") or fileName.endswith(".WMA"):
        return FORMAT_AUDIO_WMA
    elif fileName.endswith(".aac") or fileName.endswith(".AAC"):
        return FORMAT_AUDIO_AAC
    elif fileName.endswith(".avi") or fileName.endswith(".AVI") or fileName.endswith(".asf"):
        return FORMAT_VIDEO_AVI
    elif fileName.endswith(".flv") or fileName.endswith(".FLV"):
        return FORMAT_VIDEO_FLV
    elif fileName.endswith(".mkv") or fileName.endswith(".MKV"):
        return FORMAT_VIDEO_MKV
    elif fileName.endswith(".mov") or fileName.endswith(".MOV"):
        return FORMAT_VIDEO_MOV
    
    elif fileName.endswith(".mp4") or fileName.endswith(".mp4"):
        return FORMAT_VIDEO_MOV
    
    elif fileName.endswith(".3gp") or fileName.endswith(".3GP"):
        return FORMAT_VIDEO_3GP
    # TODO: Test before adding
    elif fileName.endswith(".m4v") or fileName.endswith(".M4V"):
           return FORMAT_VIDEO_M4V

    return FORMAT_UNKNOWN




homedir = os.path.expanduser('~')
coverlocation="data/covers/"
coverlocation=homedir+"/.cache/media-art/"
if ISMAEMO==1:
    coverlocation=homedir+"/.cache/media-art/"
if not os.path.exists(coverlocation):
    try:
        if not os.path.exists(coverlocation):
            os.makedirs(coverlocation)
    except OSError, message:
        print message
        coverlocation="/media/mmc2/.media-art/"
        try:
            if not os.path.exists(coverlocation):
                os.makedirs(coverlocation)
        except OSError, message:
            print "unable to create media-art folders"


thumbnailLocation=homedir+"/.thumbnails/normal/"

try:
   
    if not os.path.exists(thumbnailLocation):
        os.makedirs(thumbnailLocation)
except OSError, message:
    print "Unable to create thumbnails folders"


selectedCD=-1
shuffle=False
albumlist=[]
filelist=[]
artistlist=[]
songlist=[]
albumart=[]
artArray=[]
albumArray=[]
albumArtistArray=[]
clipList=[]
clipArray=[]
arrowPressed=0
startX=0
mouseMoved=0
mouseMovedAlbum=0
artDragXStart=0

speedModifier=1



ALBUMLISTVIEW=1
ALBUMCONTENTVIEW=2
ALBUMPLAYVIEW=3
VIDEOLISTVIEW=10

viewMode=ALBUMLISTVIEW
viewModeToBe=ALBUMLISTVIEW
cdClicked=0
buttonPressed=0
songItems=[]
activeCD=-1
nowPlayingAlbum=0
targetAlbum=0
nowShowingAlbum=0
nowPlayingSongName=""
nowPlayingAlbumName=""
nowPlayingArtistName=""
nowPlayingSongId=-1
playSelected=False
selectedArtArrayId=0





def createVideoClip(len, bgsheet, mainbg, i, VideoClip, clipfilename, clipname):
    clipArray.append(VideoClip(mainbg, i + 1))
    clipArray[i].image = bgsheet.imgat((303, 280, VIDEOCOVERWIDTH, 160), -1)
    filepath = clipname.split("/")
    cliptitle = filepath[len(filepath) - 1]
    clipArray[i].setClip(load_image(clipfilename), cliptitle, i, 0, clipname)

def createAlbumCover(os, len, mainbg, cdbgsheet, showInfo, songprocessor, time, str, True, i, False, load_image, CoverArt, albumname):
    
    filename = getCoverArtThumbFileName(albumname)
    imageLoadedFromNet = False
    try:
        test = os.path.exists(filename)
        if not test:
            songprocessor.getAlbumCover(i)
            imageLoadedFromNet = True
            test = os.path.exists(filename)
        
    except:
        print "main(): album information not ok for album:" + albumname
        songprocessor.getAlbumCover(i)
        try:
            test = os.path.exists(filename)
        except:
            filename = coverlocation + "NOARTIST.jpg"
            albumArtistArray[i] = "UNKNOWN"
            albumArray[i] = "UNKNOWN"
            albumname = "UNKNOWN"
        
    
    artArray.append(CoverArt(mainbg, i + 1))
    artArray[i].image = cdbgsheet.copy()
    if (len(filename) == 0 or not os.path.exists(filename)):
        artArray[i].setAlbum(load_image(filename), albumArtistArray[i], albumname, i, 0, filename)
        artArray[i].setunknown()
        print "setting as unknown2 " + filename
    elif IMAGECACHINUSE and os.path.exists(filename + ".cache.tga"):
        artArray[i].setAlbum(load_image(filename + ".cache.tga"), albumArtistArray[i], albumname, i, 1, filename)
    else:
        startTime = time.time()
        artArray[i].setAlbum(load_image(filename), albumArtistArray[i], albumname, i, 0, filename)        
    if (filename.find("NOARTIST") > -1):
        artArray[i].setunknown()
        print "setting as unknown1"
    if imageLoadedFromNet or (i % 4 == 0 or i > (len(albumArray) - 5)):
        text = str(i + 1) + "/" + str(len(albumArray)) + ":" + albumArray[i]
        if imageLoadedFromNet:
            text = "Downloading cover from Internet "+str(i)+"/"+str(len(albumArray))+":" + text
        text = text[0:100]
        #showInfo(text, artArray[i].image)


def getCoverArtFileName( album ):
    """Returns the cover art's filename that is formed from the album name."""
    albumString=dropInsideContent(album,"[","]" )
    albumString=dropInsideContent(albumString,"{","}" )
    albumString=dropInsideContent(albumString,"(",")" )    
    albumString=albumString.strip('()_{}[]!@#$^&*+=|\\/"\'?<>~`')
    albumString=albumString.lstrip(' ')
    albumString=albumString.rstrip(' ')
    albumString=dropInsideContent(albumString,"{","}" )
    albumString=albumString.lower()
    albumString=string.replace(albumString,"\t"," ")
    albumString=string.replace(albumString,"  "," ")    
    
    try: 
        albumString=unicodedata.normalize('NFKD',albumString).encode()
        albumString=albumString.encode()
        print albumString
    except:
        try:
            albumString=albumString.encode('latin-1', 'ignore')
            albumString=unicodedata.normalize('NFKD',albumString).encode("ascii")
            albumString=str(albumString)
            print albumString
        except:
            albumString=str(albumString)#"unknown"
        #albumString=str(albumString) 
    if len(albumString)==0: albumString=" "
    print albumString
     
    albumMD5=md5.new(albumString).hexdigest()    
    emptyMD5=md5.new(" ").hexdigest()
    albumArt=coverlocation+"album-"+emptyMD5+"-"+albumMD5+".jpeg"
    return albumArt

def getCoverArtThumbFileName( album ):
    """Returns the cover art's thumbnail filename that is formed from the album name."""
    artFile=getCoverArtFileName(album)
    thumbFile=thumbnailLocation+md5.new(artFile).hexdigest()+".jpeg"
         
    return thumbFile

def dropInsideContent(s, startMarker, endMarker):
    startPos=s.find(startMarker)
    endPos=s.find(endMarker)
    if startPos>0 and endPos>0 and endPos>startPos:
            return s[0:startPos]+s[endPos+1:len(s)]
    return s


def getCoverArtThumbFileName_old( album ):
    """Returns the cover art's thumbnail filename that is formed from the album name."""
    thumbFile=string.replace(album," ","_")
    thumbFile=fixFileString(thumbFile)
    thumbFile=coverlocation+thumbFile+"_thumb.jpg"

    try:
        thumbFile=unicode(thumbFile, 'utf-8').encode("latin-1", "ignore")
    except:
        try:
            thumbFile=unicode(thumbFile,'latin-1').encode('ascii', 'ignore')
        except:
            pass
    return thumbFile

def getCoverArtFileName_old( album ):
    """Returns the full cover art's filename that is formed from the album name."""
    thumbFile=string.replace(album," ","_")
    thumbFile=fixFileString(thumbFile)
    thumbFile=coverlocation+thumbFile+".jpg"
    try:
        thumbFile=unicode(thumbFile, 'utf-8').encode("latin-1", "ignore")
    except:
        try:
            thumbFile=unicode(thumbFile,'latin-1').encode('ascii', 'ignore')
        except:
            pass
    return thumbFile

def updateScrobbler():    
    osso_rpc.rpc_run(
             "com.nokia.songlistend",
             "/com/nokia/songlistend",
             "com.nokia.songlistend",
             "playing",
    makeScrobblerArgs(),
    wait_reply = False)
    print "info sent to scrobbler"

def makeScrobblerArgs():
    global nowPlayingAlbumName, nowPlayingArtistName, nowPlayingSongName
    
    rpc_args = (
        str(nowPlayingArtistName),
        str(nowPlayingSongName),
        str(nowPlayingAlbumName),
        int(120), #Length
        int(0))
    
    return rpc_args

def load_sound(filename):
    #filename = os.path.join('music', filename)
    return pygame.mixer.Sound(filename)


def isCompilation(album):
    global songlist
    global albumlist
    j=0
    i=0

    artistName=""
    for artist in artistlist:
        if (albumlist[i]==album):
            if len(artistName)>1 and not (artistName==artistlist[i]):
                return True
            if len(artistName)>1:
                return False
            artistName=artistlist[i]
            if artistName=="VA" or artistName=="Va":
                return True
            j=j+1
        i=i+1


def fixFileString( fs):
    fs=str(fs)
    fs=string.replace(fs," ","_")
    fs=string.replace(fs,"/","-")
    fs=string.replace(fs,":","_")
    fs=string.replace(fs,"?","_")
    fs=string.replace(fs,"%","")
    fs=string.replace(fs,"~","-")
    fs=string.replace(fs,",","-")
    fs=string.replace(fs,"*","-")
    fs=string.replace(fs,"&","-")
    fs=string.replace(fs,">","-")
    fs=string.replace(fs,"<","-")
    fs=string.replace(fs,".","-")
    fs=string.replace(fs,"(","")
    fs=string.replace(fs,")","")
    fs=string.replace(fs,'"',"")
    fs=string.replace(fs,str(0xe4),"_")
    return fs


def imgcolorkey(image, colorkey):
    if colorkey is not None:
        if colorkey is -1:
        #colorkey = image.get_at((0, 0))
            colorkey=(255,0,0)
        image.set_colorkey(colorkey, pygame.RLEACCEL)
    else:
        image.set_colorkey(None, pygame.RLEACCEL)
    return image

def load_image(filename, colorkey =None):
    f=string.replace(filename," ","_")
    print filename
    if (os.path.exists(filename) or os.path.exists(f)):
        if os.path.exists(f):
            filename=string.replace(filename," ","_")
        try:
            image = pygame.image.load(filename).convert()
        except:
            print "load_image(): Problem opening file (2):"+filename
            if (os.path.exists("/usr/share/pixmaps/UNKNOWN_UNKNOWN.jpg")):
                image = pygame.image.load("/usr/share/pixmaps/UNKNOWN_UNKNOWN.jpg").convert()
            else:
                image = pygame.image.load("./data/covers/UNKNOWN_UNKNOWN.jpg").convert()
    else:
        print "File does not exist:" + filename
        if (os.path.exists("/usr/share/pixmaps/UNKNOWN_UNKNOWN.jpg")):
            image = pygame.image.load("/usr/share/pixmaps/UNKNOWN_UNKNOWN.jpg").convert()
        else:    
            try:        
                image = pygame.image.load("data/covers/UNKNOWN_UNKNOWN.jpg").convert()
            except:
                print "Problem opening unknown file."

    return  imgcolorkey(image, colorkey)
    #return image

class SpriteSheet:
    def __init__(self, filename):
        if (os.path.exists(filename)):
            self.sheet = load_image(filename)
    def imgat(self, rect, colorkey = None):
        rect = Rect(rect)
        image = pygame.Surface(rect.size)
        image.blit(self.sheet, (0, 0), rect)

        colorkey=255,0,0
        return imgcolorkey(image, colorkey)

    def imgsat(self, rects, colorkey = None):
        imgs = []
        for rect in rects:
            imgs.append(self.imgat(rect, colorkey))
        return imgs

#temporarily disabled as dbus doesn't seem to work properly on device atm
if 1==2 and ISMAEMO == 1:    
    class BMERequest(dbus.service.Object):
        def __init__(self, bus_name, object_path=BME_REQ_PATH):
            dbus.service.Object.__init__(self, bus_name, object_path)            
        @dbus.service.signal(BME_REQ_IFC)        
        def status_info_req(self):
            print "sent"

class BatteryMonitor:
    
    def __init__(self):
        self.bus = dbus.SystemBus(private=True)
        self.bus.add_signal_receiver(self.handle_charging_off,"charger_charging_off")
        self.bus.add_signal_receiver(self.handle_charging_on ,"charger_charging_on" )
        name = dbus.service.BusName(BME_REQ_IFC, bus=self.bus)
        e = BMERequest(name)
        e.status_info_req()
        print "monitor added"

    def handle_charging_on(self,sender=None):
        print "charging"
        manager.on_battery = False
        manager.update_power()
    
    def handle_charging_off(self,sender=None):
        print "on_battery"
        manager.on_battery = True
        manager.update_powersave()



class SongList(pygame.sprite.Sprite):

    def __init__(self, mainbg,songItems):
        pygame.sprite.Sprite.__init__(self, self.containers)
        self.rect = self.image.get_rect()
        self.mainbg = mainbg
        self.songQueue=[]
        self.playedList=[]
        self.previousFile=""
        self.songItems=songItems
        self.rect.top = 172
        self.rect.left = 20
        self.lastAlbum=" "
        self.bgupdated=0
        self.counter=0
        self.currentPlayId=0
        self.albumId=0
        self.playing = False
        self.playOn=0
        self.player_clean=True
        if NOT_MAC:
            self.createGSTPlayer()
            if 1==2:
                self.bus = dbus.SessionBus(private=True)
                self.bus_obj = self.bus.get_object(OSSO_MEDIA_SERVER_IFC, OSSO_MEDIA_SERVER_PATH)
                self.bus_iface = dbus.Interface(self.bus_obj, OSSO_MEDIA_SERVER_MUSIC_IFC)
                self.bus_iface.connect_to_signal("state_changed", self.on_state)
                self.bus_iface.connect_to_signal("end_of_stream", self.on_eos)


        self.currentPlayIndex=0
        
        self.currentAlbumFileList=[]
        self.displayedAlbumFileList=[]
        
    def on_state(self,arg=None):
        
        state = "%s" % (arg,)        
        print "=====> got state: %s (self.paused=%s)" % (state,self.paused,)

        if state == "playing": 
          #self._update_volume() 
          self.start_status_query()
          #self.paused = False
          self.playOn=1
          self.playing = True
          playAlbumButton.setPause()
        elif (state == "paused" or state == "stopped"): # and self.paused != True:
          self.stop_status_query()
          self.paused = True
          playAlbumButton.setPlay()
          

    def on_eos(self,arg=None):
        file = "%s" % (arg,)
        print "EOS for %s" % (file,)
        self.stop_status_query()
        self.next()


    def send_cmd(self, method, args=()):
        osso_rpc.rpc_run(
        OSSO_MEDIA_SERVER_IFC,
        OSSO_MEDIA_SERVER_PATH,
        OSSO_MEDIA_SERVER_MUSIC_IFC,
        method,
        args,
        wait_reply = False)

    def createGSTPlayer(self):
        self.player = gst.element_factory_make("playbin2", "player")
        
    def createGSTPlayer_dsp(self):
        if ISMAEMO == 0:
            self.player = gst.parse_launch( "gnomevfssrc name=source ! mad name=id3 ! alsasink name=sink" )
        else:
            try:
                self.player = gst.parse_launch( "gnomevfssrc name=source ! id3demux name=id3 ! dspmp3sink name=sink" )
            except:
                self.player = gst.parse_launch( "gnomevfssrc name=source ! id3lib name=id3 ! dspmp3sink name=sink" )
            
        self.source = self.player.get_by_name( "source" )
        self.sink = self.player.get_by_name( "sink" )
        self.id3 = self.player.get_by_name( "id3" )
        self.player.set_name("player")

    def createGSTM4APlayer(self):
        self.player = gst.parse_launch( "gnomevfssrc name=source ! demux3gp name=demuxer ! dspaacsink name=sink sync=false" )
        self.source = self.player.get_by_name( "source" )
        self.sink = self.player.get_by_name( "sink" )
        self.player.set_name("player")

    def createGSTAACPlayer(self):
        self.player = gst.parse_launch( "gnomevfssrc name=source ! dspaacsink name=sink" )
        self.source = self.player.get_by_name( "source" )
        self.sink = self.player.get_by_name( "sink" )
        self.player.set_name("player")


    def createGSTOGGPlayer(self):
        #self.player = gst.parse_launch( "gnomevfssrc name=source ! tremor name=decoder ! dsppcmsink name=sink" )
        if ISMAEMO == 1:
            self.player = gst.parse_launch( "gnomevfssrc name=source ! oggdemux name=demuxer ! ivorbisdec name=decoder ! dsppcmsink name=sink" )
        else:
            self.player = gst.parse_launch( "gnomevfssrc name=source ! oggdemux ! vorbisdec ! audioconvert ! audioresample ! alsasink name=sink")

        self.source = self.player.get_by_name( "source" )
        self.sink = self.player.get_by_name( "sink" )
        self.player.set_name("player")

    def createGSTWMAPlayer(self):
        #self.player = gst.parse_launch( "gnomevfssrc name=source ! tremor name=decoder ! dsppcmsink name=sink" )
        self.player = gst.parse_launch( "gnomevfssrc name=source ! fluasfdemux name=demuxer  ! fluwmadec name=decoder ! dsppcmsink name=sink" )

        self.source = self.player.get_by_name( "source" )
        self.sink = self.player.get_by_name( "sink" )
        self.player.set_name("player")


    def demuxer_callback(self, demuxer, pad):
        print "demuxer callback"+pad
        self.player_clean=False

    def setAlbum(self, givenimage, artist, album, albumId):
        global listButton
        global albumButton
        global currentAlbumSongCount

        #self.image.blit(self.background, (0, 0))
        self.bgupdated=1
        #font = pygame.font.Font(None,38)
        
        #self.test=font.render(artist+ " - "+ album, 1, MAINFONTCOLOR)        
        #self.image.blit(self.test, (0, 0))
                
        self.albumId=albumId
        artArray[self.albumId].setSelected()
        
        
        #listButton.setVisible()
        listButton.update()
        k=0
        while k<SONGITEMMAXCOUNT:
            visible.remove(songItems[k])
            k=k+1

        songArray=[]
        sortArray=[]
        idArray=[]
        self.displayedAlbumFileList=[]
        if self.albumId==nowPlayingAlbum:
            self.currentAlbumFileList=[]

        i=0
        j=0
        for song in songlist:
            if (albumlist[i]==album and j<SONGITEMMAXCOUNT):
                self.displayedAlbumFileList.append(filelist[i])               
                sortArray.append(song)
                songArray.append(song)
                idArray.append(i)
                j=j+1
            i=i+1
        self.lastAlbum=album
        currentAlbumSongCount=j
        #SORT THE SONGS BY SONG NAME
        sortArray.sort()

        i=0
        for sorted in sortArray:
            j=0
            for song in songArray:
                if (sorted==song and not i==j):
                    temp=songArray[j]
                    songArray[j]=songArray[i]
                    songArray[i]=temp
                    temp2=self.displayedAlbumFileList[j]
                    self.displayedAlbumFileList[j]=self.displayedAlbumFileList[i]
                    self.displayedAlbumFileList[i]=temp2
                    temp3=idArray[j]
                    idArray[j]=idArray[i]
                    idArray[i]=temp3
                j=j+1
            i=i+1

        i=0
        for sorted in songArray:
            self.songItems[i].setSong(sorted, idArray[i], albumId)
            visible.add(songItems[i])
            #print self.displayedAlbumFileList[i] +"song:" + self.songItems[i].song
            i=i+1
        i=0
        if self.albumId==nowPlayingAlbum:
            for filename in self.displayedAlbumFileList:
                self.currentAlbumFileList.append(filename)
                #print filename+" " + self.songItems[i].song
                i=i+1

        if (viewModeToBe==ALBUMCONTENTVIEW):
            visible.add(listButton)
            #listButton.setVisible()
            listButton.update()

    def getPosition(self):
        if NOT_MAC:            
            return self.seconds
        else:
            position=pygame.mixer.music.get_pos()
        return position

    def getDuration(self):
        if NOT_MAC:            
            return self.length
        else:
            position=pygame.mixer.music.get_pos()
        return position
     
    def getPosition_old(self):
        position=0
        value=0
        if NOT_MAC:
            try:
                position, format = self.player.query_position(gst.FORMAT_TIME)
            except:
                position = gst.CLOCK_TIME_NONE
            if position != gst.CLOCK_TIME_NONE:
                value=position

        else:
            position=pygame.mixer.music.get_pos()
        return value

    def format_time(self, time):
        hour = str(int(time)/3600)
        minute = int(time)/60%60
        if minute < 10:
            minute = "0" + str(minute)
        else:
            minute = str(minute)
        seconds = int(time)%60
        if seconds < 10:
            seconds = "0" + str(seconds)
        else:
            seconds = str(seconds)
        return hour + ":" + minute + ":" + seconds
    
    def getSongLengthString(self):
        if NOT_MAC:
            try:              
              return str(self.format_time(self.length))
            except:                                                    
                return "??:??:??"

    def getSongPositionString(self):
        if NOT_MAC:        
                positionClean=self.getPosition()
                 
                return str(self.format_time(positionClean))                        
        else:
            return "??:??:??"
            
    def setPercentPosition_osso(self, position):
          self.seek ((position*self.length*1000)/100)
                
    def setPercentPosition(self, position):
        if NOT_MAC:
            try:
                duration, format = self.player.query_duration(gst.FORMAT_TIME)
            except:
                duration = gst.CLOCK_TIME_NONE
            if duration != gst.CLOCK_TIME_NONE:
                durationClean=duration/gst.MSECOND
                print "duration: " + str(self.format_time(durationClean/1000))
                print "position: " + str(position)
                print "place:" + str((position*duration)/100)
                self.seek ((position*duration)/100)
        else:
            print "seek not supported " + str(position)
            #pygame.mixer.music.get_busy()
        

    def getPercentPosition_osso(self):        
        self.length = 0
        self.seconds = 0
        self.percent = 0
        if NOT_MAC:
            try:
              (cur, tot) = self.bus_obj.get_position(dbus_interface=OSSO_MEDIA_SERVER_MUSIC_IFC)
              self.seconds = cur / 1000
              self.length = tot / 1000
              
            except:
              try: 
                cur = self.bus_obj.get_position(dbus_interface=OSSO_MEDIA_SERVER_MUSIC_IFC)
                self.seconds = cur / 1000
              except:
                self.seconds = 0            
            
            if self.length>0 : 
                self.percent = self.seconds * 100 / self.length            
            return int(self.percent)
        else:
            position=pygame.mixer.music.get_pos()
            return int(position)
        

    def getPercentPosition(self):
        position=0
        value=0
        self.length = 0
        self.seconds = 0
        self.percent = 0
        if NOT_MAC:
            try:
                position, format = self.player.query_position(gst.FORMAT_TIME)
            except:
                position = gst.CLOCK_TIME_NONE
            try:
                duration, format = self.player.query_duration(gst.FORMAT_TIME)
            except:
                duration = gst.CLOCK_TIME_NONE
            if position != gst.CLOCK_TIME_NONE:
                value = position * 100.0 / duration
            if duration<17446744073709551615:
                self.length=(duration/gst.SECOND)
                self.seconds=(position/gst.SECOND)
                self.percent=int(value)
                #print "length:" + str(self.length)+ "duration:" + str(duration)
            
                
        else:
            position=pygame.mixer.music.get_pos()
            #pygame.mixer.music.get_busy()
        return int(value)
    
    def next(self):
        if not shuffle:
            #print "playing next song in albumlist"
            if CLICKMODE==CLICK_PLAYNOW:
                self.currentPlayIndex=self.currentPlayIndex+1
                if (len(self.currentAlbumFileList)<=self.currentPlayIndex):
                    self.nextAlbum()
                if (len(self.currentAlbumFileList)>0):
                    next = self.currentAlbumFileList[self.currentPlayIndex]
                else:
                    next=None
                if next != None:
                    self.playSong(self.currentPlayIndex)
            elif CLICKMODE==CLICK_QUEUE:
                self.playQueue(0,0)

        else:
            if CLICKMODE==CLICK_PLAYNOW:
                targetAlbum=random.randrange(0, len(artArray)-1, 1)
                self.setAlbum(artArray[targetAlbum].image,albumArtistArray[targetAlbum], albumArray[targetAlbum],targetAlbum)
                self.playAlbum()
                id=0
                if len(self.currentAlbumFileList)>1:
                    id=random.randrange(1, len(self.currentAlbumFileList), 1)-1
                    self.currentPlayIndex=id
                #print "id:" + str(id)
                next = self.currentAlbumFileList[id]
                if next != None:
                    self.playSong(self.currentPlayIndex)
            elif CLICKMODE==CLICK_QUEUE:
                id=0
                if len(self.songQueue)>1:
                    id=random.randrange(0, len(self.songQueue)-1, 1)-1
                    self.playQueue(0, id)
                else:
                    if len(self.songQueue)==0:
                        self.stop()
                    else:
                        self.playQueue(0, 0)


    def play(self):
        print "starting playback"
        self.playOn=1
        
        if NOT_MAC:
            self.player.set_state(gst.STATE_PLAYING)
            #self.send_cmd("pause")
        else:
            pygame.mixer.music.play()
        playAlbumButton.setPause()

    def pause(self):
        print "Pause action performed"
        global playAlbumButton
        self.playOn=0
        if NOT_MAC:
            self.player.set_state(gst.STATE_PAUSED)
            #self.send_cmd("pause")
        else:
            pygame.mixer.music.pause()
        playAlbumButton.setPlay()

    def stop(self):
        print "STOP"
        if NOT_MAC:
            if (self.player != None): self.player.set_state(gst.STATE_NULL)
            #self.send_cmd("stop")
        else:
            pygame.mixer.music.stop()

    def showNextAlbum(self):
        self.currentPlayIndex=0
        #If in normal mode, move to next album or first album
        targetAlbum=0
        if (self.albumId<len(albumArtistArray)-1):
            targetAlbum=self.albumId+1
        self.setAlbum(artArray[targetAlbum].image,albumArtistArray[targetAlbum], albumArray[targetAlbum],targetAlbum)
        #self.playAlbum()

    def nextAlbum(self):
        global nowPlayingAlbum
        self.currentPlayIndex=0
        #If in normal mode, move to next album or first album
        targetAlbum=0
        if (nowPlayingAlbum<len(albumArtistArray)-1):
            targetAlbum=nowPlayingAlbum+1
        nowPlayingAlbum=targetAlbum
        self.setAlbum(artArray[targetAlbum].image,albumArtistArray[targetAlbum], albumArray[targetAlbum],targetAlbum)
        #self.playAlbum()

    def previousAlbum(self):
        global nowPlayingAlbum
        targetAlbum=len(albumArtistArray)-2
        if (nowPlayingAlbum>1):
            targetAlbum=nowPlayingAlbum-1
        nowPlayingAlbum=targetAlbum
        self.setAlbum(artArray[targetAlbum].image,albumArtistArray[targetAlbum], albumArray[targetAlbum],targetAlbum)
        #self.playAlbum()
        self.currentPlayIndex=len(self.currentAlbumFileList)-1

    def showPreviousAlbum(self):
        targetAlbum=len(albumArtistArray)-2
        if (self.albumId>1):
            targetAlbum=self.albumId-1
        self.setAlbum(artArray[targetAlbum].image,albumArtistArray[targetAlbum], albumArray[targetAlbum],targetAlbum)
        self.currentPlayIndex=len(self.currentAlbumFileList)-1


    def previous(self):
        if CLICKMODE==CLICK_PLAYNOW:
            self.currentPlayIndex=self.currentPlayIndex-1
            if (self.currentPlayIndex==-1):
                self.previousAlbum()
            if (len(self.currentAlbumFileList)>0):
                next = self.currentAlbumFileList[self.currentPlayIndex]
            else: next=None
            if next != None:
                self.playSong(self.currentPlayIndex)
        elif CLICKMODE==CLICK_QUEUE:
            self.playPreviousQueue()


    def addQueue(self, playIndex):
        filename=self.currentAlbumFileList[playIndex]
        self.songQueue.append(filename)
        if len(self.songQueue)==1:
            self.playQueue(1,0);
        self.updateQueueButton()
        songItems[playIndex].setSelected()
        self.resetSelections()

    def removeQueue(self, playIndex):
        filename=self.currentAlbumFileList[playIndex]
        self.songQueue.remove(filename)
        self.updateQueueButton()
        songItems[playIndex].setSelected()
        self.resetSelections()

    def updateQueueButton(self):
        font = pygame.font.Font(None, 16)
        queuecountButton.image.blit(queuecountButton.altbackground, (0,0))
        test=font.render("QUEUE SIZE:"+str(len(self.songQueue)), 1, MAINFONTCOLOR)        
        if DISPLAY_ROTATE:
            test=pygame.transform.rotate(test, 90)

        queuecountButton.image.blit(test, (15, 20))
        test=font.render("QUEUED PLAY", 1, MAINFONTCOLOR)        
        if DISPLAY_ROTATE:
            test=pygame.transform.rotate(test, 90)
        queuecountButton.image.blit(test, (0, 20 ))
        if DISPLAY_ROTATE:
            screenBottom.blit(self.image,(5,377))
        else:
            screenBottom.blit(self.image,(687,2))
        queuecountButton.updateQueueButton()
        

    def setSongDetailsFromFilename(self, filename):
        global songlist, filelist, albumlist, artArray, songButton
        global nowPlayingSongName, nowPlayingAlbum, nowPlayingAlbumName, nowPlayingArtistName, nowPlayingSongId
        i=0
        while i<len(filelist):
            if filelist[i]==filename:
                nowPlayingSongName=songlist[i]
                nowPlayingAlbumName=albumlist[i]
                nowPlayingArtistName=artistlist[i]
                nowPlayingAlbum=0
                nowPlayingSongId=i
                j=0
                for art in artArray:
                    if art.album==albumlist[i]:
                        nowPlayingAlbum=j                        
                    j=j+1
                
                songButton.setSong(nowPlayingSongName,nowPlayingAlbumName, nowPlayingArtistName)

                if self.albumId==nowPlayingAlbum:
                    self.resetSelections()

            i=i+1
    def resetSelections(self):
        j=0
        while j<SONGITEMMAXCOUNT:
            if songItems[j].song==nowPlayingSongName:
                songItems[j].setSelected()
            else:
                songItems[j].deselect()
            j=j+1

    def playQueue(self, addMode, indexId):
        qfilename=""
        if len(self.songQueue)>indexId:
            if len(self.songQueue)>1:
                qfilename=self.songQueue.pop(indexId)
                if self.previousFile==qfilename:
                    qfilename=self.songQueue.pop(indexId)
            else:
                if addMode==0:
                    qfilename=self.songQueue.pop(indexId)
                else:
                    qfilename=self.songQueue[indexId]

            self.playFile(qfilename)
            if not self.previousFile=="":
                self.playedList.append(self.previousFile)
            self.previousFile=qfilename
        else:
            self.stop()
        self.updateQueueButton()


    def playPreviousQueue(self):
        #Move previous top song to queue bottom (next to be played)
        if len(self.playedList)>0:
            #push currently playing song to queue
            if not self.previousFile=="":
                self.songQueue.insert(0, self.previousFile)

            #then insert from backlog to queue
            lastSongFile=self.playedList.pop(len(self.playedList)-1)
            self.songQueue.insert(0, lastSongFile)
            self.previousFile=""
            self.playQueue(0,0)
        else:
            self.stop()
        self.updateQueueButton()

    def playSong(self, playIndex):
        global nowPlayingAlbum
        global nowPlayingSongName
        if self.albumId==nowPlayingAlbum:
            i=0
            while i<SONGITEMMAXCOUNT:
                songItems[i].deselect()
                i=i+1
        if (playIndex<len(self.currentAlbumFileList)): self.currentPlayIndex=playIndex
        else: self.currentPlayIndex=0
        filename=self.currentAlbumFileList[self.currentPlayIndex]
        self.playFile(filename)
        


    def seekForward(self):
        if NOT_MAC:
            newPosition=self.getPosition()
            if newPosition>0:
                print "seeking from " + str(newPosition)
                newPosition=newPosition+7000000000
                print "seeking to " + str(newPosition)
                self.seek(newPosition)

    def seekBackward(self):
        if NOT_MAC:
            newPosition=self.getPosition()            
            
            newPosition=newPosition-7500000000
            if newPosition>0:
                self.seek(newPosition)
            else:
                self.seek(0)

    def seek_osso(self, location):
        self.bus_obj.seek(dbus.Int32(0), dbus.Int32(location), dbus_interface=OSSO_MEDIA_SERVER_MUSIC_IFC)
                
    #location in milliseconds
    def seek(self, location):

        #if self.player.get_state() != gst.STATE_PAUSED:
        #    self.player.set_state(gst.STATE_PAUSED)
        
        event = gst.event_new_seek(1.0, gst.FORMAT_TIME,
            gst.SEEK_FLAG_FLUSH | gst.SEEK_FLAG_ACCURATE,
            gst.SEEK_TYPE_SET, location,
            gst.SEEK_TYPE_NONE, 0)
        
        res = self.player.send_event(event)
        if res:
            print "setting new stream time to 0"
            self.player.set_new_stream_time(0L)
        else:
            print "seek to %r failed" % location
        check=self.getPercentPosition() #Force to get the current statistics.
        #self.player.set_state(gst.STATE_PLAYING)


    def getVolume(self):
        global volume
        # playbin volume is a double from 0.0 - 10.0
        #volume=0.0
        if NOT_MAC:
            volume=self.player.get_property('volume')
            #volume = self.bus_obj.get_volume(dbus_interface=OSSO_MEDIA_SERVER_MUSIC_IFC)
            volume=volume
        else:
            volume=pygame.mixer.music.get_volume()
        return volume

    def setVolume(self, newVolume):
        global volume
        newVolume = min(8.0, max(newVolume, 0.0))
        #newVolume = min(1.0, max(newVolume, 0.0))
        #newVolume = int(newVolume)        
        volume=newVolume
        print "new volume"  + str(newVolume)
        if NOT_MAC:            
            self.player.set_property('volume',  newVolume)
            #self.send_cmd("set_volume", (float(volume),) )
        else:
            volume=pygame.mixer.music.set_volume(newVolume/100.0)

    def playFile(self,filename):
        global playAlbumButton
        global changed
        global cdClicked
        global volume
        global lastSongPosition
        global currentPlayFile
        lastSongPosition=0

        if NOT_MAC:
            
            #  Old diablo style call: self.send_cmd("play_media", (str("file://"+filename),) )
            #self.player.set_state(gst.STATE_NULL)
            #self.createGSTPlayer()                          
            print "Playing file: " + filename            
            currentPlayFile=filename
            try:                
                self.player.set_state(gst.STATE_NULL)                                
                self.player.set_property("uri", "file://"+currentPlayFile)                
                self.player.set_state(gst.STATE_PLAYING)
                time.sleep(0.3)                                                 
            except:
                print "playFile(): CANNOT PLAY MUSIC"
            

                  
            self.playing = True
            self.playOn=1 
            
            
#import gst,pygst
#player = gst.element_factory_make("playbin2", "player")
#player.set_property("uri", "file:///home/user/MyDocs/Music/458 HITS/Ben E. King - Spanish Harlem.mp3")
#player.set_state(gst.STATE_PLAYING)



        else:
                #self.currentPlayIndex=0
            print "playing file" + filename
            try:
                pygame.mixer.music.stop()
                time.sleep(0.20)
                pygame.mixer.music.load(filename)

                self.play()
                self.playOn=1
            except:
                print "playFile(): problems playing file. File may be corrupt:" +filename
                #self.next()

        self.setSongDetailsFromFilename(filename)
        #if ISMAEMO: updateScrobbler()
        playAlbumButton.setPause()
        changed=1
        cdClicked=1

    def playAlbum(self):
        global albumButton
        global artArray
        #TEMP TEST
        global nowPlayingAlbum
        #nowPlayingAlbum=self.albumId
        print "Setting album to be in played list"+str(self.albumId)
        self.currentAlbumFileList=[]
        for song in self.displayedAlbumFileList:
            self.currentAlbumFileList.append(song)


    def update(self):
        i=0



##################################
#### SONGITEM
##################################

class SongItem(pygame.sprite.Sprite):


    def __init__(self, mainbg,positionindex):
        pygame.sprite.Sprite.__init__(self, self.containers)
        self.rect = self.image.get_rect()
        self.mainbg = mainbg
        self.rect.bottom = 440
        self.positionindex=positionindex
        self.albumwidth=ALBUMSPACEWIDTH
        self.posy=SONGLISTSTARTY

        self.selected=0
        self.song=""
        self.songId=-1
        self.songNumber=""


        self.selected=0
        self.font = pygame.font.SysFont(None, 28)
        self.fontNumber = pygame.font.SysFont(None, 28)
        self.fontSmall = pygame.font.SysFont(None, 22)
        self.mouseOver=0

    def writeSongDetails(self, isSelected):
        song=self.song
        
        if isSelected:            
            self.image=self.activeImage.copy()
        else:
            self.image=self.background.copy()
            
        if len(song)>0:
            songNameArray=song.split(" ")
            if songNameArray[0].isdigit():
                self.songNumber=songNameArray[0]
                self.songNumber=self.songNumber.lstrip('0')
                song=song.lstrip('01234567890 ')
                test=self.fontNumber.render(self.songNumber, 1, (117,138,159))
                self.image.blit(test, (5,26))
            else:
                self.songNumber=""
        songNameArray=song.split(" ")
        
        lineNumber=0
        linePart=""
        for namePart in songNameArray:
            if len(linePart+namePart)<28:
                linePart=linePart+namePart+" "
            else:
                test=self.font.render(linePart, 1, MAINFONTCOLOR)
                self.image.blit(test, (40,(10+lineNumber*23)))
                linePart=namePart+" "
                lineNumber=lineNumber+1
        #last line handling
        if len(linePart)>0:
            test=self.font.render(linePart, 1, MAINFONTCOLOR)
            self.image.blit(test, (40,(10+lineNumber*23)))
            linePart=namePart
        #compilation special code
        if artistlist[self.songId] != albumArtistArray[self.albumId]:
            #print "compilation!!"
            
            test=self.fontSmall.render("by " + artistlist[self.songId], 1, MAINFONTCOLOR)
            self.image.blit(test, (40,(55)))
            linePart=namePart
        
        if DISPLAY_ROTATE:
            self.rotateSongItem(90)
            
    def rotateSongItem(self,degrees):
        self.image=pygame.transform.rotate(self.image, degrees)
        self.rect = self.image.get_rect()
        
    def setSong(self, song, songId,albumId):
        global nowPlayingSongId
        global songlister
        
        self.songId=songId
        self.albumId=albumId
        self.song=song

        self.writeSongDetails(False)
        self.selected=0
        self.mouseOver=0
        print nowPlayingSongId
        if self.songId==nowPlayingSongId:
            self.setSelected()
        self.showQueueInfo()

    def deselect(self):
        global changed
        global cdClicked
        
        global songlister
        
        if (self.selected==1):
            self.selected=0
            self.setSong(self.song, self.songId, self.albumId)
            cdClicked=1
            changed=1

        if CLICKMODE==CLICK_QUEUE:
            if songlister.songQueue.count(filelist[self.songId])>0:
                self.setSong(self.song, self.songId, self.albumId)
                #print "Deselected: " + self.song

    def deHover(self):
        global changed
        global cdClicked
        
        self.setSong(self.song, self.songId, self.albumId)
        cdClicked=1
        changed=1
        #print "Deselected: " + self.song

    def showQueueInfo(self):
        if CLICKMODE==CLICK_QUEUE and songlister.songQueue.count(filelist[self.songId])>0:
            songposition=str(songlister.songQueue.index(filelist[self.songId])+1)
            songcountText=self.font.render(songposition, 1, MAINFONTCOLOR)
            self.image.blit(songcountText, (5,4))

    def setSelected(self):
        self.writeSongDetails(True)
        self.selected=1        
        self.showQueueInfo()

    def deleteSong(self, songId, songPosition):
        if songId>-1:
            global songItems,cdClicked,changed
            fname=filelist.pop(songId)
            alname=albumlist.pop(songId)
            arname=artistlist.pop(songId)
            songname=songlist.pop(songId)

            songItems[songPosition].setSong("Deleted", -1, -1)
            for si in songItems:
                if si.songId>songId:
                    if si.songId>0:
                        si.songId=si.songId-1
            print "Deleted "+ fname
            os.remove(fname)
            cdClicked=1
            changed=1


    def setHover(self):        
        self.writeSongDetails(True)
        self.mouseOver=2
        self.showQueueInfo()

    def update(self):
        global playSelected, mouseMoved
    
        
        if DISPLAY_ROTATE:
            self.posx=SONGLISTSTARTX
            self.posy=SONGLISTSTARTY+(self.positionindex)*77-mouseMoved          
            self.rect.left = self.posy
            self.rect.bottom = self.posx+250            
        else:            
            self.posx=SONGLISTSTARTX+((self.positionindex%2)*315)
            self.posy=SONGLISTSTARTY+(self.positionindex/2)*77+310-mouseMoved
            self.rect.left = self.posx
            self.rect.bottom = self.posy
        
                
        if(viewModeToBe!=ALBUMCONTENTVIEW): visible.remove(self)
        if viewMode==ALBUMCONTENTVIEW:
            mp=pygame.mouse.get_pos()[1] 
            if DISPLAY_ROTATE:
                mp=pygame.mouse.get_pos()[0]
                #print buttonPressed
                #print self.rect.collidepoint(pygame.mouse.get_pos()[0],pygame.mouse.get_pos()[1])
                
            if ( buttonPressed==1 and  mp<ALBUMBOTTOM and self.rect.collidepoint(pygame.mouse.get_pos()[0],pygame.mouse.get_pos()[1])):
                if (len(songlister.displayedAlbumFileList)>self.positionindex):
                    if not playSelected:
                        if CLICKMODE==CLICK_PLAYNOW:
                            songlister.playAlbum()
                            songlister.playSong(self.positionindex)
                            playSelected=True
                            #setCurrentPlayMode()
                        if CLICKMODE==CLICK_DELETE:
                            self.deleteSong(self.songId, self.positionindex)
                        if CLICKMODE==CLICK_QUEUE:
                            if songlister.songQueue.count(filelist[self.songId])>0:
                                songlister.playAlbum()
                                songlister.removeQueue(self.positionindex)
                                playSelected=True
                            else:
                                songlister.playAlbum()
                                songlister.addQueue(self.positionindex)
                                playSelected=True


##################### #####################
##################### CONTROL BUTTON
##################### #####################

class ControlButton(pygame.sprite.Sprite):
    def __init__(self,x,y,buttonType):
        pygame.sprite.Sprite.__init__(self, self.containers)
        self.rect = self.image.get_rect()
        self.rect.top = y
        self.rect.left = x
        self.posy=y
        self.posx=x
        self.buttonType=buttonType
        self.buttonHandled=False
        self.isVisible=False
        self.nameNotDrawn=True
        self.currentPosition=-1
        
    def setVisible(self):
        global visible
        self.isVisible=True
        visible.add(self)

    def setInvisible(self):
        global visible
        self.isVisible=False
        visible.remove(self)


    def setImage(self, image):
        self.image=image
        self.rect = self.image.get_rect()
        self.rect.left = self.posx
        self.rect.bottom = self.posy
    
    def setProgress(self, currentPosition):
        global nowPlayingAlbumName, nowPlayingSongName, mouseMoved, screenTop, changed,progressChanged
        if  not currentPosition==self.currentPosition:
            self.currentPosition=currentPosition
            
            lengthImage=ALBUMFONT.render( songlister.getSongLengthString(), 1, ALTFONTCOLOR)
            positionImage=ALBUMFONT.render( songlister.getSongPositionString(), 1, ALTFONTCOLOR)
            #positionImage.set_colorkey(MAINFONTBGCOLOR)
            
            if DISPLAY_ROTATE:
                lengthImage=pygame.transform.rotate(lengthImage, 90)
                positionImage=pygame.transform.rotate(positionImage, 90)
                
                self.image.set_clip()
                self.image.blit(self.background, (0,0)) 
                distance=currentPosition*3+24               
                self.image.set_clip((0,self.image.get_height()-distance,27,distance))
                self.image.blit(self.activeBackground, (0,0))            
                self.image.set_clip()            
                
                self.image.blit(lengthImage, (4, 15))                
                self.image.blit(positionImage, (4, 260))
                screenTop.blit(self.image,(self.rect.left,self.rect.top))
            else:                
                self.image.set_clip()
                self.image.blit(self.background, (0,0))                
                self.image.set_clip((0,0,currentPosition*3+24,27))
                self.image.blit(self.activeBackground, (0,0))            
                self.image.set_clip()                
                self.image.blit(lengthImage, (260, 4))
                self.image.blit(positionImage, (15, 4))
                screenTop.blit(self.image,(self.rect.left,self.rect.top))            
            progressChanged=True
    
    def setPlay(self):
        global playAlbumIcon,shuffleClicked,changed
        self.image=playAlbumIcon
        self.buttonType="PLAY"
        if DISPLAY_ROTATE:
            screenBottom.blit(self.image,(0,220))
        else:
            screenBottom.blit(self.image,(200,0))
        shuffleClicked=1
        changed=True
    
    def setPause(self):
        global pauseAlbumIcon, shuffleClicked,changed
        self.image=pauseAlbumIcon
        self.buttonType="PAUSE"
        #self.isVisible=True
        #self.newDraw()
        if DISPLAY_ROTATE:
            screenBottom.blit(self.image,(0,220))
        else:
            screenBottom.blit(self.image,(200,0))
        shuffleClicked=1
        changed=True
        


    def setButtonType(self, buttonType):
        self.buttonType=buttonType

    def onClick():
        print "clicked on:" +self.buttonType

    def setButton(self,x,y,buttonType):
        self.posx=x
        self.posy=y
        self.rect.bottom = y
        self.rect.left = x
        self.buttonType=buttonType

    def setRect(self, newrect):
        self.rect=newrect


    def playPressed(self):
        #print "Play button pressed"
        songlister.play()

    def pausedPressed(self):
        #print "pause button pressed"
        songlister.pause()

    def newDraw(self):
        if (self.isVisible): screen.blit(self.image,(self.rect.left, self.rect.top))

    def updateQueueButton(self):
        global shuffleClicked
        if DISPLAY_ROTATE:
            screenBottom.blit(self.image,(5,380))
        else:
            screenBottom.blit(self.image,(687,2))
        shuffleClicked=1

    def setQueueMode(self):
        global CLICKMODE, CLICK_PLAYNOW, CLICK_QUEUE,songlister, shuffleClicked
        CLICKMODE=CLICK_QUEUE
        self.image.blit(queuecountButton.background, (0,0))
        font = pygame.font.Font(None,16)
        test=font.render("QUEUED PLAY", 1, MAINFONTCOLOR)
        if DISPLAY_ROTATE:
            test=pygame.transform.rotate(test, 90)
        self.image.blit(test, (10, 25))
        self.buttonType="DELETE"
        songlister.updateQueueButton()
        
        
                

    def setContinuousMode(self):
        global CLICKMODE, CLICK_PLAYNOW, CLICK_QUEUE,songlister, shuffleClicked
        CLICKMODE=CLICK_PLAYNOW
        self.image.blit(queuecountButton.background, (0,0))
        font = pygame.font.Font(None,16)
        test=font.render("NORMAL PLAY", 1, MAINFONTCOLOR)
        if DISPLAY_ROTATE:
            test=pygame.transform.rotate(test, 90)        
        self.image.blit(test, (0, 5))
        self.buttonType="QUEUE"
        if viewMode==VIDEOLISTVIEW:
            self.buttonType="DELETE"
        self.updateQueueButton()

    def setDeleteMode(self):
        global CLICKMODE, CLICK_PLAYNOW, CLICK_QUEUE,songlister, shuffleClicked
        CLICKMODE=CLICK_DELETE
        self.image.blit(queuecountButton.background, (0,0))
        font = pygame.font.Font(None,16)
        test=font.render("DELETE", 1, (240,0,0))
        if DISPLAY_ROTATE:
            test=pygame.transform.rotate(test, 90)        
        self.image.blit(test, (0, 35))
        test=font.render("ON CLICK", 1, (240,0,0))
        if DISPLAY_ROTATE:
            test=pygame.transform.rotate(test, 90)        
        self.image.blit(test, (20, 25))
        self.buttonType="CONTINUOUS"
        self.updateQueueButton()


    def setMovieMode(self):        
        setVideoListView()
        
    def setMusicMode(self):
        setAlbumListView()
        
    def setSong(self,songName, albumName, artistName):    
        #This draws the currently playing song to the right place
        global screenBottom, screenTop
        
        
        if DISPLAY_ROTATE:
            #positionImage=pygame.transform.rotate(self.image, 90)
            #screenTop.blit(positionImage,(0,100))
            self.image.blit(self.background, (0,0))
            font = pygame.font.Font(None,30)
            test=font.render(songName, 1, MAINFONTCOLOR)
            test=pygame.transform.rotate(test, 90)
            self.image.blit(test, (3, 0))
            font = pygame.font.Font(None,20)
            test=font.render(artistName+ " - " +albumName, 1, MAINFONTCOLOR)
            test=pygame.transform.rotate(test, 90)        
            self.image.blit(test, (23, 0))
            screenTop.blit(self.image,(0,100))
        else:
            self.image.blit(self.background, (0,0))
            font = pygame.font.Font(None,30)
            test=font.render(songName, 1, MAINFONTCOLOR)        
            self.image.blit(test, (3, 15))
            font = pygame.font.Font(None,20)
            test=font.render(artistName+ " - " +albumName, 1, MAINFONTCOLOR)        
            self.image.blit(test, (3, 0))            
            screenTop.blit(self.image,(100,0))
        #print "setting top song"
                
    def update(self):
        global viewMode
        global changed
        global noshuffleImage
        global shuffleImage
        global shuffle
        global shuffleClicked
        global screenBottom
        global targetAlbum,nowPlayingAlbum
        
        if self.buttonType=="PROGRESS":
            self.nameNotDrawn=True
        #self.rect.left = self.posx
        #self.rect.bottom = self.posy
        if (not self.buttonHandled and buttonPressed==1 and self.rect.collidepoint(pygame.mouse.get_pos()[0],pygame.mouse.get_pos()[1])):
            self.buttonHandled=True
            changed=1
            if self.buttonType=="LIST":                
                setAlbumListView()                    
            elif self.buttonType=="ALBUM":            
                targetAlbum=nowPlayingAlbum
                setAlbumContentView()
            elif (self.buttonType=="PAUSE"):
                self.pausedPressed()
            elif self.buttonType=="PLAY":
                self.playPressed()
            elif self.buttonType=="NEXT":
                print "next clicked"
                songlister.next()
            elif self.buttonType=="PREVIOUS":
                print "prev clicked"
                songlister.previous()
            elif self.buttonType=="QUEUE":
                self.setQueueMode()
            elif self.buttonType=="DELETE":
                self.setDeleteMode()
            elif self.buttonType=="CONTINUOUS":
                self.setContinuousMode()
            elif self.buttonType=="MUSIC":
                self.setMusicMode()
            elif self.buttonType=="MOVIE":
                self.setMovieMode()
            elif self.buttonType=="EXIT":
                print "EXITING..."
                #songlister.stop()
                #sys.exit()
                toggleFullscreen()
                
            elif self.buttonType=="PROGRESS":
                
                if  not cdClicked:
                    newpercent=0
                    if DISPLAY_ROTATE:
                        newpercent=100-(pygame.mouse.get_pos()[1]-self.rect.top)/3
                    else:
                        newpercent=(pygame.mouse.get_pos()[0]-self.rect.left)/3 
                        newpercent=newpercent-6
                    
                    if newpercent<0: 
                        newpercent=0
                    songlister.setPercentPosition(newpercent)
                    print "seeking to progrees%: " + str(newpercent)
                
            elif self.buttonType=="SHUFFLE":
                shuffleClicked=1
                print "shuffle: " + str(shuffle)
                if shuffle:
                    shuffle=False
                    self.image=noshuffleImage
                else:
                    shuffle=True
                    self.image=shuffleImage
                if DISPLAY_ROTATE:
                    screenBottom.blit(self.image,(0,10))
                else:
                    screenBottom.blit(self.image,(400,0))
        else:
            self.buttonHandled=False


class CoverArt(pygame.sprite.Sprite):

    def __init__(self, mainbg,positionindex):
        global artArray
        pygame.sprite.Sprite.__init__(self, self.containers)
        self.rect = self.image.get_rect()
        self.mainbg = mainbg
        self.rect.bottom = 480
        self.positionindex=positionindex
        self.albumwidth=ALBUMSPACEWIDTH
        self.posx=positionindex*ALBUMSPACEWIDTH
        self.currentposition=positionindex
        self.lastSelectedCD=selectedCD
        
        if positionindex>2:
            self.currentposition=artArray[positionindex-2].currentposition+1
            self.lastSelectedCD=artArray[positionindex-2].lastSelectedCD
        
        self.selected=0
        self.albumId=0
        self.isVisible=True
        
        
    def rotateAlbum(self, degrees):
        
        self.image=pygame.transform.rotate(self.image, degrees)
        
    def setAlbum(self, givenimage, artist, album,albumId, imageType,filename):
        self.album=album
        self.artist=artist

        if imageType==0:
            if not givenimage.get_width()==ALBUMWIDTH:
                givenimage=pygame.transform.scale(givenimage, THUMBNAIL_SIZE)
            if givenimage.get_height()<ALBUMHEIGHT:
                diff=-1*(givenimage.get_height()-ALBUMHEIGHT)
                self.image.blit(givenimage, (0,diff+30))    
            else:
                self.image.blit(givenimage, (0,30))

            #Artist and album names
            #self.image.blit(albumTextBG, (0, 30 ))
            test=ALBUMBIGFONT.render(self.artist, 1, MAINFONTCOLOR)            
            self.image.blit(test, (0, 0 ))             
            test=ALBUMFONT.render(self.album, 1, MAINFONTCOLOR)            
            self.image.blit(test, (0, 15 )) 
            
            #print "album creation time: " + str(time.time()-aics)
            #Save cache version
            if IMAGECACHINUSE:
                try:
                    pygame.image.save(self.image,filename+".cache.tga")
                    print "saving cache:" +filename+".cache.tga"
                except:
                    print "setAlbum(): save not successfull for cache for "+filename
        else:
            self.image.blit(givenimage, (0,0))

        self.albumId=albumId
        #songcount=self.countSongs(self.album)
        #test=self.font.render(str(songcount), 1, MAINFONTCOLOR)
        #self.image.blit(test, (110, 4))
        
        self.image.set_colorkey(None)
        if DISPLAY_ROTATE:
            self.image=pygame.transform.rotate(self.image, 90)


    def countSongs(self, album):
        global songlist
        global albumlist
        j=0
        i=0
        for song in songlist:
            if (albumlist[i]==album):
                j=j+1
            i=i+1
        return j



    def setSelected(self):
        global activeCD, targetAlbum
        self.selected=1
        activeCD=self.albumId
        targetAlbum=self.albumId
        print "set selected"
        visible.add(self)

    def deselect(self):
        self.selected=0
        visible.remove(self)

    def setunknown(self):
        if len(self.album)>0:
            font = pygame.font.Font(None, 17)
            test=font.render(self.album, 1, MAINFONTCOLOR)
            self.image.blit(test, (2, 145))

    def newDraw(self):
        if (self.isVisible): screen.blit(self.image,(self.rect.left, self.rect.top))

    def moveOut(self, step):
        if (self.isVisible):
            newX=0
            newY=0
            if DISPLAY_ROTATE:
                newY=self.rect.top+100*step
                screen.blit(self.image,(self.rect.left, newY))
            else:
                newX=self.rect.left-100*step
                screen.blit(self.image,(newX, self.rect.top))
            
    
    def moveIn(self, step):
        if (self.isVisible):
            newX=0
            newY=0
            if DISPLAY_ROTATE:
                newY=self.rect.top+100*(5-step)                
                screen.blit(self.image,(self.rect.left, newY))
            else:
                newX=self.rect.left-100*(5-step)
                screen.blit(self.image,(newX, self.rect.top))
                    

    def halfDraw(self):
        if (self.isVisible): screen.blit(self.image,(self.rect.left, self.rect.top+80))

    def update(self):
        global selectedCD
        global activeCD
        global cdClicked
        global buttonPressed
        global viewMode
        global viewModeToBe
        global selectedArtArrayId
        global mouseReleased,lastMouseReleased


        if (viewMode==ALBUMLISTVIEW or viewModeToBe==ALBUMLISTVIEW):
            
            leftx=0              
            
            
            self.rect.width=ALBUMWIDTH
            if DISPLAY_ROTATE:
                if ((self.positionindex+2)%3==0):                    
                    leftx=ALBUMSPACEWIDTH+ALBUMSTARTX                    
                elif ((self.positionindex+1)%3==0):                
                    leftx=ALBUMSPACEWIDTH*2+ALBUMSTARTX                    
                else:                    
                    leftx=ALBUMSPACEWIDTH*3+ALBUMSTARTX                    
                bottom=((self.positionindex-1)/3)*ALBUMSPACEHEIGHT+ALBUMSTARTY            
                if SMOOTHSCROLLENABLED: bottom=bottom-speedModifier*mouseMoved

                self.rect.bottom=leftx+30
                self.rect.left=bottom-200

                    
            else:
                if ((self.positionindex+4)%5==0):                    
                    leftx=ALBUMSPACEWIDTH+ALBUMSTARTX                    
                elif ((self.positionindex+3)%5==0):                
                    leftx=ALBUMSPACEWIDTH*2+ALBUMSTARTX                    
                elif ((self.positionindex+2)%5==0):                
                    leftx=ALBUMSPACEWIDTH*3+ALBUMSTARTX                    
                elif ((self.positionindex+1)%5==0):                
                    leftx=ALBUMSPACEWIDTH*4+ALBUMSTARTX                    
                else:                    
                    leftx=ALBUMSPACEWIDTH*5+ALBUMSTARTX                    
                bottom=((self.positionindex-1)/5)*ALBUMSPACEHEIGHT+ALBUMSTARTY            
                if SMOOTHSCROLLENABLED: bottom=bottom-speedModifier*mouseMoved

                self.rect.bottom=bottom
                self.rect.left=leftx-self.albumwidth
                
            if (buttonPressed==1 and viewMode==ALBUMLISTVIEW): 
                visible.remove(self)
            else: 
                visible.add(self)
            
            mp=pygame.mouse.get_pos()[1] 
            if DISPLAY_ROTATE:
                mp=pygame.mouse.get_pos()[0]
            
            if (cdClicked==0 and viewMode==ALBUMLISTVIEW and buttonPressed==1 and  mp<ALBUMBOTTOM and self.rect.collidepoint(pygame.mouse.get_pos()[0],pygame.mouse.get_pos()[1])):
                print "click difference:" + str(mouseReleased- lastMouseReleased)
                #print self.rect
                if (mouseReleased- lastMouseReleased)>0.2:
                    
                    #songlister.setAlbum(self.image,self.artist,self.album, self.albumId)
                    #visible.add(songlister)
                    self.setSelected()
                    setAlbumContentView()
                    
            if ((viewMode==ALBUMCONTENTVIEW and viewModeToBe==ALBUMCONTENTVIEW) or (viewModeToBe==ALBUMCONTENTVIEW)):
                visible.remove(self)
                if (self.albumId==activeCD):                
                    selectedArtArrayId=self.positionindex
                    #This album has been selected

            self.lastSelectedCD=selectedCD
        else:
            visible.remove(self)
            if self.albumId==activeCD and (viewModeToBe==ALBUMCONTENTVIEW):
                selectedArtArrayId=self.positionindex



class VideoClip(pygame.sprite.Sprite):

    def __init__(self, mainbg,positionindex):
        pygame.sprite.Sprite.__init__(self, self.containers)
        self.rect = self.image.get_rect()
        self.mainbg = mainbg
        self.rect.bottom = 440
        self.positionindex=positionindex
        self.albumwidth=ALBUMSPACEWIDTH
        self.posx=positionindex*self.albumwidth
        self.currentposition=positionindex
        self.lastSelectedClip=selectedCD
        if positionindex>2:
            self.currentposition=clipArray[positionindex-2].currentposition+1
            self.lastSelectedClip=clipArray[positionindex-2].lastSelectedClip
        
        self.selected=0
        self.clipId=0
        self.isVisible=True
        self.font = pygame.font.Font(None,20)
        self.clipname=""
        self.filename=""

    def makeImageOSX(self, filename, clipname):
        command="./mplayer -ss 30 -nosound -vo tga -frames 1 \""+filename+"\""
        startpos=str(random.randint(60,120))
        if filename.find(".flv")>0:
            #flash files do not behave nicely to seek
            command="./mplayer -zoom -ss 2 -nosound -vo tga -frames 2 -vf scale="+str(VIDEOCOVERWIDTH)+":-3  \""+filename+"\""
        else:
            command="./mplayer -zoom -ss "+startpos+" -nosound -vo tga -frames 2 -vf scale="+str(VIDEOCOVERWIDTH)+":-3  \""+filename+"\""
        print command
        os.system(command)
        command="cp 00000002.tga \""+coverlocation+clipname+".tga\""
        print command
        os.system(command)
        command="rm 00000002.tga "
        os.system(command)
        command="rm 00000001.tga "
        os.system(command)

    def makeImageLinux(self, filename, clipname):
        startpos=str(random.randint(60,120))
        if filename.find(".flv")>0:
            #flash files do not behave nicely to seek
            command="mplayer -zoom -ss 2 -nosound -vo jpeg:outdir=\""+coverlocation+"\" -frames 2 -vf scale="+str(VIDEOCOVERWIDTH)+":-3  \""+filename+"\""
        else: 
            command="mplayer -zoom -ss "+startpos+" -nosound -vo jpeg:outdir=\""+coverlocation+"\" -frames 2 -vf scale="+str(VIDEOCOVERWIDTH)+":-3  \""+filename+"\""    
        #print command
        os.system(command)
        command="cp \""+coverlocation+"00000002.jpg\" \""+coverlocation+clipname+".jpg\""        
        os.system(command)
        command="rm \""+coverlocation+"00000002.jpg\""         
        os.system(command)

    def setClip(self, givenimage, clipname, clipId, imageType,filename):
        self.clipname=clipname
        self.clipId=clipId
        self.filename=filename
        clipcover=""
        if ISMAEMO:
            clipcover=coverlocation+clipname+".jpg"
        else:
            clipcover=coverlocation+clipname+".tga"
        if not (os.path.exists(clipcover)):
            if ISMAEMO:
                self.makeImageLinux(filename, clipname)
                #showInfo("Creating video thumbnail")
                #print "images disabled for maemo"
            else:
                self.makeImageOSX(filename, clipname)
                #showInfo("Creating video thumbnail")

            #If creation successful, then use that instead
        if (os.path.exists(clipcover)):
            givenimage=load_image(clipcover)
        if imageType==0:
            if not givenimage.get_width()==VIDEOCOVERWIDTH:
                if self.filename.find(".flv")>0:
                    givenimage=pygame.transform.scale(givenimage, (VIDEOCOVERWIDTH, 160))
                else:
                    givenimage=pygame.transform.scale(givenimage, (VIDEOCOVERWIDTH, 144))
                    
                    
            if givenimage.get_height()<160:
                diff=-1*(givenimage.get_height()-160)
                self.image.blit(givenimage, (0,diff+4))    
            else:
                self.image.blit(givenimage, (0,4))

            #Reflection
            #givenimage=pygame.transform.flip(givenimage, 0, 1)
            #givenimage.set_alpha(60)
            #self.image.blit(givenimage, (0,125))

            #artist name in the reflection space
            fclipname=self.clipname+" "
            fclipname=string.replace(fclipname,"video","")
            fclipname=string.replace(fclipname,"Video","")
            fclipname=string.replace(fclipname,".nokia770.avi","")
            fclipname=string.replace(fclipname,".avi","")
            fclipname=string.replace(fclipname,".mov","")
            fclipname=string.replace(fclipname,".mp4","")
            fclipname=string.replace(fclipname,".flv","")
            fclipname=string.replace(fclipname,"."," ")
            fclipname=string.replace(fclipname,"_"," ")
            test=self.font.render(fclipname, 1, MAINFONTCOLOR)
            self.image.blit(videoTextBG, (0, 50 ))
            self.image.blit(test, (5, 55 )) 
            
            #self.image.blit(test, (5, 10))
            #showInfo("ADDING VIDEO: "+fclipname, self.image)
            
        else:
            self.image.blit(givenimage, (0,0))

        self.image.set_colorkey(None)


    def newDraw(self):
        if (self.isVisible): screen.blit(self.image,(self.rect.left, self.rect.top))        

    def moveOut(self, step):
        if (self.isVisible):
            newX=0
            newY=0
            if self.rect.top>240:
                newY=self.rect.top+40*step
            else:
                newY=self.rect.top-70*step
            screen.blit(self.image,(self.rect.left, newY))

    def halfDraw(self):
        if (self.isVisible): screen.blit(self.image,(self.rect.left, self.rect.top+80))

    def update(self):
        global cdClicked
        global buttonPressed
        global viewMode, clipList
        global viewModeToBe
        global mouseReleased,lastMouseReleased



        if viewMode==VIDEOLISTVIEW and viewModeToBe==VIDEOLISTVIEW:
            
            
            bottom=ALBUMBOTTOM
            centerx=0    
            if (self.currentposition==0): self.currentposition=-1
            while (self.lastSelectedClip>selectedCD):
                self.currentposition=self.currentposition-1
                self.lastSelectedClip=self.lastSelectedClip-1
                if (self.currentposition==0): self.currentposition=len(clipList)
            while (self.lastSelectedClip<selectedCD):
                self.currentposition=self.currentposition+1
                self.lastSelectedClip=self.lastSelectedClip+1
                if (self.currentposition==len(clipList)+1): self.currentposition=1
            
            visible.remove(self)
            self.isVisible=False
            if self.currentposition<18 and  (viewMode==VIDEOLISTVIEW or viewModeToBe==VIDEOLISTVIEW):
                visible.add(self)
                self.isVisible=True
                bottom=((self.currentposition-1)/3)*self.albumwidth
                centerx=900
                if ((self.currentposition+2)%3==0):                    
                    centerx=820                    
                elif ((self.currentposition+1)%3==0):                
                    centerx=570                    
                else:                    
                    centerx=330             
                #if SMOOTHSCROLLENABLED: centerx=centerx-speedModifier*mouseMoved
                if VIDEOSMOOTHSCROLLENABLED: bottom=bottom-speedModifier*mouseMoved
                
                #if VIDEOSMOOTHSCROLLENABLED: centerx=centerx-speedModifier*mouseMoved


            
            self.rect.bottom=bottom
            if len(clipArray)<9:
                self.rect.bottom=bottom+200
                
            self.rect.right=centerx
            self.rect.width=VIDEOCOVERWIDTH

            if (buttonPressed==1 and viewMode==VIDEOLISTVIEW): visible.remove(self)
            if (cdClicked==0 and viewMode==VIDEOLISTVIEW and buttonPressed==1  and pygame.mouse.get_pos()[1]<ALBUMBOTTOM and self.rect.collidepoint(pygame.mouse.get_pos()[0],pygame.mouse.get_pos()[1]) ):
             
                print "click difference:" + str(mouseReleased- lastMouseReleased)
                if (mouseReleased-lastMouseReleased)>0.4:
                    if CLICKMODE==CLICK_DELETE:
                        print "SHOULD DELETE!!"
                    else:
                        clearScreen()
                        font = pygame.font.Font(None,30)
                        test=font.render("Starting playback... Press Back button to stop playing", 1, MAINFONTCOLOR, MAINFONTBGCOLOR)
                        test.set_colorkey(MAINFONTBGCOLOR)
                        screen.blit(test,(100, 200))
                        songlister.stop()
                        pygame.display.flip()
                        time.sleep(1.5)
                        clearScreen()
                        pygame.display.flip()
                        for event in pygame.event.get():
                            print "event:"
                        if NOT_MAC:
                            command = 'mplayer -ao esd -vo sdl '
                            #Temp decision to fullscreen all flash videos
                            
                            if self.filename.find(".flv")>0:
                                #-correct-pts
                                command = command+"-vf crop=320:192  −autosync 1"
                        else:
                            command = './mplayer −nogui  '
                            if self.filename.find(".flv")>0:
                                #-correct-pts
                                command = command+"-vf crop=320:192  −autosync 1"

                        #Add playlist. Random if needed
                        fileFound=False
                        if shuffle:
                            fileFound=True
                            command=command+ " -shuffle "

                        for clipItem in clipArray:
                            if clipItem.filename==self.filename:
                                fileFound=True
                            if fileFound:
                                if clipItem.filename.find(" ")>0:
                                    command=command+ " \"" + clipItem.filename+"\""
                                else:
                                    command=command+ " " + clipItem.filename
                                fileFound=False
                                #The above to set to play just one file. Remove for continuous play
                        #print command
                        os.system(command)
                        
                        for clipItem in clipArray:
                            clipItem.newDraw()
            self.lastSelectedClip=selectedCD
        else:
            visible.remove(self)
            self.isVisible=False


class SongProcessor:
    def getOSDir(self,addpath, filelist, depth=0):
        try:
            test=os.path.exists(addpath)
            depth=depth+1
            if (test and depth<6):
                for fileName in os.listdir (addpath):
                    try:
                        mediatype = getMediaTypeFromFileName(fileName)
                        if mediatype == MEDIA_TYPE_VIDEO:
                            clipList.append(addpath+"/"+fileName)
                        elif mediatype == MEDIA_TYPE_AUDIO:
                            filelist.append(addpath+"/"+fileName)
                            
                        elif os.path.isdir(addpath+"/"+fileName) and not (fileName.find('.')==0) and not (fileName.find("debian")==0) and not (fileName.find('Maps')==0) and not (fileName.find('maps')==0 and not (fileName.find('Ringtones')==0)):
                            self.getOSDir(addpath+"/"+fileName,filelist, depth)
                    except OSError, message:
                        print "getOSDir():OSError:", message
        except OSError, message:
            print "getOSDir():OSError:", message


    def getMusicFiles(self):
        index=0
        mediaDirs = ["/media/mmc1", "/media/mmc2", "/media/mmc3", "/home/user/MyDocs/.sounds"]
        mediaDirs.append(defaultPath) # for testing
        #mediaDirs.append("/Users/urhokonttori/Movies") # for testing
        #mediaDirs.append("/Volumes/OSX/downloads") # for testing
        #mediaDirs.append("test") # for testing
        for dir in mediaDirs:
            if (os.path.exists(dir)): 
                self.getOSDir(dir, filelist)
            
    def saveTagList(self):
        i=0
        saveArray=[]
        for fileName in filelist:
            if len(songlist) > i:
                try:
                    #0  #
                    saveString=fileName
                    saveString=saveString+"##==##"
                    saveString=saveString+songlist[i]
                    saveString=saveString+"##==##"+artistlist[i]
                    saveString=saveString+"##==##"+albumlist[i]
                    saveArray.append(str(saveString))
                    
                except UnicodeDecodeError, message:
                    print "saveTagList(): UnicodeDecodeError:", message
            i=i+1
        f = open(coverlocation+"songlist.txt", 'w' )
        f.write( os.linesep.join(saveArray))

    def getCacheFileIndex(self,filecache, fileName):
        i=0
        for cachestring in filecache:
            if cachestring.startswith(fileName):                
                return i
            i=i+1
        return -1

    def appendSong(self, trackstr, album, artist, song, fileName):
        # 1/N format?
        slashPos = trackstr.find("/")                
        if slashPos > -1:
            trackstr = trackstr[0:slashPos]
        
        
        # single digit format?
        if len(trackstr)==1 and trackstr!=" ":
             song="00"+trackstr+" "+song
        elif len(trackstr)==2 and trackstr!=" ":
             song="0"+trackstr+" "+song
        elif len(trackstr)==3:
            song=trackstr+" "+song
            
        if not ISMAEMO: #With tracker, we don't need to do this, as all data is in unicode
            try:
                album=unicode(album, 'utf-8').encode("latin-1", "ignore")
            except:
                
                #album=unicode(album,'latin-1').encode('ascii', 'ignore')
                album=str(album)
            try:
                artist=unicode(artist,'utf-8').encode('latin-1', 'ignore')
            except:
                #artist=unicode(artist,'latin-1').encode('ascii', 'ignore')
                artist=str(artist)
            try:
                song=unicode(song,'utf-8').encode('latin-1', 'ignore')
            except:
                try:
                    song=unicode(song,'latin-1').encode('ascii', 'ignore')
                except: 
                    try:               
                        song=unicode(song, errors='ignore')
                    except: 
                        song=str(song)
                
            if string.find(album, "[u'")==0 or string.find(album, "")>0:
                album=self.fixOddUnicode(album)
            if string.find(song, "[u'")==0:
                song=self.fixOddUnicode(song)
            if string.find(artist, "[u'")==0:
                artist=self.fixOddUnicode(artist)
            
        
        #Fix some funny names from odd sources
        if album.find('(')>0: album=album[0:album.find('(')]
        if song.find('http')>0: song=song[0:song.find('http')]
        if song.find('www.')>0: song=song[0:song.find('www.')]
        
        #print "appending: " + album +"  - " + song

        if album=="":
            print "appending: " + album +"  - " + song
            album="UNKNOWN"
            

        if (not album in albumArray):
            albumArray.append(album)
            albumArtistArray.append(artist)
            self.getAlbumCoverFromFile(fileName, album)

        albumlist.append(album)
        artistlist.append(artist)
        songlist.append(song)

        if ISMAEMO:#should probably also handle video case (copy from the old code)
            filelist.append(fileName)

        
        

    def getMetadataFromFilename(self, fileName ):
        """Tries to parse the song information from the filename. Expects the directory structure to be like iTunes: artist/album/song.xxx. Returns the results as tuple: artist, album, song"""
        fileName=string.replace(fileName,"/media","")
        fileName=string.replace(fileName,"/mmc","")
        if fileName.find(".", ) > -1:
            fileName = fileName[:(fileName.rfind("."))]
        songpath=fileName.split("/")
        artist="UNKNOWN"
        album="UNKNOWN"
        song = None

        if len(songpath)==1:
            song = songpath;
        elif len(songpath)==2:
            song  = songpath[len(songpath)-1]
            album = songpath[len(songpath)-2]
        elif len(songpath)>2:
            song   = songpath[len(songpath)-1]
            album  = songpath[len(songpath)-2]
            artist = songpath[len(songpath)-3]
        return (artist, album, song)


    def getIDTagsTracker(self):
        startTime=time.time()
        try:
            starttime=time.time()
            metadata=searchproxy.Query(-1, "Music", ["Audio:Artist","Audio:Album","Audio:Title","Audio:TrackNo"],"", dbus.Array([], signature='s') ,"",False,["Audio:Artist"], False,0, 40000)
            print "Got " + str(len(metadata))+" results from tracker in " +str(time.time()-starttime)+" seconds"
        except:
            showInfo("Unable to connect to tracker. Trying again.")
            time.sleep(4)
            metadata=proxy.Query(-1, "Music", ["Audio:Artist","Audio:Album","Audio:Title","Audio:TrackNo"],"", dbus.Array([], signature='s') ,"",False,["Audio:Artist"], False,0, 40000)
        #We get a nice list sorted by artist   
        for songItem in metadata:                        
            fileUrl=songItem[0]
            artist=songItem[2]
            album=songItem[3]
            song=songItem[4]
            track=songItem[5]
            
            self.appendSong(track, album, artist, song, fileUrl)
            
        i=0        
        #As tracker doesn't contain compilation tags, we'll handle those the old fashioned way
        for album in albumArray:
            if isCompilation(album):
                albumArtistArray[i]=albumArray[i]
            i=i+1
        print "Tracker tag handling with "+str(len(albumArray))+" sorted total time:" + str(time.time()-startTime)
        

    def getIDTags(self):
        startTime=time.time()
        index=0
        filecache=[]
        try:
            f = open(coverlocation+"songlist.txt", 'r' )
            filecache = [i.strip() for i in f.readlines( )]
            f.close()
        except:
            print "getIDTags(): cache file missing, will be generated"

        
        
        print "tag reading total time:" + str(time.time()-startTime)
        checkArray=[]
        for fileName in filelist:
            checkArray.append(fileName)

        #After all music files are in the list, process the files
        for fileName in checkArray:
            song=None
            album=None
            artist=None
            addToList=False
            songDir=""
            trackstr=""
            
            fileFormat = getFormatFromFileName( fileName )
            if fileFormat == FORMAT_AUDIO_MP3 or fileFormat == FORMAT_AUDIO_M4A:
                
                # Only known formats are cached and read from the cache
                cacheIndex=self.getCacheFileIndex(filecache, fileName)
                             
                if cacheIndex>-1:                    
                    fileEntry=filecache.pop(cacheIndex).split("##==##")
                    
                    if len(fileEntry)>1:
                        song=fileEntry[1]
                        artist=fileEntry[2]
                        album=fileEntry[3]
                        addToList=True
                        self.appendSong(" ", album, artist, song, fileName)
                        continue

            if fileFormat == FORMAT_AUDIO_MP3:
                song=None
                album=None
                artist=None
                addToList=False
                
                if False:
                    #print "Trying ID3"
                        album=None
                        artist=None
                        song=None

#                    
#                    try:
#                        infoObj = ID3(fileName)
#                        infoObj = infoObj.as_dict()
#                        if infoObj.has_key("ALBUM"):  album  = infoObj["ALBUM"]
#                        if infoObj.has_key("ARTIST"): artist = infoObj["ARTIST"]
#                        if infoObj.has_key("TITLE"):  song   = infoObj["TITLE"]
#                        addToList=True
#                        if infoObj.has_key("TRACKNUMBER"):
#                            trackstr = str(infoObj["TRACKNUMBER"])
#                    except InvalidTagError, message:
#                        print "getIDTags(): Invalid ID3 tag:", message
#                        album=None
#                        artist=None
#                        song=None
#                        addToList=False
#                        trackstr=""
#                        
#                    except IOError, message:
#                        print "getIDTags(): IOERROR:", message
#                        album=None
#                        artist=None
#                        song=None
#                        addToList=False
#                        trackstr=""

                # Finally try the id3 reader
                if album is None or artist is None or song is None or (len(album)>24 or album == "UNKNOWN" or artist.find("?")>-1 or album.find("?")>-1):
                    try:
                        id3r = id3reader.Reader(fileName)
                        if id3r.getValue('album'):      album  = id3r.getValue('album')
                        if id3r.getValue('title'):      song   = id3r.getValue('title')
                        if id3r.getValue('performer'):  artist = id3r.getValue('performer')
                        if id3r.getValue('track'):
                            trackstr=str(id3r.getValue('track'))
                        if id3r.getValue('TPA'):
                            test=id3r.getValue('TPA')
                            if not test=="1/1" and not test=="None":
                                test=string.replace(test,"/2","")
                                test=string.replace(test,"/3","")
                                album=album+"("+test+")"
                        addToList=True
                        
                        #if trackstr=="1" or trackstr==1: id3r.dump()
                    except IOError, message:
                        print "ID TAG ERROR: getIDTags(): IOERROR:", message
                        #MARKING FOR DO NOT ADD. IS NOT MP3 FILE
                        addToList=False
                        album=None
                        artist=None
                        song=None
                        trackstr=""
                        
                if addToList:                        
                    if artist is None or album is None or song is None:
                        # Just in case this is MP3 file with no embedded tags, try to fill in the blanks using the filesystem
                        artistFromFile, albumFromFile, songFromFile = self.getMetadataFromFilename(fileName)
                        if artist is None:
                            artist=artistFromFile
                        if album is None:
                            album=albumFromFile
                        if song is None:
                            song=songFromFile
                        if trackstr is None:
                            trackstr="00"
                            
                    if album==None or len(album)<2: album="unknown"
                    if artist==None or len(artist)<2: artist="unknown"
                    if song==None or len(song)<2: song="unknown"
                    self.appendSong(trackstr, album, artist, song, fileName)
                else:
                    print "Removing (MP3):",fileName,"since we could not identify it sufficiently"
                    filelist.remove(fileName)
                    
                    

            elif fileFormat == FORMAT_AUDIO_M4A:
                global pilImported
                if not pilImported:
                    import PIL
                    pilImported=True
                try:
                    infoObj = PyAtom(fileName)
                    if infoObj.has_key("ALBUM"):  album  = infoObj["ALBUM"]
                    if infoObj.has_key("ARTIST"): artist = infoObj["ARTIST"]
                    if infoObj.has_key("TITLE"):  song   = infoObj["TITLE"]
                    if infoObj.has_key("TRACKNUMBER"):
                        trackstr = str(infoObj["TRACKNUMBER"])
                except IOError, message:
                    # This might be broken M4A file, better remove it
                    print "getIDTags(): IOERROR:", message                    
                    addToList = False
                    artist, album, song = self.getMetadataFromFilename(fileName)
                    addToList = True

                if addToList:
                    if artist is None or album is None or song is None:
                        # Just in case this is M4A file with no embedded tags, try to fill in the blanks using the filesystem
                        artistFromFile, albumFromFile, songFromFile = self.getMetadataFromFilename(fileName)
                        if artist is None:
                            artist=artistFromFile
                        if album is None:
                            album=albumFromFile
                        if song is None:
                            song=songFromFile
                    self.appendSong(trackstr, album, artist, song, fileName)
                else:
                    if artist is None or album is None or song is None:
                        # Just in case this is MP3 file with no embedded tags, try to fill in the blanks using the filesystem
                        artistFromFile, albumFromFile, songFromFile = self.getMetadataFromFilename(fileName)
                        if artist is None:
                            artist=artistFromFile
                        if album is None:
                            album=albumFromFile
                        if song is None:
                            song=songFromFile
                        if trackstr is None:
                            trackstr="00"
                            
                    if album==None or len(album)<2: album="unknown"
                    if artist==None or len(artist)<2: artist="unknown"
                    if song==None or len(song)<2: song="unknown"
                    print song
                    self.appendSong(trackstr, album, artist, song, fileName)
                    
                    #print "Removing (M4A) ",fileName,"since we could not identify it sufficiently"
                    #filelist.remove(fileName)

            elif fileFormat == FORMAT_AUDIO_OGG or fileFormat == FORMAT_AUDIO_WMA or fileFormat ==  FORMAT_AUDIO_AAC:
                #artist, album, song = self.getMetadataFromFilename(fileName)
                
                comments = get_ogg_comments(fileName)    
                song=comments[0]
                artist=comments[1]
                trackstr=comments[2]
                album=comments[3]
                if album=='':
                    print "Using file path for ogg"
                    artist, album, song = self.getMetadataFromFilename(fileName)
                self.appendSong(trackstr, album, artist, song, fileName)
                print "added OGG/WMA/AAC: "+fileName
            else:
                filelist.remove(fileName)
                print "Removing (UNKNOWN FILETYPE) ",fileName,"since we could not identify it sufficiently"



        
        i=0
        #Mark compilations
        for album in albumArray:
            if isCompilation(album):
                albumArtistArray[i]=albumArray[i]
            i=i+1
            
        #quick sort of the albums by artist
        temp=""
        sortArray=[]
        for artist in albumArtistArray:
            sortArray.append(artist)
        sortArray.sort(reverse=False)

        #There is a better way to do this, but for now, this'll have to do. It's really not *THAT* bad.
        i=0
        j=0
        counter=0
        while counter<10:
            i=0
            for sartist in sortArray:
                j=0
                for artist in albumArtistArray:

                    if (artist==sartist):
                        albumArtistArray[j]=albumArtistArray[i]
                        albumArtistArray[i]=sartist

                        temp=albumArray[j]
                        albumArray[j]=albumArray[i]
                        albumArray[i]=temp
                    j=j+1
                i=i+1
            counter=counter+1

        if len (albumArtistArray)<21 and len(albumArtistArray)>10:
            i=0
            end=len(albumArtistArray)
            while i<end:
                albumArray.append(albumArray[i])
                albumArtistArray.append(albumArtistArray[i])
                i=i+1
        
        print "Old tag handling with sorting total time:" + str(time.time()-startTime)
        self.saveTagList()

    

    
    def getAlbumCoverFromFile(self,fileName, album):
        #print "Trying to get album cover jpg or png " + album
        songpath=fileName.split("/")
        songDir=""+fileName

        thumbFile=getCoverArtThumbFileName(album)
        fullCoverFileName=getCoverArtFileName(album)
        if len(thumbFile)>1 and os.path.exists(thumbFile): #and os.path.exists(fullCoverFileName):
            # Already have album cover in cache
            return

        if len(songpath)>2:
            song=songpath[len(songpath)-1]
            songDir=songDir.replace(song,"")
            if (os.path.exists(songDir+"cover.jpg")):
                print "Local Folder cover file found."
                shutil.copyfile(songDir+"cover.jpg",fullCoverFileName)
                image = Image.open(fullCoverFileName)
                image = image.resize( THUMBNAIL_SIZE, Image.ANTIALIAS )
                thumbFile=thumbFile
                image.save( thumbFile, "JPEG" ) #Save as thumbnail
            
            else:
                
                fileFormat = getFormatFromFileName( fileName )
                if fileFormat == FORMAT_AUDIO_MP3:                    
                    if (os.path.exists(fullCoverFileName)):
                        print "Using image extracted by tracker, but no thumb exists"
                        image = Image.open(fullCoverFileName)
                        image = image.resize( THUMBNAIL_SIZE, Image.ANTIALIAS )
                        thumbFile=thumbFile
                        image.save( thumbFile, "JPEG" ) #Save as thumbnail
                # Check if the song file has embedded album art    
                elif fileFormat == FORMAT_AUDIO_M4A:
                    showInfo("Album art from M4A file (slow) "+fileName)
                    image = PyAtom_getAlbumArt(fileName)
                    if not image is None:
                        #Uncomment to save full sized artwork
                        image.save( fullCoverFileName, "JPEG" )
                        image = image.resize( THUMBNAIL_SIZE, Image.ANTIALIAS )
                        thumbFile=getCoverArtThumbFileName(album)
                        image.save( thumbFile, "JPEG" )


    def fixOddUnicode(self, paramStr):
        print paramStr
        
        try:        
            paramStr=unicode(paramStr,'utf8').encode(sys.getdefaultencoding(), 'ignore')
        except:
            paramStr=unicode(paramStr,'latin-1').encode('ascii', 'ignore')
        paramStr=string.replace(paramStr,"\xe4","ä")
        paramStr=string.replace(paramStr,"'-_u'","")
        paramStr=string.replace(paramStr,"', u'","")
        paramStr=string.replace(paramStr,"[u'\u02d9\u0163","")
        paramStr=string.replace(paramStr,"']","")
        return paramStr


    def getAlbumCover(self, i):
        global coverlocation,socketOk
        f=" "
        thumbFile=getCoverArtThumbFileName(albumArray[i])        
        fullCoverFileName=getCoverArtFileName(albumArray[i])
        
        found=False
        try:
            f=open(thumbFile,'r')
        except:
            ok=False
            
        if (os.path.exists(fullCoverFileName)):
            #We can just scale this full version down
            image = Image.open(fullCoverFileName)
            image = image.resize( THUMBNAIL_SIZE, Image.ANTIALIAS )            
            image.save( thumbFile, "JPEG" ) #Save as thumbnail
        
        else:
            showInfo("Downloading "+str(i)+"/"+str(len(albumArray))+":"+albumArray[i])            
            compilation=isCompilation(albumArray[i])
            searchAlbum=albumArray[i]
            searchArtist=albumArtistArray[i]
            
            searchAlbum=string.replace(searchAlbum, "("," ")
            searchArtist=string.replace(searchArtist, ")"," ")
            
            
            searchString=searchAlbum+' '
            searchAltString=searchAlbum+" CD"
            
            if not compilation:
                searchString=searchAlbum+' '+ searchArtist+' '
                searchAltString=searchAlbum+" CD"
                
            if (f==' ' or f==None) and socketOk:
                found=self.retrieveImageFromNetMSN(searchString,fullCoverFileName)
                if (not(found)):
                    print "not found"+fullCoverFileName
                    found=self.retrieveImageFromNetMSN(searchAltString ,fullCoverFileName)
                    if (not(found)):                                        
                        found=self.retrieveImageFromNetMSN(string.replace(searchAltString," ", " OR ") ,fullCoverFileName)
            if found: 
                image = Image.open(fullCoverFileName)
                image = image.resize( THUMBNAIL_SIZE, Image.ANTIALIAS )            
                image.save( thumbFile, "JPEG" ) #Save as thumbnail
 

    def getAlbumCovers(self):
        global SMOOTHSCROLLENABLED,SCROLLENABLED
        if len(albumArray)<12:
            SMOOTHSCROLLENABLED=False
        if len(albumArray)<12:
            SCROLLENABLED=False
        self.font = pygame.font.Font(None,16)
        for album in albumArray:
            loadok=0

    def retrieveImageFromNet(self, imageName, filename):
        global socketOk,coverlocation
        urladdress="http://images.search.yahoo.com/search/images?"
        imageSearch=string.replace(imageName,"_"," ")
        imageSearch=string.replace(imageSearch,":"," ")
        
        imageSearch=string.replace(imageSearch,"?"," ")
        imageSearch=string.replace(imageSearch,"/"," ")
        imageSearch=string.replace(imageSearch,"\\"," ")
        imageSearch=string.replace(imageSearch,"-"," ")
        imageSearch=string.replace(imageSearch,"~"," ")
        imageSearch=string.replace(imageSearch," CD1"," ")
        imageSearch=string.replace(imageSearch," CD2"," ")
        nameEnd=imageSearch.find(')')
        if nameEnd>0:
            imageSearch=imageSearch[0:nameEnd]
            
        if (socketOk and filename.find("NOARTIST")==-1 and filename.find("UNKNOWN")==-1):
            params = {'p':imageSearch}            
            txdata = urllib.urlencode(params)
            urladdress=urladdress+txdata+"&ei=UTF-8"
            #print "opening " + urladdress
            found=False
            try:
                sock = urllib.urlopen(urladdress)                
                htmlSource = sock.read()
            except:
                print "retrieveImageFromNet(): unable to get socket"
                
                print sys.exc_info()[0]
                socketOk=False
            if socketOk:
                try:                
                    imagelocationStart=htmlSource.find('Go to fullsize image')+28
                    if (imagelocationStart>28):
                        imagelocationend=htmlSource.find('"',imagelocationStart)
                        imagelocation=htmlSource[imagelocationStart:imagelocationend]
                        
                        urllib.urlretrieve(imagelocation, filename)
                        found=True
    
                    sock.close()
                    return found
                except:
                    print "retrieveImageFromNet(): Problem saving file :" + filename
                    print sys.exc_info()[0]
                    
                    return False



    def retrieveImageFromNetMSN(self, imageName, filename):
        global socketOk,coverlocation
        #urladdress="http://search.msn.com/images/results.aspx?"
        urladdress="http://search.live.com/images/results.aspx?"
        #http://search.live.com/images/results.aspx?q=kylie+minogue+sweet+music&FORM=BIRE
        
        imageSearch=imageName
        
        if imageSearch.find('www.')>0:
            imageSearch=imageSearch[0:imageSearch.find('www.')]
        
        imageSearch=dropInsideContent(imageSearch,"[","]" )
        imageSearch=dropInsideContent(imageSearch,"{","}" )
        imageSearch=dropInsideContent(imageSearch,"(",")" )    
        imageSearch=imageSearch.strip('()_{}[]!@#$^&*+=|\\/"\'?<>~`')
        imageSearch=dropInsideContent(imageSearch,"{","}" )
        imageSearch=string.replace(imageSearch,"\t"," ")
        imageSearch=string.replace(imageSearch,"  "," ")
        
        try: 
            imageSearch=imageSearch.decode('utf-8')
        except:
            try:
                imageSearch=imageSearch.encode('latin-1', 'ignore')
                imageSearch=unicodedata.normalize('NFKD',imageSearch).encode()
            except:
                imageSearch="unknown"
        
        #imageSearch=str(imageSearch)
        #print "URL:" +imageSearch
        imagelocation=""
        if (socketOk and filename.find("NOARTIST")==-1 and filename.find("UNKNOWN")==-1):
            params = {'q':imageSearch}            
            txdata="unknown"
            try:
                txdata = urllib.urlencode(params)
            except:
                print "ERROR IN URL PARAMS:" 
                print params
            
            urladdress=urladdress+txdata+"++filterui%3aaspect-square&FORM=QBIR"
            print "opening " + urladdress
            found=False
            try:
                sock = urllib.urlopen(urladdress)
                htmlSource = sock.read()
            except:
                print "retrieveImageFromNetMSN(): unable to get socket" + urladdress
                print sys.exc_info()[0]
                socketOk=False
            if socketOk:
                try:
                    imagelocationStart=htmlSource.find('thumbnail.aspx')-40
                    imagelocationStart=htmlSource.find('src="',imagelocationStart)+5
                    #print imagelocationStart
                    if (imagelocationStart>28):
                        imagelocationend=htmlSource.find('"',imagelocationStart)
                        imagelocation=htmlSource[imagelocationStart:imagelocationend]
                        imagelocation=string.replace(imagelocation,"&amp;","&")
                        #print imagelocation
                        urllib.urlretrieve(imagelocation, filename)
                        found=True
    
                    sock.close()
                    return found
                except:
                    print "retrieveImageFromNetMSN(): Problem saving file :" + filename
                    print "url :" + imagelocation
                    
                    print  sys.exc_info()[0]
                    socketOk=False
                    return False


class MainBackground:    
    def __init__(self):
        self.background = pygame.Surface(SCREENRECT.size).convert()
        self.makebg()
    def makebg(self):
        self.background.blit(self.image, (0, 0))
        black = (20,20,20)
        self.background.fill(black)



def showPosEvent(event):
    print 'Widget=%s X=%s Y=%s' % (event.widget, event.x, event.y)


def clearScreen():
    global mainbg, BGCOLOR    
    screen.fill(BGCOLOR)
    #screen.blit(mainbg.background, (0, 0))



def updateFramework():
    global screenTop, screenBottom, buttonDown, shine
   
    #if (viewMode==ALBUMLISTVIEW or viewMode==VIDEOLISTVIEW) and buttonDown==1:
    #    screen.blit(shine, (pygame.mouse.get_pos()[0]-10, pygame.mouse.get_pos()[1]-20))

    if DISPLAY_ROTATE:
        screen.blit(screenTop, (0, 0))    
        screen.blit(screenBottom, (ALBUMBOTTOM,0))    
        rect = Rect((REFLECTIONSTART,0, 50,SCREENRECT[3]))
        image = pygame.Surface(rect.size)        
        image.blit(pygame.display.get_surface(), (0, 0), rect)
        image=pygame.transform.flip(image, 1, 0)
        image.set_alpha(70)
        screen.blit(image, (ALBUMBOTTOM,0))    
    else:
        #Landscape mode - only blit the top for the time being
        screen.blit(screenTop, (0, 0))
            
        
    
        
def updateCovers():
    for i in artArray:
        i.update()
    for i in artArray:
        i.newDraw()
    albumButton.newDraw()
    #progressButton.newDraw()
    queuecountButton.newDraw()
    #playAlbumButton.newDraw()
    shuffleButton.newDraw()
    #songButton.newDraw()
    updateFramework()

def updateClips():
    for i in clipArray:
        i.update()
    for i in clipArray:
        i.newDraw()
    albumButton.newDraw()
    #progressButton.newDraw()
    queuecountButton.newDraw()
    #playAlbumButton.newDraw()
    shuffleButton.newDraw()
    #songButton.newDraw()
    updateFramework()
        

def explodeAlbumsIn():
    global mouseMoved, dragXStart, dragSpeedX
    
    j=1
    while j<7:
        clearScreen()
        for i in artArray:
            i.moveIn(j)
        updateFramework()
        pygame.display.flip()
        time.sleep(0.01)
        j=j+1
    dragXStart=0    
    dragSpeedX=0
    clearScreen()
    updateCovers()
    pygame.display.flip()
    #queuecountButton.setVisible()
    #progressButton.setVisible()
    #songButton.setInvisible()
    
 

def explodeAlbumsOut():
    global mouseMoved, dragXStart, dragSpeedX
    
    j=1
    while j<7:
        clearScreen()
        for i in artArray:
            i.moveOut(j)
        updateFramework()
        pygame.display.flip()
        time.sleep(0.01)
        j=j+1
    dragXStart=0    
    dragSpeedX=0
    
    clearScreen()    
    
def showPNAlbums():
    global selectedArtArrayId
    global artArray
    print "ALBUMS"+str(selectedArtArrayId)
    #PREVIOUS

    if selectedArtArrayId>0 and selectedArtArrayId<len(artArray):
        artArray[selectedArtArrayId-1].rect.centerx=80
        artArray[selectedArtArrayId-1].rect.bottom=218
        visible.add(artArray[selectedArtArrayId-1])

    if selectedArtArrayId>2:
        artArray[selectedArtArrayId-2].rect.centerx=0
        artArray[selectedArtArrayId-2].rect.bottom=35
        visible.add(artArray[selectedArtArrayId-2])

    #NEXT
    if selectedArtArrayId<(len(artArray)-1):
        artArray[selectedArtArrayId].rect.centerx=0
        artArray[selectedArtArrayId].rect.bottom=390
        visible.add(artArray[selectedArtArrayId])

def setAlbumContentView():
    global viewModeToBe, viewMode, listButton, songlister,albumButton,nowPlayingAlbum

    global changed
    global cdClicked
    global songItems
    global songlister, visible, mouseMovedAlbum, mouseMoved,targetAlbum
    
    mouseMovedAlbum=mouseMoved
    mouseMoved=0
    #print "===> mouseMovedAlbum: "+str(mouseMovedAlbum)
    explodeAlbumsOut()
    songlister.setAlbum(artArray[targetAlbum].image,albumArtistArray[targetAlbum], albumArray[targetAlbum],targetAlbum)
    desetCurrentPlayMode()
    viewModeToBe=ALBUMCONTENTVIEW
    
    #albumButton.setAlbum()
    #listButton.setVisible()                
        
    #visible.add(songlister)
    #songlister.setAlbum(artArray[targetAlbum].image,albumArtistArray[targetAlbum], albumArray[targetAlbum],targetAlbum)
    
    cdClicked=1
    changed=1
    

def setAlbumListView():
    global viewModeToBe, viewMode, listButton, songlister, albumButton,songButton
    
    global changed
    global cdClicked
    global songItems
    global songlister, visible
    global dragXStart, mouseMoved, dragSpeedX,mouseMovedAlbum,mouseMoved
    print "===> Setting album list view: "+str(mouseMovedAlbum)
    #explodeAlbumsIn()
    mouseMoved=mouseMovedAlbum
    #desetCurrentPlayMode()
    #listButton.setInvisible()
    #progressButton.setInvisible()
    #queuecountButton.setInvisible()
    #playAlbumButton.setInvisible()
    #songButton.setVisible()
    i=0
    while i<SONGITEMMAXCOUNT:
        visible.remove(songItems[i])
        i=i+1
    
    #visible.remove(songlister)    
    viewModeToBe=ALBUMLISTVIEW
    viewMode=ALBUMLISTVIEW
    
    dragSpeed=0
    dragStart=0
    

                            
    clearScreen()    
    updateCovers()
    pygame.display.flip()
    

    
def setVideoListView():
    global viewModeToBe, viewMode, listButton, songlister, dragSpeed, dragStart
    #desetCurrentPlayMode()
    listButton.setInvisible()
    #progressButton.setInvisible()
    #queuecountButton.setInvisible()
    #playAlbumButton.setInvisible()
    #songButton.setVisible()
    visible.remove(songlister)
    viewModeToBe=VIDEOLISTVIEW
    viewMode=VIDEOLISTVIEW
    i=0
    while i<SONGITEMMAXCOUNT:
        visible.remove(songItems[i])
        i=i+1
        
    
    dragSpeed=0
    dragStart=0
    
    
    clearScreen()
    updateClips()
    pygame.display.flip()   
    
def setCurrentPlayMode():
    global progressButton, viewModeToBe, viewMode, listButton, songlister, albumButton
    #progressButton.setVisible()        
    clearScreen()
    pygame.display.flip()
    listButton.setInvisible()
    #albumButton.setVisible()
    
    #visible.remove(songlister)    
    viewModeToBe=ALBUMPLAYVIEW
    viewMode=ALBUMPLAYVIEW
    

def desetCurrentPlayMode():
    global progressButton, viewModeToBe, listButton, songlister
    #progressButton.setInvisible()        
    clearScreen()
    pygame.display.flip()
    
def showInfo(infoString, infoImage=None):
    global mainfont
    notificationItem=bgsheet.imgat((0, 562, 312, 75), -1)
    infoString=string.replace(infoString,"_"," ")
    print "info:" +infoString
    
    if len(infoString)>0:            
        infoStringArray=infoString.split(" ")
        lineNumber=0
        linePart=""
        for stringPart in infoStringArray:
            if len(linePart+stringPart)<30:
                linePart=linePart+stringPart+" "
            else:
                test=mainfont.render(linePart, 1, MAINFONTCOLOR)
                
                notificationItem.blit(test, (10,(10+lineNumber*18)))
                linePart=stringPart+" "
                lineNumber=lineNumber+1
        if len(stringPart)>0:
            test=mainfont.render(linePart, 1, MAINFONTCOLOR)
            
            notificationItem.blit(test, (10,(10+lineNumber*18)))
            linePart=stringPart
    
    if DISPLAY_ROTATE:        
        notificationItem=pygame.transform.rotate(notificationItem, 90)
        screen.blit(notificationItem,(660, 100))
    else:
        screen.blit(notificationItem,(100, 670))
    if infoImage !=None:
        if DISPLAY_ROTATE:
            infoImage=pygame.transform.rotate(infoImage, 90)
            screen.blit(infoImage,(520,100))
        else:
            screen.blit(infoImage,(100,520))
    updateFramework()
    pygame.display.flip()

def get_rotation():
    f = open("/sys/class/i2c-adapter/i2c-3/3-001d/coord", 'r' )
    input=f.readline( )
    f.close()
    coords = input.split(' ')
    x=0
    try:
        x=int(coords[0])
    except:
        x=0
    return x


def handleDrag(dragSpeed):
    if dragSpeed>250:
        dragSpeed=0
    if dragSpeed<-250:
        dragSpeed=0
    
    if dragSpeed>100:
        dragSpeed=100
    elif dragSpeed<-100:
        dragSpeed=-100
    elif dragSpeed>10:
        dragSpeed=dragSpeed-2
    elif dragSpeed<-10:
        dragSpeed=dragSpeed+2
    elif dragSpeed>1:
        dragSpeed=dragSpeed-1
    elif dragSpeed<-1:
        dragSpeed=dragSpeed+1
    else:
        dragSpeed=0
    return dragSpeed

def main():
    
    global selectedCD
    global cdClicked
    global filelist
    global albumlist
    global albumart
    global albumArray
    global albumArtistArray
    global artistlist
    global artArray
    global viewMode
    global viewModeToBe
    global songlist
    global songlister
    global startX
    global mouseMoved
    
    global buttonDown
    global buttonPressed
    global arrowPressed
    global visible
    global mp
    global mIn
    global mplayerOut
    global songBg
    global songItems
    global changed
    global pauseAlbumIcon
    global playAlbumIcon
    global playAlbumButton
    
    global albumButton
    global shuffleButton
    global listButton
    global notificationItem
    global progressChanged
    global queuecountButton
    global bgsheet
    global screen
    global PLAYPOSSIBLE
    global ISMAEMO
    global NOT_MAC
    global mainbg
    global shuffleImage
    global noshuffleImage
    global shuffleRect
    global shuffle
    global shuffleClicked
    global playSelected
    global bgsheet
    global MAINFONTCOLOR
    global MAINFONTBGCOLOR
    global mouseReleased
    global lastMouseReleased
    global VIDEOSMOOTHSCROLLENABLED
    global lastSongPosition
    global device
    global screen
    global winstyle
    global progressButton
    global songPosition
    global covers
    global songButton
    global shine
    global clearNeeded
    global SHINEX
    global screenBottom,screenTop
    global BGCOLOR
    global currentPlayFile
    global DISPLAY_ROTATE
    
    #if ISMAEMO:
        #device.display_blanking_pause()
        #print "making charging monitor"
        #monitor=BatteryMonitor()
    
    buttonPressed=0
    font = pygame.font.Font(None,22)


    cdbgimagelocation="data/test.png"
    bgimagelocation="data/bg.png"
    shinelocation="data/shine.png"
    if (os.path.exists("/usr/share/pixmaps/bg.png")):
        bgimagelocation="/usr/share/pixmaps/bg.png"
        shinelocation="/usr/share/pixmaps/shine.png"

    #if len(sys.argv) > 1 :
    #    bgimagelocation=string.replace(bgimagelocation,"bg.png","bg2.png")
    bgsheet= SpriteSheet(bgimagelocation)


    # left border - 0, right border - 1,
    # special left border - 2, special right border - 3
    # create the background
    MainBackground.image=bgsheet.imgat((0, 0, 0, 0), -1)    
    mainbg = MainBackground().background
    
    clearScreen()
    cdbgsheet = bgsheet.imgat((703, 495, ALBUMWIDTH, ALBUMSPACEHEIGHT), -1)
    notificationItem=bgsheet.imgat((0, 562, 231, 75), -1)
    shine=pygame.image.load(shinelocation)
    all = pygame.sprite.RenderUpdates()
    visible = pygame.sprite.RenderUpdates()
    covers = pygame.sprite.RenderUpdates()
    clips = pygame.sprite.RenderUpdates()
    ControlButton.image=bgsheet.imgat((202, 492,64, 64), -1)
    ControlButton.containers=all, visible
   
    
    
    #icons
    currentAlbumIcon=bgsheet.imgat((100, 0, 270, 37), -1)
    currentAlbumBgIcon=bgsheet.imgat((100, 0, 270, 37), -1)
    screenBottom = bgsheet.imgat((0, 420, SCREENRECT[3], 60), -1)
    screenTop = bgsheet.imgat((0, 0, SCREENRECT[3], 72), -1)
    progressIcon=bgsheet.imgat((85, 70-27, 324, 27), -1)
    progressBg=bgsheet.imgat((85, 70-27, 324, 27), -1)
    progressAltBg=bgsheet.imgat((0, 637, 324, 27), -1)
    nextIcon=bgsheet.imgat((303, 460, 70, 40), -1)
    previousIcon=bgsheet.imgat((84, 460, 90, 40), -1)
    listIcon=bgsheet.imgat((0, 0, 70, 70), -1)
    exitIcon=bgsheet.imgat((0, 430, 70, 70), -1)
    albumIcon=bgsheet.imgat((655, 80, 89, 114), -1)
    shuffleImage=bgsheet.imgat((243, 488, 70, 40), -1)
    noshuffleImage=bgsheet.imgat((406, 418, 70, 40), -1)
    queueIcon=bgsheet.imgat((500, 425, 100, 38), -1)
    queueBgIcon=bgsheet.imgat((500, 425, 100, 38), -1)
    queueAltIcon=bgsheet.imgat((500, 425, 100, 38), -1)

    playAlbumIcon=bgsheet.imgat((220,420, 40, 40), -1)
    pauseAlbumIcon=bgsheet.imgat((315,491, 40, 40), -1)

    #rotate the pixmaps as needed
    if DISPLAY_ROTATE:
        screenTop=pygame.transform.rotate(screenTop, 90)
        screenBottom=pygame.transform.rotate(screenBottom, 90)
        currentAlbumIcon=pygame.transform.rotate(currentAlbumIcon, 90)
        currentAlbumBgIcon=pygame.transform.rotate(currentAlbumBgIcon, 90)
        progressIcon=pygame.transform.rotate(progressIcon, 90)        
        progressBg=pygame.transform.rotate(progressBg, 90)
        progressAltBg=pygame.transform.rotate(progressAltBg, 90)
        previousIcon=pygame.transform.rotate(previousIcon, 90)
        nextIcon=pygame.transform.rotate(nextIcon, 90)
        shuffleImage=pygame.transform.rotate(shuffleImage, 90)
        noshuffleImage=pygame.transform.rotate(noshuffleImage, 90)
        listIcon=pygame.transform.rotate(listIcon, 90)
        queueIcon=pygame.transform.rotate(queueIcon, 90)
        queueBgIcon=pygame.transform.rotate(queueBgIcon, 90)
        queueAltIcon=pygame.transform.rotate(queueAltIcon, 90)
        pauseAlbumIcon=pygame.transform.rotate(pauseAlbumIcon, 90)
        playAlbumIcon=pygame.transform.rotate(playAlbumIcon, 90)
        
    
    exitButton=ControlButton(430,70,"EXIT")
    exitButton.setImage(exitIcon)        
    exitButton.setInvisible()
    
    nextButton=ControlButton(303,780,"NEXT")
    nextButton.setImage(nextIcon)        
    nextButton.setInvisible()

    previousButton=ControlButton(94,780,"PREVIOUS")
    previousButton.setImage(previousIcon)        
    previousButton.setInvisible()
    
    queuecountButton=ControlButton(2,245,"QUEUE")
    queuecountButton.setImage(queueIcon)
    queuecountButton.background=queueBgIcon
    queuecountButton.altbackground=queueAltIcon
    queuecountButton.setContinuousMode()
    queuecountButton.setInvisible()

    shuffleButton=ControlButton(430,780,"SHUFFLE")
    shuffleButton.setImage(noshuffleImage)
    shuffleButton.setInvisible()
    
    songButton=ControlButton(100,37,"ALBUM")
    songButton.setImage(currentAlbumIcon)
    songButton.background=(currentAlbumBgIcon)        
    songButton.setInvisible()
    
    
    listButton=ControlButton(0,70,"LIST")
    listButton.setImage(listIcon)
    listButton.setInvisible()
    
    
    albumButton=ControlButton(183,70,"ALBUM")
    albumButton.setImage(albumIcon)    

    progressButton=ControlButton(85,70,"PROGRESS")
    progressButton.setImage(progressIcon)
    progressButton.background=progressBg
    progressButton.activeBackground=progressAltBg    
    progressButton.setInvisible()
    
    
    
    playAlbumButton=ControlButton(220,747,"PLAY")
    playAlbumButton.image=playAlbumIcon
    #playAlbumButton.rect=pygame.Rect(220,747, 40 ,40)
    playAlbumButton.setInvisible()
    
    if DISPLAY_ROTATE:
        progressButton.setButton(43, 398, "PROGRESS")        
        previousButton.setButton(750, 394, "PREVIOUS")
        nextButton.setButton(750, 150, "NEXT")        
        shuffleButton.setButton(750,70,"SHUFFLE")
        listButton.setButton(0,480,"LIST")
        exitButton.setButton(0,70,"EXIT")
        queuecountButton.setButton(750, 473, "QUEUE")
        songButton.setButton(0, 370, "ALBUM")
        playAlbumButton.setButton(747, 260, "PLAY")
        
        
        
    MAINFONTCOLOR=bgsheet.sheet.get_at((100,512))
    ALTFONTCOLOR=bgsheet.sheet.get_at((100,534))
    BGCOLOR=bgsheet.sheet.get_at((200,234))        
    #MAINFONTBGCOLOR=notificationItem.get_at((40,10))
    MAINFONTBGCOLOR=bgsheet.sheet.get_at((300,300))
    
    
    showInfo("Scanning memory cards...")
    
    
    songprocessor=SongProcessor()
    processtart=time.time()    
        
    if ISMAEMO:
        showInfo("Reading music information from Tracker")
        songprocessor.getIDTagsTracker()                
    else:
        showInfo("Reading music information from ID tags...")
        songprocessor.getMusicFiles()
        #if ISMAEMO: device.display_blanking_pause()
        print "music files took:" + str(time.time()-processtart)            
        songprocessor.getIDTags()
    
    SONGITEMMAXCOUNT=200-len(albumArray)
    if SONGITEMMAXCOUNT>60: SONGITEMMAXCOUNT=60
    #if ISMAEMO: device.display_blanking_pause()
    print "music+id tags took:" + str(time.time()-processtart)
    
    #IF USER HAS NO ALBUMS, LET IT BE KNOWN AND QUIT
    if (len(filelist)<1):        
        showInfo("No albums found. UKMP will now exit")        
        time.sleep(5)
        pygame.quit()

    showInfo("LOADING COVERS ("+str(len(albumArtistArray))+" Total)")        
    songprocessor.getAlbumCovers()
    albumButton.setInvisible()


    
    
    #art = pygame.sprite.RenderUpdates()
    SongItem.image=bgsheet.imgat((313, 562, 312, SONGLISTHEIGHT), -1)
    SongItem.background=bgsheet.imgat((313, 562, 312, SONGLISTHEIGHT), -1)
    SongItem.activeImage=bgsheet.imgat((0, 562, 312, SONGLISTHEIGHT), -1)
    SongItem.containers=all, visible

    i=0
    
    while i<SONGITEMMAXCOUNT:
        songItems.append(SongItem(mainbg,i))
        songItems[i].image=bgsheet.imgat((313, 562, 312, 75), -1)
        songItems[i].activeImage=SongItem.activeImage
        visible.remove(songItems[i])
        i=i+1
    
    
    
    SongList.image = bgsheet.imgat((ALBUMNAMESTARTX,ALBUMNAMESTARTY, 450, 35), -1)
    SongList.background = bgsheet.imgat((ALBUMNAMESTARTX,ALBUMNAMESTARTY, 450, 35), -1)
    SongList.containers=all
    songlister=SongList(mainbg,songItems)
    songlister.rect.left=ALBUMNAMESTARTX
    songlister.rect.top=ALBUMNAMESTARTY

    VideoClip.image = bgsheet.imgat((303, 280, VIDEOCOVERWIDTH, 160), -1)
    VideoClip.containers=all,visible,clips
    clipfilename=coverlocation+"UNKNOWN_UNKNOWN.jpg"

    if len(clipList)<12:
        VIDEOSMOOTHSCROLLENABLED=False
        print "Too few videoclips, smooth scrolldisabled"

    clipList.sort()
    initiatedClips=0

    CoverArt.image = cdbgsheet
    CoverArt.containers = all,visible,covers
    i=0
    processtart=time.time()
    
    #cdbgsheet=bgsheet.imgat((303, 270, ALBUMWIDTH, ALBUMSPACEHEIGHT), -1)
    initiatedAlbums=0
    print "Covers art:" + str(time.time()-processtart)
    clearScreen()
    pygame.display.flip()
    clock = pygame.time.Clock()
    changed=1
    buttonDown=0
    buttonWasDown=0
    startX=0
    artdragStart=0
    idleStart=0
    lastSongPosition=0
    dirty=""
    
    dragStart=0
    
    mouseMoved=0
    mouseMovedAlbum=0
    startPos=0
    
    lastPos=0
    startX=0
    upActive=False
    downActive=False
    escActive=False
    leftActive=False
    rightActive=False
    buttonDownStart=0
    loopstart=0
    mouseReleased=0
    lastMouseReleased=0
    dragSpeed=0
    lastProgressChecked=time.time()
    buttonPressedTime=0
    queuecountButton.setContinuousMode()
    gc.collect()
    #Start glib thread:
    
    while 1:
        #if ISMAEMO and keepBacklightOn: device.display_blanking_pause()
        loopstart=time.time()
        if escActive and (time.time()-buttonDownStart)>1.5:
            return
        
        
        # get input
        arrowPressed=0
        buttonPressed=0
        clearNeeded=0
        playSelected=False
        thisY=0
        
        #Handle playing multiple files
        if (songlister.playOn==1):
            if NOT_MAC:                
                if (time.time()-lastProgressChecked)>0.4:
                    songPosition = songlister.getPercentPosition()
                    progressButton.setProgress(songPosition)
                    lastProgressChecked=time.time()
                    if songlister.getDuration()>0 and (songlister.getDuration()-songlister.getPosition())<3:
                        songlister.next()
                        songlister.length=0
                        print "next"
                        
                        if ISMAEMO:
                            print "Writing song metadata to tracker"                                                        
                            currentCount=metadataproxy.Get("Music",currentPlayFile, ["Audio:PlayCount"])
                            newcount=1
                            if len(currentCount[0])>0:                            
                                newcount=int(currentCount[0])+1
                            currentTime=str(time.strftime("%Y-%m-%dT%H:%M:%SZ", time.gmtime()))
                            metadataproxy.Set("Music",currentPlayFile, ["Audio:PlayCount","Audio:LastPlay"],[str(newcount),currentTime])
                            
                        
                #print songPosition
                #test1,test2,test3=songlister.player.get_state()
                #if test2!=gst.STATE_PLAYING  or (lastSongPosition>10 and songPosition<1) or (lastSongPosition>98 and lastSongPosition==songPosition):
                #    songlister.next()
                #    lastSongPosition=0
                #else:
                #    lastSongPosition=songPosition
            else:
                progressButton.setProgress(pygame.mixer.music.get_pos()/1000)
                if pygame.mixer.music.get_pos()==-1:
                    #a quick wait to see if it's *just* starting to play the music.
                    time.sleep(0.5)                    
                    if pygame.mixer.music.get_pos()==-1:
                        #print "songPosition"+ str(pygame.mixer.music.get_pos())
                        songlister.next()
        
        if (1==1):
            rotation=get_rotation()
            #print rotation
            #or (event.key == K_SPACE and DISPLAY_ROTATE )
            if (rotation>-300 and DISPLAY_ROTATE) :
                clearNeeded=1
                changed=1
            
                mouseMoved=int(mouseMoved*3/5)
                for album in artArray:
                    album.rotateAlbum(-90)
                for item in songItems:
                    item.rotateSongItem(-90)
                DISPLAY_ROTATE=False                        
                screenTop=pygame.transform.rotate(screenTop, -90)
                screenBottom=pygame.transform.rotate(screenBottom, -90)
                progressButton.image=pygame.transform.rotate(progressButton.image, -90)
                previousButton.image=pygame.transform.rotate(previousButton.image, -90)
                nextButton.image=pygame.transform.rotate(nextButton.image, -90)
                shuffleButton.image=pygame.transform.rotate(shuffleButton.image, -90)
                listButton.image=pygame.transform.rotate(listButton.image, -90)
                exitButton.image=pygame.transform.rotate(exitButton.image, -90)
                queuecountButton.image=pygame.transform.rotate(queuecountButton.image, -90)
                songButton.image=pygame.transform.rotate(songButton.image, -90)
                playAlbumButton.image=pygame.transform.rotate(playAlbumButton.image, -90)
                    
                exitButton.setButton(430,70,"EXIT")    
                progressButton.setButton(85, 70, "PROGRESS")
                songButton.setButton(100, 37, "ALBUM")
                shuffleButton.setButton(430,780,"SHUFFLE")
                queuecountButton.setButton(2, 245, "QUEUE")                            
                previousButton.setButton(94, 780, "PREVIOUS")                        
                nextButton.setButton(303, 780, "NEXT")                                
                listButton.setButton(0,70,"LIST")
                playAlbumButton.setButton(747, 260, "PLAY")
                # or (event.key == K_SPACE and not DISPLAY_ROTATE )
            elif (rotation<-600 and not DISPLAY_ROTATE):
                clearNeeded=1
                changed=1
            
                mouseMoved=int(mouseMoved*5/3)
                for album in artArray:
                    album.rotateAlbum(90)
                for item in songItems:
                    item.rotateSongItem(90)
                
                DISPLAY_ROTATE=True
                screenTop=pygame.transform.rotate(screenTop, 90)
                screenBottom=pygame.transform.rotate(screenBottom, 90)
                
                progressButton.image=pygame.transform.rotate(progressButton.image, 90)
                previousButton.image=pygame.transform.rotate(previousButton.image, 90)
                nextButton.image=pygame.transform.rotate(nextButton.image, 90)
                shuffleButton.image=pygame.transform.rotate(shuffleButton.image, 90)
                listButton.image=pygame.transform.rotate(listButton.image, 90)
                exitButton.image=pygame.transform.rotate(exitButton.image, 90)
                queuecountButton.image=pygame.transform.rotate(queuecountButton.image, 90)
                songButton.image=pygame.transform.rotate(songButton.image, 90)
                playAlbumButton.image=pygame.transform.rotate(playAlbumButton.image, 90)
                
                progressButton.setButton(43, 398, "PROGRESS")        
                previousButton.setButton(750, 394, "PREVIOUS")
                nextButton.setButton(750, 150, "NEXT")        
                shuffleButton.setButton(750,70,"SHUFFLE")
                listButton.setButton(0,480,"LIST")
                exitButton.setButton(0,70,"EXIT")
                queuecountButton.setButton(750, 473, "QUEUE")
                songButton.setButton(0, 370, "ALBUM")
                playAlbumButton.setButton(747, 260, "PLAY")
                
                
        for event in pygame.event.get():

            #print event
            if (event.type == KEYUP):
                downActive=False
                upActive=False
                leftActive=False
                rightActive=False
                escActive=False
                if (event.key == K_LEFT and (time.time()-buttonDownStart<0.6)):
                    songlister.previous()
                    clearNeeded=1
                if (event.key == K_RIGHT and (time.time()-buttonDownStart<0.6)):
                    songlister.next()
                    clearNeeded=1

                #buttonDownStart must be at the end so that we can decide on the next song / seek policy
                buttonDownStart=0

            if (event.type == KEYDOWN):
                buttonDownStart=time.time()

                if (event.key == K_LEFT):
                    leftActive=True
                if (event.key == K_RIGHT):
                    rightActive=True

                if (event.key == K_DOWN ):
                    downActive=True

                if (event.key == K_UP ):
                    upActive=True

                #back button pressed
                if (event.key == K_ESCAPE or event.key == K_SPACE ):
                    
                    if (viewMode==ALBUMLISTVIEW):
                        setVideoListView()                        
                    elif (viewMode==VIDEOLISTVIEW):                                                
                        #setCurrentPlayMode()
                        targetAlbum=nowPlayingAlbum
                        setAlbumContentView()
                    elif (viewMode==ALBUMPLAYVIEW):                        
                        targetAlbum=nowPlayingAlbum
                        setAlbumContentView()
                    elif (viewMode==ALBUMCONTENTVIEW):
                        setAlbumListView()
                    dragStart=0
                    dragSpeed=0
                    escActive=True
                        
                
                
                if (event.key == K_RETURN):
                    if (playAlbumButton.buttonType=="PAUSE"): songlister.pause()
                    else: songlister.play()
                    changed=1
                if (event.key == K_F7):
                    #Add volume
                    vol=songlister.getVolume()
                    print "volume:" + str(vol)
                    #vol=vol+10
                    vol=vol + 0.1
                    songlister.setVolume(vol)

                if (event.key == K_F8):
                    #Decrease volume
                    vol=songlister.getVolume()
                    print "volume:" + str(vol)
                    #vol=vol-10
                    vol=vol - 0.1
                    songlister.setVolume(vol)

                if (event.key == K_F6):
                    screen = toggleFullscreen()
                    changed=1
                if (event.key==K_BACKSPACE):
                    pygame.display.iconify() 
            if (event.type == MOUSEBUTTONUP):
                mousePosition=pygame.mouse.get_pos()[1]
                if DISPLAY_ROTATE:
                    mousePosition=pygame.mouse.get_pos()[0]
                lastMouseReleased=mouseReleased
                mouseReleased=time.time()
                if (event.button<4):
                    dragStart=0
                    
                    #here be button buttonPressedTime comparison
                    if (startPos-mousePosition<10 and startPos-mousePosition>-10 and (time.time()-buttonPressedTime)>0.1): 
                        buttonPressed=1
                    buttonDown=0
                    changed=1


            if (event.type == MOUSEMOTION ):
                mousePosition=pygame.mouse.get_pos()[1]
                if DISPLAY_ROTATE:
                    mousePosition=pygame.mouse.get_pos()[0]
                if (mousePosition>70 and buttonDown==1 and (time.time()-lastMouseReleased)>0.2):
                    if  (lastPos-mousePosition)!=0 and abs(startPos-mousePosition)>30: 
                        dragSpeed=lastPos-mousePosition
                    mouseMoved=(dragStart-mousePosition)                    
                    lastPos=mousePosition
                    changed=1

            if (event.type == MOUSEBUTTONDOWN):
                changed=0
                buttonPressedTime=time.time()
                if (event.button==1):                    
                    startPos=mousePosition
                    dragStart=mousePosition+mouseMoved
                    buttonDown=1
                #Handle Mouse WHEEL. Just as if arrow button was pressed
                if (event.button==4):
                    if (viewMode!=ALBUMCONTENTVIEW):
                        selectedCD = handleRowUp(selectedCD)
                        changed=1
                        arrowPressed=1
                        buttonPressed=0
                if (event.button==5):
                    if (viewMode!=ALBUMCONTENTVIEW):
                        #print "Scrolling down"
                        selectedCD = handleRowDown(selectedCD)
                        changed=1
                        arrowPressed=1
                        buttonPressed=0

            if event.type == QUIT :
                return

        if leftActive and buttonDownStart>0:
            if (time.time()-buttonDownStart)>0.6:
                songlister.seekBackward()
        if rightActive and buttonDownStart>0:
            if (time.time()-buttonDownStart)>0.6:
                songlister.seekForward()
        if upActive:
            if (viewMode!=ALBUMCONTENTVIEW):
                dragSpeed=-40
            if (viewMode==ALBUMCONTENTVIEW):
                songlister.showNextAlbum()
                changed=1
                arrowPressed=1
        if downActive:
            if (viewMode!=ALBUMCONTENTVIEW):
                dragSpeed=40
            if (viewMode==ALBUMCONTENTVIEW):
                songlister.showPreviousAlbum()
                changed=1
                arrowPressed=1
        #print "event handler loopTime:" + str(time.time()-loopstart)
        if viewMode==ALBUMLISTVIEW and initiatedAlbums<len(albumArray):
            albumname=albumArray[initiatedAlbums]
            createAlbumCover(os, len, mainbg, cdbgsheet, showInfo, songprocessor, time, str, True, initiatedAlbums, False, load_image, CoverArt, albumname)
            #artArray[initiatedAlbums].update()
            initiatedAlbums=initiatedAlbums+1
            
            changed=1
        
        if viewMode==VIDEOLISTVIEW and initiatedClips<len(clipList):
            clipname=clipList[initiatedClips]
            createVideoClip(len, bgsheet, mainbg, initiatedClips, VideoClip, clipfilename, clipname)
            initiatedClips=initiatedClips+1
            changed=1
        
        if dragSpeed!=0:
            dragSpeed=handleDrag(dragSpeed)
            
        albumColumns=5
        if DISPLAY_ROTATE: 
            albumColumns=3
        if buttonDown==0 and dragSpeed!=0 :
            mouseMoved=mouseMoved+dragSpeed
            changed=1
            arrowPressed=1
            #Cap songlist view
            if viewMode==ALBUMCONTENTVIEW or viewModeToBe==ALBUMCONTENTVIEW:
                songListPanLimit=int(currentAlbumSongCount-10)*SONGLISTHEIGHT+SONGLISTSTARTY
                
                if not DISPLAY_ROTATE:
                    songListPanLimit=songListPanLimit/2
                if mouseMoved<0 or currentAlbumSongCount<10:
                    mouseMoved=0
                elif mouseMoved>songListPanLimit:
                    mouseMoved=songListPanLimit
            elif (viewMode==ALBUMLISTVIEW):                
                albumListPanLimit=int(ALBUMYSCROLL*(len(albumArray)-9)/albumColumns)
                if mouseMoved<-10:                    
                    mouseMoved=-10
                    dragSpeed=5
                    clearNeeded=1
                    
                elif len(albumArray) <12:
                    mouseMoved=0
                #Cap scroling of album based on bottom hit                
                elif mouseMoved>albumListPanLimit:
                    mouseMoved=albumListPanLimit
                    clearNeeded=1
                    if dragSpeed>0:
                        dragSpeed=-5
                        
                    elif dragSpeed<-5:
                        dragSpeed=5

            elif (viewMode==VIDEOLISTVIEW):                                                
                print "list capping not handled yet"
                
        if (changed==1):
            idleStart=time.time()
            cdClicked=0
            if (buttonPressed==1):
                all.update()
                if (cdClicked==0):
                    if (shuffleClicked==1 ):
                        shuffleClicked=0
                        dirty = visible.draw(screen)                        
                        pygame.display.update(dirty)
                        updateFramework()
                        progressButton.newDraw()
                        pygame.display.flip()
                    visible.update()
                    #print "****Not drawing ..."
                else:
                    all.update()
                    dirty = visible.draw(screen)
                    updateFramework()
                    #progressButton.newDraw()
                    pygame.display.flip()
                    
                                        
            else:                
                if (clearNeeded==1 or event.type != MOUSEMOTION or viewMode==ALBUMCONTENTVIEW):
                    clearScreen()
                    
                if event.type == MOUSEMOTION and viewMode==ALBUMLISTVIEW and (SMOOTHSCROLLENABLED or VIDEOSMOOTHSCROLLENABLED):
                    if mouseMoved>(ALBUMYSCROLL*(len(albumArray)-9)/3) or mouseMoved<-10:
                        clearScreen()
                    updateCovers()
                    pygame.display.flip()

                elif event.type == MOUSEMOTION and viewMode==VIDEOLISTVIEW and (SMOOTHSCROLLENABLED or VIDEOSMOOTHSCROLLENABLED):
                    updateClips()                    
                    pygame.display.flip()

                elif (dragSpeed!=0) and viewMode==ALBUMLISTVIEW:
                    updateCovers()                    
                    pygame.display.flip()
                    
                elif (dragSpeed!=0) and viewMode==VIDEOLISTVIEW:                    
                    updateClips()                    
                    pygame.display.flip()
                else:                    
                    all.update()
                    dirty = visible.draw(screen)                    
                    updateFramework()
                    #progressButton.newDraw()
                    pygame.display.flip()
                    
            changed=0
        else:
            if (dragSpeed!=0) :
                    if viewMode==ALBUMLISTVIEW: 
                        updateCovers()
                    elif viewMode==VIDEOLISTVIEW: 
                        updateClips()
                    progressButton.newDraw()                    
                    pygame.display.flip()
            elif (progressChanged):
                updateFramework()
                pygame.display.flip()
                
            
            
        viewMode=viewModeToBe

        # cap the framerate
        #print "Total loop time:" + str(time.time()-loopstart)
        
        if dragSpeed==0:
            timediff=(time.time()-idleStart)
            if (timediff>500):
                time.sleep(1.5)
            elif (timediff>115):
                time.sleep(0.7)
            elif (timediff>15):
                time.sleep(0.5)
            elif (timediff>3):
                time.sleep(0.2)
            elif (timediff<3):
                time.sleep(0.02)    
        elif not ISMAEMO: time.sleep(0.05)

if __name__ == '__main__': 
    main()
    