#!/usr/bin/env python
#
# 
# Script based on youtube-dl.py by Ricardo Garcia Gonzalez
# And also: Alessandro Arrichiello
#
#	
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#

import sys
import optparse
import httplib
import urllib2, urllib
import re
import string
import os
import time
import netrc
import gtk

import hildon

import osso
from threading import Thread
		
# Global constants


#const_video_url_params_re = re.compile(r'player2\.swf\?([^"]+)"', re.M)



const_1k = 1024
const_initial_block_size = 12 * const_1k

os.environ["SDL_VIDEO_X11_WMCLASS"]="uktube"



coverlocation='/media/mmc1/covers/'

if not os.path.exists(coverlocation):
	try:
	    if not os.path.exists(coverlocation):
		os.makedirs(coverlocation)
	except OSError, message:
		coverlocation='/media/mmc2/covers/'
		try:
		    if not os.path.exists(coverlocation):
			os.makedirs(coverlocation)
		except OSError, message:
			coverlocation='~/covers'
			if not os.path.exists(coverlocation):
			    os.makedirs(coverlocation)			
	
	
downloadlocation='/media/mmc1/Video/'
if not os.path.exists(downloadlocation):
	try:
	    if not os.path.exists(downloadlocation):
		os.makedirs(downloadlocation)
	except OSError, message:
		print message
		downloadlocation='/media/mmc2/Video/'
		try:
		    if not os.path.exists(downloadlocation):
			os.makedirs(downloadlocation)
		except OSError, message:
			print "ERROR in creating video folder"			
	

	
# Print error message, followed by standard advice information, and then exit
def error_advice_exit(error_text):
	sys.stderr.write('Error: %s.\n' % error_text)
	app.label.set_text('Error: %s ' % error_text)
	#sys.exit('\n')

# Wrapper to create custom requests with typical headers
def request_create(url, data=None):
	retval = urllib2.Request(url)
	if data is not None:
		retval.add_data(data)
	# Try to mimic Firefox, at least a little bit
	retval.add_header('User-Agent', 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1) Gecko/20061010 Firefox/2.0')
	retval.add_header('Accept-Charset', 'ISO-8859-1,utf-8;q=0.7,*;q=0.7')
	retval.add_header('Accept', 'text/xml,application/xml,application/xhtml+xml,text/html;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5')
	retval.add_header('Accept-Language', 'en-us,en;q=0.5')
	return retval

# Perform a request, process headers and return response
def perform_request(url, data=None):
	request = request_create(url, data)
	response = urllib2.urlopen(request)
	return response

# Convert bytes to KiB
def to_k(bytes):
	global const_1k
	return bytes / const_1k

# Conditional print
def cond_print(str):
	sys.stdout.write(str)
	sys.stdout.flush()

# Title string normalization
def title_string_norm(title):
	title = ''.join((x in string.ascii_letters or x in string.digits) and x or ' ' for x in title)
	title = '_'.join(title.split())
	title = title.lower()
	return title

# Generic download step
def download_step(return_data_flag, step_title, step_error, url, post_data=None):
	try:
		cond_print('%s... ' % step_title)
		
		data = perform_request(url, post_data).read()
		cond_print('done.\n')
		if return_data_flag:
			return data
		return None

	except (urllib2.URLError, ValueError, httplib.HTTPException, TypeError):
		cond_print('failed.\n')
		error_advice_exit(step_error)

	except KeyboardInterrupt:
		sys.exit('\n')

# Generic extract step
def extract_step(step_title, step_error, regexp, data):
	try:
		cond_print('%s... ' % step_title)
		match = regexp.search(data)
		
		if match is None:
			cond_print('failed.\n')
			error_advice_exit(step_error)
		
		extracted_data = match.group(1)
		cond_print('done.\n')
		return extracted_data
	
	except KeyboardInterrupt:
		sys.exit('\n')

# Calculate new block size based on previous block size
def new_block_size(before, after, bytes):
	new_min = max(bytes / 2, 1)
	new_max = max(bytes * 2, 1)
	dif = after - before
	if dif < 0.0001:
		return new_max
	rate = int(bytes / dif)
	if rate > new_max:
		return new_max
	if rate < new_min:
		return new_min
	return rate

def getYouTube(urlAddress, fullscreenPlayback, showVideo, downloadVideo):
	global const_1k, const_initial_block_size
	imageLocation=""
	playBackStarted=False
	# Global constants
	const_video_url_str = 'http://www.youtube.com/watch?v=%s'
	const_video_url_re = re.compile(r'(?:http://)?(?:www\d*\.)?youtube\.com/(?:v/|(?:watch(?:\.php)?)?\?v=)([^&]+).*')
	
	const_login_url_str = 'http://www.youtube.com/login?next=/watch%%3Fv%%3D%s'
	const_login_post_str = 'current_form=loginForm&next=%%2Fwatch%%3Fv%%3D%s&username=%s&password=%s&action_login=Log+In'
	const_age_url_str = 'http://www.youtube.com/verify_age?next_url=/watch%%3Fv%%3D%s'
	const_age_post_str = 'next_url=%%2Fwatch%%3Fv%%3D%s&action_confirm=Confirm'
	#const_video_url_params_re = re.compile(r'.swf\?([^"]+)"', re.M)
	const_video_url_params_re = re.compile(r'watch_fullscreen?([^"]+)"', re.M)
	#const_video_url_real_str = 'http://www.youtube.com/get_video?%s'
	const_video_url_real_str = 'http://www.youtube.com/get_video%s'
	const_video_title_re = re.compile(r'<title>YouTube - ([^<]*)</title>', re.M | re.I)	
	video_url_cmdl=urlAddress
	video_filename=urlAddress
	video_title=""
	image_address=""
	if not urlAddress.startswith("/"):			
		if video_url_cmdl.find("youtube")!=-1:
			
			video_url_cmdl=string.replace(video_url_cmdl,"nl.youtube", "www.youtube")
			video_url_cmdl=string.replace(video_url_cmdl,"jp.youtube", "www.youtube")
			video_url_cmdl=string.replace(video_url_cmdl,"es.youtube", "www.youtube")
			video_url_cmdl=string.replace(video_url_cmdl,"br.youtube", "www.youtube")
			video_url_cmdl=string.replace(video_url_cmdl,"ge.youtube", "www.youtube")
			video_url_cmdl=string.replace(video_url_cmdl,"uk.youtube", "www.youtube")
			video_url_cmdl=string.replace(video_url_cmdl,"fr.youtube", "www.youtube")
			video_url_cmdl=string.replace(video_url_cmdl,"it.youtube", "www.youtube")
			video_url_cmdl=string.replace(video_url_cmdl,"pl.youtube", "www.youtube")
			
			# Verify video URL format and convert to "standard" format
			video_url_mo = const_video_url_re.match(video_url_cmdl)
			if video_url_mo is None:
				sys.exit('Error: URL does not seem to be a youtube video URL. If it is, report a bug.')
			video_url_id = video_url_mo.group(1)
			video_url = const_video_url_str % video_url_id
			
			
			# Get account information if any
			account_username = None
			account_password = None
			if len(app.usernameEntry.get_text())>1:
				account_username=app.usernameEntry.get_text()
				account_password=app.passwordEntry.get_text()
			# Install cookie and proxy handlers
			urllib2.install_opener(urllib2.build_opener(urllib2.ProxyHandler()))
			urllib2.install_opener(urllib2.build_opener(urllib2.HTTPCookieProcessor()))
			
			# Log in and confirm age if needed
			if account_username is not None:
				url = const_login_url_str % video_url_id
				post = const_login_post_str % (video_url_id, account_username, account_password)
				download_step(False, 'Logging in', 'unable to log in', url, post)
			
				url = const_age_url_str % video_url_id
				post = const_age_post_str % video_url_id
				download_step(False, 'Confirming age', 'unable to confirm age', url, post)
			
			# Retrieve video webpage
			video_webpage = download_step(True, 'Retrieving video webpage', 'unable to retrieve video webpage', video_url)
			# Extract needed video URL parameters
			video_url_params = extract_step('Extracting video URL parameters', 'unable to extract URL parameters', const_video_url_params_re, video_webpage)			
			
			videoUrlStart=video_webpage.find("watch_fullscreen?")+16
			videoUrlEnd=video_webpage.find("&title=",videoUrlStart+1)
			if not videoUrlEnd>1: 
				videoUrlEnd=video_webpage.find("';",videoUrlStart+1)
			video_url=video_webpage[videoUrlStart:videoUrlEnd]
			video_url_real = const_video_url_real_str % video_url
			
			
			print video_url_real			
			# Extract video title if needed
			video_title = title_string_norm(extract_step('Extracting video title', 'unable to extract video title', const_video_title_re, video_webpage))
			image_address=coverlocation+video_title+".flv.jpg"
			if app.saveOn:
				image_url="http://img.youtube.com/vi/"+video_url_id+"/default.jpg"
				urllib.urlretrieve(image_url, image_address)			
			video_filename=downloadlocation+title_string_norm(video_title)+".flv"
				
		
		if video_url_cmdl.find("dailymotion")!=-1:
			video_webpage = download_step(True, 'Retrieving video webpage', 'unable to retrieve video webpage', video_url_cmdl)
			videoUrlStart=video_webpage.find("http%3A%2F%2Fwww.dailymotion.com%2Fget")
			videoUrlEnd=video_webpage.find('"',videoUrlStart+1)
			video_url=video_webpage[videoUrlStart:videoUrlEnd]
			
			videoTitleStart=video_webpage.find("<title>")+7
			videotitleEnd=video_webpage.find('- Dailymotion',videoTitleStart+1)
			if videotitleEnd!=-1:
				video_title=video_webpage[videoTitleStart:videotitleEnd-1]
			else:
				video_title="unknownDailymotion"
			
			video_url=video_url.replace("%3A",":")
			video_url=video_url.replace("%2F","/")
			video_url=video_url.replace("%3F","?")
			video_url=video_url.replace("%3D","=")
			video_title=title_string_norm(video_title)
			video_title.replace("video_","")
			video_url_real=video_url
			video_filename=downloadlocation+video_title+".flv"
			imageUrlStart=video_url.rfind("/")+1
			imageUrlEnd=video_url.find('.',imageUrlStart+1)
			image_url=video_url[imageUrlStart:imageUrlEnd]
			image_url="http://static-10.dailymotion.com/dyn/preview/160x120/"+image_url+".jpg"
			image_address=coverlocation+video_title+".flv.jpg"
			if app.saveOn:				
				urllib.urlretrieve(image_url, image_address)
				print "saving image to:" +image_address
				
		if video_url_cmdl.find("stage6")!=-1:
			print "PROCESSING STAGE6 VIDEO!"
			video_webpage = download_step(True, 'Retrieving video webpage', 'unable to retrieve video webpage', video_url_cmdl)
			videoUrlStart=video_webpage.find("src&quot; value=&quot;")+22
			videoUrlEnd=video_webpage.find('&quot;',videoUrlStart+1)
			video_url=video_webpage[videoUrlStart:videoUrlEnd]
			print video_url
			
			videoTitleStart=video_webpage.find("<title>")+7
			videotitleEnd=video_webpage.find('</title>',videoTitleStart+1)
			if videotitleEnd!=-1:
				video_title=video_webpage[videoTitleStart:videotitleEnd-1]
			else:
				video_title="unknownStage6"
			
			print video_title
			video_url=video_url.replace("%3A",":")
			video_url=video_url.replace("%2F","/")
			video_url=video_url.replace("%3F","?")
			video_url=video_url.replace("%3D","=")
			
			video_url=video_url.replace("&middot;","")
			video_title.replace("stage6","")
			video_title=title_string_norm(video_title)
			
			
			
			
			video_url_real=video_url
			video_filename=downloadlocation+video_title+".avi"
			image_address=coverlocation+video_title+".flv.jpg"
				
		print "image at:" +image_address					
		app.image.set_from_file(image_address)			
		if not downloadVideo:
			return
		
		
		if not app.saveOn:
			video_filename=downloadlocation+"lastVideo.flv"
		
		print "output filename set to : "+video_filename	
		try:
			disk_test = open(video_filename, 'wb')
			disk_test.close()
		except (OSError, IOError):
			sys.exit('Error: unable to open %s for writing.' % video_filename)
		
		
		# Retrieve video data
		#try:
		if 1==1:
			video_data = perform_request(video_url_real)	
			cond_print('Video data found at %s\n' % video_data.geturl())
			death=0
			if "vo.llnwd.net" not in video_data.geturl():
				death=1
			
			video_file = open(video_filename, 'wb')
			
			try:
				video_len_str = '%sk' % to_k(long(video_data.info()['Content-length']))
			except:
				print "video length unknown"
				video_len_str = '(unknown)'
			print "length=" + str(video_len_str)
			print "Video file opened: " + video_filename
			byte_counter = 0
			block_size = const_initial_block_size
			
			i=0
			while True:
				i=i+1
				cond_print('\rRetrieving video data... %sk of %s ' % (to_k(byte_counter), video_len_str))
				app.label.set_text('Retrieving video data... %sk of %s ' % (to_k(byte_counter), video_len_str))
				
				before = time.time()
				video_block = video_data.read(block_size)
				after = time.time()
				dl_bytes = len(video_block)
				if dl_bytes == 0:
					break
				byte_counter += dl_bytes
				if showVideo and not playBackStarted and to_k(byte_counter)>1024:
					print "Starting  playback"
					runner=runIt(video_filename, fullscreenPlayback)
					runner.start()
					playBackStarted=True
				video_file.write(video_block)
				block_size = new_block_size(before, after, dl_bytes)			
				while gtk.events_pending():
					gtk.main_iteration()			
		
			video_file.close()
			cond_print('done.\n')
			cond_print('Video data saved to %s\n' % video_filename)
		
		#except (urllib2.URLError, ValueError, httplib.HTTPException, TypeError):
		#	cond_print('failed.\n')
		#	error_advice_exit('unable to download video data')
		
	if fullscreenPlayback:
		command = 'mplayer -vf crop=320:192 ' + str(video_filename) 
	else:
		command = 'mplayer ' + str(video_filename) 
	if showVideo:
		app.label.set_text('Video ready for playback')
		while gtk.events_pending():
			gtk.main_iteration()		
		
		#Disabled to test streaming version
		if not playBackStarted:
			print 'Running:'+ command		
			os.system(command)
			
	
	#Set the current address to be the last played file (so that user can easily replay)
	app.entry.set_text(video_filename)
	#In the end add movie to the playlist if it is not a local file
	if not urlAddress.startswith("/"):	
		app.filecombobox.append_text(video_filename)

class runIt(Thread):
   def __init__ (self, video_filename, fullscreenPlayback):
      Thread.__init__(self)
      self.video_filename=video_filename
      self.fullscreenPlayback=fullscreenPlayback
      self.status = -1
   def run(self):	
	if self.fullscreenPlayback:
		command = 'mplayer -vf crop=320:192 ' + self.video_filename		
		os.system(command)
	else:
		command = 'mplayer ' + self.video_filename
		print 'Running:'+ command		
		os.system(command)

class uktube(hildon.Program):
	def __init__(self):
		hildon.Program.__init__(self)
		self.saveOn=True
		self.window = hildon.Window()
		self.window.connect("destroy", gtk.main_quit)  
		self.add_window(self.window)
		
		self.paste_button = gtk.Button("Paste link")
		self.paste_button.connect("clicked", self.pasteAddress)
		
		self.send_button = gtk.Button("Show Original Aspect")
		self.send_button.connect("clicked", self.accessYoutube)
		
		self.save_button = gtk.Button("Only Download")
		self.save_button.connect("clicked", self.onlyDownload)
		
		self.delete_button = gtk.Button("Delete")
		self.delete_button.connect("clicked", self.delete)
		
		self.send_buttonFS = gtk.Button("Show In Widescreen")
		self.send_buttonFS.connect("clicked", self.accessYoutubeFS)
		vbox = gtk.VBox(False, 0)
		self.window.add(vbox)
		vbox.show()
		
		hbox = gtk.HBox(False, 0)		
		hbox2 = gtk.HBox(False, 0)		
		hbox3 = gtk.HBox(False, 0)		
		
		self.image = gtk.Image()
		#self.image.set_from_file("/tmp/f27.jpg")
		self.image.show()
		
		
		self.label = gtk.Label("Paste youtube/dailymotion URL or select a local file.")
		vbox.pack_start(self.label, True, True, 0)
		
		self.label.show()   
		self.filecombobox = gtk.combo_box_new_text()
		for fileName in os.listdir (downloadlocation):			
			if fileName.find('.')!=0 and (fileName.endswith(".flv") or fileName.endswith(".avi")) :
				self.filecombobox.append_text(downloadlocation+fileName)

		self.filecombobox.connect("changed", self.localFileSelected)
		


		
		self.labelUname = gtk.Label("Username:")
		hbox3.pack_start(self.labelUname, True, True, 0)
		self.usernameEntry = gtk.Entry()
		self.usernameEntry.set_max_length(50)
		self.usernameEntry.set_text("")		
		hbox3.pack_start(self.usernameEntry, True, True, 0)
				
		self.labelUPass = gtk.Label("Password:")
		hbox3.pack_start(self.labelUPass, True, True, 0)
		self.passwordEntry = gtk.Entry()
		self.passwordEntry.set_max_length(50)
		self.passwordEntry.set_text("")
		#This makes the field password like
		self.passwordEntry.set_visibility(False)
		
		hbox3.pack_start(self.passwordEntry, True, True, 0)
		self.labelUname.show()
		self.usernameEntry.show()
		self.labelUPass.show()
		self.passwordEntry.show()
		
		
		self.label.show()
		
		vbox.pack_start(self.filecombobox, True, True, 0)
		vbox.pack_start(hbox3)
		hbox.pack_start(self.send_button, True, True, 0)
		hbox2.pack_start(self.paste_button, True, True, 0)
		hbox2.pack_start(self.image, True, True, 0)		
		vbox.pack_start(hbox2, True, True, 0)
		self.paste_button.show()
		self.entry = gtk.Entry()
		self.entry.set_max_length(450)
		self.entry.set_text("")
		vbox.pack_start(self.entry, True, True, 0)
		self.entry.show()
		self.saveFileCB = gtk.CheckButton("Save file on memory card ")
		self.saveFileCB.set_active(True)
		self.saveFileCB.connect("toggled", self.togglesave)
		vbox.pack_start(self.saveFileCB)
		self.saveFileCB.show()
		vbox.pack_start(hbox)
		hbox.show()
		
		hbox.pack_start(self.send_button, True, True, 0)
		hbox.pack_start(self.send_buttonFS, True, True, 0)
		hbox.pack_start(self.save_button, True, True, 0)
		hbox.pack_start(self.delete_button, True, True, 0)
		
		self.send_button.show()
	
	
	
	def getOSDir(self,addpath, filelist, depth=0):
		try:
		 test=os.path.exists(addpath)
		 depth=depth+1
		 if (test and depth<6):
		  for fileName in os.listdir (addpath):
			#print fileName 	 
			try:
				if fileName.find('.')!=0 and (fileName.find(".mp3")>0 or fileName.find(".MP3")>0 or fileName.find(".ogg")>0 or fileName.find(".OGG")>0) :			
					filelist.append(addpath+'/'+fileName)
				if os.path.isdir(addpath+"/"+fileName) and not (fileName.find('.')==0) and not (fileName.find('debian')==0) and not (fileName.find('Maps')==0) and not (fileName.find('maps')==0):
					self.getOSDir(addpath+"/"+fileName,filelist, depth)
			except OSError, message:
				print "OSError:", message			
		except OSError, message:
			print "OSError:", message
		
	def togglesave(self, widget):
		if self.saveOn:
			self.saveOn=False
		else:
			self.saveOn=True
	
	def populateCombobox(self):
		for fileName in os.listdir (downloadlocation):			
			if fileName.find('.')!=0 and (fileName.endswith(".flv") or fileName.endswith(".avi")):
				self.filecombobox.append_text(downloadlocation+fileName)		
		while gtk.events_pending():
			gtk.main_iteration()
			
	def delete(self, widget):		
		self.saveOn=True
		if self.entry.get_text().find("/")==0:
			filetodelete=self.entry.get_text()
			if (os.path.exists(filetodelete)):
				os.remove(filetodelete)								
				self.removeComboItem(self.filecombobox, filetodelete)				
				app.label.set_text("Video deleted")
				while gtk.events_pending():
					gtk.main_iteration()				
				
				
	def localFileSelected(self, widget):
		print self.get_active_text(self.filecombobox)
		self.entry.set_text(self.get_active_text(self.filecombobox))
	
	
	def onlyDownload(self, widget):		
		getYouTube(self.entry.get_text(), False, False, True)
	
		
	def removeComboItem(self, combobox, removetext):	
		model = combobox.get_model()
		i=0
		while i<len(model):
			if model[i][0]==removetext:
				combobox.remove_text(i)
				if i<len(model)-1:
					combobox.set_active(i)
					self.entry.set_text(self.get_active_text(self.filecombobox))
			i=i+1
		
		
	
	def get_active_text(self,combobox):
		model = combobox.get_model()
		active = combobox.get_active()
		if active < 0:
		    return None
		return model[active][0]
	
	def accessYoutube(self, widget):
		global getYouTube		
		app.label.set_text("Initiating download...")
		while gtk.events_pending():
			gtk.main_iteration()				
		getYouTube(self.entry.get_text(), False, True, True)
		
		#runner=runIt().start()
		
	def pasteAddress(self, widget):
		self.entry.set_text("")
		self.entry.paste_clipboard()
		while gtk.events_pending():
			gtk.main_iteration()						
		getYouTube(self.entry.get_text(), True, True, False)
		app.label.set_text("Ready to download...")
		
		while gtk.events_pending():
			gtk.main_iteration()
		
		self.populateCombobox()
	def accessYoutubeFS(self, widget):
		global getYouTube		
		app.label.set_text("Initiating download...")
		while gtk.events_pending():
			gtk.main_iteration()				
		getYouTube(self.entry.get_text(), True, True, True)
		
		#runner=runIt().start()
		
		
	def run(self):     
		self.window.show_all()
		gtk.main() 

if __name__ == "__main__":  
	app = uktube() 
	app.run()         
