#ifndef TXTREADER_H
#define TXTREADER_H
#include <QApplication>
#include <QMainWindow>
#include <QWidget>
#include <QLabel>
#include <QList>
#include <QFontMetrics>
#include <QLine>
#include <QDebug>
#include <QTime>
#include <QPushButton>
#include <QTextEdit>
#include <QSpacerItem>
#include <QGridLayout>
#include <QSystemTrayIcon>
#include <QCloseEvent>
#include <QMenu>
#include <QTextStream>
#include <QMessageBox>
#include <QFileDialog>
#include <QSettings>
#include <QInputDialog>
#include <QFontDialog>
#include <QColorDialog>
#include <QStyleOption>
#include <QTranslator>
#include <QUrl>
#include <QPainter>
#include "ReaderView.h"
class TxtReader : public QMainWindow//QWidget
{
	Q_OBJECT
public:
    enum ScreenOrientation {
        ScreenOrientationLockPortrait,
        ScreenOrientationLockLandscape,
        ScreenOrientationAuto
    };
        TxtReader(QString infile = "");
        void jumpToPrePage();
        void jumpToNextPage();
        void setOrientation(ScreenOrientation orientation);
protected:
	void keyPressEvent(QKeyEvent * event);
//	void mouseMoveEvent(QMouseEvent *event);
	void mousePressEvent(QMouseEvent *event);
        void closeEvent ( QCloseEvent * event );
//for context menu
	void contextMenuEvent(QContextMenuEvent *event);
//        void paintEvent(QPaintEvent *);
        virtual void resizeEvent(QResizeEvent *event);
private:
	QString version,bgImage,uilang;
	QFont txtFont;
        QColor txtColor,bgColor;
        int curPageNum,curOffset;
	bool o_isfullscreen;
        bool isLandscape;

        ReaderView *viewContentEdit;
        QTimer *showbutton;
        QTimer *screenblank;

        QString FileContent;
        QList<int> PageOffsetList;
        int TotalPageNum;
        QString searchText;

	QPoint dragPosition;
        void jumpToOffset(int offset);
        void jumpToPage(int pageNum);
        int loadFile(const QString &fileName);
        void genPageList(QString &content,QList<int> &list);
        void reGenPageList();

        QMenu *fileMenu;
        QIcon icon;
	QAction *openAct;
	QAction *aboutAct;
	QString codecstr;
        QMenu *searchMenu;
        QAction *searchOriAct;
        QAction *searchCurAct;
	QMenu *codecMenu;
	QAction *GB2312Act;
	QAction *UTF8Act;
	QAction *BIG5Act;
	QActionGroup *codecActionGroup;
	QAction *jumpAct;
	QMenu *bookmarkMenu;
        QList<QAction *> bookmarkArray;
	QAction *addBookmarkAct;
	QAction *delBookmarkAct;
        QAction *clearBookmarkAct;
	QMenu *setfontMenu;
	QAction *addTxtSizeAct;
	QAction *subTxtSizeAct;
	QAction *setfontAct;
	QAction *setfontcolorAct;
	QMenu * bgMenu;
	QAction * scnAction;
	QAction * setbgcolorAct;
	QAction * setbgimageAct;
	QAction * delbgimageAct;
        QMenu * historyMenu;
        QMenu * languageMenu;
        QActionGroup *languageActionGroup;
	void createLanguageMenu();
	QTranslator appTranslator;
//for trayIcon
	void createActions();
	void createTrayIcon();
	QAction *quitAction;
        QAction *rotateAct;

	QMenu *trayIconMenu;
        QPushButton *fullButton;

// for recentfiles menu
	void setCurrentFile(const QString &fileName);
	void updateRecentFileActions();
	QString strippedName(const QString &fullFileName);
	QString curFile;
	QMenu *recentFilesMenu;
	enum { MaxRecentFiles = 5 };
	QAction *recentFileActs[MaxRecentFiles];
        QAction *separatorAct;

        //void setSizeBaseAndIncIncrement();
        void backToRead();
private slots:
	void open();
        void about();
        void slotSearchOri();
        void slotSearchCur();
        void showChanges();
        void myShowContextMenu(QPoint point);
	void setcodecstr(QAction *action);
        void slotJumpToPage();
        void getBookDependSetting();
        void saveBookDependSetting();
	void addBookmark();
	void delBookmark();
        void clearBookmark();
	void openBookmark();
	void addTxtSize();
	void subTxtSize();
	void setfont();
	void setfontcolor();
	void setbgcolor();
	void setbgimage();
        void resetbg();
	void hideAndRestore();
        void setScreenLight();
        void screenLight();
	void switchLanguage(QAction *action);
	void retranslateUi();
        void rotate();
        void touchFull();
//for trayIcon
	void quitaction();
//for recentfiles
        void openRecentFile();
};
#endif 
