unit txproximity;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, dbus, Dialogs, ctypes;

procedure prox(use : boolean);
function isProxClosed():boolean;

implementation

function isProxClosed():boolean;
var
  sl : TStringList;
begin
  sl := TStringList.Create();
  if FileExists('/sys/devices/platform/gpio-switch/proximity/state') then
    sl.LoadFromFile('/sys/devices/platform/gpio-switch/proximity/state')
  else
    begin
      ShowMessage('File doesnt exist!');
      sl.Free;
      Exit;
    end;
  if sl.Count > 0 then
    begin
      if sl[0] = 'closed' then
        Result := True
      else
        Result := False;
    end
  else
    ShowMessage('sl.Count := 0');
  sl.Free;
end;

procedure prox(use : boolean);
var
  err: DBusError;
  conn: PDBusConnection;
  ret: cint;
  msg: PDBusMessage;
  serial: dbus_uint32_t = 0;
  state : string;
begin
  { Initializes the errors }
  dbus_error_init(@err);
  { Connection }
  conn := dbus_bus_get(DBUS_BUS_SYSTEM, @err);
  if dbus_error_is_set(@err) <> 0 then
  begin
    WriteLn('Connection Error: ' + err.message);
    dbus_error_free(@err);
  end;
  if conn = nil then
    begin
      ShowMessage('conn is nil :/ ');
      Exit;
    end;
  { Request the name of the bus }
  ret := dbus_bus_name_has_owner(conn, 'proximityd.method.change', @err);
  if dbus_error_is_set(@err) <> 0 then
  begin
    ShowMessage('Name Error: ' + err.message);
    dbus_error_free(@err);
  end;
  {
  system(QString("dbus-send --dest=proximityd.method.change --type=method_call --print-reply /proximityd/method/change proximityd.method.change.Change string:turnOn int32:%2").arg(QCoreApplication::applicationPid()).toUtf8().constData());
  }

  // create a new method call and check for errors
  msg := dbus_message_new_method_call('proximityd.method.change', // target for the method call
                                      '/proximityd/method/change', // object to call on
                                      'proximityd.method.change', // interface to call on
                                      'Change'); // method name
  if (msg = nil) then
  begin
    ShowMessage('Message Null');
    Exit;
  end;

  if use then
    state := 'turnOn'
  else
    state := 'turnOff';

  if not boolean(dbus_message_append_args(msg,DBUS_TYPE_STRING, [@state, DBUS_TYPE_INVALID])) then
   Exit;
  // send the message and flush the connection
  if (dbus_connection_send(conn, msg, @serial) = 0) then
  begin
    ShowMessage('Out Of Memory!');
    Exit;
  end;
  dbus_connection_flush(conn);
  // free the message and close the connection
  dbus_message_unref(msg);
  dbus_connection_unref(conn);
end;

end.

