{
    This file is part of TxPad.

    TxPad is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    TxPad is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with TxPad.  If not, see <http://www.gnu.org/licenses/>
}

{
Linking : -L/home/trx/lazarus/fpc/libcross

After : arm-linux-strip -s /home/trx/n900/new/TxPad/txpad
}



unit MainUnit;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  ExtCtrls, Menus, ComCtrls, Buttons, ActnList, SynEdit, SynHighlighterAny,
  SynHighlighterPHP, SynHighlighterPas, SynHighlighterCpp, SynHighlighterJava,
  SynHighlighterPerl, SynHighlighterHTML, SynHighlighterXML, SynHighlighterLFM,
  SynHighlighterDiff, synhighlighterunixshellscript, SynHighlighterCss,
  SynHighlighterTeX, SynHighlighterSQL, SynHighlighterPython, SynHighlighterVB,
  SynEditHighlighter, SynEditKeyCmds, SynEditTypes, SynExportHTML,
  SynCompletion, SynMacroRecorder, SynHighlighterBat, SynHighlighterIni,
  IniFiles, txqtfunc, qtwidgets, qtproc, qt4, LCLType, txkinscroller,
  txproximity, ftpopendlg, ftpserverlist, ftpsavedlg, lmessages, SynHighlighterJScript;


type
  TxZoomKeys = (zkChangeTabs, zkChangeFont, zkDontUse);

  TxRecentFiles = array [1..10] of string;

  TxMacro = record
    SMR      : TSynMacroRecorder;
    FileName : string;
    Caption  : string;
    Changed  : boolean;
  end;
  TxMacros = array [1..6] of TxMacro;

  TxScript = record
    FileName : string;
    Caption  : string;
    DocID    : integer;
  end;
  TxScripts = array [1..6] of TxScript;

  TxColorScheme = record
    Background  : TColor;
    Text        : TColor;
    Gutter      : TColor;
    GutterText  : TColor;
    CodeFolder  : TColor;
  end;

  TxSynEditOptions = record
    CaretSkipsTab : boolean;
    CursorPastEOF : boolean;
    CursorPastEOL : boolean;
    MaxUndo       : integer;
    TabSize       : integer;
    FontSize      : integer;
  end;

  TxSettings = record
    UseRegExpr       : boolean;
    WholeWords       : boolean;
    CaseSensitive    : boolean;
    AppOrientation   : TAppOrientation;
    ZoomKeys         : TxZoomKeys;
    ShowTabBar       : boolean;
    ColorScheme      : TxColorScheme;
    SynEditOptions   : TxSynEditOptions;
    RecentFiles      : TxRecentFiles;
    Macros           : TxMacros;
    Scripts          : TxScripts;
    FTPTempDir       : string;
    ExtraBar         : array of TLabel;
    AllwaysShowBar   : boolean;
  end;
  TxFTPDetails = record
    RemoteFile : string;
    LocalFile  : string;
    Server     : TxFtpServer;
  end;
  PTxFTPDetails = ^TxFTPDetails;

  TxDocument = record
    DocID      : integer;
    Page       : TTabSheet;
    Edit       : TSynEdit;
    Scroller   : TTxKinScroller;
    FileName   : string;
    Modified   : boolean;
    Active     : boolean;
    isFTP      : boolean;
    FTPDetails : TxFTPDetails;
  end;
  // Shift = 16 , Fn = 227 , Ctrl = 17
  TxShiftState = (xssNone, xssOne, xssTwo);
  TxAltGrState = (xasNone, xasOne, xasTwo);
  { TMainForm }

  TMainForm = class(TForm)
    ActionJumpTo: TAction;
    ActionZoomMinus: TAction;
    ActionZoomPlus: TAction;
    ActionFullScreen: TAction;
    ActionSearch: TAction;
    ActionSearchReplace: TAction;
    ActionCloseTab: TAction;
    ActionSaveAs: TAction;
    ActionSave: TAction;
    ActionOpen: TAction;
    ActionNew: TAction;
    ActionList1: TActionList;
    Button7: TButton;
    Button8: TButton;
    FindButton: TButton;
    Label4: TLabel;
    Label5: TLabel;
    MacrosButton: TButton;
    FullscreenButton: TButton;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    BookmarkButton: TButton;
    BMImgList: TImageList;
    MenuItem34: TMenuItem;
    MenuItem41: TMenuItem;
    MenuItem44: TMenuItem;
    MenuItem45: TMenuItem;
    MenuItem46: TMenuItem;
    MenuItem47: TMenuItem;
    MenuItem48: TMenuItem;
    Panel1: TPanel;
    ReplaceAllButton: TButton;
    ReplaceEdit: TEdit;
    ReplacePanel: TPanel;
    ScriptEdit6: TMenuItem;
    ScriptEdit5: TMenuItem;
    ScriptEdit4: TMenuItem;
    ScriptEdit3: TMenuItem;
    ScriptEdit2: TMenuItem;
    ScriptEdit1: TMenuItem;
    ScriptRun6: TMenuItem;
    ScriptRun5: TMenuItem;
    ScriptRun4: TMenuItem;
    ScriptRun3: TMenuItem;
    ScriptRun2: TMenuItem;
    ScriptRun1: TMenuItem;
    ScriptsMenu: TPopupMenu;
    ScriptsButton: TButton;
    MenuItem1: TMenuItem;
    BMToggle1: TMenuItem;
    BMToggle2: TMenuItem;
    BMToggle3: TMenuItem;
    BMToggle4: TMenuItem;
    BMToggle5: TMenuItem;
    BMToggle6: TMenuItem;
    BMGoto4: TMenuItem;
    MenuItem11: TMenuItem;
    MenuItem2: TMenuItem;
    BMGoto5: TMenuItem;
    BMGoto6: TMenuItem;
    BMGoto1: TMenuItem;
    BMGoto2: TMenuItem;
    BMGoto3: TMenuItem;
    MenuItem30: TMenuItem;
    MenuItem32: TMenuItem;
    MacroPlay1: TMenuItem;
    MacroPlay2: TMenuItem;
    MacroPlay3: TMenuItem;
    MacroPlay4: TMenuItem;
    MacroPlay5: TMenuItem;
    MacroPlay6: TMenuItem;
    MacroRec1: TMenuItem;
    MacroRec2: TMenuItem;
    MacroRec3: TMenuItem;
    MacroRec4: TMenuItem;
    MacroRec5: TMenuItem;
    MacroRec6: TMenuItem;
    MenuItem4: TMenuItem;
    MenuItem6: TMenuItem;
    MenuItem7: TMenuItem;
    PageLeftButton: TButton;
    ExitItem: TMenuItem;
    MenuItem29: TMenuItem;
    MenuItem35: TMenuItem;
    MenuItem36: TMenuItem;
    FontDialog1: TFontDialog;
    MainMenu1: TMainMenu;
    FileMenuItem: TMenuItem;
    MenuItem10: TMenuItem;
    MenuItem12: TMenuItem;
    MenuItem13: TMenuItem;
    MenuItem14: TMenuItem;
    MenuItem15: TMenuItem;
    MenuItem16: TMenuItem;
    MenuItem17: TMenuItem;
    MenuItem18: TMenuItem;
    MenuItem19: TMenuItem;
    PageLabelButton: TButton;
    PageUpFullButton: TButton;
    PageRightButton: TButton;
    PageCloseButton: TButton;
    PageUpButton: TButton;
    PageDownButton: TButton;
    PageDownFullButton: TButton;
    BookmarkMenu: TPopupMenu;
    MacrosMenu: TPopupMenu;
    ProximityTimer: TTimer;
    ProxTimeoutTimer: TTimer;
    ExtraBarBox: TScrollBox;
    SearchCloseButton: TButton;
    SearchEdit: TEdit;
    SearchPanel: TPanel;
    StartupTimer: TTimer;
    SynBatSyn1: TSynBatSyn;
    SynExporterHTML1: TSynExporterHTML;
    SynIniSyn1: TSynIniSyn;
    SynJScriptSyn1 : TSynJScriptSyn;
    SynMacroRecorder1: TSynMacroRecorder;
    ViewMenuItem: TMenuItem;
    MenuItem20: TMenuItem;
    MenuItem21: TMenuItem;
    MenuItem22: TMenuItem;
    MenuItem23: TMenuItem;
    MenuItem24: TMenuItem;
    MenuItem25: TMenuItem;
    MenuItem26: TMenuItem;
    MenuItem27: TMenuItem;
    MenuItem28: TMenuItem;
    MenuItem3: TMenuItem;
    ToolsMenuItem: TMenuItem;
    MenuItem31: TMenuItem;
    MenuItem33: TMenuItem;
    MenuItem37: TMenuItem;
    MenuItem38: TMenuItem;
    MenuItem39: TMenuItem;
    HighlightMenuItem: TMenuItem;
    MenuItem40: TMenuItem;
    MenuItem42: TMenuItem;
    MenuItem43: TMenuItem;
    AboutItem: TMenuItem;
    MenuItem5: TMenuItem;
    EditMenuItem: TMenuItem;
    MenuItem8: TMenuItem;
    MenuItem9: TMenuItem;
    pg: TPageControl;
    SearchEdit2: TEdit;
    SearchPanel1: TPanel;
    SynCppSyn1: TSynCppSyn;
    SynCssSyn1: TSynCssSyn;
    SynFreePascalSyn1: TSynFreePascalSyn;
    SynHTMLSyn1: TSynHTMLSyn;
    SynJavaSyn1: TSynJavaSyn;
    SynLFMSyn1: TSynLFMSyn;
    SynPasSyn1: TSynPasSyn;
    SynPerlSyn1: TSynPerlSyn;
    SynPHPSyn1: TSynPHPSyn;
    SynPythonSyn1: TSynPythonSyn;
    SynSQLSyn1: TSynSQLSyn;
    SynTeXSyn1: TSynTeXSyn;
    SynUNIXShellScriptSyn1: TSynUNIXShellScriptSyn;
    SynVBSyn1: TSynVBSyn;
    SynXMLSyn1: TSynXMLSyn;
    FocusTimer: TTimer;
    ShortCutDelayTimer: TTimer;
    procedure ActionNewExecute(Sender: TObject);
    procedure BMGoto1Click(Sender: TObject);
    procedure BMToggle1Click(Sender: TObject);
    procedure BookmarkButtonClick(Sender: TObject);
    procedure MenuItem45Click(Sender: TObject);
    procedure MenuItem46Click(Sender: TObject);
    procedure MenuItem47Click(Sender: TObject);
    procedure MenuItem48Click(Sender: TObject);
    procedure ReplaceEditKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure SearchCloseButtonClick(Sender: TObject);
    procedure ReplaceAllButtonClick(Sender: TObject);
    procedure FindButtonClick(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure ExitItemClick(Sender: TObject);
    procedure ExtraBarBoxMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ExtraBarBoxMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure ExtraBarBoxMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ExtraBarButton1Click(Sender: TObject);
    procedure ExtraBarButton1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ExtraBarButton1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure ExtraBarButton1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ExtraBarButton6MouseEnter(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure FormDeactivate(Sender: TObject);
    procedure FormHide(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure FormResize(Sender: TObject);
    procedure FormUTF8KeyPress(Sender: TObject; var UTF8Key: TUTF8Char);
    procedure FormWindowStateChange(Sender: TObject);
    procedure FullscreenButtonClick(Sender: TObject);
    procedure MacroPlay1Click(Sender: TObject);
    procedure MacroRec1Click(Sender: TObject);
    procedure MacrosButtonClick(Sender: TObject);
    procedure MacrosMenuPopup(Sender: TObject);
    procedure MenuItem10Click(Sender: TObject);
    procedure MenuItem12Click(Sender: TObject);
    procedure MenuItem13Click(Sender: TObject);
    procedure MenuItem14Click(Sender: TObject);
    procedure MenuItem15Click(Sender: TObject);
    procedure MenuItem16Click(Sender: TObject);
    procedure MenuItem17Click(Sender: TObject);
    procedure MenuItem18Click(Sender: TObject);
    procedure MenuItem19Click(Sender: TObject);
    procedure MenuItem20Click(Sender: TObject);
    procedure MenuItem21Click(Sender: TObject);
    procedure MenuItem22Click(Sender: TObject);
    procedure MenuItem23Click(Sender: TObject);
    procedure MenuItem24Click(Sender: TObject);
    procedure MenuItem25Click(Sender: TObject);
    procedure MenuItem26Click(Sender: TObject);
    procedure MenuItem27Click(Sender: TObject);
    procedure MenuItem28Click(Sender: TObject);
    procedure MenuItem31Click(Sender: TObject);
    procedure MenuItem32Click(Sender: TObject);
    procedure MenuItem33Click(Sender: TObject);
    procedure MenuItem35Click(Sender: TObject);
    procedure MenuItem36Click(Sender: TObject);
    procedure MenuItem37Click(Sender: TObject);
    procedure MenuItem39Click(Sender: TObject);
    procedure MenuItem3Click(Sender: TObject);
    procedure MenuItem42Click(Sender: TObject);
    procedure AboutItemClick(Sender: TObject);
    procedure MenuItem44Click(Sender: TObject);
    procedure MenuItem4Click(Sender: TObject);
    procedure MenuItem5Click(Sender: TObject);
    procedure MenuItem6Click(Sender: TObject);
    procedure MenuItem7Click(Sender: TObject);
    procedure MenuItem8Click(Sender: TObject);
    procedure MenuItem9Click(Sender: TObject);
    procedure PageCloseButtonClick(Sender: TObject);
    procedure PageDownButtonClick(Sender: TObject);
    procedure PageDownFullButtonClick(Sender: TObject);
    procedure PageLeftButtonClick(Sender: TObject);
    procedure PageRightButtonClick(Sender: TObject);
    procedure PageUpButtonClick(Sender: TObject);
    procedure PageUpFullButtonClick(Sender: TObject);
    procedure pgCloseTabClicked(Sender: TObject);
    procedure GenSynEditChange(Sender: TObject);
    procedure pgPageChanged(Sender: TObject);
    procedure ProximityTimerTimer(Sender: TObject);
    procedure ProxTimeoutTimerTimer(Sender: TObject);
    procedure ScriptEdit1Click(Sender: TObject);
    procedure ScriptRun1Click(Sender: TObject);
    procedure ScriptsButtonClick(Sender: TObject);
    procedure ScriptsMenuPopup(Sender: TObject);
    procedure SearchEditClick(Sender: TObject);
    procedure SearchEditKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure StartupTimerTimer(Sender: TObject);
    procedure GenSynEditReplaceText(Sender: TObject; const ASearch,
      AReplace: string; Line, Column: integer;
      var ReplaceAction: TSynReplaceAction);
    procedure SynEditDummyMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure SynEditDummyMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure SynEditDummyMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure SynEditDummyKeyPress(Sender: TObject; var Key: char);
    procedure FocusTimerTimer(Sender: TObject);
    procedure ShortCutDelayTimerTimer(Sender: TObject);
    procedure kinTimerTimer(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
    TagCount : integer; // Unique tag id counter
    Settings : TxSettings;
    Docs : array of TxDocument;
    Fullscreen : boolean;
    AutoOrientation : boolean;
    PortraitMode : boolean;
    XShift : TxShiftState;
    XAltGr : TxAltGrState;
    SearchReplace : boolean;
    PromptingReplace : boolean;
    function NewDoc(fname : string; ftpinfo : PTxFTPDetails=nil):integer;
    procedure CloseDoc(id : integer);
    procedure SaveDoc(id : integer; SaveAs : boolean = false; silent : boolean = false);
    procedure ApplyHighlight(id : integer; hl :TSynCustomHighlighter);
    procedure ApplyHighlightByExt(id : integer);
    procedure ApplyHighlightToMenu(h : TSynCustomHighlighter);
    procedure LoadSettings(fname : string);
    procedure SaveSettings(fname : string);
    function GetDocIDByTag(t : integer):integer;
  public //Menu stuff..
    mb : QMenuBarH;
    mh : QMenuH;
    hook_mh : QMenu_hookH;
    actFile, actEdit, actView, actTools, actAbout, actExit : QActionH;
    short_executed : boolean;
    LastAction : TAction;
    procedure MenuHookTrigered(act : QActionH); cdecl;
    procedure CreateMenuBar;
  public //Misc stuff..
    MacroRecording, MacroPlaying : boolean;
    MacroRecordingID, MacroPlayingID : integer;
    iconFullscreenH, iconPageLeftH, iconPageRightH, iconPageCloseH,
    iconPageUpH, iconPageUpFullH, iconPageDownH, iconPageDownFullH : QIconH;
    ProxSession : boolean;
    MediaBarTimeout : integer;
    procedure MediaBarProx(use : boolean);
    procedure ApplyColorScheme;
    procedure ApplySynEditOptions;
    procedure AddToRecentFiles(fname : string);
    procedure RepositionSearchButtons(showButtons : boolean);
  public // Notify events
    procedure TxGetEvents;
  public // FTP stuff..
    openftpdlg : TFTPOpenDlgF;
    saveftpdlg : TFTPSaveDlgF;
  public // Extra Bar..
    ExtraScroller : TTxKinScroller;
    procedure ExtraBarLabelClick(Sender : TObject);
    procedure ExtraBarLabelMouseDown(Sender: TObject; Mouse : TMouseButton; Shift: TShiftState; X,Y: Integer);
    procedure ExtraBarLabelMouseMove(Sender: TObject; Shift: TShiftState; X,Y: Integer);
    procedure ExtraBarLabelMouseUp(Sender: TObject; Mouse : TMouseButton; Shift: TShiftState; X,Y: Integer);
    function CreateExtraBarButton(s : string; num : integer):TLabel;
  end;


const
  CURRENT_VER   : string = 'v0.7.0';
  CONFIG_DIR    : string = '/home/user/.config/TxPad/';
  CONFIG_FILE   : string = '/home/user/.config/TxPad/txpad.conf';
  FTP_TEMP_DIR  : string = '/home/user/MyDocs/tmp/';
  EXTRA_BUTTONS : string = '↹';

var
  MainForm: TMainForm;
  zz : boolean;
  mx,my : integer;
  kk : boolean;
  temp_k : word;
  first : boolean;
  sY, sX : integer;
  last_btn : TButton;

implementation

uses OpenDlg, SaveDlg, PasteBin, SettingsUnit, AboutBox, txdbus, FontDlg, GenMenu,
     HTMLExport, JumpToDlg, TxInputDlg, ScriptExecUnit, FTPProgressDlg;

{$R *.lfm}

function TMainForm.CreateExtraBarButton(s : string; num : integer):TLabel;
begin
  Result := TLabel.Create(ExtraBarBox);
  Result.Parent := ExtraBarBox;
  Result.AutoSize := False;
  Result.ParentFont := False;
  Result.Height := 64;
  Result.Width := 64;
  Result.Top := 1;
  Result.Left := (num*64);
  Result.OnClick := @ExtraBarLabelClick;
  Result.OnMouseDown := @ExtraBarLabelMouseDown;
  Result.OnMouseMove := @ExtraBarLabelMouseMove;
  Result.OnMouseUp := @ExtraBarLabelMouseUp;
  Result.Alignment := taCenter;
  Result.Transparent:= True;
  Result.Caption := s;
  Result.Font.Quality := fqClearType;
  Result.Font.Style := [fsBold];
  Result.Font.Size := 30;
  Result.Font.Color := clGray;
  Result.Repaint;
end;

procedure TMainForm.RepositionSearchButtons(showButtons : boolean);
begin
  SearchEdit.Width := (MainForm.Width-SearchEdit.Left)-Panel1.Width-2;
  SearchEdit.Top := 1;
  ReplaceEdit.Top := 51;
  ReplaceEdit.Width := SearchEdit.Width;
  Panel1.Top:=1;
  Panel1.Left:= SearchEdit.Left+SearchEdit.Width+1;
  if showButtons then
    begin
      SearchEdit.Visible := True;
      ReplaceEdit.Visible := True;
      Panel1.Visible := True;
      SearchCloseButton.Visible := True;
      FindButton.Visible := True;
      ReplaceAllButton.Visible := True;
      ReplacePanel.Visible := True;
      Button7.Visible := True;
      Button8.Visible := True;
      Label4.Visible := True;
      Label5.Visible := True;
      SearchPanel.Visible := True;
    end
  else
    begin
      SearchEdit.Visible := False;
      ReplaceEdit.Visible := False;
      Panel1.Visible := False;
      SearchCloseButton.Visible := False;
      FindButton.Visible := False;
      ReplaceAllButton.Visible := False;
      ReplacePanel.Visible := False;
      Button7.Visible := False;
      Button8.Visible := False;
      Label4.Visible := False;
      Label5.Visible := False;
      SearchPanel.Visible := False;
      SearchPanel.Height:=0;
    end
end;

procedure TMainForm.TxGetEvents;
begin
  {}
end;

procedure TMainForm.ExtraBarLabelClick(Sender : TObject);
begin
  if pg.PageCount < 1 then
    Exit;
  if TLabel(Sender).Caption = '↹' then
    Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.InsertTextAtCaret(#9)
  else
    Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.InsertTextAtCaret(TLabel(Sender).Caption);
  Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.SetFocus;
end;

procedure TMainForm.ExtraBarLabelMouseDown(Sender: TObject; Mouse : TMouseButton; Shift: TShiftState; X,Y: Integer);
begin
  if Assigned(ExtraScroller) then
    ExtraScroller.MouseDown((TLabel(Sender).Left)+X,Y)
end;

procedure TMainForm.ExtraBarLabelMouseMove(Sender: TObject; Shift: TShiftState; X,Y: Integer);
begin
  if Assigned(ExtraScroller) then
    ExtraScroller.MouseMove((TLabel(Sender).Left)+X,Y)
end;

procedure TMainForm.ExtraBarLabelMouseUp(Sender: TObject; Mouse : TMouseButton; Shift: TShiftState; X,Y: Integer);
begin
  if Assigned(ExtraScroller) then
    ExtraScroller.MouseUp((TLabel(Sender).Left)+X,Y)
end;

procedure TMainForm.MediaBarProx(use : boolean);
const
  iniFileName : string = '/home/user/.config/MohammadAG/mediabar.conf';
var
  iniFile : TMemIniFile;
begin
  if not FileExists(iniFileName) then
    Exit;
  iniFile := TMemIniFile.Create(iniFileName);
  if use then
    begin // Enable it..
      iniFile.WriteInteger('main','timeout',MediaBarTimeOut);
    end
  else
    begin // Disable it..
      MediaBarTimeOut := iniFile.ReadInteger('main','timeout',1200);
      if MediaBarTimeOut = 9999999 then
        MediaBarTimeOut := 1200;
      iniFile.WriteInteger('main','timeout',9999999);
    end;
  iniFile.UpdateFile;
  iniFile.Free;
end;

procedure TMainForm.MenuHookTrigered(act : QActionH); cdecl;
var
  i, res : integer;
begin
  if act = actFile then
    begin
      GenMenuF.Caption := 'File Menu';
      GenMenuF.ListBox1.Clear;
      for i := 0 to FileMenuItem.Count - 1 do
        begin
          GenMenuF.ListBox1.Items.Add(FileMenuItem.Items[i].Caption);
        end;
      GenMenuF.MRes := '';
      res := GenMenuF.ShowModal;
      if (GenMenuF.MRes <> '') and (res = mrOk) then
        begin
          for i := 0 to FileMenuItem.Count - 1 do
            begin
              if FileMenuItem.Items[i].Caption = GenMenuF.MRes then
                FileMenuItem.Items[i].OnClick(Self);
            end;
        end;
    end;
  if act = actEdit then
    begin
      GenMenuF.Caption := 'Edit Menu';
      GenMenuF.ListBox1.Clear;
      for i := 0 to EditMenuItem.Count - 1 do
        begin
          GenMenuF.ListBox1.Items.Add(EditMenuItem.Items[i].Caption);
        end;
      GenMenuF.MRes := '';
      res := GenMenuF.ShowModal;
      if (GenMenuF.MRes <> '') and (res = mrOk) then
        begin
          for i := 0 to EditMenuItem.Count - 1 do
            begin
              if EditMenuItem.Items[i].Caption = GenMenuF.MRes then
                EditMenuItem.Items[i].OnClick(Self);
            end;
        end;
    end;
  if act = actView then
    begin
      GenMenuF.Caption := 'View Menu';
      GenMenuF.ListBox1.Clear;
      for i := 0 to ViewMenuItem.Count - 1 do
        begin
          GenMenuF.ListBox1.Items.Add(ViewMenuItem.Items[i].Caption);
        end;
      GenMenuF.MRes := '';
      res := GenMenuF.ShowModal;
      if (GenMenuF.MRes <> '') and (res = mrOk) then
        begin
          if GenMenuF.MRes = 'Highlight Code' then
            begin
              GenMenuF.Caption := 'Highlight Code Menu';
              GenMenuF.MRes := '';
              GenMenuF.ListBox1.Clear;
              for i := 0 to HighlightMenuItem.Count - 1 do
                begin
                  GenMenuF.ListBox1.Items.Add(HighlightMenuItem.Items[i].Caption);
                end;
              res := GenMenuF.ShowModal;
              if (GenMenuF.MRes <> '') and (res = mrOk) then
                for i := 0 to HighlightMenuItem.Count - 1 do
                  begin
                    if HighlightMenuItem.Items[i].Caption = GenMenuF.MRes then
                      HighlightMenuItem.Items[i].OnClick(Self);
                  end;
            end
          else
            begin
              for i := 0 to ViewMenuItem.Count - 1 do
                 begin
                   if ViewMenuItem.Items[i].Caption = GenMenuF.MRes then
                     ViewMenuItem.Items[i].OnClick(Self);
                 end;
            end;
        end;
    end;
  if act = actTools then
    begin
      GenMenuF.Caption := 'Tools Menu';
      GenMenuF.ListBox1.Clear;
      for i := 0 to ToolsMenuItem.Count - 1 do
        begin
          GenMenuF.ListBox1.Items.Add(ToolsMenuItem.Items[i].Caption);
        end;
      GenMenuF.MRes := '';
      res := GenMenuF.ShowModal;
      if (GenMenuF.MRes <> '') and (res = mrOk) then
        begin
          for i := 0 to ToolsMenuItem.Count - 1 do
            begin
              if ToolsMenuItem.Items[i].Caption = GenMenuF.MRes then
                ToolsMenuItem.Items[i].OnClick(Self);
            end;
        end;
    end;
  if act = actAbout then
    begin
      AboutItem.OnClick(Self);
    end;
  if act = actExit then
    begin
      ExitItem.OnClick(Self);
    end;
end;

procedure TMainForm.CreateMenuBar;
var
  s, mh_name : WideString;
  ma : QActionH;
begin
  short_executed := False;
  mb := QMenuBar_Create(TQtMainWindow(MainForm.Handle).Widget);
  TQtMainWindow(MainForm.Handle).setMenuBar(mb);
  mh_name := 'menu';
  mh := QMenu_Create(@mh_name, QMenuBarH(TQtMainWindow(MainForm.Handle).MenuBar.Widget));
  QMenu_setTitle(mh,@mh_name);
  ma := TQtMainWindow(MainForm.Handle).MenuBar.addMenu(mh);
  s := 'File';
  actFile := QMenu_addAction(mh, @s);
  s := 'Edit';
  actEdit := QMenu_addAction(mh, @s);
  s := 'View';
  actView := QMenu_addAction(mh, @s);
  s := 'Tools';
  actTools := QMenu_addAction(mh, @s);
  s := 'About';
  actAbout := QMenu_addAction(mh, @s);
  s := 'Exit';
  actExit := QMenu_addAction(mh, @s);

  hook_mh := QMenu_hook_create(QObjectH(mh));
  QMenu_hook_hook_triggered(hook_mh,@MenuHookTrigered);
end;

function TMainForm.GetDocIDByTag(t : integer):integer;
var
  i : integer;
begin
  Result := -1;
  for i := 0 to length(Docs)-1 do
    begin
      if Docs[i].Page.Tag = t then
        begin
          Result := i;
          Break;
        end;
    end;
end;

procedure TMainForm.ApplyColorScheme;
var
  i : integer;
begin
  if pg.PageCount < 1 then
    Exit;
  for i := 0 to pg.PageCount-1 do
    begin
      Docs[GetDocIDByTag(pg.Pages[i].Tag)].Edit.Color := Settings.ColorScheme.Background;
      Docs[GetDocIDByTag(pg.Pages[i].Tag)].Edit.Font.Color:= Settings.ColorScheme.Text;
      Docs[GetDocIDByTag(pg.Pages[i].Tag)].Edit.Gutter.Color := Settings.ColorScheme.Gutter;
      Docs[GetDocIDByTag(pg.Pages[i].Tag)].Edit.Gutter.Parts.Part[1].MarkupInfo.Background := Settings.ColorScheme.Gutter;
      Docs[GetDocIDByTag(pg.Pages[i].Tag)].Edit.Gutter.Parts.Part[1].MarkupInfo.Foreground := Settings.ColorScheme.GutterText;
      Docs[GetDocIDByTag(pg.Pages[i].Tag)].Edit.Gutter.Parts.Part[4].MarkupInfo.Foreground := Settings.ColorScheme.CodeFolder;
    end;
end;

procedure TMainForm.ApplySynEditOptions;
var
  i : integer;
begin
  if pg.PageCount < 1 then
    Exit;
  for i := 0 to pg.PageCount-1 do
    begin
      Docs[GetDocIDByTag(pg.Pages[i].Tag)].Edit.MaxUndo := Settings.SynEditOptions.MaxUndo;
      Docs[GetDocIDByTag(pg.Pages[i].Tag)].Edit.TabWidth := Settings.SynEditOptions.TabSize;
      // Scroll past EOL
      if Settings.SynEditOptions.CursorPastEOL then
        Docs[GetDocIDByTag(pg.Pages[i].Tag)].Edit.Options := Docs[GetDocIDByTag(pg.Pages[i].Tag)].Edit.Options + [eoScrollPastEOL]
      else
        Docs[GetDocIDByTag(pg.Pages[i].Tag)].Edit.Options := Docs[GetDocIDByTag(pg.Pages[i].Tag)].Edit.Options - [eoScrollPastEOL];

{ Disabled for now...
      // Scroll past EOF
      if Settings.SynEditOptions.CursorPastEOF then
        Docs[GetDocIDByTag(pg.Pages[i].Tag)].Edit.Options := Docs[GetDocIDByTag(pg.Pages[i].Tag)].Edit.Options + [eoScrollPastEOF]
      else
        Docs[GetDocIDByTag(pg.Pages[i].Tag)].Edit.Options := Docs[GetDocIDByTag(pg.Pages[i].Tag)].Edit.Options - [eoScrollPastEOF];
      // Carret skips tab
      if Settings.SynEditOptions.CaretSkipsTab then
        Docs[GetDocIDByTag(pg.Pages[i].Tag)].Edit.Options2 := Docs[GetDocIDByTag(pg.Pages[i].Tag)].Edit.Options2 + [eoCaretSkipTab]
      else
        Docs[GetDocIDByTag(pg.Pages[i].Tag)].Edit.Options2 := Docs[GetDocIDByTag(pg.Pages[i].Tag)].Edit.Options2 - [eoCaretSkipTab];
}
    end;
end;

procedure TMainForm.AddToRecentFiles(fname : string);
var
  i, found : integer;
  si : TMemIniFile;
  temp : string;
begin
  if fname = '' then
    Exit;

  { Prepare the list.. }
  found := 0;
  for i := 1 to 10 do
    if fname = Settings.RecentFiles[i] then
      found := i;
  if found = 0 then
    begin // File not in the list...
      for i := 10 downto 2 do
        begin
          if Settings.RecentFiles[i-1] <> '' then
            Settings.RecentFiles[i] := Settings.RecentFiles[i-1];
        end;
    end
  else
    begin // File is in the list, move it to the top..
      temp := Settings.RecentFiles[found];
      for i := found to 9 do
        if Settings.RecentFiles[i] <> '' then
          Settings.RecentFiles[i] := Settings.RecentFiles[i+1];

      for i := 10 downto 2 do
        begin
          if Settings.RecentFiles[i-1] <> '' then
            Settings.RecentFiles[i] := Settings.RecentFiles[i-1];
        end;
    end;
  Settings.RecentFiles[1] := fname;
  { Save the list.. }
  si := TMemIniFile.Create(CONFIG_FILE);
  for i := 1 to 10 do
    begin
      si.WriteString('Recent', 'F'+inttostr(i),Settings.RecentFiles[i]);
    end;
  si.UpdateFile;
  si.Free;
end;

procedure TMainForm.LoadSettings(fname : string);
var
  ini : TMemIniFile;
  orient : string;
  zoom : string;
  i : integer;
  lab : TQtWidget;
begin
  if not FileExists(fname) then
    begin // First run :)
      if not CreateDir('/home/user/.config/TxPad') then
        begin
          ShowMessage('Cant create config file!');
          Exit;
        end;
      ShowDBusMessage('Welcome to TxPad '+CURRENT_VER);
    end;
  ini := TMemIniFile.Create(fname);
  Settings.ShowTabBar := ini.ReadBool('Misc','ShowTabBar',False);
  Settings.UseRegExpr := ini.ReadBool('Search','UseRegExpr',False);
  Settings.WholeWords := ini.ReadBool('Search','WholeWords',False);
  Settings.CaseSensitive := ini.ReadBool('Search','CaseSensitive',False);
  // FTP stuff..
  Settings.FTPTempDir := ini.ReadString('FTP','TempDir',FTP_TEMP_DIR);
  // Extra bar stuff
  Settings.AllwaysShowBar := ini.ReadBool('ExtraBar','AllwaysOn', False);
  if not ini.SectionExists('ExtraBar') then
    begin // Add some standard buttons..
      SetLength(Settings.ExtraBar,8);
      for i := 0 to 7 do
        Settings.ExtraBar[i] := CreateExtraBarButton('',i);
      Settings.ExtraBar[0].Caption := '↹';
      Settings.ExtraBar[1].Caption := '|';
      Settings.ExtraBar[2].Caption := '{';
      Settings.ExtraBar[3].Caption := '}';
      Settings.ExtraBar[4].Caption := '<';
      Settings.ExtraBar[5].Caption := '>';
      Settings.ExtraBar[6].Caption := '[';
      Settings.ExtraBar[7].Caption := ']';
    end
  else
    begin
      SetLength(Settings.ExtraBar,ini.ReadInteger('ExtraBar','ButtonCount',0));
      if length(Settings.ExtraBar) > 0 then
        begin
          for i := 0 to length(Settings.ExtraBar)-1 do
            begin
              Settings.ExtraBar[i] := CreateExtraBarButton(ini.ReadString('ExtraBar','BTN'+inttostr(i),''),i);
            end;
        end;
    end;

  zoom := ini.ReadString('Misc','ZoomKeys','zkChangeTabs');
  if zoom = 'zkChangeTabs' then
    Settings.ZoomKeys := zkChangeTabs;
  if zoom = 'zkChangeFont' then
    Settings.ZoomKeys := zkChangeFont;
  if zoom = 'zkChangeTabs' then
    Settings.ZoomKeys := zkDontUse;
  orient := ini.ReadString('Layout','AppOrientation','aoAuto');
  if orient = 'aoHorizontal' then
    Settings.AppOrientation := aoHorizontal;
  if orient = 'aoVertical' then
    Settings.AppOrientation := aoVertical;
  if orient = 'aoAuto' then
    Settings.AppOrientation := aoAuto;

  Settings.SynEditOptions.CaretSkipsTab := ini.ReadBool('Editor','CaretSkipsTab',False);
  Settings.SynEditOptions.CursorPastEOF := ini.ReadBool('Editor','CursorPastEOF',False);
  Settings.SynEditOptions.CursorPastEOL := ini.ReadBool('Editor','CursorPastEOL',True);
  Settings.SynEditOptions.MaxUndo := ini.ReadInteger('Editor','MaxUndo',1024);
  Settings.SynEditOptions.TabSize := ini.ReadInteger('Editor','TabSize',8);
  Settings.SynEditOptions.FontSize:= ini.ReadInteger('Editor','FontSize',16);

  // Get colors..
  Settings.ColorScheme.Background := StringToColor(ini.ReadString('Colors','Background',ColorToString(clWhite)));
  Settings.ColorScheme.Text := StringToColor(ini.ReadString('Colors','Text',ColorToString(clBlack)));
  Settings.ColorScheme.Gutter := StringToColor(ini.ReadString('Colors','Gutter',ColorToString(clGray)));
  Settings.ColorScheme.GutterText := StringToColor(ini.ReadString('Colors','GutterText',ColorToString(clBlack)));
  Settings.ColorScheme.CodeFolder := StringToColor(ini.ReadString('Colors','CodeFolder',ColorToString(clBlack)));

  //Get recent files
  for i := 1 to 10 do
    begin
      Settings.RecentFiles[i] := ini.ReadString('Recent', 'F'+inttostr(i),'');
    end;

  // Get macros...
  for i := 1 to 6 do
    begin
      if ini.ReadString('Macros','MF'+inttostr(i),'') <> '' then
        begin
          Settings.Macros[i].FileName := ini.ReadString('Macros','MF'+inttostr(i),'');
          if ini.ReadString('Macros','MC'+inttostr(i),'') <> '' then
            Settings.Macros[i].Caption := ini.ReadString('Macros','MC'+inttostr(i),'')
          else
            Settings.Macros[i].Caption := 'Untitled';
          Settings.Macros[i].SMR := TSynMacroRecorder.Create(MainForm);
          Settings.Macros[i].SMR.LoadFromFile(Settings.Macros[i].FileName);
        end;
    end;

  // Get scripts...

  for i := 1 to 6 do
    begin
      Settings.Scripts[i].DocID := -1;
      if ini.ReadString('Scripts','SF'+inttostr(i),'') <> '' then
        begin
          Settings.Scripts[i].FileName := ini.ReadString('Scripts','SF'+inttostr(i),'');
          Settings.Scripts[i].Caption := ini.ReadString('Scripts','SC'+inttostr(i),'');
        end;
    end;

  // Apply settings
  RotateApp(MainForm.Handle,Settings.AppOrientation);
  case Settings.ZoomKeys of
    zkChangeTabs, zkChangeFont : UseZoomKeys(MainForm.Handle, True);
  end;
  if Settings.ShowTabBar then
    begin
      pg.ShowTabs := True;
 //     ProximityTimer.Enabled := False;
    end
  else
    begin
      pg.ShowTabs := False;
 //     ProximityTimer.Enabled := True;
    end;
  ini.UpdateFile;
  ini.Free;
end;

procedure TMainForm.SaveSettings(fname : string);
var
  ini : TMemIniFile;
  i : integer;
  s : string;
begin
  // Apply the settings to SettingsF first
  SettingsF.CheckBox1.Checked := Settings.UseRegExpr;
  SettingsF.CheckBox2.Checked := Settings.WholeWords;
  SettingsF.CheckBox3.Checked := Settings.CaseSensitive;
  SettingsF.CheckBox4.Checked := Settings.ShowTabBar;
  SettingsF.CheckBox5.Checked := Settings.SynEditOptions.CaretSkipsTab;
  SettingsF.CheckBox6.Checked := Settings.SynEditOptions.CursorPastEOF;
  SettingsF.CheckBox7.Checked := Settings.SynEditOptions.CursorPastEOL;
  SettingsF.CheckBox8.Checked := Settings.AllwaysShowBar;
  SettingsF.Edit1.Text := IntToStr(Settings.SynEditOptions.MaxUndo);
  SettingsF.Edit3.Text := IntToStr(Settings.SynEditOptions.TabSize);
  case Settings.AppOrientation of
    aoHorizontal:SettingsF.RadioButton1.Checked := True;
    aoVertical:SettingsF.RadioButton2.Checked := True;
    aoAuto:SettingsF.RadioButton3.Checked := True;
  end;
  case Settings.ZoomKeys of
    zkChangeTabs : SettingsF.RadioButton4.Checked := True;
    zkChangeFont : SettingsF.RadioButton5.Checked := True;
    zkDontUse : SettingsF.RadioButton6.Checked := True;
  end;
  // Color scheme...
  SettingsF.BackgroundBox.Selected := Settings.ColorScheme.Background;
  SettingsF.BackgroundBox.Color := SettingsF.BackgroundBox.Selected;

  SettingsF.TextBox.Selected := Settings.ColorScheme.Text;
  SettingsF.TextBox.Color := SettingsF.TextBox.Selected;

  SettingsF.GutterBox.Selected := Settings.ColorScheme.Gutter;
  SettingsF.GutterBox.Color := SettingsF.GutterBox.Selected;

  SettingsF.GutterTextBox.Selected := Settings.ColorScheme.GutterText;
  SettingsF.GutterTextBox.Color := SettingsF.GutterTextBox.Selected;

  SettingsF.CodeFolderBox.Selected := Settings.ColorScheme.CodeFolder;
  SettingsF.CodeFolderBox.Color := SettingsF.CodeFolderBox.Selected;
  // Extra Bar
  SettingsF.ListBox1.Clear;
  for i := 0 to length(Settings.ExtraBar) -1 do
    begin
      SettingsF.ListBox1.Items.Add(Settings.ExtraBar[i].Caption);
    end;

  // Check result
  if SettingsF.ShowModal <> mrOK then
    Exit;
  // Apply settings
  Settings.UseRegExpr := SettingsF.CheckBox1.Checked;
  Settings.WholeWords := SettingsF.CheckBox2.Checked;
  Settings.CaseSensitive := SettingsF.CheckBox3.Checked;
  Settings.ShowTabBar := SettingsF.CheckBox4.Checked;

  Settings.SynEditOptions.CaretSkipsTab := SettingsF.CheckBox5.Checked;
  Settings.SynEditOptions.CursorPastEOF := SettingsF.CheckBox6.Checked;
  Settings.SynEditOptions.CursorPastEOL := SettingsF.CheckBox7.Checked;
  Settings.SynEditOptions.MaxUndo := StrToInt(SettingsF.Edit1.Text);
  Settings.SynEditOptions.TabSize := StrToInt(SettingsF.Edit3.Text);
  if Settings.ShowTabBar then
    begin
      pg.ShowTabs := True;
//      ProximityTimer.Enabled := False;
    end
  else
    begin
      pg.ShowTabs := False;
//      ProximityTimer.Enabled := True;
    end;

  if SettingsF.RadioButton1.Checked then
    Settings.AppOrientation := aoHorizontal;
  if SettingsF.RadioButton2.Checked then
    Settings.AppOrientation := aoVertical;
  if SettingsF.RadioButton3.Checked then
    Settings.AppOrientation := aoAuto;

  if SettingsF.RadioButton4.Checked then
    begin
      Settings.ZoomKeys := zkChangeTabs;
      UseZoomKeys(MainForm.Handle, True);
    end;
  if SettingsF.RadioButton5.Checked then
    begin
      Settings.ZoomKeys := zkChangeFont;
      UseZoomKeys(MainForm.Handle, True);
    end;
  if SettingsF.RadioButton6.Checked then
    begin
      Settings.ZoomKeys := zkDontUse;
      UseZoomKeys(MainForm.Handle, False);
    end;
  RotateApp(MainForm.Handle,Settings.AppOrientation);
  // Color scheme
  Settings.ColorScheme.Background := SettingsF.BackgroundBox.Selected;
  Settings.ColorScheme.Text := SettingsF.TextBox.Selected;
  Settings.ColorScheme.Gutter := SettingsF.GutterBox.Selected;
  Settings.ColorScheme.GutterText := SettingsF.GutterTextBox.Selected;
  Settings.ColorScheme.CodeFolder := SettingsF.CodeFolderBox.Selected;
  ApplyColorScheme;

  // Extra Bar
  Settings.AllwaysShowBar := SettingsF.CheckBox8.Checked;
  for i := 0 to length(Settings.ExtraBar)-1 do
    Settings.ExtraBar[i].Free;
  SetLength(Settings.ExtraBar,0);
  SetLength(Settings.ExtraBar,SettingsF.ListBox1.Items.Count);
  for i := 0 to length(Settings.ExtraBar)-1 do
    Settings.ExtraBar[i] := CreateExtraBarButton(SettingsF.ListBox1.Items[i],i);

  // SynEdit Options
  ApplySynEditOptions;
  // Save to ini
  ini := TMemIniFile.Create(fname);
  ini.WriteBool('Search','UseRegExpr',SettingsF.CheckBox1.Checked);
  ini.WriteBool('Search','WholeWords',SettingsF.CheckBox2.Checked);
  ini.WriteBool('Search','CaseSensitive',SettingsF.CheckBox3.Checked);
  ini.WriteBool('Misc','ShowTabBar',SettingsF.CheckBox4.Checked);
  ini.WriteBool('Editor','CaretSkipsTab',SettingsF.CheckBox5.Checked);
  ini.WriteBool('Editor','CursorPastEOF',SettingsF.CheckBox6.Checked);
  ini.WriteBool('Editor','CursorPastEOL',SettingsF.CheckBox7.Checked);
  ini.WriteInteger('Editor','MaxUndo',StrToInt(SettingsF.Edit1.Text));
  ini.WriteInteger('Editor','TabSize',StrToInt(SettingsF.Edit3.Text));
  case Settings.AppOrientation of
    aoHorizontal:ini.WriteString('Layout','AppOrientation','aoHorizontal');
    aoVertical:ini.WriteString('Layout','AppOrientation','aoVertical');
    aoAuto:ini.WriteString('Layout','AppOrientation','aoAuto');
  end;
  case Settings.ZoomKeys of
    zkChangeTabs : ini.WriteString('Misc','ZoomKeys','zkChangeTabs');
    zkChangeFont : ini.WriteString('Misc','ZoomKeys','zkChangeFont');
    zkDontUse : ini.WriteString('Misc','ZoomKeys','zkDontUse');
  end;
  // Color scheme..
  ini.WriteString('Colors','Background',ColorToString(Settings.ColorScheme.Background));
  ini.WriteString('Colors','Text',ColorToString(Settings.ColorScheme.Text));
  ini.WriteString('Colors','Gutter',ColorToString(Settings.ColorScheme.Gutter));
  ini.WriteString('Colors','GutterText',ColorToString(Settings.ColorScheme.GutterText));
  ini.WriteString('Colors','CodeFolder',ColorToString(Settings.ColorScheme.CodeFolder));
  // Extra Bar
  ini.WriteBool('ExtraBar','AllwaysOn',Settings.AllwaysShowBar);
  ini.WriteInteger('ExtraBar','ButtonCount',length(Settings.ExtraBar));
  for i := 0 to length(Settings.ExtraBar)-1 do
    begin
      ini.WriteString('ExtraBar','BTN'+inttostr(i),Settings.ExtraBar[i].Caption);
    end;

  ini.UpdateFile;
  ini.Free;
end;

{ TMainForm }
procedure TMainForm.ApplyHighlightToMenu(h : TSynCustomHighlighter);
begin
{  if h = nil then
    begin
      MenuItem5.Checked := True;
      Exit;
    end;
  if h.name = 'SynPasSyn1' then
    MenuItem14.Checked := True;
  if h.name = 'SynFreePascalSyn1' then
    MenuItem15.Checked := True;
  if h.name = 'SynCppSyn1' then
    MenuItem16.Checked := True;
  if h.name = 'SynJavaSyn1' then
    MenuItem17.Checked := True;
  if h.name = 'SynPerlSyn1' then
    MenuItem18.Checked := True;
  if h.name = 'SynHTMLSyn1' then
    MenuItem19.Checked := True;
  if h.name = 'SynXMLSyn1' then
    MenuItem20.Checked := True;
  if h.name = 'SynPythonSyn1' then
    MenuItem21.Checked := True;
  if h.name = 'SynLFMSyn1' then
    MenuItem22.Checked := True;
  if h.name = 'SynUNIXShellScriptSyn1' then
    MenuItem23.Checked := True;
  if h.name = 'SynCssSyn1' then
    MenuItem24.Checked := True;
  if h.name = 'SynPHPSyn1' then
    MenuItem25.Checked := True;
  if h.name = 'SynTeXSyn1' then
    MenuItem26.Checked := True;
  if h.name = 'SynSQLSyn1' then
    MenuItem27.Checked := True;
  if h.name = 'SynVBSyn1' then
    MenuItem28.Checked := True;      }

end;

procedure TMainForm.ApplyHighlightByExt(id : integer);
  function Check(id : integer; ext : string; hl : TSynCustomHighlighter):boolean;
  begin
    if pos(LowerCase(ext),LowerCase(hl.DefaultFilter)) > 0 then
      begin
        Docs[id].Edit.Highlighter := hl;
        hl.Enabled := True;
        Result := True
      end
    else
      Result := False;
  end;

var
  s : string;
begin
  s := ExtractFileExt(Docs[id].FileName);
  if Check(id,s,SynPasSyn1) then Exit;
  if Check(id,s,SynFreePascalSyn1) then Exit;
  if Check(id,s,SynCppSyn1) then Exit;
  if Check(id,s,SynJavaSyn1) then Exit;
  if Check(id,s,SynPerlSyn1) then Exit;
  if Check(id,s,SynHTMLSyn1) then Exit;
  if Check(id,s,SynXMLSyn1) then Exit;
  if Check(id,s,SynPythonSyn1) then Exit;
  if Check(id,s,SynLFMSyn1) then Exit;
  if Check(id,s,SynUNIXShellScriptSyn1) then Exit;
  if Check(id,s,SynCssSyn1) then Exit;
  if Check(id,s,SynPHPSyn1) then Exit;
  if Check(id,s,SynTeXSyn1) then Exit;
  if Check(id,s,SynSQLSyn1) then Exit;
  if Check(id,s,SynVBSyn1) then Exit;
  if Check(id,s,SynIniSyn1) then Exit;
  if Check(id,s,SynBatSyn1) then Exit;
  if Check(id,s,SynJScriptSyn1) then Exit;

end;

procedure TMainForm.ApplyHighlight(id : integer; hl :TSynCustomHighlighter);
begin
  Docs[id].Edit.Highlighter := hl;
  hl.Enabled := True;
end;

procedure TMainForm.SaveDoc(id : integer; SaveAs : boolean = false; silent : boolean = false);
var
  failed : boolean;
  ftpProgress : TFTPProgressDlgF;
begin
  failed := False;
  if SaveAs then
    begin
      if SaveDlgF.ShowModal <> mrOk then
        Exit;
      if SaveDlgF.FName <> '' then
        begin
          try
            Docs[id].Edit.Lines.SaveToFile(SaveDlgF.FName);
            Docs[id].FileName := SaveDlgF.FName;
            Docs[id].Page.Caption := ExtractFileName(SaveDlgF.FName);
          except
            ShowMessage('Can''t save!');
            failed := True;
            Exit;
          end;
        end;
    end
  else
    begin
      if Docs[id].FileName <> '' then
        begin
          try
            Docs[id].Edit.Lines.SaveToFile(Docs[id].FileName);
            if Docs[id].isFTP then
              begin
                ftpProgress := TFTPProgressDlgF.Create(MainForm);
                ftpProgress.FTPAction := daPut;
                ftpProgress.FTPServer := Docs[id].FTPDetails.Server;
                ftpProgress.RemoteFileName := Docs[id].FTPDetails.RemoteFile;
                ftpProgress.LocalFileName:= Docs[id].FileName;
                Application.ProcessMessages;
                if ftpProgress.ShowModal <> MrOk then
                  failed := True;
                ftpProgress.Free;
                DeleteFile(Docs[id].FileName);
                silent := True;
                ShowDBusMiniMessage('File saved to FTP!');
              end;
          except
            ShowMessage('Can''t save!');
            failed := True;
            Exit;
          end;
        end
      else
        begin
          if SaveDlgF.ShowModal <> mrOk then
            Exit;
          if SaveDlgF.FName <> '' then
            begin
              try
                Docs[id].Edit.Lines.SaveToFile(SaveDlgF.FName);
                Docs[id].FileName := SaveDlgF.FName;
                Docs[id].Page.Caption := ExtractFileName(SaveDlgF.FName);
              except
                ShowMessage('Can''t save!');
                failed := True;
                Exit;
              end;
            end;
        end;
    end;
  if not failed then
    begin
      if not silent then
        ShowDBusMiniMessage('File saved!');
      Docs[id].Modified := False;
      if Pos('*',Docs[id].Page.Caption)  > 0 then
        Docs[id].Page.Caption := Copy(Docs[id].Page.Caption,Pos('*',Docs[id].Page.Caption)+1,length(Docs[id].Page.Caption));
    end;
end;

procedure TMainForm.CloseDoc(id : integer);
var
  i : integer;
begin
  // Check if its a script
  for i := 1 to 6 do
    if Settings.Scripts[i].DocID = id then
      begin // Its a script, update the record..
        Settings.Scripts[i].DocID := -1;
      end;

  // Add to the recent files list.. (if not FTP file)
  if not Docs[id].isFTP then
    AddToRecentFiles(Docs[id].FileName);
  // Free the components
  Docs[id].Edit.Free;
  Docs[id].Edit := nil;
  Docs[id].Scroller.Free;
  Docs[id].Scroller := nil;
  Docs[id].Page.Free;
  Docs[id].Page := nil;
  // Now delete from array...
  if Length(Docs) > 1 then
    begin
      for i := id+1 to Length(Docs)-1 do
        begin
          Docs[i-1] := Docs[i];
        end;
      SetLength(Docs, Length(Docs)-1);
    end
  else
    begin
      SetLength(Docs, 0);
      Docs := nil;
    end;
end;

function TMainForm.NewDoc(fname : string; ftpinfo : PTxFTPDetails=nil):integer;
var
  ks : TSynEditKeyStroke;
begin
  Result := -1;
  SetLength(Docs, Length(Docs)+1);
  Inc(TagCount);
  Docs[Length(Docs)-1].DocID := Length(Docs)-1;
  Docs[Length(Docs)-1].Page := TTabSheet.Create(pg);
  Docs[Length(Docs)-1].Page.Parent := pg;
  Docs[Length(Docs)-1].Page.Align:= alClient;
  Docs[Length(Docs)-1].Page.Tag := TagCount;
  Docs[Length(Docs)-1].Edit := TSynEdit.Create(Docs[Length(Docs)-1].Page);
  // Create the kinetic scroller..
  Docs[Length(Docs)-1].Scroller := TTxKinScroller.Create(Docs[Length(Docs)-1].Page);
  Docs[Length(Docs)-1].Scroller.TargetControl := Docs[Length(Docs)-1].Edit;
  Docs[Length(Docs)-1].Edit.Parent := Docs[Length(Docs)-1].Page;
  Docs[Length(Docs)-1].Edit.Align := alClient;
  Docs[Length(Docs)-1].Edit.Tag := TagCount;
  Docs[Length(Docs)-1].Edit.Font.Size:= Settings.SynEditOptions.FontSize;
  Docs[Length(Docs)-1].Edit.Font.Quality:= fqCleartype;
  Docs[Length(Docs)-1].Edit.Font.CharSet:= 4; //FCS_ISO_10646_1 - Unicode
  Docs[Length(Docs)-1].Edit.BlockTabIndent:=1;
  if fname <> '' then
    begin
      try
        Docs[Length(Docs)-1].Edit.Lines.LoadFromFile(fname);
        Docs[Length(Docs)-1].FileName:= fname;
        if FTPInfo <> nil then
          Docs[Length(Docs)-1].Page.Caption:= ExtractFileName(fname)+' (FTP)'
        else
          Docs[Length(Docs)-1].Page.Caption:= ExtractFileName(fname);
        ApplyHighlightByExt(Length(Docs)-1);
      except
        ShowMessage('Can''t open that file!');
        Docs[Length(Docs)-1].Page.Caption := 'Untitled';
        Docs[Length(Docs)-1].FileName := '';
      end;
    end
  else
    begin
      Docs[Length(Docs)-1].Page.Caption := 'Untitled';
    end;

  if FTPInfo <> nil then
    begin
      Docs[Length(Docs)-1].isFTP := True;
      Docs[Length(Docs)-1].FTPDetails := FTPInfo^;
    end;

  Docs[Length(Docs)-1].Edit.OnChange := @GenSynEditChange;
  Docs[Length(Docs)-1].Edit.OnKeyPress := @SynEditDummyKeyPress;
  Docs[Length(Docs)-1].Edit.OnMouseDown := @SynEditDummyMouseDown;
  Docs[Length(Docs)-1].Edit.OnMouseMove := @SynEditDummyMouseMove;
  Docs[Length(Docs)-1].Edit.OnMouseUp := @SynEditDummyMouseUp;
  Docs[Length(Docs)-1].Edit.OnReplaceText := @GenSynEditReplaceText;
  // Apply the color scheme..
  Docs[Length(Docs)-1].Edit.Color:= Settings.ColorScheme.Background;
  Docs[Length(Docs)-1].Edit.Font.Color:= Settings.ColorScheme.Text;
  Docs[Length(Docs)-1].Edit.Gutter.Color := Settings.ColorScheme.Gutter;
  Docs[Length(Docs)-1].Edit.Gutter.Parts.Part[1].MarkupInfo.Background := Settings.ColorScheme.Gutter;
  Docs[Length(Docs)-1].Edit.Gutter.Parts.Part[1].MarkupInfo.Foreground := Settings.ColorScheme.GutterText;
  Docs[Length(Docs)-1].Edit.Gutter.Parts.Part[4].MarkupInfo.Foreground := Settings.ColorScheme.CodeFolder;
  // Apply the options
  ApplySynEditOptions;

  TQtCustomControl( Docs[Length(Docs)-1].Edit.Handle).viewport.setAttribute(QtWA_InputMethodEnabled);
  // Add bookmark icons
  Docs[Length(Docs)-1].Edit.BookMarkOptions.BookmarkImages := BMImgList;

  // Claim some keys..
  ks := Docs[Length(Docs)-1].Edit.Keystrokes.Add;
  ks.ShortCut := Menus.ShortCut(VK_K,[ssCtrl]);
  ks.Command:=199;

  // Fixes the auto capitalisation bug (all characters are uppercase)
  QWidget_setInputMethodHints(TQtWidget(Docs[Length(Docs)-1].Edit.Handle).Widget,QtImhNoAutoUppercase);


  HighlightMenuItem.Enabled := True;
  pg.ActivePageIndex := Docs[Length(Docs)-1].Page.PageIndex;
  FocusTimer.Enabled := True;

  // Return the Doc ID..
  Result := Length(Docs)-1;
end;

procedure TMainForm.FormCreate(Sender: TObject);
var
  i : integer;
  iconFile : WideString;
  btn : TQtPushButton;
  ExtraWidget, SPanel : TQtWidget;
  edt : TQtLineEdit;
begin
  MediaBarProx(False);
  CreateMenuBar;
  TagCount := 0;
  LoadSettings(CONFIG_FILE);
  TQtTabWidget(pg.Handle).TabBar.StyleSheet := 'QTabBar::tab { height: 45px; } ' +
                                               'QTabBar::close-button { image: url(/usr/share/icons/hicolor/48x48/hildon/general_close.png); height: 45px; width: 45px; } ' +
                                               'QTabBar::scroller { width: 60px; } ' +
                                               'QTabBar QToolButton { border-color: gray; border-width: 2px; } ' +
                                               'QTabBar QToolButton { background: black; } ' +
                                               'QTabBar QToolButton::right-arrow { image: url(/usr/share/icons/hicolor/48x48/hildon/general_forward.png); } ' +
                                               'QTabBar QToolButton::left-arrow { image: url(/usr/share/icons/hicolor/48x48/hildon/general_back.png); } '+
                                               'QTabWidget::pane { border-bottom: 0px solid red;  }';
  // Fullscreen button
  btn := TQtPushButton(FullscreenButton.Handle);
  iconFile := '/usr/share/icons/hicolor/64x64/hildon/general_fullsize.png';
  iconFullscreenH := QIcon_create(@iconFile);
  btn.setIcon(iconFullscreenH);
  btn.StyleSheet:= 'QPushButton { background-color: rgba(20, 20, 20, 50%);  border-width:1px; border-style:solid; border-color:black; }';
  FullscreenButton.Visible := False;
  // Page left button
  btn := TQtPushButton(PageLeftButton.Handle);
  iconFile := '/usr/share/icons/hicolor/64x64/hildon/general_back.png';
  iconPageLeftH := QIcon_create(@iconFile);
  btn.setIcon(iconPageLeftH);
  btn.StyleSheet:= 'QPushButton { background-color: rgba(20, 20, 20, 50%);  border-width:1px; border-style:solid; border-color:black; }';
  PageLeftButton.Visible := False;
  // Page right button
  btn := TQtPushButton(PageRightButton.Handle);
  iconFile := '/usr/share/icons/hicolor/64x64/hildon/general_forward.png';
  iconPageRightH := QIcon_create(@iconFile);
  btn.setIcon(iconPageRightH);
  btn.StyleSheet:= 'QPushButton { background-color: rgba(20, 20, 20, 50%);  border-width:1px; border-style:solid; border-color:black; }';
  PageRightButton.Visible := False;
  // Page close button
  btn := TQtPushButton(PageCloseButton.Handle);
  iconFile := '/usr/share/icons/hicolor/48x48/hildon/general_close.png';
  iconPageCloseH := QIcon_create(@iconFile);
  btn.setIcon(iconPageCloseH);
  btn.StyleSheet:= 'QPushButton { background-color: rgba(20, 20, 20, 50%);  border-width:1px; border-style:solid; border-color:black; }';
  PageCloseButton.Visible := False;

  // Page up button
  btn := TQtPushButton(PageUpButton.Handle);
  iconFile := '/usr/share/icons/hicolor/64x64/apps/txpad_up.png';
  iconPageUpH := QIcon_create(@iconFile);
  btn.setIcon(iconPageUpH);
  btn.StyleSheet:= 'QPushButton { background-color: rgba(20, 20, 20, 50%);  border-width:1px; border-style:solid; border-color:black; }';

  // Page up full button
  btn := TQtPushButton(PageUpFullButton.Handle);
  iconFile := '/usr/share/icons/hicolor/64x64/apps/txpad_up_full.png';
  iconPageUpFullH := QIcon_create(@iconFile);
  btn.setIcon(iconPageUpFullH);
  btn.StyleSheet:= 'QPushButton { background-color: rgba(20, 20, 20, 50%);  border-width:1px; border-style:solid; border-color:black; }';

  // Page down button
  btn := TQtPushButton(PageDownButton.Handle);
  iconFile := '/usr/share/icons/hicolor/64x64/apps/txpad_down.png';
  iconPageDownH := QIcon_create(@iconFile);
  btn.setIcon(iconPageDownH);
  btn.StyleSheet:= 'QPushButton { background-color: rgba(20, 20, 20, 50%);  border-width:1px; border-style:solid; border-color:black; }';

  // Page down full button
  btn := TQtPushButton(PageDownFullButton.Handle);
  iconFile := '/usr/share/icons/hicolor/64x64/apps/txpad_down_full.png';
  iconPageDownFullH := QIcon_create(@iconFile);
  btn.setIcon(iconPageDownFullH);
  btn.StyleSheet:= 'QPushButton { background-color: rgba(20, 20, 20, 50%);  border-width:1px; border-style:solid; border-color:black;}';

  PageDownFullButton.Top := MainForm.Height-64;
  PageDownButton.Top := PageDownFullButton.Top-65;

  // Page label button
  btn := TQtPushButton(PageLabelButton.Handle);
  btn.StyleSheet:= 'QPushButton { background-color: rgba(10, 10, 10, 50%); border-width:1px; border-style:solid; border-color:black; }';

  // Bookmark button
  btn := TQtPushButton(BookmarkButton.Handle);
  btn.StyleSheet:= 'QPushButton { background-color: rgba(20, 20, 20, 50%); border-width:1px; border-style:solid; border-color:black; }';

  // Macros button
  btn := TQtPushButton(MacrosButton.Handle);
  btn.StyleSheet:= 'QPushButton { background-color: rgba(20, 20, 20, 50%); border-width:1px; border-style:solid; border-color:black; }';

  // Scripts button
  btn := TQtPushButton(ScriptsButton.Handle);
  btn.StyleSheet:= 'QPushButton { background-color: rgba(20, 20, 20, 50%); border-width:1px; border-style:solid; border-color:black;}';


  // ExtraBarBox
  ExtraScroller := TTxKinScroller.Create(MainForm);
  ExtraScroller.TargetControl := ExtraBarBox;
  ExtraScroller.Enabled := True;
  ExtraWidget := TQtWidget(ExtraBarBox.Handle);
  ExtraWidget.StyleSheet:= 'QFrame { background-color: rgba(20, 20, 20, 40%); '+
                                    'border-width:1px; ' +
                                    'border-style:solid; '+
                                    'border-color:black; ' +
                                    'color: white} ' +
                           'QScrollBar:horizontal { height: 0px;} ' +
                           'QScrollBar:vertical { width: 0px;} ';

  // Search & Replace Box
  edt := TQtLineEdit(SearchEdit.Handle);
  QWidget_setInputMethodHints(edt.Widget,QtImhNoAutoUppercase);
  edt.StyleSheet:= ' QLineEdit { border: 1px solid gray; ' +
                               ' border-radius: 0px; ' +
                               ' padding: 0 0px; ' +
                               ' background-color : white }';

  edt := TQtLineEdit(ReplaceEdit.Handle);
  QWidget_setInputMethodHints(edt.Widget,QtImhNoAutoUppercase);
  edt.StyleSheet:= ' QLineEdit { border: 1px solid gray; ' +
                               ' border-radius: 0px; ' +
                               ' padding: 0 0px; ' +
                               ' background-color : white }';

  // SearchPanel
  SPanel := TQtWidget(SearchPanel.Handle);
  SPanel.StyleSheet:= ' QFrame { border: 0px solid gray; }';

  fullscreen := False;
  XShift := xssNone;
  first := true;
  SearchReplace := False;
  SearchPanel.Width:= MainForm.Width-1;

  if ParamCount > 0 then
    begin
      for i := 1 to ParamCount do
        begin
          NewDoc(ParamStr(i));
        end;
    end
  else
    NewDoc('');
  StartUpTimer.Enabled := True;
end;

procedure TMainForm.FormDeactivate(Sender: TObject);
begin
  ProximityTimer.Enabled := False;
  SearchPanel.Width:= MainForm.Width;
end;

procedure TMainForm.FormHide(Sender: TObject);
begin
end;

procedure TMainForm.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin

end;

procedure TMainForm.FormResize(Sender: TObject);
begin
  if MainForm.Height > MainForm.Width then
    PortraitMode := True
  else
    PortraitMode := False;
  pg.Left := 0;
  pg.Top := 0;
  if not SearchPanel.Visible then
    begin
      pg.Width := (MainForm.Width+10);
      pg.Height := (MainForm.Height+10);
      RepositionSearchButtons(False);
    end
  else
    begin
      pg.Width := (MainForm.Width+10);
      pg.Height := (MainForm.Height+10)-SearchPanel.Height;
      RepositionSearchButtons(True);
    end;
end;

procedure TMainForm.FormUTF8KeyPress(Sender: TObject; var UTF8Key: TUTF8Char);
begin
//  ShowMessage(UTF8Key);
end;

procedure TMainForm.FormWindowStateChange(Sender: TObject);
begin
end;

procedure TMainForm.FullscreenButtonClick(Sender: TObject);
begin
  MenuItem31.OnClick(Self);
end;

procedure TMainForm.MacroPlay1Click(Sender: TObject);
begin
  if pg.PageCount < 1 then
    Exit;
  with Sender as TMenuItem do
    begin
      Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.SetFocus;
      if Name = 'MacroPlay1' then
        begin
          Settings.Macros[1].SMR.Editor := Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit;
          Settings.Macros[1].SMR.PlaybackMacro(Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit);
          Settings.Macros[1].SMR.Editor := nil;
        end;
      if Name = 'MacroPlay2' then
        begin
          Settings.Macros[2].SMR.Editor := Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit;
          Settings.Macros[2].SMR.PlaybackMacro(Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit);
          Settings.Macros[2].SMR.Editor := nil;
        end;
      if Name = 'MacroPlay3' then
        begin
          Settings.Macros[3].SMR.Editor := Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit;
          Settings.Macros[3].SMR.PlaybackMacro(Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit);
          Settings.Macros[3].SMR.Editor := nil;
        end;
      if Name = 'MacroPlay4' then
        begin
          Settings.Macros[4].SMR.Editor := Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit;
          Settings.Macros[4].SMR.PlaybackMacro(Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit);
          Settings.Macros[4].SMR.Editor := nil;
        end;
      if Name = 'MacroPlay5' then
        begin
          Settings.Macros[5].SMR.Editor := Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit;
          Settings.Macros[5].SMR.PlaybackMacro(Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit);
          Settings.Macros[5].SMR.Editor := nil;
        end;
      if Name = 'MacroPlay6' then
        begin
          Settings.Macros[6].SMR.Editor := Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit;
          Settings.Macros[6].SMR.PlaybackMacro(Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit);
          Settings.Macros[6].SMR.Editor := nil;
        end;
    end;
end;

procedure TMainForm.MacroRec1Click(Sender: TObject);
begin
  if pg.PageCount < 1 then
    Exit;
  with Sender as TMenuItem do
    begin
      if Name = 'MacroRec1' then
        begin
          if not Assigned(Settings.Macros[1].SMR) then
            Settings.Macros[1].SMR := TSynMacroRecorder.Create(MainForm);
          Settings.Macros[1].SMR.Editor := Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit;
          Settings.Macros[1].SMR.RecordMacro(Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit);
          MacroRecordingID := 1;
          MacroRecording := True;
        end;
      if Name = 'MacroRec2' then
        begin
          if not Assigned(Settings.Macros[2].SMR) then
            Settings.Macros[2].SMR := TSynMacroRecorder.Create(MainForm);
          Settings.Macros[2].SMR.Editor := Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit;
          Settings.Macros[2].SMR.RecordMacro(Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit);
          MacroRecordingID := 2;
          MacroRecording := True;
        end;
      if Name = 'MacroRec3' then
        begin
          if not Assigned(Settings.Macros[3].SMR) then
            Settings.Macros[3].SMR := TSynMacroRecorder.Create(MainForm);
          Settings.Macros[3].SMR.Editor := Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit;
          Settings.Macros[3].SMR.RecordMacro(Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit);
          MacroRecordingID := 3;
          MacroRecording := True;
        end;
      if Name = 'MacroRec4' then
        begin
          if not Assigned(Settings.Macros[4].SMR) then
            Settings.Macros[4].SMR := TSynMacroRecorder.Create(MainForm);
          Settings.Macros[4].SMR.Editor := Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit;
          Settings.Macros[4].SMR.RecordMacro(Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit);
          MacroRecordingID := 4;
          MacroRecording := True;
        end;
      if Name = 'MacroRec5' then
        begin
          if not Assigned(Settings.Macros[5].SMR) then
            Settings.Macros[5].SMR := TSynMacroRecorder.Create(MainForm);
          Settings.Macros[5].SMR.Editor := Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit;
          Settings.Macros[5].SMR.RecordMacro(Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit);
          MacroRecordingID := 5;
          MacroRecording := True;
        end;
      if Name = 'MacroRec6' then
        begin
          if not Assigned(Settings.Macros[6].SMR) then
            Settings.Macros[6].SMR := TSynMacroRecorder.Create(MainForm);
          Settings.Macros[6].SMR.Editor := Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit;
          Settings.Macros[6].SMR.RecordMacro(Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit);
          MacroRecordingID := 6;
          MacroRecording := True;
        end;
    end;
  Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.SetFocus;
end;

procedure TMainForm.MacrosButtonClick(Sender: TObject);
begin
  MacrosMenu.Popup;
end;

procedure TMainForm.MacrosMenuPopup(Sender: TObject);
var
  i : integer;
begin
  if MacroRecording then
    begin
      MacrosMenu.Items[0].Enabled := False;
      MacrosMenu.Items[1].Enabled := False;
      MacrosMenu.Items[2].Enabled := True;
    end
  else
    begin
      MacrosMenu.Items[0].Enabled := True;
      MacrosMenu.Items[1].Enabled := True;
      MacrosMenu.Items[2].Enabled := False;
    end;

  for i := 1 to 6 do
    begin
      if Assigned(Settings.Macros[i].SMR) then
        begin
          with FindComponent('MacroPlay'+inttostr(i)) as TMenuItem do
            begin
              Caption := Settings.Macros[i].Caption;
              Enabled := True;
            end;
            with FindComponent('MacroRec'+inttostr(i)) as TMenuItem do
              begin
                Caption := Settings.Macros[i].Caption;
              end;
        end
      else
        begin
          with FindComponent('MacroPlay'+inttostr(i)) as TMenuItem do
            begin
              Caption := 'Empty';
              Enabled := False;
            end;
            with FindComponent('MacroRec'+inttostr(i)) as TMenuItem do
              begin
                Caption := 'Empty';
              end;
        end;
    end;
end;

procedure TMainForm.BMGoto1Click(Sender: TObject);
begin
  if pg.PageCount < 1 then
    Exit;
  with Sender as TMenuItem do
    begin
      if Name = 'BMGoto1' then
        Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.CommandProcessor(301,'',nil);
      if Name = 'BMGoto2' then
        Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.CommandProcessor(302,'',nil);
      if Name = 'BMGoto3' then
        Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.CommandProcessor(303,'',nil);
      if Name = 'BMGoto4' then
        Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.CommandProcessor(304,'',nil);
      if Name = 'BMGoto5' then
        Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.CommandProcessor(305,'',nil);
      if Name = 'BMGoto6' then
        Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.CommandProcessor(306,'',nil);
    end;
end;

procedure TMainForm.BMToggle1Click(Sender: TObject);
var
  p : TPoint;
begin
  p := Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.LogicalCaretXY;
  with Sender as TMenuItem do
    begin
      if Name = 'BMToggle1' then
        Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.CommandProcessor(361,'',@p);
      if Name = 'BMToggle2' then
        Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.CommandProcessor(362,'',@p);
      if Name = 'BMToggle3' then
        Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.CommandProcessor(363,'',@p);
      if Name = 'BMToggle4' then
        Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.CommandProcessor(364,'',@p);
      if Name = 'BMToggle5' then
        Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.CommandProcessor(365,'',@p);
      if Name = 'BMToggle6' then
        Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.CommandProcessor(366,'',@p);
    end;
end;

procedure TMainForm.BookmarkButtonClick(Sender: TObject);
begin
  BookmarkMenu.PopUp;
end;

procedure TMainForm.MenuItem45Click(Sender: TObject);
begin
  ApplyHighlight(GetDocIDByTag(pg.ActivePage.Tag),SynIniSyn1);
  MainForm.Refresh;
end;

procedure TMainForm.MenuItem46Click(Sender: TObject);
begin
  ApplyHighlight(GetDocIDByTag(pg.ActivePage.Tag),SynBatSyn1);
  MainForm.Refresh;
end;

procedure TMainForm.MenuItem47Click(Sender: TObject);
var
  ftpProgress : TFTPProgressDlgF;
  info : TxFTPDetails;
begin
  saveftpdlg := TFTPSaveDlgF.Create(MainForm);
  if saveftpdlg.ShowModal = MrOk then
    begin
      ftpProgress := TFTPProgressDlgF.Create(MainForm);
      ftpProgress.FTPAction := daPut;
      ftpProgress.FTPServer := saveftpdlg.currentServer;
      ftpProgress.RemoteFileName := saveftpdlg.RemoteFileName;
      ftpProgress.LocalFileName := Settings.FTPTempDir+ExtractFileName(saveftpdlg.RemoteFileName);
      Application.ProcessMessages;
      info.RemoteFile := saveftpdlg.RemoteFileName;
      info.LocalFile := Settings.FTPTempDir+ExtractFileName(saveftpdlg.RemoteFileName);
      // Create the local file first..
      Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.Lines.SaveToFile(info.LocalFile);
      info.Server := saveftpdlg.currentServer;
      if ftpProgress.ShowModal = MrOk then
        begin
          ShowDBusMiniMessage('File saved to FTP!');
          Docs[GetDocIDByTag(pg.ActivePage.Tag)].Modified := False;
          Docs[GetDocIDByTag(pg.ActivePage.Tag)].isFTP := True;
          Docs[GetDocIDByTag(pg.ActivePage.Tag)].FTPDetails := info;
          Docs[GetDocIDByTag(pg.ActivePage.Tag)].Page.Caption := ExtractFileName(info.LocalFile);
          Docs[GetDocIDByTag(pg.ActivePage.Tag)].FileName:= info.LocalFile;
          if Pos('*',Docs[GetDocIDByTag(pg.ActivePage.Tag)].Page.Caption)  > 0 then
            Docs[GetDocIDByTag(pg.ActivePage.Tag)].Page.Caption := Copy(Docs[GetDocIDByTag(pg.ActivePage.Tag)].Page.Caption,Pos('*',Docs[GetDocIDByTag(pg.ActivePage.Tag)].Page.Caption)+1,length(Docs[GetDocIDByTag(pg.ActivePage.Tag)].Page.Caption));
        end;
      ftpProgress.Free;
      DeleteFile(info.LocalFile);
    end;
  saveftpdlg.Free;
end;

procedure TMainForm.MenuItem48Click(Sender: TObject);
begin
  ApplyHighlight(GetDocIDByTag(pg.ActivePage.Tag), SynJScriptSyn1);
  MainForm.Refresh;
end;

procedure TMainForm.ReplaceEditKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin

end;

procedure TMainForm.ActionNewExecute(Sender: TObject);
begin
  LastAction := Sender as TAction;
  LastAction.Enabled:= False;
  if not short_executed then
    begin
      if LastAction.Name = 'ActionNew' then
        MenuItem3.OnClick(Self);
      if LastAction.Name = 'ActionOpen' then
        MenuItem8.OnClick(Self);
      if LastAction.Name = 'ActionSave' then
        MenuItem9.OnClick(Self);
      if LastAction.Name = 'ActionSaveAs' then
        MenuItem10.OnClick(Self);
      if LastAction.Name = 'ActionCloseTab' then
        MenuItem12.OnClick(Self);
      if LastAction.Name = 'ActionSearch' then
        MenuItem35.OnClick(Self);
      if LastAction.Name = 'ActionSearchReplace' then
        MenuItem36.OnClick(Self);
      if LastAction.Name = 'ActionFullScreen' then
        MenuItem31.OnClick(Self);
      if LastAction.Name = 'ActionZoomPlus' then
        MenuItem37.OnClick(Self);
      if LastAction.Name = 'ActionZoomMinus' then
        MenuItem39.OnClick(Self);
      if LastAction.Name = 'ActionJumpTo' then
        MenuItem7.OnClick(Self);
      short_executed := True;
    end;
  ShortCutDelayTimer.Enabled := True;
end;

procedure TMainForm.FindButtonClick(Sender: TObject);
var
  opts : TSynSearchOptions;
  res : integer;
begin
  if not SearchReplace then
    begin
      opts := [ssoFindContinue];
      if Settings.UseRegExpr then
        opts := opts+[ssoRegExpr];
      if Settings.CaseSensitive then
        opts := opts+[ssoMatchCase];
      if Settings.WholeWords then
        opts := opts+[ssoWholeWord];
      res := Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.SearchReplace(SearchEdit.Text,'',opts);
    end
  else
    begin
      opts := [ssoPrompt, ssoReplace];
      if Settings.UseRegExpr then
        opts := opts+[ssoRegExpr];
      if Settings.CaseSensitive then
        opts := opts+[ssoMatchCase];
      if Settings.WholeWords then
        opts := opts+[ssoWholeWord];
      PromptingReplace := False;
      res := Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.SearchReplace(SearchEdit.Text,ReplaceEdit.Text,opts);
    end;
  if res = 0 then
    ShowDBusMiniMessage('Text not found!');
end;

procedure TMainForm.SearchCloseButtonClick(Sender: TObject);
begin
  if SearchReplace then
    MenuItem36.OnClick(Self)
  else
    MenuItem35.OnClick(Self);
end;

procedure TMainForm.ReplaceAllButtonClick(Sender: TObject);
var
  opts : TSynSearchOptions;
  res : integer;
begin
  if MessageDlg('Replace All', 'Really replace all?',mtConfirmation,[mbYes, mbNo],0) <> mrYes then
    Exit;
  begin
    opts := [ssoReplaceAll];
    if Settings.UseRegExpr then
      opts := opts+[ssoRegExpr];
    if Settings.CaseSensitive then
      opts := opts+[ssoMatchCase];
    if Settings.WholeWords then
      opts := opts+[ssoWholeWord];
    PromptingReplace := False;
    res := Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.SearchReplace(SearchEdit.Text,ReplaceEdit.Text,opts);
  end;
if res = 0 then
  ShowDBusMiniMessage('Text not found!');
end;

procedure TMainForm.Button7Click(Sender: TObject);
var
  opts : TSynSearchOptions;
begin
  ReplacePanel.Visible := False;
  opts := [ssoPrompt, ssoReplace, ssoSelectedOnly];
  if Settings.UseRegExpr then
    opts := opts+[ssoRegExpr];
  if Settings.CaseSensitive then
    opts := opts+[ssoMatchCase];
  if Settings.WholeWords then
    opts := opts+[ssoWholeWord];
  PromptingReplace := True;
  Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.SearchReplace(SearchEdit.Text,ReplaceEdit.Text,opts);
  FindButton.OnClick(Self);
end;

procedure TMainForm.Button8Click(Sender: TObject);
begin
  ReplacePanel.Visible := False;
  FindButton.OnClick(Self);
end;

procedure TMainForm.Button9Click(Sender: TObject);
begin
  prox(false);
end;

procedure TMainForm.ExitItemClick(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.ExtraBarBoxMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if Assigned(ExtraScroller) then
    ExtraScroller.MouseDown(X,Y);
end;

procedure TMainForm.ExtraBarBoxMouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
begin
  if Assigned(ExtraScroller) then
    ExtraScroller.MouseMove(X,Y);
end;

procedure TMainForm.ExtraBarBoxMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if Assigned(ExtraScroller) then
    ExtraScroller.MouseUp(X,Y);
end;

procedure TMainForm.ExtraBarButton1Click(Sender: TObject);
begin
  if pg.PageCount < 1 then
    Exit;
{  with Sender as TButton do
    begin
      if Name = 'ExtraBarButton1' then
        begin // Tab
          Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.InsertTextAtCaret(#9);
        end;
      if Name = 'ExtraBarButton2' then
        begin // '|'
          Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.InsertTextAtCaret(ExtraBarButton2.Caption);
        end;
      if Name = 'ExtraBarButton3' then
        begin // '{'
          Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.InsertTextAtCaret(ExtraBarButton3.Caption);
        end;
      if Name = 'ExtraBarButton4' then
        begin // '}'
          Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.InsertTextAtCaret(ExtraBarButton4.Caption);
        end;
      if Name = 'ExtraBarButton5' then
        begin // '<'
          Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.InsertTextAtCaret(ExtraBarButton5.Caption);
        end;
      if Name = 'ExtraBarButton6' then
        begin // '>'
          Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.InsertTextAtCaret(ExtraBarButton6.Caption);
        end;
      if Name = 'ExtraBarButton7' then
        begin // '['
          Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.InsertTextAtCaret(ExtraBarButton7.Caption);
        end;
      if Name = 'ExtraBarButton8' then
        begin // ']'
          Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.InsertTextAtCaret(ExtraBarButton8.Caption);
        end;
      Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.SetFocus;
    end;    }
end;

procedure TMainForm.ExtraBarButton1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  tempx, tempy : integer;
  cur_btn : TButton;
begin
  // Mouse is moving, pass it to the Scroll Area...
  cur_btn := Sender as TButton;
  tempx := (cur_btn.Left+X);
  tempy := (cur_btn.Top+Y);
  // Pass the event to the parent...
  ExtraScroller.MouseDown(Mouse.CursorPos.X,0);

end;

procedure TMainForm.ExtraBarButton1MouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
var
  tempx, tempy : integer;
  cur_btn : TButton;
begin
  // Mouse is moving, pass it to the Scroll Area...
//  last_btn.Font.Color := clWhite;
  Application.ProcessMessages;
  cur_btn := Sender as TButton;
  cur_btn.Font.Color := clRed;
  tempx := (cur_btn.Left+X);
  tempy := (cur_btn.Top+Y);
  // Pass the event to the parent...
  if mouse.IsDragging then
    ExtraScroller.MouseMove(Mouse.CursorPos.X,0);
end;

procedure TMainForm.ExtraBarButton1MouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  tempx, tempy : integer;
  cur_btn : TButton;
begin
  // Mouse is moving, pass it to the Scroll Area...
  cur_btn := Sender as TButton;
  tempx := (cur_btn.Left+X);
  tempy := (cur_btn.Top+Y);
  // Pass the event to the parent...
  ExtraScroller.MouseUp(tempx, 0);
end;

procedure TMainForm.ExtraBarButton6MouseEnter(Sender: TObject);
begin

end;

procedure TMainForm.FormActivate(Sender: TObject);
begin
  ProximityTimer.Enabled := True;
  SearchPanel.Width:= MainForm.Width-1;
end;

procedure TMainForm.FormClose(Sender: TObject; var CloseAction: TCloseAction);
var
  i, res : integer;
begin
  MediaBarProx(True);
  // Check for open/modified documents
  if pg.PageCount > 0 then
    begin
      for i := pg.PageCount-1 downto 0 do
        begin
          if Docs[GetDocIDByTag(pg.Pages[i].Tag)].Modified then
            begin
              res := MessageDlg('Document "'+Docs[GetDocIDByTag(pg.Pages[i].Tag)].Page.Caption+'" has been modified', 'Do you want to save the changes?', mtConfirmation, [mbYes, mbNo, mbCancel], 0);
              if res = mrYes then
                begin
                  SaveDoc(GetDocIDByTag(pg.Pages[i].Tag));
                  CloseDoc(GetDocIDByTag(pg.Pages[i].Tag));
                end;
              if res = mrNo then
                begin
                  CloseDoc(GetDocIDByTag(pg.Pages[i].Tag));
                end;
            end
          else
            CloseDoc(GetDocIDByTag(pg.Pages[i].Tag));
        end;
    end;
  // Check for modified macros

  {to do..}
end;

procedure TMainForm.MenuItem10Click(Sender: TObject);
begin
  if pg.PageCount > 0 then
    begin
      SaveDoc(GetDocIDByTag(pg.ActivePage.Tag), True);
    end;
end;

procedure TMainForm.MenuItem12Click(Sender: TObject);
var
  res : integer;
begin
  if pg.PageCount < 1 then
    Exit;
  if Docs[GetDocIDByTag(pg.ActivePage.Tag)].Modified then
    begin
      res := MessageDlg('Document has been modified', 'Do you want to save the changes?', mtConfirmation, [mbYes, mbNo, mbCancel], 0);
      if res = mrYes then
        begin
          SaveDoc(GetDocIDByTag(pg.ActivePage.Tag));
          CloseDoc(GetDocIDByTag(pg.ActivePage.Tag));
        end;
      if res = mrNo then
        begin
          CloseDoc(GetDocIDByTag(pg.ActivePage.Tag));
        end;
    end
  else
    CloseDoc(GetDocIDByTag(pg.ActivePage.Tag));
end;

procedure TMainForm.MenuItem13Click(Sender: TObject);
var
  ini : TMemIniFile;
begin
  if pg.PageCount > 0 then
    begin
      FontDlgF.FontSize := Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.Font.Size;
      FontDlgF.FontName := Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.Font.Name;
      if FontDlgF.ShowModal = mrOk then
        begin
          Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.Font.Pitch := FontDlgF.FontPitch;
          Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.Font.Quality := fqClearType;
          Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.Font.Size := FontDlgF.FontSize;
          Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.Font.Name := FontDlgF.FontName;
          ini := TMemIniFile.Create(CONFIG_FILE);
          ini.WriteInteger('Editor','FontSize',FontDlgF.FontSize);
          ini.UpdateFile;
          ini.Free;
        end;
      Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.Refresh;
      Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.SetFocus;
    end;
  MainForm.Refresh;
end;

procedure TMainForm.MenuItem14Click(Sender: TObject);
begin
  ApplyHighlight(GetDocIDByTag(pg.ActivePage.Tag),SynPasSyn1);
  MainForm.Refresh;
end;

procedure TMainForm.MenuItem15Click(Sender: TObject);
begin
  ApplyHighlight(GetDocIDByTag(pg.ActivePage.Tag),SynFreePascalSyn1);
  MainForm.Refresh;
end;

procedure TMainForm.MenuItem16Click(Sender: TObject);
begin
  ApplyHighlight(GetDocIDByTag(pg.ActivePage.Tag),SynCppSyn1);
  MainForm.Refresh;
end;

procedure TMainForm.MenuItem17Click(Sender: TObject);
begin
  ApplyHighlight(GetDocIDByTag(pg.ActivePage.Tag),SynJavaSyn1);
  MainForm.Refresh;
end;

procedure TMainForm.MenuItem18Click(Sender: TObject);
begin
  ApplyHighlight(GetDocIDByTag(pg.ActivePage.Tag),SynPerlSyn1);
  MainForm.Refresh;
end;

procedure TMainForm.MenuItem19Click(Sender: TObject);
begin
  ApplyHighlight(GetDocIDByTag(pg.ActivePage.Tag),SynHTMLSyn1);
  MainForm.Refresh;
end;

procedure TMainForm.MenuItem20Click(Sender: TObject);
begin
  ApplyHighlight(GetDocIDByTag(pg.ActivePage.Tag),SynXMLSyn1);
  MainForm.Refresh;
end;

procedure TMainForm.MenuItem21Click(Sender: TObject);
begin
  ApplyHighlight(GetDocIDByTag(pg.ActivePage.Tag),SynPythonSyn1);
  MainForm.Refresh;
end;

procedure TMainForm.MenuItem22Click(Sender: TObject);
begin
  ApplyHighlight(GetDocIDByTag(pg.ActivePage.Tag),SynLFMSyn1);
  MainForm.Refresh;
end;

procedure TMainForm.MenuItem23Click(Sender: TObject);
begin
  ApplyHighlight(GetDocIDByTag(pg.ActivePage.Tag),SynUnixShellScriptSyn1);
  MainForm.Refresh;
end;

procedure TMainForm.MenuItem24Click(Sender: TObject);
begin
  ApplyHighlight(GetDocIDByTag(pg.ActivePage.Tag),SynCSSSyn1);
  MainForm.Refresh;
end;

procedure TMainForm.MenuItem25Click(Sender: TObject);
begin
  ApplyHighlight(GetDocIDByTag(pg.ActivePage.Tag),SynPHPSyn1);
  MainForm.Refresh;
end;

procedure TMainForm.MenuItem26Click(Sender: TObject);
begin
  ApplyHighlight(GetDocIDByTag(pg.ActivePage.Tag),SynTeXSyn1);
  MainForm.Refresh;
end;

procedure TMainForm.MenuItem27Click(Sender: TObject);
begin
  ApplyHighlight(GetDocIDByTag(pg.ActivePage.Tag),SynSQLSyn1);
  MainForm.Refresh;
end;

procedure TMainForm.MenuItem28Click(Sender: TObject);
begin
  ApplyHighlight(GetDocIDByTag(pg.ActivePage.Tag),SynVBSyn1);
  MainForm.Refresh;
end;

procedure TMainForm.MenuItem31Click(Sender: TObject);
begin
  if fullscreen then
    begin
      fullscreen := False;
      UseFullscreen(MainForm.Handle, False);
    end
  else
    begin
      fullscreen := True;
      UseFullscreen(MainForm.Handle, True);
    end;
end;

procedure TMainForm.MenuItem32Click(Sender: TObject);
var
  ini : TMemIniFile;
begin
  if MacroRecording then
    begin
      Settings.Macros[MacroRecordingID].SMR.Stop;
      TxInputDlgF.Caption := 'Macro name :';
      if TxInputDlgF.ShowModal = mrOk then
        Settings.Macros[MacroRecordingID].Caption := TxInputDlgF.Edit1.Text
      else
        Settings.Macros[MacroRecordingID].Caption := 'Untitled';
      if MessageDlg('Save Macro', 'Do you want to save this macro?', mtConfirmation, [mbYes, mbNo], 0 ) = mrYes then
        begin
          ini := TMemIniFile.Create(CONFIG_FILE);
          ini.WriteString('Macros','MF'+inttostr(MacroRecordingID),CONFIG_DIR+'macro'+inttostr(MacroRecordingID));
          ini.WriteString('Macros','MC'+inttostr(MacroRecordingID),Settings.Macros[MacroRecordingID].Caption);
          ini.UpdateFile;
          ini.Free;
          ShowMessage(inttostr(Settings.Macros[MacroRecordingID].SMR.EventCount));
          Settings.Macros[MacroRecordingID].SMR.SaveToFile(CONFIG_DIR+'macro'+inttostr(MacroRecordingID));
          ShowDBusMiniMessage('Macro saved!');
        end;
      MacroRecordingID := 0;
      MacroRecording := False;
    end;
  Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.SetFocus;
end;

procedure TMainForm.MenuItem33Click(Sender: TObject);
var
  i : integer;
begin
  if pg.PageCount  < 1 then
    begin
      ShowMessage('There are no opened files...');
      Exit;
    end;
  for i := 14 to 28 do
    begin
      with FindComponent('MenuItem'+inttostr(i)) as TMenuItem do
        if Checked then
          begin
            PasteBinF.Edit2.Text := lowercase(Caption);
            if i = 15 then
              PasteBinF.Edit2.Text := 'pascal';
            if i = 19 then
              PasteBinF.Edit2.Text := 'html4strict';
            if i = 23 then
              PasteBinF.Edit2.Text := '';
            if i = 26 then
              PasteBinF.Edit2.Text := '';
          end;
    end;
  PasteBinF.ShowModal;
end;

procedure TMainForm.MenuItem35Click(Sender: TObject);
begin
  if pg.PageCount  < 1 then
    Exit;
  if not SearchReplace then
    begin
      if SearchPanel.Visible = True then
        begin
          SearchPanel.Visible := False;
          RepositionSearchButtons(False);
          FullScreenButton.Top := MainForm.Height-64;
          pg.Height := MainForm.Height+10;
        end
      else
        begin
          SearchPanel.Visible := True;
          RepositionSearchButtons(True);
          SearchPanel.Height := 50;
          FullScreenButton.Top := MainForm.Height-64-50;
          pg.Height := (MainForm.Height+10)-SearchPanel.Height;
        end;
    end
  else
    begin
      if SearchPanel.Visible = True then
        begin
          SearchPanel.Height := 50;
          FindButton.Caption := 'Find Next';
          SearchReplace := False;
          RepositionSearchButtons(True);
          FullScreenButton.Top := MainForm.Height-64-50;
          pg.Height := (MainForm.Height+10)-SearchPanel.Height;
        end
      else
        begin
          FindButton.Caption := 'Find Next';
          SearchReplace := False;
          RepositionSearchButtons(False);
          SearchPanel.Visible := False;
          FullScreenButton.Top := MainForm.Height-64;
          pg.Height := (MainForm.Height+10);
        end;
    end;
end;

procedure TMainForm.MenuItem36Click(Sender: TObject);
begin
  if pg.PageCount  < 1 then
    Exit;
  if SearchReplace then
    begin
      SearchReplace := False;
      SearchPanel.Height := 50;
      SearchPanel.Visible := False;
      RepositionSearchButtons(False);
      FullScreenButton.Top := MainForm.Height-64;
      pg.Height := (MainForm.Height+10);
    end
  else
    begin
      SearchReplace := True;
      SearchPanel.Height := 100;
      SearchPanel.Visible := True;
      RepositionSearchButtons(True);
      FindButton.Caption := 'Rep Next';
      FullScreenButton.Top := MainForm.Height-64-100;
      pg.Height := (MainForm.Height+10)-SearchPanel.Height;
    end;
end;

procedure TMainForm.MenuItem37Click(Sender: TObject);
var
  ini : TMemIniFile;
begin
  if pg.PageCount  < 1 then
    Exit;
  if Settings.ZoomKeys = zkChangeTabs then
    begin
      // Go left
      if pg.PageIndex > 0 then
        pg.PageIndex:= pg.PageIndex-1;
    end;
  if Settings.ZoomKeys = zkChangeFont then
    begin
      Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.Font.Size := Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.Font.Size-1;
      if Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.Font.Size <= 6 then
        Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.Font.Size := 6;
      ini := TMemIniFile.Create(CONFIG_FILE);
      ini.WriteInteger('Editor','FontSize',Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.Font.Size);
      ini.UpdateFile;
      ini.Free;
      // Caret size doesnt change (bug in SynEdit), so improvise
      Docs[GetDocIDByTag(pg.ActivePage.Tag)].Page.SetFocus;
      Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.SetFocus;
//      Docs[pg.ActivePage.Tag].Edit.XCaret.ChangeOnTouch;
    end;

end;

procedure TMainForm.MenuItem39Click(Sender: TObject);
var
  ini : TMemIniFile;
begin
  if pg.PageCount  < 1 then
    Exit;
  if Settings.ZoomKeys = zkChangeTabs then
    begin
      // Go right
      if pg.PageIndex < pg.PageCount then
        pg.PageIndex:= pg.PageIndex+1;
    end;
  if Settings.ZoomKeys = zkChangeFont then
    begin
      Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.Font.Size := Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.Font.Size+1;
      if Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.Font.Size >= 40 then
        Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.Font.Size := 40;
      ini := TMemIniFile.Create(CONFIG_FILE);
      ini.WriteInteger('Editor','FontSize',Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.Font.Size);
      ini.UpdateFile;
      ini.Free;
      // Caret size doesnt change (bug in SynEdit), so improvise
      Docs[GetDocIDByTag(pg.ActivePage.Tag)].Page.SetFocus;
      Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.SetFocus;
//      Docs[pg.ActivePage.Tag].Edit.XCaret.ChangeOnTouch;
    end;
end;

procedure TMainForm.MenuItem3Click(Sender: TObject);
begin
  NewDoc('');
  MainForm.Refresh;
end;

procedure TMainForm.MenuItem42Click(Sender: TObject);
begin
  SaveSettings(CONFIG_FILE);
end;

procedure TMainForm.AboutItemClick(Sender: TObject);
begin
  AboutBoxF.ShowModal;
end;

procedure TMainForm.MenuItem44Click(Sender: TObject);
var
  ftpProgress : TFTPProgressDlgF;
  info : TxFTPDetails;
begin
  openftpdlg := TFTPOpenDlgF.Create(MainForm);
  if openftpdlg.ShowModal = MrOk then
    begin
      ftpProgress := TFTPProgressDlgF.Create(MainForm);
      ftpProgress.FTPAction := daGet;
      ftpProgress.FTPServer := openftpdlg.currentServer;
      ftpProgress.RemoteFileName := openftpdlg.RemoteFileName;
      ftpProgress.LocalFileName := openftpdlg.LocalFileName;
      Application.ProcessMessages;
      info.RemoteFile := openftpdlg.RemoteFileName;
      info.LocalFile := openftpdlg.LocalFileName;
      info.Server := openftpdlg.currentServer;
      if ftpProgress.ShowModal = MrOk then
        NewDoc(ftpProgress.LocalFileName, @info);
      ftpProgress.Free;
      DeleteFile(info.LocalFile);
    end;
  openftpdlg.Free;
end;

procedure TMainForm.MenuItem4Click(Sender: TObject);
var
  htmlex : TSynExporterHTML;
  lines : TStringList;
begin
  if pg.PageCount < 1 then
    Exit;
  HTMLExportF.FontColorBox.Color := HTMLExportF.FontColorBox.Selected;
  HTMLExportF.BackColorBox.Color := HTMLExportF.BackColorBox.Selected;
  if HTMLExportF.ShowModal <> mrOK then
    Exit;

  htmlex := TSynExporterHTML.Create(MainForm);
  htmlex.ExportAsText := true;
  if Assigned(Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.Highlighter) then
    htmlex.Highlighter := Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.Highlighter;
  htmlex.Title := HTMLExportF.Edit1.Text;
  case HTMLExportF.ListBox1.ItemIndex of
    0 : htmlex.HTMLFontSize:= fs01;
    1 : htmlex.HTMLFontSize:= fs02;
    2 : htmlex.HTMLFontSize:= fs03;
    3 : htmlex.HTMLFontSize:= fs04;
    4 : htmlex.HTMLFontSize:= fs05;
    5 : htmlex.HTMLFontSize:= fs06;
    6 : htmlex.HTMLFontSize:= fs07;
  end;
  htmlex.Font.Color := HTMLExportF.FontColorBox.Selected;
  htmlex.Color := HTMLExportF.BackColorBox.Selected;
  htmlex.UseBackground := True;

  if HTMLExportF.RadioButton1.Checked then
    htmlex.ExportAll(Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.Lines);
  if HTMLExportF.RadioButton2.Checked then
    begin
      lines := TStringList.Create;
      lines.Add(Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.SelText);
      htmlex.ExportAll(lines);
      lines.Free;
    end;

  if SaveDlgF.ShowModal = mrOK then
    htmlex.SaveToFile(SaveDlgF.FName);
  ShowDBusMiniMessage('Exported to HTML');
  htmlex.Free;
end;

procedure TMainForm.MenuItem5Click(Sender: TObject);
begin
  Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.Highlighter := nil;
  //with Sender as TMenuItem do Checked := True;
  MainForm.Refresh;
end;

procedure TMainForm.MenuItem6Click(Sender: TObject);
var
  i, res : integer;
begin
  GenMenuF.Caption := 'Open Recent Files';
  GenMenuF.ListBox1.Clear;
  for i := 1 to 10 do
    GenMenuF.ListBox1.Items.Add(Settings.RecentFiles[i]);

  res := GenMenuF.ShowModal;
  if (GenMenuF.MRes <> '') and (res = mrOk) then
    begin
      NewDoc(GenMenuF.MRes);
    end;
end;

procedure TMainForm.MenuItem7Click(Sender: TObject);
var
  i : integer;
begin
  if pg.PageCount < 1 then
    Exit;
  if JumpToDlgF.ShowModal = MrOK then
    if TryStrToInt(JumpToDlgF.Edit1.Text,i) then
      Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.CaretY := i
    else
      ShowDBusMiniMessage('Invalid value!');
end;

procedure TMainForm.MenuItem8Click(Sender: TObject);
begin
  OpenDlgF.ShowModal;
  if OpenDlgF.FName <> '' then
    NewDoc(OpenDlgF.FName);
  MainForm.Refresh;
end;

procedure TMainForm.MenuItem9Click(Sender: TObject);
begin
  if pg.PageCount > 0 then
    begin
      SaveDoc(GetDocIDByTag(pg.ActivePage.Tag));
    end;
end;

procedure TMainForm.PageCloseButtonClick(Sender: TObject);
begin
  MenuItem12.OnClick(Self);
end;

procedure TMainForm.PageDownButtonClick(Sender: TObject);
begin
  if pg.PageCount > 0 then
    begin
      with Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit do
        begin
          TopLine := TopLine + (LinesInWindow);
        end;
    end;
end;

procedure TMainForm.PageDownFullButtonClick(Sender: TObject);
begin
  if pg.PageCount > 0 then
    begin
      with Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit do
        begin
          TopLine := Lines.Count;
        end;
    end;
end;

procedure TMainForm.PageLeftButtonClick(Sender: TObject);
begin
  if pg.PageCount  < 1 then
    Exit;
  // Go left
  if pg.PageIndex > 0 then
    pg.PageIndex:= pg.PageIndex-1;
end;

procedure TMainForm.PageRightButtonClick(Sender: TObject);
begin
  if pg.PageCount  < 1 then
    Exit;
  // Go right
  if pg.PageIndex < pg.PageCount then
    pg.PageIndex:= pg.PageIndex+1;
end;

procedure TMainForm.PageUpButtonClick(Sender: TObject);
begin
  if pg.PageCount > 0 then
    begin
      with Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit do
        begin
          TopLine := TopLine - (LinesInWindow);
        end;
    end;
end;

procedure TMainForm.PageUpFullButtonClick(Sender: TObject);
begin
  if pg.PageCount > 0 then
    begin
      with Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit do
        begin
          TopLine := 0;
        end;
    end;
end;

procedure TMainForm.pgCloseTabClicked(Sender: TObject);
var
  res : integer;
  i : integer;
begin
  with Sender as TTabSheet do
    begin
      if GetDocIDByTag(Tag) < 0 then
        begin
          ShowMessage('This shouldn''t happen'+inttostr(Tag));
          for i := 0 to length(Docs)-1 do
            ShowMessage('D Tags['+inttostr(i)+'] = '+inttostr(Docs[i].Page.Tag));
        end;
      if Docs[GetDocIDByTag(Tag)].Modified then
        begin
          res := MessageDlg('Document has been modified', 'Do you want to save the changes?', mtConfirmation, [mbYes, mbNo, mbCancel], 0);
          if res = mrYes then
            begin
              SaveDoc(GetDocIDByTag(Tag));
              CloseDoc(GetDocIDByTag(Tag));
            end;
          if res = mrNo then
            begin
              CloseDoc(GetDocIDByTag(Tag));
            end;
        end
      else
        CloseDoc(GetDocIDByTag(Tag));
    end;
end;

procedure TMainForm.GenSynEditChange(Sender: TObject);
begin
  with Sender as TSynEdit do
    begin
      Docs[GetDocIDByTag(Tag)].Modified := True;
      if Pos('*',Docs[GetDocIDByTag(Tag)].Page.Caption)  < 1 then
        Docs[GetDocIDByTag(Tag)].Page.Caption := '*'+Docs[GetDocIDByTag(Tag)].Page.Caption;
    end;
end;

procedure TMainForm.pgPageChanged(Sender: TObject);
begin
  if pg.PageCount > 0 then
    begin
      if pg.ActivePage <> nil then
        PageLabelButton.Caption := pg.ActivePage.Caption;
    end
  else
    PageLabelButton.Caption := '';
end;

procedure TMainForm.ProximityTimerTimer(Sender: TObject);
var
  i : integer;
begin

  if not Settings.ShowTabBar then
    begin
      if isProxClosed and (ProxTimeoutTimer.Enabled = false) and (ProxSession = false) then
        begin //Show the buttons..
          ProxSession := True;
          PageLeftButton.Visible := True;
          PageRightButton.Visible := True;
          PageCloseButton.Visible := True;
          PageLabelButton.Visible := True;
          if pg.PageCount > 0 then
            PageLabelButton.Caption := pg.ActivePage.Caption
          else
            PageLabelButton.Caption := 'No files open';
          ProxTimeoutTimer.Enabled := True;
        end;
      if ProxSession and not isProxClosed then
        ProxSession := False;
    end;

  if Settings.AllwaysShowBar and not ExtraBarBox.Visible then
    ExtraBarBox.Visible := True;
  // Page up/down buttons
  if isProxClosed then
    begin
      if Settings.ShowTabBar then
        begin
          PageUpFullButton.Top := 51;
          PageUpButton.Top := 116;
        end
      else
        begin
          PageUpFullButton.Top := 1;
          PageUpButton.Top := 66;
        end;
      PageUpButton.Visible := True;
      PageUpFullButton.Visible := True;
      BookmarkButton.Visible := True;
      MacrosButton.Visible := True;
      ScriptsButton.Visible := True;
      if fullscreen then
        FullscreenButton.Visible := True;
      // Extra Bar
      ExtraBarBox.Constraints.MaxWidth:=MainForm.Width-133;
      ExtraBarBox.Visible := True;
      if SearchPanel.Visible then
        begin
          if SearchPanel.Height = 50 then
            begin
              PageDownButton.Top := MainForm.Height-64-65-50;
              PageDownFullButton.Top := MainForm.Height-64-50;
              if FullscreenButton.Visible then
                begin
                  BookmarkButton.Top := MainForm.Height-64-65-50;
                  MacrosButton.Top := MainForm.Height-64-65-50-65;
                  ScriptsButton.Top := MainForm.Height-64-65-50-65-65;
                end
              else
                begin
                  BookmarkButton.Top := MainForm.Height-64-50;
                  MacrosButton.Top := MainForm.Height-64-50-65;
                  ScriptsButton.Top := MainForm.Height-64-50-65-65;
                end;
            end;
          if SearchPanel.Height = 100 then
            begin
              PageDownButton.Top :=  MainForm.Height-64-65-100;
              PageDownFullButton.Top :=  MainForm.Height-64-100;
              if FullscreenButton.Visible then
                begin
                  BookmarkButton.Top := MainForm.Height-64-65-100;
                  MacrosButton.Top := MainForm.Height-64-65-100-65;
                  ScriptsButton.Top := MainForm.Height-64-65-100-65-65;
                end
              else
                begin
                  BookmarkButton.Top := MainForm.Height-64-100;
                  MacrosButton.Top := MainForm.Height-64-100-65;
                  ScriptsButton.Top := MainForm.Height-64-100-65-65;
                end;
            end;
        end
      else
        begin
          PageDownButton.Top :=  MainForm.Height-64-65;
          PageDownFullButton.Top :=  MainForm.Height-64;
          if FullscreenButton.Visible then
            begin
              BookmarkButton.Top := MainForm.Height-64-65;
              MacrosButton.Top := MainForm.Height-64-65-65;
              ScriptsButton.Top := MainForm.Height-64-65-65-65;
            end
          else
            begin
              BookmarkButton.Top := MainForm.Height-64;
              MacrosButton.Top := MainForm.Height-64-65;
              ScriptsButton.Top := MainForm.Height-64-65-65;
            end;
        end;
      PageDownButton.Visible := True;
      PageDownFullButton.Visible := True;
      ExtraBarBox.Top := PageDownFullButton.Top;
    end
  else
    begin
      PageUpButton.Visible := False;
      PageUpFullButton.Visible := False;
      PageDownButton.Visible := False;
      PageDownFullButton.Visible := False;
      BookmarkButton.Visible := False;
      MacrosButton.Visible := False;
      ScriptsButton.Visible := False;
      FullscreenButton.Visible := False;
      // Extra Bar
      if not Settings.AllwaysShowBar then
        ExtraBarBox.Visible := False;

      if ProxTimeoutTimer.Enabled = false then
        PageLabelButton.Visible := False;
    end;
end;

procedure TMainForm.ProxTimeoutTimerTimer(Sender: TObject);
begin
  ProxTimeoutTimer.Enabled := False;
  PageLeftButton.Visible := False;
  PageRightButton.Visible := False;
  PageCloseButton.Visible := False;
  PageLabelButton.Visible := False;
end;

procedure TMainForm.ScriptEdit1Click(Sender: TObject);
var
  ini : TMemIniFile;
  num : integer;
begin
  if pg.PageCount < 1 then
    Exit;
  with Sender as TMenuItem do
    begin
      num := 0;
      if Name = 'ScriptEdit1' then num := 1;
      if Name = 'ScriptEdit2' then num := 2;
      if Name = 'ScriptEdit3' then num := 3;
      if Name = 'ScriptEdit4' then num := 4;
      if Name = 'ScriptEdit5' then num := 5;
      if Name = 'ScriptEdit6' then num := 6;
      if num = 0 then
        Exit;
      // Check if name change is needed..
      if MessageDlg('Name of the script', 'Do you want to change the name?', mtConfirmation, [mbYes, mbNo], 0) = mrYes then
        begin
          TxInputDlgF.Caption := 'Script name :';
          if TxInputDlgF.ShowModal = mrOk then
            begin
              ini := TMemIniFile.Create(CONFIG_FILE);
              if TxInputDlgF.Edit1.Text <> '' then
                begin
                  Settings.Scripts[num].Caption := TxInputDlgF.Edit1.Text;
                  ini.WriteString('Scripts','SC'+inttostr(num),TxInputDlgF.Edit1.Text);
                end
              else
                begin
                  Settings.Scripts[num].Caption := 'Untitled '+inttostr(num);
                  ini.WriteString('Scripts','SC'+inttostr(num),'Untitled '+inttostr(num));
                end;
              ini.UpdateFile;
              ini.Free;
            end;
        end;
      // Open the script file for editing..
      if FileExists(Settings.Scripts[num].FileName) then
        Settings.Scripts[num].DocID := NewDoc(Settings.Scripts[num].FileName)
      else
        begin // Its a new script..
          // Create the Document
          Settings.Scripts[num].FileName := CONFIG_DIR+'script'+inttostr(num)+'.sh';
          Settings.Scripts[num].DocID := NewDoc('');
          ini := TMemIniFile.Create(CONFIG_FILE);
          ini.WriteString('Scripts','SF'+inttostr(num),Settings.Scripts[num].FileName);
          ini.UpdateFile;
          ini.Free;
          Docs[Settings.Scripts[num].DocID].FileName := Settings.Scripts[num].FileName;
          SaveDoc(Settings.Scripts[num].DocID, False, True);
          ApplyHighlightByExt(Settings.Scripts[num].DocID);
        end;
    end;
end;

procedure TMainForm.ScriptRun1Click(Sender: TObject);
var
  se : TScriptExecF;
  i : integer;
begin
  if pg.PageCount < 1 then
    Exit;
  with Sender as TMenuItem do
    begin
      if Name = 'ScriptRun1' then
        begin
          //Check if its modified..
          for i := 0 to pg.PageCount -1 do
            if Docs[GetDocIDByTag(pg.Pages[i].Tag)].DocID = Settings.Scripts[1].DocID then
              if Docs[GetDocIDByTag(pg.Pages[i].Tag)].Modified then
                begin // Its modified..
                  if MessageDlg('Script is modified', 'Do you want to save the changes before execution?', mtConfirmation, [mbYes, mbNo], 0) = mrYes then
                    begin
                      SaveDoc(Settings.Scripts[1].DocID);
                    end;
                end;
          // Run the script..
          se := TScriptExecF.Create(MainForm);
          se.ScriptName := Settings.Scripts[1].FileName;
          se.Caption := Settings.Scripts[1].Caption + ' - script result';
          se.ExecuteIt;
          se.ShowModal;
          se.Free;
        end;
      if Name = 'ScriptRun2' then
        begin
          //Check if its modified..
          for i := 0 to pg.PageCount -1 do
            if Docs[GetDocIDByTag(pg.Pages[i].Tag)].DocID = Settings.Scripts[2].DocID then
              if Docs[GetDocIDByTag(pg.Pages[i].Tag)].Modified then
                begin // Its modified..
                  if MessageDlg('Script is modified', 'Do you want to save the changes before execution?', mtConfirmation, [mbYes, mbNo], 0) = mrYes then
                    begin
                      SaveDoc(Settings.Scripts[2].DocID);
                    end;
                end;
          // Run the script..
          se := TScriptExecF.Create(MainForm);
          se.ScriptName := Settings.Scripts[2].FileName;
          se.Caption := Settings.Scripts[2].Caption + ' - script result';
          se.ExecuteIt;
          se.ShowModal;
          se.Free;
        end;
      if Name = 'ScriptRun3' then
        begin
          //Check if its modified..
          for i := 0 to pg.PageCount -1 do
            if Docs[GetDocIDByTag(pg.Pages[i].Tag)].DocID = Settings.Scripts[3].DocID then
              if Docs[GetDocIDByTag(pg.Pages[i].Tag)].Modified then
                begin // Its modified..
                  if MessageDlg('Script is modified', 'Do you want to save the changes before execution?', mtConfirmation, [mbYes, mbNo], 0) = mrYes then
                    begin
                      SaveDoc(Settings.Scripts[3].DocID);
                    end;
                end;
          // Run the script..
          se := TScriptExecF.Create(MainForm);
          se.ScriptName := Settings.Scripts[3].FileName;
          se.Caption := Settings.Scripts[3].Caption + ' - script result';
          se.ExecuteIt;
          se.ShowModal;
          se.Free;
        end;
      if Name = 'ScriptRun4' then
        begin
          //Check if its modified..
          for i := 0 to pg.PageCount -1 do
            if Docs[GetDocIDByTag(pg.Pages[i].Tag)].DocID = Settings.Scripts[4].DocID then
              if Docs[GetDocIDByTag(pg.Pages[i].Tag)].Modified then
                begin // Its modified..
                  if MessageDlg('Script is modified', 'Do you want to save the changes before execution?', mtConfirmation, [mbYes, mbNo], 0) = mrYes then
                    begin
                      SaveDoc(Settings.Scripts[4].DocID);
                    end;
                end;
          // Run the script..
          se := TScriptExecF.Create(MainForm);
          se.ScriptName := Settings.Scripts[4].FileName;
          se.Caption := Settings.Scripts[4].Caption + ' - script result';
          se.ExecuteIt;
          se.ShowModal;
          se.Free;
        end;
      if Name = 'ScriptRun5' then
        begin
          //Check if its modified..
          for i := 0 to pg.PageCount -1 do
            if Docs[GetDocIDByTag(pg.Pages[i].Tag)].DocID = Settings.Scripts[5].DocID then
              if Docs[GetDocIDByTag(pg.Pages[i].Tag)].Modified then
                begin // Its modified..
                  if MessageDlg('Script is modified', 'Do you want to save the changes before execution?', mtConfirmation, [mbYes, mbNo], 0) = mrYes then
                    begin
                      SaveDoc(Settings.Scripts[5].DocID);
                    end;
                end;
          // Run the script..
          se := TScriptExecF.Create(MainForm);
          se.ScriptName := Settings.Scripts[5].FileName;
          se.Caption := Settings.Scripts[5].Caption + ' - script result';
          se.ExecuteIt;
          se.ShowModal;
          se.Free;
        end;
      if Name = 'ScriptRun6' then
        begin
          //Check if its modified..
          for i := 0 to pg.PageCount -1 do
            if Docs[GetDocIDByTag(pg.Pages[i].Tag)].DocID = Settings.Scripts[6].DocID then
              if Docs[GetDocIDByTag(pg.Pages[i].Tag)].Modified then
                begin // Its modified..
                  if MessageDlg('Script is modified', 'Do you want to save the changes before execution?', mtConfirmation, [mbYes, mbNo], 0) = mrYes then
                    begin
                      SaveDoc(Settings.Scripts[6].DocID);
                    end;
                end;
          // Run the script..
          se := TScriptExecF.Create(MainForm);
          se.ScriptName := Settings.Scripts[6].FileName;
          se.Caption := Settings.Scripts[6].Caption + ' - script result';
          se.ExecuteIt;
          se.ShowModal;
          se.Free;
        end;
    end;
end;

procedure TMainForm.ScriptsButtonClick(Sender: TObject);
begin
  ScriptsMenu.PopUp;
end;

procedure TMainForm.ScriptsMenuPopup(Sender: TObject);
var
  i : integer;
begin
  for i := 1 to 6 do
    begin
      if Settings.Scripts[i].FileName = '' then
        begin
          with FindComponent('ScriptRun'+inttostr(i)) as TMenuItem do
            begin
              Enabled := False;
              Caption := 'Untitled '+inttostr(i);
            end;
          with FindComponent('ScriptEdit'+inttostr(i)) as TMenuItem do
            Caption := 'Untitled '+inttostr(i);
        end
      else
        begin
          if Settings.Scripts[i].Caption <> '' then
            begin
              with FindComponent('ScriptRun'+inttostr(i)) as TMenuItem do
                begin
                  Enabled := True;
                  Caption := Settings.Scripts[i].Caption;
                end;
                with FindComponent('ScriptEdit'+inttostr(i)) as TMenuItem do
                  Caption := Settings.Scripts[i].Caption;
            end
          else
            begin
              with FindComponent('ScriptRun'+inttostr(i)) as TMenuItem do
                begin
                  Enabled := True;
                  Caption := 'Untitled '+inttostr(i);
                end;
                with FindComponent('ScriptEdit'+inttostr(i)) as TMenuItem do
                  Caption := 'Untitled '+inttostr(i);
            end;
        end;
    end;
end;

procedure TMainForm.SearchEditClick(Sender: TObject);
begin
  MainForm.Update;
  MainForm.UpdateAlignIndex;
  MainForm.ReAlign;

end;

procedure TMainForm.SearchEditKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if key = 13 then
    FindButton.OnClick(Self);
end;

procedure TMainForm.StartupTimerTimer(Sender: TObject);
begin
  StartupTimer.Enabled := False;
  FullscreenButton.Visible := True;
  PageUpButton.Visible := True;
  PageUpFullButton.Visible := True;
  PageDownButton.Visible := True;
  PageDownFullButton.Visible := True;
  PageLabelButton.Visible := True;
  PageLeftButton.Visible := True;
  PageRightButton.Visible := True;
  PageCloseButton.Visible := True;
  BookmarkButton.Visible := True;
  MacrosButton.Visible := True;
  ScriptsButton.Visible := True;
  ExtraBarBox.Visible := True;
  FullscreenButton.Visible := False;
  PageUpButton.Visible := False;
  PageUpFullButton.Visible := False;
  PageDownButton.Visible := False;
  PageDownFullButton.Visible := False;
  PageLabelButton.Visible := False;
  PageLeftButton.Visible := False;
  PageRightButton.Visible := False;
  PageCloseButton.Visible := False;
  BookmarkButton.Visible := False;
  MacrosButton.Visible := False;
  ScriptsButton.Visible := False;
  SearchPanel.Visible := False;
  ExtraBarBox.Visible := False;
  RepositionSearchButtons(False);
end;

procedure TMainForm.GenSynEditReplaceText(Sender: TObject; const ASearch,
  AReplace: string; Line, Column: integer; var ReplaceAction: TSynReplaceAction
  );
begin
  if not PromptingReplace then
    begin
      PromptingReplace := True;
      ReplaceAction := raCancel;
      ReplacePanel.Visible := True;
    end
  else
    begin
      PromptingReplace := False;
      ReplacePanel.Visible := False;
      ReplaceAction := raReplace;
    end;
end;

procedure TMainForm.SynEditDummyMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if isProxClosed then
    begin
      Docs[GetDocIDByTag(pg.ActivePage.Tag)].Scroller.MouseDown(X,Y);
      with Sender as TSynEdit do
        Options:= Options+[eoNoSelection, eoNoCaret];
    end
  else
    begin  // Only scroll if the press is inside the gutter...
      with Sender as TSynEdit do
        begin
          if X < Gutter.Width then
            begin
              Docs[GetDocIDByTag(pg.ActivePage.Tag)].Scroller.MouseDown(0,Y);
            end;
        end;
    end;
end;

procedure TMainForm.SynEditDummyMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  if isProxClosed then
    begin
      Docs[GetDocIDByTag(pg.ActivePage.Tag)].Scroller.MouseMove(X,Y);
    end
  else
    begin  // Only scroll if the press is inside the gutter...
      with Sender as TSynEdit do
        begin
          if X < Gutter.Width then
            begin
              Docs[GetDocIDByTag(pg.ActivePage.Tag)].Scroller.MouseMove(0,Y);
            end;
        end;
    end;
end;

procedure TMainForm.SynEditDummyMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if isProxClosed then
    Docs[GetDocIDByTag(pg.ActivePage.Tag)].Scroller.MouseUp(X,Y)
  else
    begin  // Only scroll if the press is inside the gutter...
      Docs[GetDocIDByTag(pg.ActivePage.Tag)].Scroller.MouseDown(0,Y);
    end;

  with Sender as TSynEdit do
    Options:= Options-[eoNoSelection, eoNoCaret];
end;

procedure TMainForm.SynEditDummyKeyPress(Sender: TObject; var Key: char);
begin
  { Dummy Key Press }
end;


procedure TMainForm.FocusTimerTimer(Sender: TObject);
begin
  FocusTimer.Enabled := False;
  Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.SetFocus;
  pg.ActivePage.Caption := '';
  if Docs[GetDocIDByTag(pg.ActivePage.Tag)].FileName <> '' then
    pg.ActivePage.Caption := ExtractFileName(Docs[GetDocIDByTag(pg.ActivePage.Tag)].FileName)
  else
    pg.ActivePage.Caption := 'Untitled';
end;

procedure TMainForm.ShortCutDelayTimerTimer(Sender: TObject);
begin
  ShortCutDelayTimer.Enabled := False;
  LastAction.Enabled:= True;
  short_executed := False;
end;

procedure TMainForm.kinTimerTimer(Sender: TObject);
begin

end;

end.

