unit OpenDlg;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, EditBtn,
  ShellCtrls, ExtCtrls, StdCtrls, ComCtrls, txkinscroller;

type

  { TOpenDlgF }

  TOpenDlgF = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Edit1: TEdit;
    Panel1: TPanel;
    ShellListView1: TShellListView;
    ShellTreeView1: TShellTreeView;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure ShellListView1Click(Sender: TObject);
    procedure ShellTreeView1Click(Sender: TObject);
    procedure ShellTreeView1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ShellTreeView1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure ShellTreeView1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { private declarations }
  public
    FName : string;
    kinscroll : TTxKinScroller;
  end;

var
  OpenDlgF: TOpenDlgF;

implementation

{$R *.lfm}

{ TOpenDlgF }

procedure TOpenDlgF.Button1Click(Sender: TObject);
begin
  FName := Edit1.Text;
  OpenDlgF.ModalResult := mrCancel;
end;

procedure TOpenDlgF.Button2Click(Sender: TObject);
begin
  FName := '';
  Close;
end;

procedure TOpenDlgF.FormCreate(Sender: TObject);
begin
  kinscroll := TTxKinScroller.Create(OpenDlgF);
  kinscroll.TargetControl := ShellTreeView1;
  kinscroll.Enabled := True;
end;

procedure TOpenDlgF.FormDestroy(Sender: TObject);
begin
    kinscroll.Free;
end;

procedure TOpenDlgF.FormShow(Sender: TObject);
var
  i : integer;
begin
  OpenDlgF.ModalResult := mrNone;
  if ShellListView1.ColumnCount > 1 then
    for i := 1 to ShellListView1.ColumnCount-1 do
      begin
        ShellListView1.Column[i].Visible:= False;
      end;
  ShellListView1.Column[0].MinWidth:= ShellListView1.Width;
end;

procedure TOpenDlgF.ShellListView1Click(Sender: TObject);
begin
  if ShellListView1.SelCount > 0 then
    Edit1.Text :=  ShellTreeView1.GetPathFromNode(ShellTreeView1.Selected)+'/'+ShellListView1.Selected.Caption;
end;

procedure TOpenDlgF.ShellTreeView1Click(Sender: TObject);
begin
  if not kinscroll.InertiaActive then
    begin
      if ShellTreeView1.Selected.Expanded then
        ShellTreeView1.Selected.Collapse(False)
      else
        ShellTreeView1.Selected.Expand(False);
      Edit1.Text := ShellTreeView1.GetPathFromNode(ShellTreeView1.Selected);
    end;
end;

procedure TOpenDlgF.ShellTreeView1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if Assigned(kinscroll) then
    kinscroll.MouseDown(X,Y);
end;

procedure TOpenDlgF.ShellTreeView1MouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
  if Assigned(kinscroll) then
    kinscroll.MouseMove(X,Y);
end;

procedure TOpenDlgF.ShellTreeView1MouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if Assigned(kinscroll) then
    kinscroll.MouseUp(X,Y);
end;

end.

