unit SaveDlg;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, ShellCtrls,
  ExtCtrls, StdCtrls, qt4, qtwidgets;

type

  { TSaveDlgF }

  TSaveDlgF = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Edit1: TEdit;
    kinTimer: TTimer;
    Panel1: TPanel;
    ShellListView1: TShellListView;
    ShellTreeView1: TShellTreeView;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Edit1KeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure FormShow(Sender: TObject);
    procedure kinTimerTimer(Sender: TObject);
    procedure ShellListView1Click(Sender: TObject);
    procedure ShellTreeView1Click(Sender: TObject);
    procedure ShellTreeView1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ShellTreeView1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure ShellTreeView1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ShellTreeView1SelectionChanged(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
    FName : string;
    kinMouseDownPoint : TPoint;
    kinMouseCurrentPoint : TPoint;
    kinMouseDownPointInertia : TPoint;
    kinMouseCurrentPointInertia : TPoint;
    kinOriginalScrollBarValue : TPoint;
    kinCurrentScrollBarValue : TPoint;
    kinMouseIsDown : boolean;
    kinMouseIsMoving : boolean;
    kinInertiaActive : boolean;
    kinInertia : integer;
    procedure kinStopInertia;
  end; 

const
  kinIgnoreRadius : integer = 20;
  kinTimerInterval : integer = 50;
  kinFriction : integer = 1;

var
  SaveDlgF: TSaveDlgF;


implementation

{$R *.lfm}

{ TSaveDlgF }

procedure TSaveDlgF.Edit1KeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  if key = 13 then
    Button1.OnClick(Self);
end;

procedure TSaveDlgF.FormShow(Sender: TObject);
var
  i : integer;
begin
  if ShellListView1.ColumnCount > 1 then
    for i := 1 to ShellListView1.ColumnCount-1 do
      begin
        ShellListView1.Column[i].Visible:= False;
      end;
  ShellListView1.Column[0].MinWidth:= ShellListView1.Width;
end;

procedure TSaveDlgF.kinTimerTimer(Sender: TObject);
var
  SArea : TQtAbstractScrollArea;
  SAreaSize : TPoint;
  tempY : integer;
begin
  if kinMouseIsDown and kinInertiaActive then
    begin // Gather some energy...
      SArea := TQtAbstractScrollArea(ShellTreeView1.Handle);
      SAreaSize.Y := Round((ShellTreeView1.Height*((SArea.verticalScrollBar.getMax-SArea.verticalScrollBar.getMin)+SArea.verticalScrollBar.getPageStep))/SArea.verticalScrollBar.getPageStep);
      tempY := (kinMouseCurrentPointInertia.Y - kinMouseDownPointInertia.Y);
      kinInertia := Round((tempY * SArea.verticalScrollBar.getMax) / SAreaSize.Y);
      kinMouseDownPointInertia.Y := kinMouseCurrentPointInertia.Y;
    end
  else if (not kinMouseIsDown) and kinInertiaActive then
    begin // Release the energy...

      // Apply the friction..
      if kinInertia > 0 then
        Dec(kinInertia)
      else
        Inc(kinInertia);

      // Dont reverse..
      if abs(kinInertia) < 2 then
        kinStopInertia;

      // Scroll it..
      SArea := TQtAbstractScrollArea(ShellTreeView1.Handle);
      SArea.verticalScrollBar.setValue(SArea.verticalScrollBar.getValue-kinInertia);
    end
  else
    begin // Do nothing, stop the motion...(reset);
      kinStopInertia;
    end;
end;

procedure TSaveDlgF.ShellListView1Click(Sender: TObject);
begin
end;

procedure TSaveDlgF.ShellTreeView1Click(Sender: TObject);
begin
  if not kinInertiaActive then
    begin
      if ShellTreeView1.Selected.Expanded then
        ShellTreeView1.Selected.Collapse(False)
      else
        ShellTreeView1.Selected.Expand(False);
      Edit1.Text := ShellTreeView1.GetPathFromNode(ShellTreeView1.Selected)+'/';
    end;
end;

procedure TSaveDlgF.ShellTreeView1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  kinMouseDownPoint.X := X;
  kinMouseDownPoint.Y := Y;
  kinMouseDownPointInertia.X := X;
  kinMouseDownPointInertia.Y := Y;
  kinOriginalScrollBarValue.Y := TQtAbstractScrollArea(ShellTreeView1.Handle).verticalScrollBar.getValue;
  kinOriginalScrollBarValue.X := TQtAbstractScrollArea(ShellTreeView1.Handle).horizontalScrollBar.getValue;
  kinMouseIsDown := True;
  if kinInertiaActive then
    kinStopInertia;
end;

procedure TSaveDlgF.ShellTreeView1MouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
var
  SArea : TQtAbstractScrollArea;
  Dist : TPoint;
  SAreaSize : TPoint;
  amountY : integer;
begin
  kinMouseCurrentPoint.X := X;
  kinMouseCurrentPoint.Y := Y;
  kinMouseCurrentPointInertia.X := X;
  kinMouseCurrentPointInertia.Y := Y;
  //Check if outside the no-go radius...
  if kinMouseDownPoint.Y <> -1 then //Check if CurPos is accurate first...
    if (kinMouseCurrentPoint.Y > (kinMouseDownPoint.Y+kinIgnoreRadius)) or (kinMouseCurrentPoint.Y < (kinMouseDownPoint.Y-kinIgnoreRadius)) then
      begin//We have moved outside the radius, do some moving...
        if not kinInertiaActive then
          begin // Inertia...
            kinInertiaActive := True;
            if not kinTimer.Enabled then
              kinTimer.Enabled := True;
          end
        else
          begin // Manual drag...
            if (kinMouseCurrentPoint.Y > kinMouseDownPoint.Y) then
              dist.Y := (kinMouseCurrentPoint.Y - kinMouseDownPoint.Y)
            else
              dist.Y := (kinMouseDownPoint.Y - kinMouseCurrentPoint.Y)*-1;
            // Get the ScrollArea
            SArea := TQtAbstractScrollArea(ShellTreeView1.Handle);
            // Do the math
            SAreaSize.Y := Round((ShellTreeView1.Height*((SArea.verticalScrollBar.getMax-SArea.verticalScrollBar.getMin)+SArea.verticalScrollBar.getPageStep))/SArea.verticalScrollBar.getPageStep);
            amountY := Round((Dist.Y * SArea.verticalScrollBar.getMax) / SAreaSize.Y);
            // Scroll...
            SArea.verticalScrollBar.setValue(kinOriginalScrollBarValue.Y-amountY);
          end;
     end;
end;

procedure TSaveDlgF.ShellTreeView1MouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  kinMouseDownPoint.X := -1;
  kinMouseDownPoint.Y := -1;
  kinMouseIsDown := False;
end;

procedure TSaveDlgF.ShellTreeView1SelectionChanged(Sender: TObject);
begin

end;

procedure TSaveDlgF.Button1Click(Sender: TObject);
begin
  FName := '';
  if ExtractFileName(Edit1.Text) <> '' then
    begin
      if FileExists(Edit1.Text) then
        begin
          if MessageDlg('File allready exists', 'Do you want to overwrite?', mtConfirmation,[mbYes, mbNo],0 ) <> mrYes then
            Exit;
        end;
      FName := Edit1.Text;
    end
  else
    begin
      ShowMessage('Enter the file name first!');
      Exit;
    end;
  SaveDlgF.ModalResult := mrOk;
end;

procedure TSaveDlgF.Button2Click(Sender: TObject);
begin
  FName := '';
  SaveDlgF.ModalResult := mrCancel;
end;

procedure TSaveDlgF.kinStopInertia;
begin
  kinInertiaActive := False;
  kinInertia := 0;
  kinTimer.Enabled := False;
end;

end.

