/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef URLSHORTENER_H
#define URLSHORTENER_H

#include <QObject>
#include <QDebug>
#include <QString>
#include <QNetworkAccessManager>
#include <QNetworkProxy>
#include <QList>
#include <QStringList>
#include <QListIterator>
#include <QRegExp>
#include <QNetworkRequest>
#include <QNetworkReply>

#ifdef Q_WS_MAEMO_5
    #include <QMaemo5InformationBox>
#endif

/*!
 * \class UrlShortener
 *
 * \brief UrlShortener class handles all operations related to url shortening.
 */
class UrlShortener: public QObject
{
    Q_OBJECT

    public:
        UrlShortener();
        ~UrlShortener();
	void parseUrl(QString string);

    signals:
        void shortened( const QString &url );
        void newString( const QString &url );
        void errorMessage( const QString &message );

    private slots:
        void shorten( const QStringList &url );
        void replyFinished( QNetworkReply * reply );
        void appendToList(QString shortUrl);
        int replyStatus( QNetworkReply *reply );

    private:
	QNetworkAccessManager *connection;
        QList<QString> list;
        QStringList urlList;
        QStringList temp;
};

#endif // URLSHORTENER_H
