/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef TWITTERTWEETINFO_H
#define TWITTERTWEETINFO_H

#include "applicationItems/twitterapplicationitem.h"
#include "applicationItems/twitterbutton.h"
#include "applicationItems/twittertopbar.h"
#include "applicationItems/kineticlist.h"
#include "applicationItems/tweet.h"
#include "twitterimage.h"

#include "twitterapi/entry.h"

/*!
 * \class TwitterTweetInfo
 *
 * \brief TwitterTweetInfo class handles all operations related to timelines
 */
class TwitterTweetInfo : public TwitterApplicationItem
{
    Q_OBJECT

public:
    TwitterTweetInfo(Tweet *tweet, QGraphicsWidget *parent=0);
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *);
    void updateTweetInfo(QString type, bool update);

protected:
    void mousePressEvent(QGraphicsSceneMouseEvent *event);

signals:
    void retweet(QString);
    void reply(QString, quint64);
    void del(quint64, Tweet*);
    void favorite(QString, bool);
    void unfollow(QString, bool);

public slots:
    void startAnimation(void);

private slots:
    void _paintAvatar(void);
    void _openImage(QString url);
    void _reply(void);
    void _retweet(void);
    void _deleteTweet(void);
    void _exitAnimation(void);
    void _changeOrientation(void);

private:
    void _createButtons(void);
    void _paintTweet(void);
    void _showUrls(QStringList urls);
    QStringList _createUrls(QString text);

private:
    TwitterApplicationItem *_container;
    TwitterButton *_deleteButton;
    TwitterButton *_retweetButton;
    TwitterButton *_replyButton;
    TwitterButton *_backButton;
    Tweet *_tweet;
    TwitterImage *_twitterImage;

    KineticList *_urls;
    Entry _entry;

    QGraphicsTextItem *_tweetText;
    QGraphicsTextItem *_message;
    QGraphicsLineItem *_sep1;
    QGraphicsLineItem *_sep2;
    QImage _defaultImage;
    QImage _image;
    QFont font;
    QPointF _startPos;
    QPointF _endPos;
    bool _anim;
    int _buttonsHeight;
};

#endif // TWITTERTWEETINFO_H
