#include "twitterspinbox.h"

TwitterSpinBox::TwitterSpinBox(QGraphicsWidget *parent)
    : TwitterApplicationItem(parent)
{
    setFlag(QGraphicsItem::ItemIsFocusable);
    setFiltersChildEvents(true);

    // Create Minus Button
    _minusButton = new TwitterButton(TwitterButton::Minus, "", this);
    _minusButton->setPos(0, 1);

    // Create textbox
    _inputBox = new LineEdit(LineEdit::SpinBox, this);
    _inputBox->setPos(58, 0);

    // Create Plus Button
    _plusButton = new TwitterButton(TwitterButton::Plus, "", this);
    _plusButton->setPos(145, 1);

    setMinimumSize(203, 60);
    setMaximumSize(203, 60);
    setGeometry(0, 0, 203, 62);
}

void TwitterSpinBox::enable(bool option)
{
    _minusButton->enable(option);
    _plusButton->enable(option);
    _inputBox->enable(option);
}
