#ifndef ACCOUNT_H
#define ACCOUNT_H

#include <applicationItems/user.h>
#include <applicationItems/tweet.h>

typedef struct Acc {

    bool operator == (const Acc &other);

    QString username;
    QString token;
    QString tokenSecret;
    QString imageUrl;
    bool showAvatar;
    bool showUsername;
    bool showTimestamp;
    bool showReplyTo;
    bool highlightUrls;
    bool highlightMentions;
    bool highlightTags;
    QImage avatar;
}Acc;


class Account : public QObject
{
    Q_OBJECT

public:
    static Account *instance(void);
    void reloadSettings(void);
    void setUser(User*);
    void setSelected(QString user);
    Acc* getSelected();
    void setSelectedAutoLogin(bool);
    bool isSelectedAutoLogin(void);
    QList<Acc> getUsers(void);
    void saveImage(QString, QImage);
    QImage getSelectedAvatar(void);
    QString getSelectedImageUrl(void);
    bool userExists(QString);
    void removeSelected(void);
    bool hasAutoLogin(void);
    int autoLoginPosition(void);
    void saveNewAccount(QString, QString, QString);

private:
    Account();
    void _loadSettings(void);

private:
    QSettings _settings;
    static Account *_instance;
    QList<Acc> _orderedAccounts;
    QString _autoLogin;
    Acc *_selected;
};

#endif // ACCOUNTMANAGER_H
