#include "account.h"

bool Acc::operator == (const Acc &other)
{
    return ( username == other.username
            && token == other.token
            && tokenSecret == other.tokenSecret
            && imageUrl == other.imageUrl
            && showAvatar == other.showAvatar
            && showUsername == other.showUsername
            && showTimestamp == other.showTimestamp
            && showReplyTo == other.showReplyTo
            && highlightUrls == other.highlightUrls
            && highlightMentions == other.highlightMentions
            && highlightTags == other.highlightTags
            && avatar == other.avatar);
}

QMap<QString,Acc> _accounts;

Account *Account::_instance = 0;

Account* Account::instance(void)
{
    if(!Account::_instance) {
        Account::_instance = new Account();
    }

    return Account::_instance;
}

Account::Account() :
    _settings("Zagaia","TweeGo"),
    _autoLogin(-1),
    _selected(0)
{
    _loadSettings();
}

void Account::_loadSettings(void)
{
    int size = _settings.beginReadArray("ACCOUNTS");
    for(int i = 0; i < size; i++) {
        _settings.setArrayIndex(i);

        Acc account;
        account.username = _settings.value("username").toString();
        account.token = _settings.value("token").toString();
        account.tokenSecret = _settings.value("tokenSecret").toString();
        account.imageUrl = _settings.value("imageUrl").toString();
        account.avatar = _settings.value("avatar").value<QImage>();
        account.showAvatar = _settings.value("showAvatar").toInt();
        account.showUsername = _settings.value("showUsername").toInt();
        account.showTimestamp = _settings.value("showTimestamp").toInt();
        account.showReplyTo = _settings.value("showReplyTo").toInt();
        account.highlightUrls = _settings.value("highlightUrls").toInt();
        account.highlightMentions = _settings.value("highlightMentions").toInt();
        account.highlightTags = _settings.value("highlightTags").toInt();

        _accounts[account.username] = account;
        _orderedAccounts.append(account);
    }
    _settings.endArray();

    _settings.beginGroup("AUTOLOGIN");
    _autoLogin = _settings.value("user").toString();
    _settings.endGroup();
}

void Account::reloadSettings(void)
{
    _accounts.clear();
    _orderedAccounts.clear();

    _loadSettings();
}

void Account::setSelected(QString user)
{
    _selected = &_accounts[user];
}

Acc* Account::getSelected(void)
{
    return _selected;
}

QImage Account::getSelectedAvatar(void)
{
    return _selected->avatar;
}

QString Account::getSelectedImageUrl(void)
{
    return _selected->imageUrl;
}

void Account::setSelectedAutoLogin(bool option)
{
    _settings.beginGroup("AUTOLOGIN");

    if(option) {
        _settings.setValue("user",_selected->username);
        _autoLogin = _selected->username;
    } else {
        _settings.setValue("user","");
        _autoLogin = "";
    }

    _settings.endGroup();
}

bool Account::isSelectedAutoLogin(void)
{
    if (_selected->username == _autoLogin)
        return true;
    return false;
}

int Account::autoLoginPosition(void)
{
    return _orderedAccounts.indexOf(_accounts[_autoLogin]);
}

bool Account::hasAutoLogin(void)
{
    if(_autoLogin != "")
        return true;
    return false;
}

QList<Acc> Account::getUsers(void)
{
    return _orderedAccounts;
}

void Account::saveImage(QString imageUrl, QImage avatar)
{
    int pos = _orderedAccounts.indexOf(_accounts[_selected->username]);

    _settings.beginReadArray("ACCOUNTS");
    _settings.setArrayIndex(pos);

    _settings.setValue("avatar", avatar);
    _settings.setValue("imageUrl", imageUrl);

    _settings.endArray();

    reloadSettings();
}

bool Account::userExists(QString user)
{
    // Dumb
    if(_accounts[user].username == user)
        return true;
    return false;
}

void Account::removeSelected(void)
{
    int pos = _orderedAccounts.indexOf(_accounts[_selected->username]);

    int size = _settings.beginReadArray("ACCOUNTS");
    _settings.endArray();

    _settings.beginWriteArray("ACCOUNTS");
    _settings.setArrayIndex(pos);
    _settings.remove("");

    QString username, token, tokenSecret, imageUrl;
    QImage avatar;
    int showAvatar, showUsername, showTimestamp, showReplyTo, highlightUrls, highlightMentions, highlightTags;
    int j;

    for(int i = pos; i < size-1; i++) {
        // Read next
        j = i + 1;

        _settings.setArrayIndex(j);
        username = _settings.value("username").toString();
        token = _settings.value("token").toString();
        tokenSecret = _settings.value("tokenSecret").toString();
        imageUrl = _settings.value("imageUrl").toString();
        avatar = _settings.value("avatar").value<QImage>();
        showAvatar = _settings.value("showAvatar").toInt();
        showUsername = _settings.value("showUsername").toInt();
        showTimestamp = _settings.value("showTimestamp").toInt();
        showReplyTo = _settings.value("showReplyTo").toInt();
        highlightUrls = _settings.value("highlightUrls").toInt();
        highlightMentions = _settings.value("highlightMentions").toInt();
        highlightTags = _settings.value("highlightTags").toInt();

        // Read next on the present position
        _settings.setArrayIndex(i);
        _settings.setValue("username", QString(username));
        _settings.setValue("token", QString(token));
        _settings.setValue("tokenSecret", QString(tokenSecret));
        _settings.setValue("imageUrl", imageUrl);
        _settings.setValue("showAvatar", showAvatar);
        _settings.setValue("showUsername", showUsername);
        _settings.setValue("showTimestamp", showTimestamp);
        _settings.setValue("showReplyTo", showReplyTo);
        _settings.setValue("highlightUrls", highlightUrls);
        _settings.setValue("highlightMentions", highlightMentions);
        _settings.setValue("highlightTags", highlightTags);
        _settings.setValue("avatar", avatar);
    }

    // Remove Last Account
    _settings.setArrayIndex(size-1);
    _settings.remove("");
    _settings.endArray();

    // Decrease accounts size
    _settings.beginWriteArray("ACCOUNTS", size - 1);
    _settings.endArray();

    // If autologin is enable to the removed account, reset autologin
    if(_selected->username == _autoLogin) {
        _settings.beginGroup("AUTOLOGIN");
        _settings.setValue("autologin",0);
        _settings.setValue("user",-1);
        _settings.endGroup();

        _autoLogin = "";
    }

    _selected = NULL;
    reloadSettings();
}

void Account::saveNewAccount(QString username, QString token, QString tokenSecret)
{
    int size = _settings.beginReadArray("ACCOUNTS");
    _settings.endArray();

    // Write the list to file
    _settings.beginWriteArray("ACCOUNTS");
    _settings.setArrayIndex(size);
    _settings.setValue("username", username);
    _settings.setValue("token", token);
    _settings.setValue("tokenSecret", tokenSecret);
    _settings.setValue("imageUrl", "");
    _settings.setValue("showAvatar", 1);
    _settings.setValue("showUsername", 1);
    _settings.setValue("showTimestamp", 1);
    _settings.setValue("showReplyTo", 1);
    _settings.setValue("highlightUrls", 1);
    _settings.setValue("highlightMentions", 1);
    _settings.setValue("highlightTags", 1);
    _settings.setValue("avatar", 0);
    _settings.endArray();

    Acc newAcc;
    newAcc.username = QString(username);
    newAcc.token = QString(token);
    newAcc.tokenSecret = QString(tokenSecret);
    newAcc.imageUrl = "";
    newAcc.showAvatar = true;
    newAcc.showUsername = true;
    newAcc.showTimestamp = true;
    newAcc.showReplyTo = true;
    newAcc.highlightUrls = true;
    newAcc.highlightMentions = true;
    newAcc.highlightTags = true;
    newAcc.avatar = QImage();

    _accounts[username] = newAcc;
    _orderedAccounts.append(newAcc);
}
