/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef LOGINVIEW_H
#define LOGINVIEW_H

#include "applicationItems/twittercheckbox.h"
#include "applicationItems/lineedit.h"
#include "applicationItems/loader.h"
#include "applicationItems/twitterbutton.h"
#include "applicationItems/loginsettings.h"
#include "applicationItems/oauthwizard.h"
#include "applicationItems/kineticlist.h"

/*!
 * \class LoginView
 *
 * \brief Login window with customized widgets.
 */
class LoginView : public QGraphicsWidget
{
    Q_OBJECT

public:
    void createUi(void);
    LoginView(void);
    TwitterButton *_cancelButton;
    KineticList *usersList;

public slots:
    void connected(void);
    void connectionError(void);
    void emitLoginAccount(void);

private slots:
    void _connecting(void);
    void _deleteLoader(void);
    void _endLogin(void);
    void _animSettings(void);

signals:
    void exitLogin(void);
    void loginAccount(void);
    void rememberMe(void);
    void done(void);
    void abort(void);
    void newAccount(void);

private:
    QAbstractAnimation *_createEntryAnimation(void);
    QAbstractAnimation *_createExitAnimation();
    void _createButtons(void);
    void _createLogo(void);
    void _createLoginBackground(void);
    void _createSettings(void);
    void _createOauthWizard(void);
    void _createUsersList(void);
    void _addOpacityAnim(QParallelAnimationGroup *anim,
                         TwitterApplicationItem *item,
                         int delay);
    void _addPosAnim(QParallelAnimationGroup *anim,
                     TwitterApplicationItem *item,
                     QPointF startValue, QPointF endValue,
                     QEasingCurve easing, int delay);

private:
    QAbstractAnimation *_exitAnim;
    QAbstractAnimation *_entryAnim;
    QGraphicsRectItem *m_background;
    QGraphicsPixmapItem *_logo;
    TwitterButton *_loginButton;
    TwitterButton *_exitButton;
    TwitterButton *_exposeButton;
    TwitterButton *_settingsButton;
    TwitterButton *_newAccountButton;
    LoginSettings *_settingsDialog;
    OauthWizard *_oauthWizard;
    Loader *_loader;
};

#endif // LOGINVIEW_H
