/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#include "oauthwizard.h"

const QByteArray OauthWizard::TwitterRequestTokenURL = "https://twitter.com/oauth/request_token";
const QByteArray OauthWizard::TwitterAccessTokenURL  = "https://twitter.com/oauth/access_token";
const QByteArray OauthWizard::TwitterAuthorizeURL    = "https://twitter.com/oauth/authorize";

const QByteArray OauthWizard::ConsumerKey    = "EFeRfSdoLJPVFPcfw85TyQ";
const QByteArray OauthWizard::ConsumerSecret = "XlPsZ7soQ7QzXLgXFaSyswBGDcv1vz0cII3ov1EuLo";

const QByteArray OauthWizard::ParamCallback      = "oauth_callback";
const QByteArray OauthWizard::ParamCallbackValue = "oob";
const QByteArray OauthWizard::ParamVerifier      = "oauth_verifier";
const QByteArray OauthWizard::ParamScreenName    = "screen_name";

OauthWizard::OauthWizard(QGraphicsWidget *parent)
    : TwitterApplicationItem(parent),
    _step(1)
{
    // OauthWizard object size
    this->setGeometry(0,0,314,480);

    // Font
    font.setFamily("Nokia Sans");
    font.setStyle(QFont::StyleNormal);
    font.setStyleStrategy(QFont::PreferAntialias);
    font.setWeight(QFont::Normal);
    font.setPixelSize(18);

    // Background
    _bg = new QGraphicsRectItem(0,0,314,480,this);
    _bg->setBrush(QBrush(QColor(Qt::white)));
    _bg->setPen(Qt::NoPen);

    // title
    _title = new QGraphicsTextItem("Authentication",this);
    _title->setFont(font);
    _title->setPos((_bg->boundingRect().width() - _title->boundingRect().width())/2,10);
    _title->setDefaultTextColor(QColor("#0f95da"));

    // line 1
    _sep1 = new QGraphicsLineItem(_bg->x() + 22,50,this->boundingRect().width()-22,50,this);

    // Allow Text
    QString allowText = "<p align=\"center\"; style=\"font-family:'Nokia Sans'; font-size:18px;\">";
    allowText += "To use TweeGo, you must allow it to access your Twitter Account </p>";

    _text1 = new QGraphicsTextItem(this);
    _text1->setHtml(allowText);
    _text1->setTextWidth(this->boundingRect().width()-30);
    _text1->setPos((_bg->boundingRect().width() - _text1->boundingRect().width())/2,60);

    // Allow Button
    _allowButton = new TwitterButton(TwitterButton::Generic,"Allow TweeGo",this);
    _allowButton->setPos((_bg->boundingRect().width() - _allowButton->boundingRect().width())/2,124);
    connect(_allowButton,SIGNAL(released()),SLOT(_openUrl()));

    // line 2
    _sep2 = new QGraphicsLineItem(_bg->x() + 22,199,this->boundingRect().width()-22,199,this);

    // PIN Code Text
    QString pinCodeText = "<p align=\"center\"; style=\"font-family:'Nokia Sans'; font-size:18px;\">";
    pinCodeText += "Insert your PIN code:</p>";

    _text2 = new QGraphicsTextItem(this);
    _text2->setHtml(pinCodeText);
    _text2->setTextWidth(this->boundingRect().width()-30);
    _text2->setPos((_bg->boundingRect().width() - _text2->boundingRect().width())/2,210);

    // PIN Code line Edit
    _pinEntry = new LineEdit(LineEdit::Short,this);
    _pinEntry->setPos((_bg->boundingRect().width() - _pinEntry->boundingRect().width())/2,250);
    _pinEntry->setMaxLength(7);
    connect(_pinEntry, SIGNAL(textChanged(QString)),SLOT(_enableButton()));

    // Validate Button
    _validateButton = new TwitterButton(TwitterButton::Generic,"Validate PIN",this);
    _validateButton->setPos((_bg->boundingRect().width() - _validateButton->boundingRect().width())/2,320);
    connect(_validateButton, SIGNAL(released()),SLOT(_authorize()));

    // back button
    _backButton = new TwitterButton(TwitterButton::GenericDownLeft,"Back",this);
    _backButton->setPos(0,422);
    connect(_backButton, SIGNAL(released()), SLOT(_exitAnimation()));

    // finish button
    _finishButton = new TwitterButton(TwitterButton::GenericDownRight,"Create Account",this);
    _finishButton->setPos(228, 423);
    connect(_finishButton, SIGNAL(released()),SLOT(_saveTokens()));

    // Step 1
    _authSteps(_step);
}

void OauthWizard::startAnimation(void)
{
    QPropertyAnimation *mvWhiteRect = new QPropertyAnimation(this,"pos");
    mvWhiteRect->setStartValue(QPointF(800,0));
    mvWhiteRect->setEndValue(QPointF(800-314,0));
    mvWhiteRect->setDuration(250);
    mvWhiteRect->setEasingCurve(QEasingCurve::OutBack);
    mvWhiteRect->start();
}

void OauthWizard::_exitAnimation(void)
{
    QPropertyAnimation *exitAnim = new QPropertyAnimation(this,"pos");
    exitAnim->setStartValue(QPointF(800-314,0));
    exitAnim->setEndValue(QPointF(800,0));
    exitAnim->setDuration(250);
    exitAnim->setEasingCurve(QEasingCurve::OutBack);
    exitAnim->start();

    _authSteps(_step = 1);
}

void OauthWizard::_openUrl(void)
{
#ifdef Q_WS_MAEMO_5
    QMaemo5InformationBox::information(NULL, "Please wait...", QMaemo5InformationBox::DefaultTimeout);
#endif

    // Init qoauth
    qoauth = new QOAuth::Interface( this );
    qoauth->setConsumerKey( ConsumerKey );
    qoauth->setConsumerSecret( ConsumerSecret );

    // Request Token
    QOAuth::ParamMap requestToken = qoauth->requestToken( TwitterRequestTokenURL, QOAuth::GET, QOAuth::HMAC_SHA1 );

    if(qoauth->error() != QOAuth::NoError) {
        #ifdef Q_WS_MAEMO_5
            QMaemo5InformationBox::information(NULL, "There was a network-related problem with completing the request. Please try again later.",
                                               QMaemo5InformationBox::DefaultTimeout);
        #endif
        _authSteps(_step=1);
        return;
    }

    token = requestToken.value( QOAuth::tokenParameterName() );
    tokenSecret = requestToken.value( QOAuth::tokenSecretParameterName() );

    QString url = TwitterAuthorizeURL;
    url.append( "?" );
    url.append( "&" + QOAuth::tokenParameterName() + "=" + token );
    url.append( "&" + ParamCallback + "=" + ParamCallbackValue );

    QDesktopServices::openUrl(QUrl(url));

    // Step 2
    _authSteps(++_step);
}

void OauthWizard::_enableButton(void)
{
    if(_pinEntry->getText().length() > 6)
        _validateButton->enable(true);
    else
        _validateButton->enable(false);
}

void OauthWizard::_authorize(void)
{
#ifdef Q_WS_MAEMO_5
    QMaemo5InformationBox::information(NULL, "Please wait...", QMaemo5InformationBox::DefaultTimeout);
#endif

    // Authorize
    QOAuth::ParamMap otherArgs;
    otherArgs.insert( ParamVerifier, _pinEntry->getText().toAscii());
    QOAuth::ParamMap accessToken = qoauth->accessToken( TwitterAccessTokenURL, QOAuth::POST, token,
                                                        tokenSecret, QOAuth::HMAC_SHA1, otherArgs );

    if(qoauth->error() != QOAuth::NoError) {
        #ifdef Q_WS_MAEMO_5
            QMaemo5InformationBox::information(NULL, "Either the PIN you entered is incorrect, or a network-related problem occured. Please try again later.",
                                               QMaemo5InformationBox::DefaultTimeout);
        #endif
            _authSteps(_step=1);
            return;
    }

    // Step 3
    _authSteps(++_step);

    // Save informations
    screenName = accessToken.value( ParamScreenName );
    token = accessToken.value( QOAuth::tokenParameterName() );
    tokenSecret = accessToken.value( QOAuth::tokenSecretParameterName() );

    #ifdef Q_WS_MAEMO_5
        QMaemo5InformationBox::information(NULL, "TweeGo Allowed! Press Create Account to finish.",QMaemo5InformationBox::DefaultTimeout);
    #endif
}

void OauthWizard::_saveTokens(void)
{
    QSettings settings("Zagaia","TweeGo");

    // Populate the list with any previous account
    int size = settings.beginReadArray("ACCOUNTS");
    for (int i = 0; i < size; ++i) {
        settings.setArrayIndex(i);
        if(QString(screenName) == settings.value("userName").toString())
        {
            #ifdef Q_WS_MAEMO_5
                QMaemo5InformationBox::information(NULL, "User already created.",QMaemo5InformationBox::DefaultTimeout);
            #endif
            _exitAnimation();
            return;
        }
    }
    settings.endArray();

    // Write the list to file
    settings.beginWriteArray("ACCOUNTS");
    settings.setArrayIndex(size);
    settings.setValue("username", QString(screenName));
    settings.setValue("token", QString(token));
    settings.setValue("tokenSecret", QString(tokenSecret));
    settings.setValue("imageUrl","");
    settings.setValue("avatar",0);
    settings.endArray();

    // Add new account to the list
    emit newAccount();

    // Move the oauthWizard back to side and reset steps
    _exitAnimation();
}

void OauthWizard::_authSteps(int step)
{
    switch(step) {
        case 1: // Step 1: sep1 and allow button enabled
            _sep1->setPen(QPen(QColor("#0f95da")));
            _text1->setDefaultTextColor(QColor("#0f95da"));
            _allowButton->enable(true);
            _sep2->setPen(QPen(QColor("#757575")));
            _text2->setDefaultTextColor(QColor("#757575"));
            _pinEntry->enable(false);
            _pinEntry->setMessage("");
            _validateButton->enable(false);
            _finishButton->enable(false);
            break;

        case 2: // Step 2: sep2 and pin entry enabled
            _sep1->setPen(QPen(QColor("#757575")));
            _text1->setDefaultTextColor(QColor("#757575"));
            _allowButton->enable(false);
            _sep2->setPen(QPen(QColor("#0f95da")));
            _text2->setDefaultTextColor(QColor("#0f95da"));
            _pinEntry->enable(true);
            _finishButton->enable(false);
            break;

        case 3: // Step 3: finish button enabled
            _sep2->setPen(QPen(QColor("#757575")));
            _text2->setDefaultTextColor(QColor("#757575"));
            _validateButton->enable(false);
            _pinEntry->enable(false);
            _pinEntry->setMessage("");
            _finishButton->enable(true);
            break;
    }
}

void OauthWizard::mousePressEvent(QGraphicsSceneMouseEvent *event)
{
    Q_UNUSED(event);
}
