/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef LOGINCTRL_H
#define LOGINCTRL_H

#include <QtGui/QApplication>

#include "loginview.h"
#include "applicationItems/dialog.h"
#include "applicationItems/user.h"
#include "applicationItems/oauthwizard.h"

#include "backend.h"

/*! \class LoginCtrl
 *
 * \brief LoginCtrl class is the controller to LoginView.
 */
class LoginCtrl : public QObject
{
    Q_OBJECT

public:
    LoginCtrl(bool autologin, QGraphicsScene *scene);
    ~LoginCtrl(void);
    void showView(void);

private:
    QGraphicsScene *_scene;
    LoginView *_loginView;
    DialogView *_dialog;
    bool _autologin;

private:
    void _loadSettings(void);

private slots:
    void _loginTwitter(void);
    void _exitButtonPressed(void);
    void _connectionError(QString);
    void _exit(void);
    void _abort(void);
    void _populateUserList(void);

signals:
    void accountConnected(void);
    void done(void);
};

#endif // LOGINCTRL_H
