/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef TWITTERCHECKBOX_H
#define TWITTERCHECKBOX_H

#include <QtGui/QGraphicsSceneMouseEvent>
#include <QtGui/QStyleOptionGraphicsItem>
#include <QtGui/QPainter>

#include "twitterapplicationitem.h"

/*! \class TwitterCheckBox
 * \brief TwitterCheckBox class
 * Handles all operations related to checkBox item.
 */
class TwitterCheckBox: public TwitterApplicationItem
{
    Q_OBJECT

public:
    enum CheckBoxType { RememberMe, Location, Settings };

    TwitterCheckBox(CheckBoxType type, bool checked, QGraphicsWidget *parent = 0);
    QRectF boundingRect() const;
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *);
    bool isChecked();
    void setChecked(bool value);
    void setCheckBoxType(int);

signals:
    void pressed();

protected:
    void mousePressEvent(QGraphicsSceneMouseEvent *);

private:
    QPixmap _checkImg;
    QPixmap _checkEmptyImg;
    QPointF _initPos;
    bool _checked;
    int _checkboxType;
};

#endif // TWITTERCHECKBOX_H
