#ifndef OAUTHWIZARD_H
#define OAUTHWIZARD_H

#include <QDesktopServices>

#include <QtOAuth/QtOAuth>

#include "twitterapplicationitem.h"
#include "applicationItems/twitterbutton.h"
#include "applicationItems/lineedit.h"

#ifdef Q_WS_MAEMO_5
    #include <QMaemo5InformationBox>
#endif

typedef struct {
    QString screenName;
    QString token;
    QString tokenSecret;
}AuthorizedAccount;

class OauthWizard : public TwitterApplicationItem
{
    Q_OBJECT

public:
    OauthWizard(QGraphicsWidget *parent);
    static const QByteArray ConsumerKey;
    static const QByteArray ConsumerSecret;

public slots:
    void startAnimation(void);

private slots:
    void _exitAnimation(void);
    void _openUrl(void);
    void _enableButton(void);
    void _authorize(void);
    void _saveTokens(void);

protected:
    void mousePressEvent(QGraphicsSceneMouseEvent *event);

signals:
    void newAccount(void);

private:
    void _authSteps(int step);

private:
    QList <AuthorizedAccount> accounts;
    QGraphicsRectItem *_bg;
    QGraphicsLineItem *_sep1;
    QGraphicsLineItem *_sep2;
    QGraphicsTextItem *_title;
    QGraphicsTextItem *_text1;
    QGraphicsTextItem *_text2;
    TwitterButton *_backButton;
    TwitterButton *_finishButton;
    TwitterButton *_allowButton;
    TwitterButton *_validateButton;
    LineEdit *_pinEntry;
    QFont font;
    int _step;

    QOAuth::Interface *qoauth;

    QByteArray screenName;
    QByteArray token;
    QByteArray tokenSecret;
    static const QByteArray TwitterRequestTokenURL;
    static const QByteArray TwitterAccessTokenURL;
    static const QByteArray TwitterAuthorizeURL;
    static const QByteArray ParamCallback;
    static const QByteArray ParamCallbackValue;
    static const QByteArray ParamVerifier;
    static const QByteArray ParamScreenName;
    static const QByteArray ParamToken;
    static const QByteArray ParamTokenSecret;
};

#endif // SETTINGS_H
