/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef SPLASHCTRL_H
#define SPLASHCTRL_H

#include <QtCore/QDebug>
#include "splashview.h"

/*!
 * \class SplashCtrl
 *
 * \brief SplashCtrl class that initializes the objects of the splash screen
 */
class SplashCtrl : public QObject
{
    Q_OBJECT

public:
    SplashCtrl(QGraphicsScene *scene);
    ~SplashCtrl(void);
    void showView(void);

private:
    QGraphicsScene *_scene;
    SplashView *_view;

signals:
    void done(void);
};

#endif // SPLASHCTRL_H
