/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef TWEET_H
#define TWEET_H

#include <QtGui/QGraphicsSceneMouseEvent>
#include <QtGui/QTextDocument>
#include <QtGui/QPainter>

#include <QtNetwork>

#include "twitterapplicationitem.h"

class Tweet : public TwitterApplicationItem
{
    Q_OBJECT

public:
    Tweet(const QString &username, const QString &text, const QString &imageUrl, const QString &statusId,
          const QString &createdAt, const QString &source, const bool &favorite, const QString &coordinates,
          bool isMyTweet, int posInList, QGraphicsWidget *parent);
    void paint(QPainter *painter,const QStyleOptionGraphicsItem *option, QWidget *widget);

public:
    void setFavorite(bool);
    QString getUsername(void);
    QString getMessage(void);
    QImage getImage(void);
    QString getStatusId(void);
    bool getFavorite(void);
    QString getCoordinates(void);
    bool getIsMyTweet(void);
    int getPosInList(void);
    bool getFollowing(void);
    void setFollowing(QString, bool);
    QTextDocument* getTweetDocument(void);
    void setPosition(int);

protected:
    void mousePressEvent(QGraphicsSceneMouseEvent *event);
    void mouseReleaseEvent(QGraphicsSceneMouseEvent *event);

signals:
    void createTweetInfo(Tweet *tweet);
    void imageDownloaded(void);

private slots:
    void handleNetworkRequest(QNetworkReply *reply);
    void download(QString Url);

private:
    void createTweetMessage(QString username, QString text, QString source, QString createdAt);
    void createAnimations(void);
    QString parseCreatedAt(QString);
    QString parseSource(QString);
    QString parseText(QString);

private:
    QString m_username;
    QString m_text;
    QString m_createdAt;
    QString m_source;
    QString m_statusId;
    bool    m_favorite;
    QString m_coordinates;
    QString m_imageUrl;
    bool    m_isMyTweet;
    int     m_posInList;
    bool    m_following;
    QNetworkAccessManager m_manager;
    QImage  m_image;
    bool    paintImage;
    QGraphicsTextItem *message;
};

#endif
